/*
    Copyright (C) 2000 Andrew Zabolotny <bit@eltech.ru>

    Usage of this library is not restricted in any way.
    The full license text can be found in the file dxe.txt.

    This program demonstrates the re-export feature of DXE library.
    By providing the RTLD_GLOBAL flag to dlopen() you make all the
    symbols in the library automatically available to subsequently
    loaded modules. In our example module "test3.dxe" makes use
    of functions from "test2.dxe" as if they were usual external
    C functions.
*/

#include <stdio.h>
#include <dlfcn.h>

#define MODULE1 "test2.dxe"
#define MODULE2 "test3.dxe"

DXE_EXPORT_TABLE (syms)
  DXE_EXPORT (printf)
DXE_EXPORT_END

static int lastresort ()
{
  printf ("last resort function called!\n");
  return 0;
}

void *dxe_res (const char *symname)
{
  printf ("%s: undefined symbol in dynamic module\n", symname);
  return &lastresort;
}

int main ()
{
  // Set the error callback function
  dlsetres (dxe_res);

  // Register the symbols exported into dynamic modules
  dlregsym (syms);

  // Now try to load the first module
  dxe_h h1 = dlopen (MODULE1, RTLD_GLOBAL);
  if (!h1)
  {
    printf (MODULE1 ": %s\n", dlerror ());
    exit (-1);
  }

  // And now try to load the second module
  dxe_h h2 = dlopen (MODULE2, 0);
  if (!h2)
  {
    printf (MODULE2 ": %s\n", dlerror ());
    dlclose (h1);
    exit (-1);
  }

  /* Allright, now call the main function from second module */
  void (*test_reexp) () = (void (*)())dlsym (h2, "test_reexp");
  if (test_reexp)
    test_reexp ();

  dlclose (h2);
  dlclose (h1);
  return 0;
}
