
#include "app.h"

#define CHAR_WIDTH	6
#define CHAR_HEIGHT 8
#define MY_WIDTH	HEIGHT
#define MY_HEIGHT	WIDTH


static Boolean charsGetPx(char ch, UInt8 r, UInt8 c);

static UInt8 convert_2d_to_1d(UInt8 x, UInt8 y)
{
    return  ((HEIGHT - 1 - y)*WIDTH+(x));
}

static void set_pixel(UInt8 x, UInt8 y, UInt8 on)	//actually rotates the drawn image (hence "x", "y" instead of "r", "c")
{
    UInt8 arrayPos = convert_2d_to_1d(x,y);
	UInt8 mask;
	UInt8* img_b = appBufGet(1);

	mask = 1 << (arrayPos & 7);
	arrayPos >>= 3;

	if(on) 
		img_b[arrayPos] |= mask;
 	else 
		img_b[arrayPos] &= ~mask;
}

static UInt16 strlen(const char* s){

	UInt16 c = 0;

	while(*s++) c++;

	return c;
}

static void waitFrame(void){

	UInt8 frame;	


	frame = appGetFrameNo();
	while(appGetFrameNo() == frame);
}

static void tostr(char* s, UInt8 v){

	s[0] = (v / 10) + '0';
	s[1] = (v % 10) + '0';
}

void appMarquee(const char* str){

	char strTime[16];
	UInt8 r, c, y = 2, inv = 0;
	Int16 i, x = 0, L, totalWidth = 0;
	Boolean customStr = !!str;	//if pasded a string we just show it once
	
	if(!customStr) str = strTime;

	while(1){
		
		Int16 charX = 0;

		if(!customStr){

			UInt32 s, m, h;

			s = appReadRtc() / RTC_TICKS_PER_SEC;
			
			m = s / 60;
			s = s % 60;

			h = m / 60;
			m = m % 60;
		
			h = h % 24;

			tostr(strTime + 2, h);
			tostr(strTime + 5, m);
			tostr(strTime + 8, s);


			strTime[0] = ' ';
			strTime[1] = ' ';
			strTime[4] = ':';
			strTime[7] = ':';
			strTime[10] = ' ';
			strTime[11] = ' ';
			strTime[12] = 0;
			
		//	x = 0;
		}

		L = strlen(str);
		totalWidth = L * CHAR_WIDTH;
		
		if(x == totalWidth){

			x = 0;
			y = appGetRand() % (MY_HEIGHT - CHAR_HEIGHT);
			inv = (appGetRand() & 1) != 0;
			if(customStr) break;
		}


		for(i = 0; i < L; i++){

			charX += CHAR_WIDTH;
		
			if(charX >= x + MY_WIDTH) break;			//char is off to the right
			if(charX + CHAR_WIDTH < x)	continue;	//char is off to the left

			for(r = 0; r < 8; r++){
				for(c = 0; c < 6; c++){
	
					Int8 ec = (Int16)c + (charX - x);

					if(ec >= 0 && ec < MY_WIDTH) set_pixel(r + y, ec, inv != charsGetPx(str[i], r, c));
				}
			}

			for(c = 0; c < MY_WIDTH; c++){

				for(r = 0; r < y; r++) set_pixel(r, c, inv);
				for(r = y + CHAR_HEIGHT; r < MY_HEIGHT; r++) set_pixel(r, c, inv);
			}
		}		

		appBufFlip();
		waitFrame();
		__delay_ms(300);
		x++;
	}
}






/////////////////////




#define FIRST_VALID_CHAR	0x20
#define LAST_VALID_CHAR		0x7F
#define MISSING_CHAR_CHAR	0x7F

static const UInt8 chars[];



static Boolean charsGetPx(char ch_, UInt8 row, UInt8 col){

	const UInt8* chr;
	UInt8 ch = (unsigned char)ch_;
	
	chr = chars;
	if(ch < FIRST_VALID_CHAR || ch > LAST_VALID_CHAR) ch = MISSING_CHAR_CHAR;
	ch -= FIRST_VALID_CHAR;
	chr += ((UInt16)ch * 6);

	if(col >= CHAR_WIDTH) col = 0;
	
	//each 3 bytes code for 4 rows of the symbol
	while(row >= 4){
		
		chr += 3;
		row -= 4;
	}
	
	while(row--) col += CHAR_WIDTH;	//sol is now the bit we want
	
	chr += (col / 8);
	
	col = col % 8;
	
	return ((*chr) >> col) & 1;
}



#define _	0UL
#define W	1UL
	


#define R(a0,a1,a2,a3,a4,a5,b0,b1,b2,b3,b4,b5,c0,c1,c2,c3,c4,c5,d0,d1,d2,d3,d4,d5)				\
																								\
												(a0 << 0) | (a1 << 1) | (a2 << 2) | (a3 << 3) |	\
												(a4 << 4) | (a5 << 5) | (b0 << 6) | (b1 << 7),	\
												(b2 << 0) | (b3 << 1) | (b4 << 2) | (b5 << 3) |	\
												(c0 << 4) | (c1 << 5) | (c2 << 6) | (c3 << 7),	\
												(c4 << 0) | (c5 << 1) | (d0 << 2) | (d1 << 3) |	\
												(d2 << 4) | (d3 << 5) | (d4 << 6) | (d5 << 7)



static const UInt8 chars[]=

{

//' ',

R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_),
R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_),




//'!',

R(_,_,W,_,_,_,
  _,_,W,_,_,_,
  _,_,W,_,_,_,
  _,_,W,_,_,_),
R(_,_,_,_,_,_,
  _,_,W,_,_,_,
  _,_,W,_,_,_,
  _,_,_,_,_,_),




//'"',

R(_,W,_,W,_,_,
  _,W,_,W,_,_,
  _,W,_,W,_,_,
  _,_,_,_,_,_),
R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_),




//'#',

R(_,W,_,W,_,_,
  _,W,_,W,_,_,
  W,W,W,W,W,_,
  _,W,_,W,_,_),
R(W,W,W,W,W,_,
  _,W,_,W,_,_,
  _,W,_,W,_,_,
  _,_,_,_,_,_),



//'$',

R(_,_,W,_,_,_,
  _,W,W,W,W,_,
  W,_,W,_,_,_,
  _,W,W,W,_,_),
R(_,_,W,_,W,_,
  W,W,W,W,_,_,
  _,_,W,_,_,_,
  _,_,_,_,_,_),




//'%',

R(W,W,_,_,_,_,
  W,W,_,_,W,_,
  _,_,_,W,_,_,
  _,_,W,_,_,_),
R(_,W,_,_,_,_,
  W,_,_,W,W,_,
  _,_,_,W,W,_,
  _,_,_,_,_,_),




//'&',

R(_,W,_,_,_,_,
  W,_,W,_,_,_,
  W,_,W,_,_,_,
  _,W,_,_,_,_),
R(W,_,W,_,W,_,
  W,_,_,W,_,_,
  _,W,W,_,W,_,
  _,_,_,_,_,_),




//''',

R(_,_,W,_,_,_,
  _,_,W,_,_,_,
  _,_,W,_,_,_,
  _,_,_,_,_,_),
R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_),




//'(',

R(_,_,W,_,_,_,
  _,W,_,_,_,_,
  W,_,_,_,_,_,
  W,_,_,_,_,_),
R(W,_,_,_,_,_,
  _,W,_,_,_,_,
  _,_,W,_,_,_,
  _,_,_,_,_,_),

  
  
//')',

R(_,_,W,_,_,_,
  _,_,_,W,_,_,
  _,_,_,_,W,_,
  _,_,_,_,W,_),
R(_,_,_,_,W,_,
  _,_,_,W,_,_,
  _,_,W,_,_,_,
  _,_,_,_,_,_),

  
  
//'*',

R(_,_,_,_,_,_,
  _,_,W,_,_,_,
  W,_,W,_,W,_,
  _,W,W,W,_,_),
R(W,_,W,_,W,_,
  _,_,W,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_),

  
  
//'+',

R(_,_,_,_,_,_,
  _,_,W,_,_,_,
  _,_,W,_,_,_,
  W,W,W,W,W,_),
R(_,_,W,_,_,_,
  _,_,W,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_),

  
  
//',',

R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_),
R(_,_,_,_,_,_,
  _,W,W,_,_,_,
  _,_,W,_,_,_,
  _,W,_,_,_,_),

  
  
//'-',

R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_,
  W,W,W,W,W,_),
R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_),

  
  
//'.',

R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_),
R(_,_,_,_,_,_,
  _,W,W,_,_,_,
  _,W,W,_,_,_,
  _,_,_,_,_,_),

  
  
//'/',

R(_,_,_,_,_,_,
  _,_,_,_,W,_,
  _,_,_,W,_,_,
  _,_,W,_,_,_),
R(_,W,_,_,_,_,
  W,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_),

  
  
//'0',

R(_,W,W,W,_,_,
  W,_,_,_,W,_,
  W,_,_,W,W,_,
  W,_,W,_,W,_),
R(W,W,_,_,W,_,
  W,_,_,_,W,_,
  _,W,W,W,_,_,
  _,_,_,_,_,_),

  
  
//'1',

R(_,_,W,_,_,_,
  _,W,W,_,_,_,
  _,_,W,_,_,_,
  _,_,W,_,_,_),
R(_,_,W,_,_,_,
  _,_,W,_,_,_,
  _,W,W,W,_,_,
  _,_,_,_,_,_),

  
  
//'2',

R(_,W,W,W,_,_,
  W,_,_,_,W,_,
  _,_,_,_,W,_,
  _,_,_,W,_,_),
R(_,_,W,_,_,_,
  _,W,_,_,_,_,
  W,W,W,W,W,_,
  _,_,_,_,_,_),

  
  
//'3',

R(W,W,W,W,W,_,
  _,_,_,W,_,_,
  _,_,W,_,_,_,
  _,_,_,W,_,_),
R(_,_,_,_,W,_,
  W,_,_,_,W,_,
  _,W,W,W,_,_,
  _,_,_,_,_,_),

  
  
  
//'4',

R(_,_,_,W,_,_,
  _,_,W,W,_,_,
  _,W,_,W,_,_,
  W,_,_,W,_,_),
R(W,W,W,W,W,_,
  _,_,_,W,_,_,
  _,_,_,W,_,_,
  _,_,_,_,_,_),

  
  
//'5',

R(W,W,W,W,W,_,
  W,_,_,_,_,_,
  W,W,W,W,_,_,
  _,_,_,_,W,_),
R(_,_,_,_,W,_,
  W,_,_,_,W,_,
  _,W,W,W,_,_,
  _,_,_,_,_,_),

  
  
  
//'6',

R(_,_,W,W,_,_,
  _,W,_,_,_,_,
  W,_,_,_,_,_,
  W,W,W,W,_,_),
R(W,_,_,_,W,_,
  W,_,_,_,W,_,
  _,W,W,W,_,_,
  _,_,_,_,_,_),

  
  
//'7',

R(W,W,W,W,W,_,
  _,_,_,_,W,_,
  _,_,_,W,_,_,
  _,_,W,_,_,_),
R(_,W,_,_,_,_,
  _,W,_,_,_,_,
  _,W,_,_,_,_,
  _,_,_,_,_,_),

  
  
//'8',

R(_,W,W,W,_,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_,
  _,W,W,W,_,_),
R(W,_,_,_,W,_,
  W,_,_,_,W,_,
  _,W,W,W,_,_,
  _,_,_,_,_,_),

  
  
//'9',

R(_,W,W,W,_,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_,
  _,W,W,W,W,_),
R(_,_,_,_,W,_,
  _,_,_,W,_,_,
  _,W,W,_,_,_,
  _,_,_,_,_,_),

  
  
//':',

R(_,_,_,_,_,_,
  _,W,W,_,_,_,
  _,W,W,_,_,_,
  _,_,_,_,_,_),
R(_,W,W,_,_,_,
  _,W,W,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_),




//';',

R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,W,W,_,_,
  _,_,W,W,_,_),
R(_,_,_,_,_,_,
  _,_,W,W,_,_,
  _,_,_,W,_,_,
  _,_,W,_,_,_),




//'<',

R(_,_,_,W,_,_,
  _,_,W,_,_,_,
  _,W,_,_,_,_,
  W,_,_,_,_,_),
R(_,W,_,_,_,_,
  _,_,W,_,_,_,
  _,_,_,W,_,_,
  _,_,_,_,_,_),

  
  
//'=',

R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  W,W,W,W,W,_,
  _,_,_,_,_,_),
R(W,W,W,W,W,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_),

  
  
//'>',

R(_,W,_,_,_,_,
  _,_,W,_,_,_,
  _,_,_,W,_,_,
  _,_,_,_,W,_),
R(_,_,_,W,_,_,
  _,_,W,_,_,_,
  _,W,_,_,_,_,
  _,_,_,_,_,_),
  
  
//'?',

R(_,W,W,W,_,_,
  W,_,_,_,W,_,
  _,_,_,_,W,_,
  _,_,_,W,_,_),
R(_,_,W,_,_,_,
  _,_,_,_,_,_,
  _,_,W,_,_,_,
  _,_,_,_,_,_),




//'@',

R(_,W,W,W,_,_,
  W,_,_,_,W,_,
  W,_,W,_,W,_,
  W,_,W,W,W,_),
R(W,_,W,_,_,_,
  W,_,_,_,_,_,
  _,W,W,W,W,_,
  _,_,_,_,_,_),




//'A',

R(_,W,W,W,_,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,W,W,W,W,_),
R(W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_,
  _,_,_,_,_,_),

  
  
//'B',

R(W,W,W,W,_,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,W,W,W,_,_),
R(W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,W,W,W,_,_,
  _,_,_,_,_,_),

  
  
//'C',

R(_,W,W,W,_,_,
  W,_,_,_,W,_,
  W,_,_,_,_,_,
  W,_,_,_,_,_),
R(W,_,_,_,_,_,
  W,_,_,_,W,_,
  _,W,W,W,_,_,
  _,_,_,_,_,_),

  
  
//'D',

R(W,W,W,W,_,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_),
R(W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,W,W,W,_,_,
  _,_,_,_,_,_),

  
  
//'E',

R(W,W,W,W,W,_,
  W,_,_,_,_,_,
  W,_,_,_,_,_,
  W,W,W,W,_,_),
R(W,_,_,_,_,_,
  W,_,_,_,_,_,
  W,W,W,W,W,_,
  _,_,_,_,_,_),

  
  
//'F',

R(W,W,W,W,W,_,
  W,_,_,_,_,_,
  W,_,_,_,_,_,
  W,W,W,W,_,_),
R(W,_,_,_,_,_,
  W,_,_,_,_,_,
  W,_,_,_,_,_,
  _,_,_,_,_,_),

  
  
//'G',

R(_,W,W,W,_,_,
  W,_,_,_,W,_,
  W,_,_,_,_,_,
  W,_,W,W,W,_),
R(W,_,_,_,W,_,
  W,_,_,_,W,_,
  _,W,W,W,_,_,
  _,_,_,_,_,_),

  
  
//'H',

R(W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,W,W,W,W,_),
R(W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_,
  _,_,_,_,_,_),

  
  
//'I',

R(_,W,W,W,_,_,
  _,_,W,_,_,_,
  _,_,W,_,_,_,
  _,_,W,_,_,_),
R(_,_,W,_,_,_,
  _,_,W,_,_,_,
  _,W,W,W,_,_,
  _,_,_,_,_,_),

  
  
//'J',

R(_,_,W,W,W,_,
  _,_,_,W,_,_,
  _,_,_,W,_,_,
  _,_,_,W,_,_),
R(_,_,_,W,_,_,
  W,_,_,W,_,_,
  _,W,W,_,_,_,
  _,_,_,_,_,_),

  
  
//'K',

R(W,_,_,_,W,_,
  W,_,_,W,_,_,
  W,_,W,_,_,_,
  W,W,_,_,_,_),
R(W,_,W,_,_,_,
  W,_,_,W,_,_,
  W,_,_,_,W,_,
  _,_,_,_,_,_),

  
  
//'L',

R(W,_,_,_,_,_,
  W,_,_,_,_,_,
  W,_,_,_,_,_,
  W,_,_,_,_,_),
R(W,_,_,_,_,_,
  W,_,_,_,_,_,
  W,W,W,W,W,_,
  _,_,_,_,_,_),

  
  
//'M',

R(W,_,_,_,W,_,
  W,W,_,W,W,_,
  W,_,W,_,W,_,
  W,_,W,_,W,_),
R(W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_,
  _,_,_,_,_,_),

  
  
//'N',

R(W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,W,_,_,W,_,
  W,_,W,_,W,_),
R(W,_,_,W,W,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_,
  _,_,_,_,_,_),

  
  
//'O',

R(_,W,W,W,_,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_),
R(W,_,_,_,W,_,
  W,_,_,_,W,_,
  _,W,W,W,_,_,
  _,_,_,_,_,_),

  
  
//'P',

R(W,W,W,W,_,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,W,W,W,_,_),
R(W,_,_,_,_,_,
  W,_,_,_,_,_,
  W,_,_,_,_,_,
  _,_,_,_,_,_),

  
  
  
//'Q',

R(_,W,W,W,_,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_),
R(W,_,W,_,W,_,
  W,_,_,W,_,_,
  _,W,W,_,W,_,
  _,_,_,_,_,_),

  
  
//'R',

R(W,W,W,W,_,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,W,W,W,_,_),
R(W,_,W,_,_,_,
  W,_,_,W,_,_,
  W,_,_,_,W,_,
  _,_,_,_,_,_),

  
  
  
//'S',

R(_,W,W,W,W,_,
  W,_,_,_,_,_,
  W,_,_,_,_,_,
  _,W,W,W,_,_),
R(_,_,_,_,W,_,
  _,_,_,_,W,_,
  W,W,W,W,_,_,
  _,_,_,_,_,_),

  
  
  
//'T',

R(W,W,W,W,W,_,
  _,_,W,_,_,_,
  _,_,W,_,_,_,
  _,_,W,_,_,_),
R(_,_,W,_,_,_,
  _,_,W,_,_,_,
  _,_,W,_,_,_,
  _,_,_,_,_,_),

  
  
  
//'U',

R(W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_),
R(W,_,_,_,W,_,
  W,_,_,_,W,_,
  _,W,W,W,_,_,
  _,_,_,_,_,_),

  
  
//'V',

R(W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_),
R(W,_,_,_,W,_,
  _,W,_,W,_,_,
  _,_,W,_,_,_,
  _,_,_,_,_,_),

  
  
//'W',

R(W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_),
R(W,_,W,_,W,_,
  W,_,W,_,W,_,
  _,W,_,W,_,_,
  _,_,_,_,_,_),

  
  
//'X',

R(W,_,_,_,W,_,
  W,_,_,_,W,_,
  _,W,_,W,_,_,
  _,_,W,_,_,_),
R(_,W,_,W,_,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_,
  _,_,_,_,_,_),

  
  
//'Y',

R(W,_,_,_,W,_,
  W,_,_,_,W,_,
  _,W,_,W,_,_,
  _,_,W,_,_,_),
R(_,_,W,_,_,_,
  _,_,W,_,_,_,
  _,_,W,_,_,_,
  _,_,_,_,_,_),

  
  
//'Z',

R(W,W,W,W,W,_,
  _,_,_,_,W,_,
  _,_,_,W,_,_,
  _,_,W,_,_,_),
R(_,W,_,_,_,_,
  W,_,_,_,_,_,
  W,W,W,W,W,_,
  _,_,_,_,_,_),

  
  
//'[',

R(_,_,W,W,_,_,
  _,_,W,_,_,_,
  _,_,W,_,_,_,
  _,_,W,_,_,_),
R(_,_,W,_,_,_,
  _,_,W,_,_,_,
  _,_,W,W,_,_,
  _,_,_,_,_,_),

  
  
//'\',

R(_,_,_,_,_,_,
  W,_,_,_,_,_,
  _,W,_,_,_,_,
  _,_,W,_,_,_),
R(_,_,_,W,_,_,
  _,_,_,_,W,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_),

  
  
//']',

R(_,_,W,W,_,_,
  _,_,_,W,_,_,
  _,_,_,W,_,_,
  _,_,_,W,_,_),
R(_,_,_,W,_,_,
  _,_,_,W,_,_,
  _,_,W,W,_,_,
  _,_,_,_,_,_),

  
  
//'^',

R(_,_,W,_,_,_,
  _,W,_,W,_,_,
  W,_,_,_,W,_,
  _,_,_,_,_,_),
R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_),




//'_',

R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_),
R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  W,W,W,W,W,_,
  _,_,_,_,_,_),




//'`',

R(_,_,W,_,_,_,
  _,_,W,_,_,_,
  _,_,_,W,_,_,
  _,_,_,_,_,_),
R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_),




//'a',

R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  _,W,W,W,_,_,
  _,_,_,_,W,_),
R(_,W,W,W,W,_,
  W,_,_,_,W,_,
  _,W,W,W,W,_,
  _,_,_,_,_,_),

  
  
//'b',

R(W,_,_,_,_,_,
  W,_,_,_,_,_,
  W,_,W,W,_,_,
  W,W,_,_,W,_),
R(W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,W,W,W,_,_,
  _,_,_,_,_,_),

  
  
//'c',

R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  _,W,W,W,_,_,
  W,_,_,_,_,_),
R(W,_,_,_,_,_,
  W,_,_,_,W,_,
  _,W,W,W,_,_,
  _,_,_,_,_,_),

  
  
//'d',

R(_,_,_,_,W,_,
  _,_,_,_,W,_,
  _,W,W,_,W,_,
  W,_,_,W,W,_),
R(W,_,_,_,W,_,
  W,_,_,_,W,_,
  _,W,W,W,W,_,
  _,_,_,_,_,_),

  
  
//'e',

R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  _,W,W,W,_,_,
  W,_,_,_,W,_),
R(W,W,W,W,W,_,
  W,_,_,_,_,_,
  _,W,W,W,_,_,
  _,_,_,_,_,_),

  
  
//'f',

R(_,_,W,W,_,_,
  _,W,_,_,W,_,
  _,W,_,_,_,_,
  W,W,W,_,_,_),
R(_,W,_,_,_,_,
  _,W,_,_,_,_,
  _,W,_,_,_,_,
  _,_,_,_,_,_),

  
  
//'g',

R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  _,W,W,W,W,_,
  W,_,_,_,W,_),
R(W,_,_,_,W,_,
  _,W,W,W,W,_,
  _,_,_,_,W,_,
  _,W,W,W,_,_),

  
  
//'h',

R(W,_,_,_,_,_,
  W,_,_,_,_,_,
  W,_,W,W,_,_,
  W,W,_,_,W,_),
R(W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_,
  _,_,_,_,_,_),

  
  
//'i',

R(_,_,W,_,_,_,
  _,_,_,_,_,_,
  _,W,W,_,_,_,
  _,_,W,_,_,_),
R(_,_,W,_,_,_,
  _,_,W,_,_,_,
  _,W,W,W,_,_,
  _,_,_,_,_,_),

  
  
//'j',

R(_,_,_,W,_,_,
  _,_,_,_,_,_,
  _,_,W,W,_,_,
  _,_,_,W,_,_),
R(_,_,_,W,_,_,
  _,_,_,W,_,_,
  W,_,_,W,_,_,
  _,W,W,_,_,_),

  
  
//'k',

R(_,W,_,_,_,_,
  _,W,_,_,_,_,
  _,W,_,_,W,_,
  _,W,_,W,_,_),
R(_,W,W,_,_,_,
  _,W,_,W,_,_,
  _,W,_,_,W,_,
  _,_,_,_,_,_),

  
  
//'l',

R(_,W,W,_,_,_,
  _,_,W,_,_,_,
  _,_,W,_,_,_,
  _,_,W,_,_,_),
R(_,_,W,_,_,_,
  _,_,W,_,_,_,
  _,W,W,W,_,_,
  _,_,_,_,_,_),

  
  
//'m',

R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  W,W,_,W,_,_,
  W,_,W,_,W,_),
R(W,_,W,_,W,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_,
  _,_,_,_,_,_),

  
  
//'n',

R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  W,_,W,W,_,_,
  W,W,_,_,W,_),
R(W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_,
  _,_,_,_,_,_),

  
  
//'o',

R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  _,W,W,W,_,_,
  W,_,_,_,W,_),
R(W,_,_,_,W,_,
  W,_,_,_,W,_,
  _,W,W,W,_,_,
  _,_,_,_,_,_),

  
  
//'p',

R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  W,W,W,W,_,_,
  W,_,_,_,W,_),
R(W,_,_,_,W,_,
  W,W,W,W,_,_,
  W,_,_,_,_,_,
  W,_,_,_,_,_),

  
  
//'q',

R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  _,W,W,_,W,_,
  W,_,_,W,W,_),
R(W,_,_,_,W,_,
  _,W,W,W,W,_,
  _,_,_,_,W,_,
  _,_,_,_,W,_),

  
  
//'r',

R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  W,_,W,W,_,_,
  W,W,_,_,W,_),
R(W,_,_,_,_,_,
  W,_,_,_,_,_,
  W,_,_,_,_,_,
  _,_,_,_,_,_),

  
  
//'s',

R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  _,W,W,W,_,_,
  W,_,_,_,_,_),
R(_,W,W,W,_,_,
  _,_,_,_,W,_,
  W,W,W,W,_,_,
  _,_,_,_,_,_),

  
  
//'t',

R(_,W,_,_,_,_,
  _,W,_,_,_,_,
  W,W,W,_,_,_,
  _,W,_,_,_,_),
R(_,W,_,_,_,_,
  _,W,_,_,W,_,
  _,_,W,W,_,_,
  _,_,_,_,_,_),

  
  
//'u',

R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_),
R(W,_,_,_,W,_,
  W,_,_,W,W,_,
  _,W,W,_,W,_,
  _,_,_,_,_,_),

  
  
//'v',

R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_),
R(W,_,_,_,W,_,
  _,W,_,W,_,_,
  _,_,W,_,_,_,
  _,_,_,_,_,_),

  
  
//'w',

R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_),
R(W,_,W,_,W,_,
  W,_,W,_,W,_,
  _,W,_,W,_,_,
  _,_,_,_,_,_),

  
  
//'x',

R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  W,_,_,_,W,_,
  _,W,_,W,_,_),
R(_,_,W,_,_,_,
  _,W,_,W,_,_,
  W,_,_,_,W,_,
  _,_,_,_,_,_),

  
  
//'y',

R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_),
R(W,_,_,_,W,_,
  _,W,W,W,W,_,
  _,_,_,_,W,_,
  _,W,W,W,_,_),

  
  
//'z',

R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  W,W,W,W,W,_,
  _,_,_,W,_,_),
R(_,_,W,_,_,_,
  _,W,_,_,_,_,
  W,W,W,W,W,_,
  _,_,_,_,_,_),

  
  
//'{',

R(_,_,W,W,_,_,
  _,W,_,_,_,_,
  _,W,_,_,_,_,
  W,_,_,_,_,_),
R(_,W,_,_,_,_,
  _,W,_,_,_,_,
  _,_,W,W,_,_,
  _,_,_,_,_,_),

  
  
//'|',

R(_,_,W,_,_,_,
  _,_,W,_,_,_,
  _,_,W,_,_,_,
  _,_,W,_,_,_),
R(_,_,W,_,_,_,
  _,_,W,_,_,_,
  _,_,W,_,_,_,
  _,_,_,_,_,_),




//'}',

R(W,W,_,_,_,_,
  _,_,W,_,_,_,
  _,_,W,_,_,_,
  _,_,_,W,_,_),
R(_,_,W,_,_,_,
  _,_,W,_,_,_,
  W,W,_,_,_,_,
  _,_,_,_,_,_),

  
  
//'~',

R(_,_,_,_,_,_,
  _,W,_,_,_,_,
  W,_,W,_,W,_,
  _,_,_,W,_,_),
R(_,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_,
  _,_,_,_,_,_),




// '\0x7F',	//- no char

R(W,W,W,W,W,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,_,_,_,W,_),
R(W,_,_,_,W,_,
  W,_,_,_,W,_,
  W,W,W,W,W,_,
  _,_,_,_,_,_),


};



