#ifndef _SOC_H_
#define _SOC_H_

#include <stdbool.h>
#include <stdint.h>


#define DISK_SEC_SZ				512



//rom port accesses
#define SOC_IO_ADDR_CHAR_LO		0x000		//no effect when written
#define SOC_IO_ADDR_CHAR_HI		0x001		//sends char when written (incl TXLO).
#define SOC_IO_ADDR_CHAR_RD		0x002		//when read, latches an incoming char. returns nonzero if one exists, tyou can then read SOC_IO_ADDR_CHAR_LO/SOC_IO_ADDR_CHAR_HI



bool socInit(const uint8_t *rom, uint32_t romSz, uint8_t *ram, uint8_t *ramSta /* precisely 1/4 the size */, uint32_t ramSz);
void socRun(void);

uint8_t socGetRomPage(void);

//exernally provided
void socExtPutChar(char ch);
int_fast16_t socExtGetChar(void);	//return -1 if none


bool socExtSdSecRead(uint32_t sec, uint8_t *dst);
bool socExtSdSecWrite(uint32_t sec, const uint8_t *dst);
uint32_t socExtSdGetSize(void);


//psram stats (0, 1, or -2 for both)
uint64_t socPrvGetPsramNumSelections(int8_t which);
uint64_t socPrvGetPsramNumSelectionsPage0(int8_t which);
uint64_t socPrvGetPsramSelectedTicks(int8_t which);
uint32_t socPrvGetPsramLongestSelectedTicks(int8_t which);

#endif

