#ifndef _CPU_H_
#define _CPU_H_

#include <stdbool.h>
#include <stdint.h>



bool cpuInit(void);
void cpuRunInstr(void);

void cpuPrvSetTestSignal(bool signal);	//signal is "1"

uint64_t cpuGetCy(void);
uint64_t cpuGetInstrCt(void);

//exernally provided
uint8_t cpuExtRomRead(uint_fast16_t addr);
uint8_t cpuExtRamRead(uint_fast16_t addr);									//only nibble read
void cpuExtRamWrite(uint_fast16_t addr, uint_fast8_t val);					//only nibble written

uint8_t cpuExtStatusByteRead(uint_fast16_t addr);							//only nibble read		//ADDR == 256 * DCL + (src & 0xf0) + statusByteIdx /* 0..3 */
void cpuExtStatusByteWrite(uint_fast16_t addr, uint_fast8_t val);			//only nibble written	//ADDR == 256 * DCL + (src & 0xf0) + statusByteIdx /* 0..3 */

uint8_t cpuExtRomPortRead(void);												//only nibble read
void cpuExtRamPortWrite(uint_fast8_t chipIdx, uint_fast8_t val);			//only nibble written

//for external use
uint_fast8_t cpuRegRead(uint_fast8_t regIdx);
void cpuRegWrite(uint_fast8_t regIdx, uint_fast8_t val);


//externally provided
uint8_t cpuExtHyper(uint_fast8_t which, uint_fast8_t A, uint_fast8_t C);	//instructions 0x0? are used for this where x != 0. sets A to return val's bottom 4 bits, C to bit 4

const uint64_t* cpuPrvGetProfilingData(void);

#endif

