/*	 An 10-point Font similar to Arial for Web pages
	font with upper- and lowercase, etc., but no antialiasing
	Usage:	PutsArial10(BITMAP *bmp,int x,int y, int Hue, char *Str)
		(where Hue is the foreground color)
		StrLenArial10(char *Str)
		The font data should be loaded at the beginning of the
		program, by calling LoadArial10().
*/
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#include "allegro.h"
#include "lcars24.h"
#include "lccolor.h"
#include "parts.h"
#include "winfont.h"


int LoadArial10()
{
	int c;

	long z;
	PACKFILE *Fp;

	memset(Arial10, (null), 12544);
	strcpy( CurrentFile, "C:\\LCARS24\\SYSTEM\\FONTS\\arial10.sff" );
	Fp = pack_fopen(CurrentFile, "rb");
	if ( Fp == NULL) {
	FontLoadError(CurrentFile);
	exit(0);
	}
	for(z = 0; z < 12544; ++z ) {
		Arial10[z] = pack_getc(Fp);
	}
		pack_fclose( Fp );
	return(0);
}
int StrLenArial10(char *Str)
{
	char Capture[1800];
	int i;
	int k;
	int pos;
	int j;

	pos = 1;
	j = strlen(Str);
	strcpy(Capture, Str);
	if( Capture[j-1] <= 32 ) Capture[j-1] = 32;
	if( Capture[j] <= 32 ) Capture[j] = 32;
	k = NULL;
	Capture[j+1] = (k);
	for(k = 0; k < j; ++k) {
		i = Capture[k];
		if( Capture[k] == 9 ) pos = (40 + ((pos/40)*40) );
			else pos += Arial10[i]-65;
	}
	return(pos);
}
int BlitArial10(BITMAP *bmp, int x, int y, int Hue, int TargetChar)
{
	int a,b;
	int z;
	unsigned char i;
	static unsigned char BitVal[] = { 128,64,32,16,8,4,2,1 };

	if( TargetChar <= 32 ) return(1);
	z=(TargetChar-30)*64;
	for(b=0; b<16; ++b) {
		for(a=0; a<8; ++a) {
			i = Arial10[b+z] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x, b+y, Hue);
		}
	}
	for(b=0; b<16; ++b) {
		for(a=0; a<8; ++a) {
			i = Arial10[b+z+32] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x+8, b+y, Hue);
		}
	}
	return(0);
}
int PutsArial10(BITMAP *bmp,int x,int y, int Hue, char *Str)
{
	char Capture[1800];
	int i;
	int k;
	int pos;
	int j;
	int tabpos;
	unsigned int t;

	t=32;
	pos = x;
	j = strlen(Str);
	strcpy(Capture, Str);
	k = NULL;
	Capture[j+1] = (k);
	for(k = 0; k < j; ++k) {
		if( Capture[k] < 32 && Capture[k] != 9 ) i = (t);
		else i = Capture[k];
		if(y>0 && Capture[k] != 9 ) {
	 BlitArial10(bmp,pos,y,Hue,i);
		}
		if( Capture[k] == 9 ) {
			tabpos=0;
			while( pos-x >= tabpos) tabpos += 40;
			pos = tabpos + x;
		} else pos += Arial10[i]-65;
	}
	return(0);
}
int LoadMono13()
{
	int c;

	long z;
	PACKFILE *Fp;

	memset(Mono13, (null), 12544);
	strcpy( CurrentFile, "C:\\LCARS24\\SYSTEM\\FONTS\\mono13.sff" );
	Fp = pack_fopen(CurrentFile, "rb");
	if ( Fp == NULL) {
	FontLoadError(CurrentFile);
	exit(0);
	}
	for(z = 0; z < 12544; ++z ) {
		Mono13[z] = pack_getc(Fp);
	}
		pack_fclose( Fp );
	return(0);
}
int StrLenMono13(char *Str)
{
	char Capture[1800];
	int i;
	int k;
	int pos;
	int j;

	pos = 1;
	j = strlen(Str);
	strcpy(Capture, Str);
	if( Capture[j-1] <= 32 ) Capture[j-1] = 32;
	if( Capture[j] <= 32 ) Capture[j] = 32;
	k = NULL;
	Capture[j+1] = (k);
	for(k = 0; k < j; ++k) {
		i = Capture[k];
		if( Capture[k] == 9 ) pos = (40 + ((pos/40)*40) );
			else pos += Mono13[i]-65;
	}
	return(pos);
}
int BlitMono13(BITMAP *bmp, int x, int y, int Hue, int TargetChar)
{
	int a,b;
	int z;
	unsigned char i;
	static unsigned char BitVal[] = { 128,64,32,16,8,4,2,1 };

	if( TargetChar <= 32 ) return(1);
	if(isdigit(TargetChar)) Hue=PALEBLUE;
	z=(TargetChar-30)*64;
	for(b=0; b<24; ++b) {
		for(a=0; a<8; ++a) {
			i = Mono13[b+z] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x, b+y, Hue);
		}
	}
	for(b=0; b<24; ++b) {
		for(a=0; a<8; ++a) {
			i = Mono13[b+z+32] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x+8, b+y, Hue);
		}
	}
	return(0);
}
int PutsMono13(BITMAP *bmp,int x,int y, int Hue, char *Str)
{
	char Capture[1800];
	int i;
	int k;
	int pos;
	int j;
	int tabpos;
	unsigned int t;

	fc=Hue;
	bc=BLACK;
	FadeOut(fc);
	t=32;
	pos = x;
	j = strlen(Str);
	strcpy(Capture, Str);
	k = NULL;
	Capture[j+1] = (k);
	for(k = 0; k < j; ++k) {
		if( Capture[k] < 32 && Capture[k] != 9 ) i = (t);
		else i = Capture[k];
	if(y>0 && Capture[k] != 9 ) {
/*
		if(i==65 | i==77 | i==86 |i==87) {
			if(i==65) F14ptA(bmp,pos+1,y);
			if(i==77) F14ptM(bmp,pos,y);
			if(i==86) F14ptV(bmp,pos+1,y);
			if(i==87) F14ptW(bmp,pos,y);
		} else  */  BlitMono13(bmp,pos,y,Hue,i);
		}
		if( Capture[k] == 9 ) {
			tabpos=0;
			while( pos-x >= tabpos) tabpos += 40;
			pos = tabpos + x;
		} else pos += Mono13[i]-65;
	}
	return(0);
}


