/* 	Webfont, loader and driver for fonts for Web pages
	Usage: LoadWebFont(char *FontName)
		BlitWebFont(BITMAP *bmp,int x,int y,int Hue,int TargetChar)
		PutsWebFont(BITMAP *bmp,int x,int y,int Hue,char *Str)
		(where Hue is the foreground color)
		StrLenWebFont(char *Str)
		SetDefaultWebFont() loads Arial10 (was Web11).
		The font data for Arial10 should be loaded at the beginning
		of the program, by calling LoadArial10().
*/

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#include "webfont.h"

/* not used in LCARS 24 v.2.x */

/*
int LoadWeb11()
{
	int c;
	long z;
	PACKFILE *Fp;

	memset(Web11, (null), 12544);
	strcpy( CurrentFile, "C:\\LCARS24\\SYSTEM\\FONTS\\web11.sff" );
	Fp = pack_fopen(CurrentFile, "rb");
	if (Fp == NULL) FontLoadError(CurrentFile);
	for(z = 0; z < 12544; ++z ) Web11[z] = pack_getc(Fp);
	pack_fclose( Fp );
	return(0);
}
*/
int SetDefaultWebFont()
{
	int z;

	for(z = 0; z < 12544; ++z ) WebFont[z] = Arial10[z];
}
int LoadWebFont(char *FontName)
{
	int c;
	long z;
	PACKFILE *Fp;

	memset(WebFont, (null), 12544);
	strcpy( CurrentFile, "C:\\LCARS24\\SYSTEM\\FONTS\\" );
	strcat( CurrentFile, FontName);
	Fp = pack_fopen(CurrentFile, "rb");
	if (Fp == NULL) FontLoadError(CurrentFile);
	for(z = 0; z < 12544; ++z ) WebFont[z] = pack_getc(Fp);
	pack_fclose( Fp );
	return(0);
}
int StrLenWebFont(char *Str)
{
	char Capture[1800];
	int i;
	int k;
	int pos;
	int j;

	pos = 1;
	j = strlen(Str);
	strcpy(Capture, Str);
	if( Capture[j-1] <= 32 ) Capture[j-1] = 32;
	if( Capture[j] <= 32 ) Capture[j] = 32;
	k = NULL;
	Capture[j+1] = (k);
	for(k = 0; k < j; ++k) {
		i = Capture[k];
		if( Capture[k] == 9 ) pos = (40 + ((pos/40)*40) );
			else pos += WebFont[i]-65;
	}
	return(pos);
}
int BlitWebFont(BITMAP *bmp,int x,int y,int Hue,int TargetChar)
{
	int a,b;
	int z;
	unsigned char i;
	static unsigned char BitVal[] = { 128,64,32,16,8,4,2,1 };

	if(ItalicsOn==TRUE) x+=3;
	if( TargetChar <= 32 ) return(1);
	z=(TargetChar-30)*64;
	for(b=0; b<32; ++b) {
if(ItalicsOn==TRUE && (b==3 || b==6 || b==9 || b==12 || b==15 || b==18 || b==21 || b==24 || b==27)) x-=1;
		for(a=0; a<8; ++a) {
			i = WebFont[b+z] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x, b+y, Hue);
		}
	}
	for(b=0; b<32; ++b) {
		for(a=0; a<8; ++a) {
			i = WebFont[b+z+32] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x+8, b+y, Hue);
		}
	}
	return(0);
}

