/* Standby.c, variables and some functions of the main LCARS 24 module */

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#include "standby.h"

void Box1a(int Color, char *Str1, char *Str2, char *Str3, char *Str4)
{
	int boxtop;

	boxtop=10;
	rectfill(screen,10,boxtop,110,boxtop+54,Color);
	PutsLuna(14,boxtop + 4, BLACK,Color, Str1);
	PutsLuna(90,boxtop + 4, BLACK,Color, Str2);
	PutsLuna(14,boxtop + 37, BLACK,Color, Str3);
	PutsLuna(90,boxtop + 37, BLACK,Color, Str4);
}
void Box2a(int Hue, char *Str)
{
	int boxtop;

	boxtop=68;
	rectfill(screen,10,boxtop,110,boxtop+54,Hue);
	PutsLuna(14,boxtop + 37, BLACK,Hue, Str);
	PutsLuna(96,boxtop + 37, BLACK,Hue, "F9");

	if(strnicmp( "ALARM", Str,5 )==0 ) {
		if(AudioOff==TRUE) PutsLuna(14,boxtop+4,BLACK,Hue, "DISABLED");
			else {
				if(AlarmType==0) PutsLuna(14,boxtop+4,BLACK,Hue, "MIDI");
				if(AlarmType==1) PutsLuna(14,boxtop+4,BLACK,Hue, "MP3");
				if(AlarmType==2) PutsLuna(14,boxtop+4,BLACK,Hue, "VOICE");
			}
	}
}
void Box1b(int Hue, char *Str)
{
	int boxtop;

	boxtop=536;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
	PutsLuna(14,boxtop + 4, BLACK,Hue, Str);
	PutsLuna(96,boxtop + 4, BLACK,Hue, "F1");
}
void EscBox1b(int Hue, char *Str)
{
	int boxtop;

	boxtop=536;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
	PutsLuna(14,boxtop + 4, BLACK,Hue, Str);
	PutsLuna(90,boxtop + 4, BLACK,Hue, "F12");
}
void Box2b(int Hue)
{
	int boxtop;

	boxtop=479;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
	PutsLuna(14,boxtop + 4, BLACK,Hue, "RESTART");
	PutsLuna(96,boxtop + 4, BLACK,Hue, "F2");
}
void Box3b(int Hue)
{
	int boxtop;

	boxtop=422;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
	PutsLuna(14,boxtop + 4, BLACK,Hue, "FILES");
	PutsLuna(96,boxtop + 4, BLACK,Hue, "F3");
}
void Box4b(int Hue)
{
	int boxtop;

	boxtop=365;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
	PutsLuna(14,boxtop + 4, BLACK,Hue, "PROGRAMS");
	PutsLuna(96,boxtop + 4, BLACK,Hue, "F4");
}
void Box5b(int Hue)
{
	int boxtop;

	boxtop=308;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
	PutsLuna(14,boxtop + 4, BLACK,Hue, "LCARS");
	PutsLuna(96,boxtop + 4, BLACK,Hue, "F5");
}
void Box3bm(int Hue)
{
	int boxtop;

	boxtop=422;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
	PutsLuna(106-StrLenLuna("EXAMPLES")+2,boxtop+37, BLACK,Hue, "EXAMPLES");
}
void Box4bm(int Hue)
{
	int boxtop;

	boxtop=365;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
	PutsLuna(106-StrLenLuna("FUNCTIONS")+2,boxtop+37, BLACK,Hue, "FUNCTIONS");
}
void Box5bm(int Hue)
{
	int boxtop;

	boxtop=308;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
	PutsLuna(106-StrLenLuna("OPERATORS")+2,boxtop+37, BLACK,Hue, "OPERATORS");
}
void ElbowSignage(int Hue1, int Hue2)
{
	int boxtop;

	boxtop=130;

	PutsLuna(14,boxtop, BLACK,Hue1, "LIGHT");
	PutsLuna(89,boxtop, BLACK,Hue1, "SPC");
	PutsLuna(14,boxtop + 18, BLACK,Hue1, "PHONEBOOK");
	PutsLuna(96,boxtop + 18, BLACK,Hue1, "F8");

	boxtop=590 - (54*6) - 16;
	PutsLuna(14,boxtop + 37 -19, BLACK,Hue2, "WORLD TIME");
	PutsLuna(96,boxtop + 37 -19, BLACK,Hue2, "F7");

	PutsLuna(14,boxtop + 37, BLACK,Hue2, "MATH");
	PutsLuna(96,boxtop + 37, BLACK,Hue2, "F6");
}
void Boxes()
{
	Box1a(LILAC, "CLOSE", "F12", "HELP", "F11");
	if(SingleAlarmOnOff==0) Box2a(BracketColor2,"ALARM ON");
		else Box2a(MANGO,"ALARM OFF");
	Br1F1Box(BracketColor1, "SETTINGS", "F1");
	Br1F2Box(BracketColor1, "RESTART", "F2");
	Br1F3Box(BracketColor1, "FILES", "F3");
	Br1F4Box(BracketColor1, "PROGRAMS", "F4");
	Br1F5Box(BracketColor1, "LCARS", "F5");
	ElbowSignage(BracketColor1,BracketColor2);
}
void Screen1( int Clear)
{
	if(Clear==1) Wrapper(60,30);
	if(Clear==1) rectfill(screen,0,0,800,600, BLACK);
	Brackets1(BracketColor1,BracketColor2);
	Boxes();
	AlarmDisplay();
	min_old=70;
	day_old=32;
}
void ColorSwitch(int x, int y, int sz)
{
	if(SnoozeAlarmMin != 70) return;
	if( strcmp(SecDisplay,"57")==0 && TimeDisplay[4]==57 ) {
		TimeColor=ORANGE;
		BracketColor1=PALEBLUE;
		BracketColor2=NAPLES;
		Brackets1(BracketColor1,BracketColor2); /* for 3 seconds */
		Boxes();
		MarsF(x, y, sz, TimeColor, BLACK, TimeDisplay);
		PutDate();
		TimeColor=NAPLES;
	}
	if( strcmp(SecDisplay,"00")==0 && TimeDisplay[4]==57) {
		TimeColor=NAPLES;
		switch( ColorScheme )
			{
				case 1:	BracketColor1=PALEBLUE;
						BracketColor2=BIGBLUE;
						break;
				case 2:	BracketColor1=MANGO;
						BracketColor2=BRICK;
						break;
				default:  BracketColor1=ORANGE;
						BracketColor2=PALEBLUE;
			}
		Brackets1(BracketColor1,BracketColor2);
		Boxes();
		MarsF(x, y, sz, TimeColor, BLACK, TimeDisplay);
		PutDate();
	}
	if( strcmp(SecDisplay,"30")==0) {
		Br1F2Box(MANGO, "RESTART", "F2");
		Br1F3Box(MANGO, "FILES", "F3");
		Br1F4Box(MANGO, "PROGRAMS", "F4");
	}
	if( strcmp(SecDisplay,"33")==0) Boxes();
	if( strcmp(SecDisplay,"45")==0) {
		Br1F2Box(BRICK, "RESTART", "F2");
		Br1F3Box(BRICK, "FILES", "F3");
		Br1F4Box(BRICK, "PROGRAMS", "F4");
		Br1F5Box(MANGO, "LCARS", "F5");
	}
	if( strcmp(SecDisplay,"49")==0) {
		Br1F2Box(BIGBLUE, "RESTART", "F2");
		Br1F3Box(BIGBLUE, "FILES", "F3");
		Br1F4Box(BIGBLUE, "PROGRAMS", "F4");
		Br1F5Box(BIGBLUE, "LCARS", "F5");
	}
	if( strcmp(SecDisplay,"54")==0) Boxes();
}
void PutStarDate(int x, int y, int Color)
{ /* PutsFont21 widens a hyphen before a numeral to form a minus sign. */
	if( MidiPlaying != 0 ) return;
	if(SnoozeAlarmMin != 70) return;
	GetStarDate();
	rectfill(screen,x,y,x+152,y+21,BLACK);
	PutsFont21(x,y, Color,"STARDATE: ");
	PutsFont21(x+StrLenFont21("STARDATE: "),y, Color,"-");
	PutsFont21(x+StrLenFont21("STARDATE: ")+3,y, Color,StarDate);
}

/* Our own command-line DOS service */

void ClearTextBuf()
{
	int z;

	for(z=0; z <= EndText; ++z) memset(Ln[z],(null),LINELENGTH);
}
unsigned long DoFree()
{
	struct _diskfree_t d;
	long Megabytes=0;

	_dos_getdiskfree(3, &d);
	Megabytes=(d.avail_clusters * d.bytes_per_sector * d.sectors_per_cluster)/1048576;
	return(Megabytes);
}
unsigned long FloppyFree()
{
	struct _diskfree_t d;
	long FloppyBytesFree;

	_dos_getdiskfree(1, &d); /* drive A: */
	FloppyBytesFree = d.avail_clusters * d.bytes_per_sector;

	return(FloppyBytesFree);
}
void DirFindFilesAndInfo(char *mask, int Num)
{
	struct ffblk f;
	int FilesDone=findfirst(mask, &f, FA_ARCH);

	while (!FilesDone) {
		sprintf(DosFileArray[Num],"%10u  %2u:%02u  %2u/%02u/%4u  %s",
		f.ff_fsize,
		(f.ff_ftime >> 11) & 0x1f,
		(f.ff_ftime >>  5) & 0x3f,
		(f.ff_fdate >>  5) & 0x0f,
		(f.ff_fdate & 0x1f),
		((f.ff_fdate >> 9) & 0x7f) + 1980,
		f.ff_name);

		FilesDone=findnext(&f);
	}
}
void SortFiles()
{
	char bag[80];
	int f;
	int r=0;
	char done,ch;
	int z,i;

	for( z=0; z<NumOfFiles; ++z) ustrupr(DosFileArray[z]);

	do {
		done=TRUE;
		for (f=0; f<NumOfFiles-1; ++f) {
			r=strcmp(DosFileArray[f],DosFileArray[f+1]);
			if( r > 0 )	 {
				strcpy(bag,DosFileArray[f]);
				strcpy(DosFileArray[f],DosFileArray[f+1]);
				strcpy(DosFileArray[f+1],bag);
				done=FALSE;
			}
		}
	} while (done==FALSE);
}
int DirFindFiles(char *mask)
{
	struct ffblk f;
	int Found;

	TotalBytes=0;
	NumOfFiles=0;
	Found=findfirst(mask, &f, FA_ARCH);
	while ( !Found ) {
		strcpy(DosFileArray[NumOfFiles], f.ff_name);
		if(stricmp(f.ff_name,"CWSDPMI.SWP")!=0) ++NumOfFiles;
		TotalBytes += f.ff_fsize;
		Found=findnext( &f );
	}
	SortFiles();
	return(Found);
}
void SortFolders()
{
	char bag[80];
	int f,z;
	int r=0;
	char done;

	for( z=0; z<NumOfFolders; ++z) ustrupr(DosFolderArray[z]);

	do {
		done=TRUE;
		for (f=0; f<=NumOfFolders-1; ++f) {
			r=memicmp(DosFolderArray[f],DosFolderArray[f+1],80);
			if( r > 0 )	 {
				memcpy(bag,DosFolderArray[f],80);
				memcpy(DosFolderArray[f],DosFolderArray[f+1],80);
				memcpy(DosFolderArray[f+1],bag,80);
				done=FALSE;
			}
		}
	} while ( done==FALSE );
}
int DirFindFolders(char *mask)
{
	char Temp[32];
	struct ffblk f;
	int Found;

	NumOfFolders=0;
	Found=findfirst(mask, &f, FA_DIREC);
	while ( !Found ) {
		if(f.ff_attrib==FA_DIREC) {
			strcpy(DosFolderArray[NumOfFolders], ">								 <DIR>  ");
			strcat(DosFolderArray[NumOfFolders], f.ff_name);
			strcpy(Temp,f.ff_name);
			if(Temp[0]!='.') ++NumOfFolders;
		}
		Found=findnext( &f );
	}
	SortFolders();
	return(Found);
}
void DoDir(int b)
{
	int i,z, pos;
	char DummyPath[80];
	char mask[80]="*.*";
	int j,k,m,Result, FloppyFreeBytes;

	memset(DummyPath,(null),80);
	ClearTextBuf();

	m=0;
	while(KeyInStr[b]==32) ++b;
	k=strlen(KeyInStr);
	if(k < 5) goto bypass;
	for(j=b; j<k; ++j) {
		t=KeyInStr[j];
		DummyPath[m]=(t);
		++m;
	}
	DummyPath[m]=(null);
	strcpy(mask,DummyPath);

bypass:
	TotalBytes=0;
	ClearTextBuf();
	EndText=0;

	strcpy(Ln[EndText],">Directories:");
	++EndText;
	DirFindFolders(mask);
	DirFindFolders(mask);  /* DJGPP is more reliable if repeating. */
	for(z=0; z<NumOfFolders; ++z)  {
		strcpy(Ln[EndText],DosFolderArray[z]);
		++EndText;
	}
	if(NumOfFolders==0) strcat(Ln[0]," None");
	strcpy(Ln[EndText],"Files in Current Directory:");
	pos=EndText;
	++EndText;

	DirFindFiles(mask);	 /* Once is okay for this. */
	for(z=0; z<NumOfFiles; ++z)  {
		DirFindFilesAndInfo(DosFileArray[z], z);
		strcpy( Ln[EndText], DosFileArray[z]);
		++EndText;
	}
	if(NumOfFiles==0) strcat(Ln[pos]," None");
	sprintf(Ln[EndText],"%10d files(s)  %10u bytes", NumOfFiles, TotalBytes);
	++EndText;
	if(CurrentDrive==2) {
		sprintf(Ln[EndText],"%10d dir(s) %10u MB free (reported)",
		NumOfFolders, DoFree());
	}
	if(CurrentDrive==0) {
	FloppyFreeBytes=FloppyFree();
		sprintf(Ln[EndText],"%10d dir(s) %10u bytes free",
		NumOfFolders, FloppyFreeBytes);
	}
	++EndText;
}
void GetCopyPath(char *Maskspec)
{
	char PathnameOnly[80];
	char PathAndFilename[80];
	int Place,a,k;

	_fixpath(Maskspec,PathAndFilename);
	fix_filename_slashes(PathAndFilename);
	a=1;
	for(;;) {  /* find the last backslash */
		if( PathAndFilename[a] == 92 ) Place = a;
		if( PathAndFilename[a] == 0 ) break;
		++a;
	}
	strcpy(PathnameOnly,PathAndFilename);
	PathnameOnly[Place] = (null);
	strcpy(CopyPath,PathnameOnly);
	k=strlen(CopyPath);
	if(CopyPath[k]!='\\') strcat(CopyPath,"\\");
}
int GetYNA()
{
loopback:
	do {
		SolPutTime();
	} while(!kbhit());
	c=GetKey();
	switch( c )  		/* get Y/N/A */
	{
		case F12: return(2);
		case 65:
		case 97: return(3);	/* A/a */
		case 78:
		case 110: return(0); /* N/n */
		case 89:
		case 121: return(1); /* Y/y */
		default: goto loopback;
	}
}
int CopyOneFile(char *Dest, char *Source)
{
	char CmdStr[80];
	int Place;

	memset(CmdStr,(null),80);
	strcpy(CmdStr,"copy ");
	strcat(CmdStr,Dest);
	strcat(CmdStr," ");
	strcat(CmdStr,Source);
	strcat(CmdStr,">nul");
/*
rectfill(screen,118,26,500,49+32,BLACK);
PutsFont21(120,26,PURPLE,CmdStr);
*/
	system(CmdStr);
}
int DoCopy(int b)
{
	int i,z, pos;
	char DummyPath[80];
	char CheckPath[80];
	char CheckFile[80];
	char SourceFile[80];
	char Temp[80];
	char mask[80]="*.*";
	int j,k,m,cy,Result;
	int Skip=FALSE;
	int NumCopied=0;

	memset(DummyPath,(null),80);
	ClearTextBuf();

	m=0;
	while(KeyInStr[b]==32) ++b;
	k=strlen(KeyInStr);
	for(j=b; j<k; ++j) {
		t=KeyInStr[j];
		DummyPath[m]=(t);
		++m;
	}
	DummyPath[m]=(null);
	strcpy(mask,DummyPath);

	GetCopyPath(mask);

	TotalBytes=0;
	ClearTextBuf();
	EndText=0;

	strcpy(Ln[EndText],">Copying:");
	++EndText;

	strcpy(CheckPath,CurrentPath);
	k=strlen(CheckPath);
	CheckPath[k-1]='\\';
if(k==3) CheckPath[k-1]=(null); /* direct A: or C: */

	cy=0;
	DirFindFiles(mask);
	if(NumOfFiles==0) strcpy(Ln[0],"File not found");
	for(z=0; z<NumOfFiles; ++z)  {
		strcpy(Ln[EndText],CopyPath);

	strcpy(CheckFile,CheckPath);
	k=strlen(CheckFile);
	if(memicmp(CheckFile,"A:\\\\",3)==0 && k<5) strcpy(CheckFile,"A:\\");
	if(memicmp(CheckFile,"C:\\\\",3)==0 && k<5) strcpy(CheckFile,"C:\\");
	strcat(CheckFile,DosFileArray[z]);
/*
rectfill(screen,618,126,800,49+132,BLACK);
PutsFont21(620,126,PALEBLUE,CheckFile);
*/
		if(__file_exists(CheckFile) && Skip==FALSE) {
			strcpy(Ln[EndText],">");
			strcat(Ln[EndText],CheckFile);
			strcat(Ln[EndText]," Overwrite? ");
			strcpy(Temp,Ln[EndText]);
			strcat(Ln[EndText],"(Yes/No/All)");
			DosRefresh(cy);
			Result=GetYNA();
			strcpy(Ln[EndText],Temp);
			if(Result==2) return(2); /* close DOS service */
			if(Result==0) {
				strcat(Ln[EndText]," No");
			}
			if(Result==1) {
				strcat(Ln[EndText]," Yes");
				strcpy(SourceFile,CopyPath);
				strcat(SourceFile,DosFileArray[z]);
				CopyOneFile(SourceFile,CheckFile);
				++NumCopied;
			}
			if(Result==3) {
				strcat(Ln[EndText]," All starting here");
				Skip=TRUE;
				strcpy(SourceFile,CopyPath);
				strcat(SourceFile,DosFileArray[z]);
				CopyOneFile(SourceFile,CheckFile);
				++NumCopied;
			}
		} else {
			strcat( Ln[EndText], DosFileArray[z]);
			strcpy(SourceFile,CopyPath);
			strcat(SourceFile,DosFileArray[z]);
			CopyOneFile(SourceFile,CheckFile);
			++NumCopied;
		}
		if(EndText > 8) cy=EndText-8;
		DosRefresh(cy);
		++EndText;
	}
	sprintf(Ln[EndText],">Number of files copied: %u", NumCopied);
	++EndText;
	if(EndText > 8) cy=EndText-8;
	DosRefresh(cy);
	return(3);
}
int DoDel(int b)
{
	int i,z, pos,dy;
	char DummyPath[80];
	char mask[80];
	int j,k,m,Result;

	memset(DummyPath,(null),80);
	ClearTextBuf();

	EndText=0;
	m=0;
	while(KeyInStr[b]==32) ++b;
	k=strlen(KeyInStr);
	for(j=b; j<k; ++j) {
		t=KeyInStr[j];
		DummyPath[m]=(t);
		++m;
	}
	DummyPath[m]=(null);
	strcpy(mask,DummyPath);

	ClearTextBuf();
	EndText=0;
	strcpy(Ln[EndText],">Confirm: Delete all files listed below? (y/n)");
	++EndText;

	DirFindFiles(mask);
	for(z=0; z<NumOfFiles; ++z)  {
		DirFindFilesAndInfo(DosFileArray[z], z);
		strcpy( Ln[EndText], DosFileArray[z]);
		++EndText;
	}
	++EndText;
	if(NumOfFiles==0) {
		ClearTextBuf();
		strcpy(Ln[0],"Specified file(s) not found");
		EndText=1;
		return;
	}
	DosRefresh(0);
	dy=0;

loopback:
	do {
		SolPutTime();
	} while(!kbhit());
	c=GetKey();
	switch( c )  		/* get Y/N */
	{
		case F12: return(2);
		case 78:
		case 110: ClearTextBuf();	/* N/n */
			 strcpy(Ln[0],"Delection canceled");
			 EndText=1;
			 return(1);
		case 89:
		case 121: DirFindFiles(mask); /* Y/y */
			 for(i=0; i<NumOfFiles; ++i) remove(DosFileArray[i]);
			 ClearTextBuf();
			 strcpy(Ln[0],"Specified file(s) deleted");
			 EndText=1;
			 return(1);
		case UPARROW:
			if(dy<1) goto loopback;
			--dy;
			DosRefresh(dy);
			goto loopback;
		case DOWNARROW: if(dy>=EndText-8) goto loopback;
			++dy;
			DosRefresh(dy);
			goto loopback;
		default: goto loopback;
	}
}
void LineInput_DisplayInputString(int Hue)
{
	rectfill(screen,118,126,800,149+32,BLACK);
	PutsFont21(120,126,PALEBLUE,CurrentPath);
	PutsFont21(120+StrLenFont21(CurrentPath),126,Hue,KeyInStr);
}
void LineInput_Clear()
{
	cx=120-6;
	dx=1;
	memset(KeyInStr,(null),80);
	rectfill(screen,120,126,800,149+32,BLACK);
	LineInput_DisplayInputString(ORANGE);
}
void ChangeDirectory(int i)
{
	char DummyPath[80];
	char Prefix[80];
	int j,k,m,Result;

/* get the argument */
	memset(DummyPath,(null),80);
	m=0;
	k=strlen(KeyInStr);
	for(j=i; j<k; ++j) {
		if(t != 32) DummyPath[m]=toupper(KeyInStr[j]);
		++m;
	}
/* try it (no output if NG) */
	Result=chdir(DummyPath);
	if(Result != 0) return;

/* case such as CD \ */
/*
	if(strcmp(DummyPath,"\\")==0 && CurrentPath[0]=='A') strcpy(DummyPath,"A:\\");
	if(strcmp(DummyPath,"\\")==0 && CurrentPath[0]=='C') strcpy(DummyPath,"C:\\");
*/
/* case such as CD \somedir\subdir */
/*
	if(DummyPath[0]=='\\' && CurrentPath[0]=='A') {
		strcpy(Prefix,"A:");
		strcat(Prefix,DummyPath);
		strcpy(DummyPath,Prefix);
	}
	if(DummyPath[0]=='\\' && CurrentPath[0]=='C') {
		strcpy(Prefix,"C:");
		strcat(Prefix,DummyPath);
		strcpy(DummyPath,Prefix);
	}
*/
/* setup for subsequent case such as A: (handled elsewhere) */


	getcwd(DummyPath,80);
	fix_filename_slashes(DummyPath);

	if(CurrentDrive==2) strcpy(PathOfDriveC,DummyPath);
	if(CurrentDrive==0) strcpy(PathOfDriveA,DummyPath);

	strcat(DummyPath,">");
	strcpy(CurrentPath,DummyPath);

	LineInput_Clear();
	LineInput_DisplayInputString(MANGO);

	DirectoryChange=1;
}
int MakeDir(int b)
{
	char DummyPath[80];
	char DirPath[80];
	int j,k,m,Result;

	m=0;
	while(KeyInStr[b]==32) ++b;
	k=strlen(KeyInStr);
	for(j=b; j<k; ++j) {
		t=KeyInStr[j];
		DummyPath[m]=(t);
		++m;
	}
	DummyPath[m]=(null);

	_fixpath(DummyPath,DirPath);
	Result=mkdir(DirPath, S_IWUSR);
	fix_filename_slashes(DirPath);

	ClearTextBuf();
	if(Result==0) {
		strcpy(Ln[0],"New directory created:");
		strcpy(Ln[1],">");
		strcat(Ln[1],get_filename(DummyPath));
		strcpy(Ln[2],"Full path:");
		strcpy(Ln[3],">");
		strcat(Ln[3],DirPath);
		EndText=4;
	} else {
		strcpy(Ln[0],"Specified directory and/or path not valid");
		if(__file_exists(DirPath)) {
			strcpy(Ln[0],"Specified directory name already in use:");
			strcpy(Ln[1],">");
			strcat(Ln[1],DirPath);
		}
		EndText=1;
	}
	rectfill(screen,120,248,799,599,BLACK);
	DosRefresh(0);
}
int RemoveDir(int b)
{
	char DummyPath[80];
	char DirPath[80];
	int j,k,m,Result;

	m=0;
	while(KeyInStr[b]==32) ++b;
	k=strlen(KeyInStr);
	for(j=b; j<k; ++j) {
		t=KeyInStr[j];
		DummyPath[m]=(t);
		++m;
	}
	DummyPath[m]=(null);
	_fixpath(DummyPath,DirPath);
	Result=rmdir(DirPath);
	fix_filename_slashes(DirPath);

	ClearTextBuf();
	if(Result==0) {
		strcpy(Ln[0],"Directory removed:");
		strcpy(Ln[1],">");
		strcat(Ln[1],get_filename(DummyPath));
		strcpy(Ln[2],"Full path:");
		strcpy(Ln[3],">");
		strcat(Ln[3],DirPath);
		EndText=4;
	} else {
		strcpy(Ln[0],"Directory must be empty before calling this function");
		if( !  __file_exists(DirPath)) {
			strcpy(Ln[0],"Specified directory not found");
			strcpy(Ln[1],">");
			strcat(Ln[1],DirPath);
		}
		EndText=1;
	}
	rectfill(screen,120,248,799,599,BLACK);
	DosRefresh(0);
}
int DoType(int b)
{
	char DummyPath[80];
	char DirPath[80];
	char Ext[4];
	int j,k,m,Result;

	m=0;
	while(KeyInStr[b]==32) ++b;
	k=strlen(KeyInStr);
	for(j=b; j<k; ++j) {
		t=KeyInStr[j];
		DummyPath[m]=(t);
		++m;
	}
	DummyPath[m]=(null);

	_fixpath(DummyPath,DirPath);
	fix_filename_slashes(DirPath);
	ClearTextBuf();

	if(stricmp("TXT", get_extension(DirPath) ) == 0) goto ext_ok;
	if(stricmp("BAT", get_extension(DirPath) ) == 0) goto ext_ok;
	if(stricmp("C", get_extension(DirPath) ) == 0) goto ext_ok;
	if(stricmp("CPP", get_extension(DirPath) ) == 0) goto ext_ok;
	if(stricmp("H", get_extension(DirPath) ) == 0) goto ext_ok;
	if(stricmp("PAS", get_extension(DirPath) ) == 0) goto ext_ok;
	if(stricmp("CFG", get_extension(DirPath) ) == 0) goto ext_ok;
	if(stricmp("CONFIG.SYS", get_filename(DirPath) ) == 0) goto ext_ok;

	strcpy(Ln[0],"Service limited to TXT, BAT, C, CPP, H, PAS, CFG,");
	strcpy(Ln[1],"and CONFIG.SYS files");
	EndText=2;
	goto out;
ext_ok:
	if(__file_exists(DirPath)) {
		strcpy(CurrentFile, DirPath);
		if(LoadTextFile()!=0) {
			strcpy(Ln[0],"Load error");
			EndText=1;
		}
		rectfill(screen,120,248,799,599,BLACK);
		DosRefresh(0);
	} else {
		strcpy(Ln[0],"Specified directory and/or path not valid");
		strcpy(Ln[1],">");
		strcat(Ln[1],DirPath);
		EndText=2;
	}
out:	rectfill(screen,120,248,799,599,BLACK);
	DosRefresh(0);
}
int Rename(int b)
{
	char DummyPath[80];
	char OldPath[80];
	char NewPath[80];
	char DirOldPath[80];
	char DirNewPath[80];
	int j,k,m,Result;

	if(strchr(KeyInStr,'*') != 0 ) {
		ClearTextBuf();
		strcpy(Ln[0],"LCARS rename function does not support wild cards.");
		EndText=1;
		goto out;
	}
	memset(DummyPath,(null),80);
	memset(OldPath,(null),80);
	memset(NewPath,(null),80);
	memset(DirOldPath,(null),80);
	memset(DirOldPath,(null),80);
	m=0;
	while(KeyInStr[b]==32) ++b;
	k=strlen(KeyInStr);
	for(j=b; j<k; ++j) {
		t=KeyInStr[j];
		DummyPath[m]=(t);
		++m;
	}
	DummyPath[m]=(null);

	Result=0;
	b=0;
	m=0;
	while(DummyPath[b]!=32) ++b;
	strncpy(OldPath,DummyPath,b);

	while(DummyPath[b]==32) ++b;
	for(j=b; j<k; ++j) {
		t=DummyPath[j];
		NewPath[m]=(t);
		++m;
	}
	NewPath[m]=(null);

	_fixpath(OldPath,DirOldPath);
	_fixpath(NewPath,DirNewPath);

	if( !  __file_exists(DirOldPath)) {
		ClearTextBuf();
		strcpy(Ln[0],"Specified file/directory not found");
		strcpy(Ln[1],">");
		fix_filename_slashes(DirOldPath);
		strcat(Ln[1],DirOldPath);
		EndText=2;
		goto out;
	}

	if(__file_exists(DirNewPath)) {
		ClearTextBuf();
		strcpy(Ln[0],"Specified new name already in use:");
		strcpy(Ln[1],">");
		strcat(Ln[1],DirNewPath);
		EndText=2;
		goto out;
	}

	Result=rename(DirOldPath,DirNewPath);

	fix_filename_slashes(DirOldPath);
	fix_filename_slashes(DirNewPath);

	ClearTextBuf();
	if(Result==0) {
		strcpy(Ln[0],"Previous name:");
		strcpy(Ln[1],">");
		strcat(Ln[1],get_filename(DirOldPath));
		strcpy(Ln[2],"Full path:");
		strcpy(Ln[3],">");
		strcat(Ln[3],DirOldPath);

		strcpy(Ln[4],"New name:");
		strcpy(Ln[5],">");
		strcat(Ln[5],get_filename(DirNewPath));
		strcpy(Ln[6],"Full path:");
		strcpy(Ln[7],">");
		strcat(Ln[7],DirNewPath);

		EndText=8;
	} else {
		strcpy(Ln[0],"Command unclear.  Please repeat.");
		EndText=1;
	}
out:
	rectfill(screen,120,248,799,599,BLACK);
	DosRefresh(0);
}
int LcarsCmdCom()
{
	char Cmd[80];
	char CheckForExec[80];
	int Detect, k, Result;

	k=strlen(KeyInStr);
	while(KeyInStr[k]<33) {
		KeyInStr[k]=(null);
		--k;
	}
	++k;
	dx=k+1;
	if(k==0) return(1);

/* Rigid control, not leaving things to DOS */

	strcpy(CheckForExec,KeyInStr);
	strcat(CheckForExec,".exe");
	if(__file_exists(CheckForExec) ) {
		ClearTextBuf();
		strcpy(Ln[0],"Program launching from here not supported");
		goto output;
	}
	if(memicmp(KeyInStr,"dir",3)==0) {
		DoDir(3);
		return(1);
	}
	if(memicmp(KeyInStr,"cls",k)==0 && k==3 ) {
		ClearTextBuf();
		goto output;
	}
	if(memicmp(KeyInStr,"ver",k)==0 && k==3 ) {
		ClearTextBuf();
		strcpy(Ln[0],"LCARS Command Service Version 2.0");
		EndText=1;
		rectfill(screen,120,248,799,599,BLACK);
		DosRefresh(0);
		return(1);
	}
	if(memicmp(KeyInStr,"md ",3)==0) {
		MakeDir(2);
		return(1);
	}
	if(memicmp(KeyInStr,"mkdir ",6)==0) {
		MakeDir(5);
		return(1);
	}
	if(memicmp(KeyInStr,"rd ",3)==0) {
		RemoveDir(2);
		return(1);
	}
	if(memicmp(KeyInStr,"rmdir ",6)==0) {
		RemoveDir(5);
		return(1);
	}
	if(memicmp(KeyInStr,"ren ",4)==0) {
		Rename(3);
		return(1);
	}
	if(memicmp(KeyInStr,"rename ",7)==0) {
		Rename(6);
		return(1);
	}
	if(memicmp(KeyInStr,"del ",4)==0) {
		Result=DoDel(3);
		if(Result==2) return(2);
			else return(1);
	}
	if(memicmp(KeyInStr,"del",k)==0 && k==3 ) {
		ClearTextBuf();
		strcpy(Ln[0],"No files specified for deletion");
		EndText=1;
		rectfill(screen,120,248,799,599,BLACK);
		DosRefresh(0);
		return(1);
	}
	if(memicmp(KeyInStr,"erase ",6)==0) {
		Result=DoDel(5);
		if(Result==2) return(2);
			else return(1);
	}
	if(memicmp(KeyInStr,"erase",k)==0 && k==5 ) {
		ClearTextBuf();
		strcpy(Ln[0],"No files specified for erasure");
		EndText=1;
		rectfill(screen,120,248,799,599,BLACK);
		DosRefresh(0);
		return(1);
	}
	if(memicmp(KeyInStr,"type ",5)==0) {
		Result=DoType(4);
		if(Result==2) return(2);
			else return(1);
	}
	if(memicmp(KeyInStr,"type",k)==0 && k==4 ) {
		ClearTextBuf();
		strcpy(Ln[0],"No file specified for display");
		EndText=1;
		rectfill(screen,120,248,799,599,BLACK);
		DosRefresh(0);
		return(1);
	}
	if(memicmp(KeyInStr,"copy",k)==0 && k==4 ) {
		ClearTextBuf();
		strcpy(Ln[0],"No files specified for copying");
		EndText=1;
		rectfill(screen,120,248,799,599,BLACK);
		DosRefresh(0);
		return(1);
	}
	if(memicmp(KeyInStr,"copy ",5)==0) {
		Result=DoCopy(4);
		return(Result);
	}
	if(memicmp(KeyInStr,"sys",3)==0 ) {
		ClearTextBuf();
		strcpy(Ln[0],"Sys function not supported.");
		EndText=1;
		rectfill(screen,120,248,799,599,BLACK);
		DosRefresh(0);
		return(1);
	}
	if(memicmp(KeyInStr,"time",k)==0 && k==4) return(2);
	if(memicmp(KeyInStr,"date",k)==0 && k==4) return(2);
	if(memicmp(KeyInStr,"exit",k)==0 && k==4) return(2);

	if(memicmp(KeyInStr,"cd ",3)==0 ) {
		ChangeDirectory(3);
		return(0);
	}
	if(memicmp(KeyInStr,"chdir ",6)==0 ) {
		ChangeDirectory(6);
		return(0);
	}
	if(memicmp(KeyInStr,"a:",k)==0 && k==2) {
		if(CurrentPath[0]=='A') return(1);
		strcpy(CurrentPath,PathOfDriveA);
		strcat(CurrentPath,">");
		LineInput_Clear();
		LineInput_DisplayInputString(MANGO);
		setdisk(0);
		CurrentDrive=0;
		DriveChange=1;
		return(1);
	}
	if(memicmp(KeyInStr,"c:",k)==0 && k==2) {
		if(CurrentPath[0]=='C') return(1);
		strcpy(CurrentPath,PathOfDriveC);
		strcat(CurrentPath,">");
		LineInput_Clear();
		LineInput_DisplayInputString(MANGO);
		setdisk(2);
		CurrentDrive=2;
		DriveChange=1;
		return(1);
	}

/* Leave nothing to DOS */

	ClearTextBuf();
	strcpy(Ln[0],"Requested function not supported.");
	EndText=1;
	rectfill(screen,120,248,799,599,BLACK);
	DosRefresh(0);
	return(1);

output:
	strcpy(DosClip,KeyInStr);
	LineInput_Clear();
	LineInput_DisplayInputString(NAPLES);
	rectfill(screen,120,248,799,599,BLACK);
	DosRefresh(0);
	return(1);
}

/***** LCARS 24 shared line-input module *****/

int DosRefresh(int txty)
{
	int gy,i,z;

	if(txty==0) min_old=70;
	gy=284-36;
	for( z=0; z < 9; ++z) {
		rectfill(screen,138,gy,799,gy+36,BLACK);
	if( Ln[txty+z][0]=='>' || Ln[txty+z][0]=='!') {
		for( i=0; i< strlen(Ln[txty+z]); ++i)
			Highlight[i]=Ln[txty+z][i+1];
	PutsFont21(140,gy,ORANGE,Highlight);
		} else 	PutsFont21(140,gy,PALEBLUE,Ln[txty+z]);
		gy += 36;
	}
}
void DosTopOfFile(int txty)
{
	DosRefresh(txty);
}
void DosEndOfFile(int txty)
{
	rectfill(screen,120,248,799,599,BLACK);
	DosRefresh(txty);
}
void LineInput_Cursor()
{
	int q,z,i;

	i=StrLenFont21(CurrentPath);
	cx=120-6;
	for( z=0; z<dx-1; ++z) {
		q=KeyInStr[z];
		cx=cx+ Font21[q] -65;
		}
	cy=126+32;
	xor_mode(TRUE);
	rectfill(screen,cx+i+6,cy-10,cx+i+14,cy-8, WHITE);
	xor_mode(FALSE);
}
void LineInput_CursorLeft()
{
	if( dx==1 ) return;
	--dx;
}
void LineInput_CursorRight()
{
	k=strlen( KeyInStr );
	if( dx > k ) return;
		++dx;
}
void LineInput_Del()
{
	int z;

	k= strlen( KeyInStr );
	if( dx > k ) return;
	for( z=dx-1; z < k; ++z) {
		KeyInStr[z]=KeyInStr[z+1];
	}
	LineInput_DisplayInputString(ORANGE);
}
void LineInput_BS()
{
	int z;

	if( dx <= 1 ) return;
	LineInput_CursorLeft();
	k= strlen( KeyInStr );
	for( z=dx-1; z < k; ++z) {
		KeyInStr[z]=KeyInStr[z+1];
	}
	LineInput_DisplayInputString(ORANGE);
}
void LineInput_DisplayChar()
{
	int q,z;

	if( c < 32 ) return;
	q=StrLenFont21(CurrentPath)+StrLenFont21(KeyInStr);
	k= strlen( KeyInStr );
	if(k>43) return;
	if(dx < k &&  q > 700) return;

	if(dx < k+1) for(z=k; z >= dx; --z) KeyInStr[z]=KeyInStr[z-1];
	if(!(dx-1 > k+1 ) )	KeyInStr[dx-1] =( c );
/*		KeyInStr[k+1]=( null );
*/
	LineInput_DisplayInputString(ORANGE);
	LineInput_CursorRight();
}
int AllBlank()
{ /* Returns 0 if the string is nothing but blanks */
	int a,b;

	a=0;
	b=strlen(KeyInStr);
	while( b > a) {
		if( isspace(KeyInStr[a])==0) return(1);
		++a;
	}
	 return(0);
}

/* This following function is customized for DOS service.  Other services
	that require single-line user input should be modified versions
	(different F-key response) of this yet share the
	support functions above.
*/
void DosLineInput()
{
	int Result,txty;
	txty=0;
	strcat(CurrentPath,">");
	LineInput_Clear();
	strcpy(KeyInStr,"dir *.*");
/*	DoDir(3);				  Let's not automatically invoke dir */
	DosRefresh(0);
	LineInput_Clear();

loopback:
	LineInput_Cursor();
	do {
		SolPutTime();
	} while(!kbhit());
	c=GetKey();
	LineInput_Cursor();
	switch( c )
	{
		case F12: return;
		case F9:  LineInput_Clear();
			  strcpy(KeyInStr,DosClip);
			  LineInput_DisplayInputString(ORANGE);
			  goto loopback;
		case F10: strcpy(DosClip,KeyInStr);
			  LineInput_Clear();
			  goto loopback;
		case 13:  if( strlen(KeyInStr)==0) {
				ScoldUser();
				goto loopback;
			  }
			  if( AllBlank()==0 ) {
				LineInput_Clear();
				ScoldUser();
				goto loopback;
			  }
			  Result=LcarsCmdCom();
			  if(Result==0) goto loopback;
			  if(Result==1) {
				txty=0;
				DosRefresh(0);
				goto loopback;
			  }
			  if(Result==2) return;
			  if(Result==3) {
				txty=EndText-8;
				goto loopback;
			  }
		case BS:  LineInput_BS();
			  goto loopback;
		case 124: 		/* disallow >, |, / */
		case 62:
		case 47:  goto loopback;
		case LEFTARROW: LineInput_CursorLeft();
			  goto loopback;
		case RIGHTARROW: LineInput_CursorRight();
			  goto loopback;
		case UPARROW:
			  if(txty<1) goto loopback;
			  --txty;
			  DosRefresh(txty);
			  goto loopback;
		case DOWNARROW: if(txty>=EndText-8) goto loopback;
			  ++txty;
			  DosRefresh(txty);
			  goto loopback;
		case DELKEY: LineInput_Del();
			  goto loopback;
		case PGUPKEY: if(txty<1) goto loopback;
			  txty -=8;
			  if(txty<0) txty=0;
			  DosRefresh(txty);
			  goto loopback;
		case PGDNKEY: if(txty>=EndText-5) goto loopback;
			  txty +=8;
			  if(txty>=EndText-8) {
				txty=EndText-8;
			  }
			  DosRefresh(txty);
			  goto loopback;
		case HOMEKEY: if(txty<1) goto loopback;
			  txty=0;
			  DosTopOfFile(txty);
			  goto loopback;
		case ENDKEY: if(txty>=EndText-5) goto loopback;
			  txty=EndText-5;
			  DosEndOfFile(txty);
			  goto loopback;
		case 350: Screenshot792("Dos8.bmp");
			goto loopback;
		case 351: Screenshot1024("Dos10.bmp");
			goto loopback;
		default:  if( c >= 315) goto loopback;
			  LineInput_DisplayChar();
			  goto loopback;
	}
}
void MathLineInput()
{
	char Cmd[80];

	LineInput_Clear();
	PanelBeep();
loopback:
	LineInput_Cursor();
	do {
		SolPutTime();
	} while(!kbhit());
	c=GetKey();
	LineInput_Cursor();
	switch( c )
	{
		case F12: 	return;
		case F11: 	OpenHelp("c:\\lcars24\\system\\mathdoc.txt");
				goto loopback;
		case F9: 	LineInput_Clear();
				strcpy(KeyInStr,MathClip);
				LineInput_DisplayInputString(ORANGE);
				goto loopback;
		case F10: 	strcpy(MathClip,KeyInStr);
				LineInput_Clear();
				goto loopback;
		case 13: 	if( strlen(KeyInStr)==0) {
					ScoldUser();
					goto loopback;
				 }
				if( AllBlank()==0 ) {
					LineInput_Clear();
					ScoldUser();
					goto loopback;
				}
				memset(MathInput[1],(null),80);
				strcpy(MathInput[1],KeyInStr);
				LcMath();
				rectfill(screen,140,281,799,281+32,BLACK);
				PutsFont21(140,281,PALEBLUE,MathOutput);
				goto loopback;
		case BS:	LineInput_BS();
				goto loopback;
		case LEFTARROW: LineInput_CursorLeft();
				goto loopback;
		case RIGHTARROW: LineInput_CursorRight();
				goto loopback;
		case DOWNARROW: goto loopback;
		case DELKEY: 	LineInput_Del();
				goto loopback;
		case PGUPKEY:
		case PGDNKEY:
		case UPARROW: 	goto loopback;
		case 350: Screenshot792("Math8.bmp");
				goto loopback;
		case 351: Screenshot1024("Math10.bmp");
				goto loopback;
		default:  if( c >= 315) goto loopback;
				LineInput_DisplayChar();
				goto loopback;
	}
}

void GlowMode()
{
	rectfill(screen,0,0,800,600, BLACK);
	PopsicleSticks(LILAC);
	Title("GLOW MODE");
	PutsLuna(200,20, BLACK,LILAC, "OFF: PRESS ANY KEY");
	rectfill(screen,0,50,800,550, makecol(255,255,255));

	min_old=70;
	do {
		PopPutTime(1);
	} while(!kbhit());
	GetKey();
}
int FindOS(void)
{
	if(os_type==OSTYPE_UNKNOWN) DosDetected=TRUE;
	if(os_type==OSTYPE_OPENDOS) DosDetected=TRUE;
}
void FindGifFiles()
{
	struct ffblk fblock;
	int Found, z;
	unsigned short t;
	char mask[80];

	for(z = 0; z < 16; ++z) memset(GifList[z], (null), 80);
	t=13;
	GifList[0][0]=(t);
	EndGifList=0;
	strcpy(mask, "C:\\LCARS24\\SYSTEM\\GIF\\*.GIF");
	Found = findfirst(mask, &fblock, 0);
	while ( !Found ) {
		strcpy(GifList[EndGifList], fblock.ff_name);
		++EndGifList;
		if(EndGifList > 30) break;
		Found = findnext( &fblock );
	}
}
int RegisterDateSetting(int NewMonth, int NewDay, int NewYear)
{
	struct timeval tvp;
	struct timezone tvpz;
	int dateseconds, min, hr, sc, days;
	time_t xt;
	struct tm *pt;

	time(&xt);
	pt=gmtime(&xt);
	min=pt->tm_min;
	hr=pt->tm_hour;
	sc=pt->tm_sec;

	days=GetJulian(NewMonth, NewDay, NewYear)-2440588;
	dateseconds=days*86400;

	tvp.tv_sec=dateseconds+(hr*3600)+(min*60)+sc;
	tvp.tv_usec=290944;
	settimeofday( &tvp, 0);
}
void RegisterTimeSetting(int NewHr, int NewMin)
{
	struct timeval tvp;
	struct timezone tvpz;
	int rc, raw, days, year, dateseconds;
	time_t xt;
	struct tm *pt;
	int min, hr, sc;
	unsigned int t;

	if (SettingType==1) {
		time(&xt);
		pt=gmtime(&xt);
		min=pt->tm_min;
		hr=pt->tm_hour;
		sc=pt->tm_sec;

		rc=gettimeofday(&tvp, &tvpz);
		raw=tvp.tv_sec;
		dateseconds=raw-((hr*3600)+(min*60)+sc);
		tvp.tv_sec=dateseconds+(NewHr*3600)+(NewMin*60);
		tvp.tv_usec=290944;
		rc=settimeofday( &tvp, 0);
	}
	if (SettingType==2) {
		AlarmHour=NewHr;
		AlarmMin=NewMin;
		SingleAlarmOnOff=1;
		BuildAlarmString();
		AlarmDisplay();
		Box2a(MANGO,"ALARM OFF");
		memcpy(SecWhenAlarmSet,SecDisplay,2);
	}
}
void ForcedTimeDisplay(int x, int y, int sz)
{
	min_old=70;
	PutTime(x,y,sz);
}
void DateSettingDisplay(int NewMonth, int NewDay)
{
	int l_holder;
	int r_holder;

	l_holder=NewMonth / 10;
	t=l_holder + 48;
	if(l_holder==0) t=32;
	DateSetting[0]=(t);

	r_holder=NewMonth - (l_holder * 10);
	t=r_holder + 48;
	DateSetting[1]=(t);

	l_holder=NewDay / 10;
	t=l_holder + 48;
	DateSetting[3]=(t);

	r_holder=NewDay - (l_holder * 10);
	t=r_holder + 48;
	DateSetting[4]=(t);

/*	rectfill(screen,140-18,320-14,320+8,420+14,BLACK); */
	MarsF(140-18, 330-14, 4, NAPLES, BLACK, DateSetting);
}
void SettingDisplay(int NewHr, int NewMin)
{
	int hours;
	int l_holder;
	int r_holder;

	hours=NewHr;

	if(MilitaryTime !=0) goto bypass;
	if(NewHr > 11 ) PutSettingPM(323,374);
	if(NewHr < 12 ) PutSettingAM(322,374);

	if(hours > 12) hours -= 12;
	if(hours==0) hours=12;

bypass:
	l_holder=hours / 10;
	t=l_holder + 48;
	if(l_holder==0) t=32;
	TimeSetting[0]=(t);

	r_holder=hours - (l_holder * 10);
	t=r_holder + 48;
	TimeSetting[1]=(t);

	l_holder=NewMin / 10;
	t=l_holder + 48;
	TimeSetting[3]=(t);

	r_holder=NewMin - (l_holder * 10);
	t=r_holder + 48;
	TimeSetting[4]=(t);

	MarsF(132, 316, 4, NAPLES, BLACK, TimeSetting);
}
void DisplaySnoozeSetting()
{
	char SnoozeStr[3];

	itoa( SnoozeVal, SnoozeStr, 10);
	if(SnoozeVal==0) strcpy(SnoozeStr," 0");
	if(SnoozeVal==6) strcpy(SnoozeStr," 6");
	MarsF(444+82,445+48,2,MANGO,BLACK, SnoozeStr);
}
void TimeSettingMode()
{
	int NewHr;
	int NewMin;
	int z;

	NewHr=Hours;
	NewMin=Minutes;

	rectfill(screen,112,250,650,599,BLACK);
	SettingDisplay(NewHr,NewMin);
	if( SettingType==1) PopUp1(120,255,LILAC,"SET TIME");
	if( SettingType==2) PopUp1(120,255,LILAC,"SET ALARM");
	SettingGuide(1,120,255,LILAC);

	for( z=0; z < 6; ++z)
		  {
				 t=TimeDisplay[z];
				 TimeSetting[z]=(t);
	}
	ForcedTimeDisplay(456,280,4); /* So it won't wait for a new minute */

	if( SettingType==2) {

		/* flange, with one hole */
		rectfill(screen, 444,445,444+72,570,BIGBLUE);
		rectfill(screen,486, 540, 510, 564, BLACK);

		PutsFont21(444+82, 445, ORANGE, "SNOOZE");
		DisplaySnoozeSetting();
		PutsFont21(578, 528, MANGO, "MINUTES");
		PutsLuna(444+82, 556,ORANGE,BLACK, "PG UP/DN");
/*
test alignment
rect(screen, 544,445+34,544+72,570,BORG);
rect(screen, 544,445,544+72,570-34,BORG);
*/
	}

loopback:
	do {
		PutTime(456,280,4); /* Same x position and size as above */
	} while (!kbhit());

	c=GetKey();
	switch( c )
	{
		case F1:
		case F2:
		case F3:
		case F4:
		case F5:
		case 27:
			Box1b(BracketColor1, "SETTINGS");
			rectfill(screen,112,250,650,599,BLACK);
			ForcedTimeDisplay(164,264,10);
			return;
		case DOWNARROW:
			--NewHr;
			if(NewHr < 0) NewHr=23;
			SettingDisplay(NewHr,NewMin);
			goto loopback;
		case UPARROW:
			++NewHr;
			if(NewHr==24) NewHr=0;
			SettingDisplay(NewHr,NewMin);
			goto loopback;
		case LEFTARROW:
			--NewMin;
			if(NewMin < 0) NewMin=59;
			SettingDisplay(NewHr,NewMin);
			goto loopback;
		case RIGHTARROW:
			++NewMin;
			if(NewMin==60) NewMin=0;
			SettingDisplay(NewHr,NewMin);
			goto loopback;
		case PGDNKEY: if(SnoozeVal==0) goto loopback;
			if( SettingType==2) {
				SnoozeVal-=6;
				DisplaySnoozeSetting();
			}
			goto loopback;
		case PGUPKEY: if(SnoozeVal==18) goto loopback;
			if( SettingType==2) {
				SnoozeVal+=6;
				DisplaySnoozeSetting();
			}
			goto loopback;
		case 13:
			RegisterTimeSetting(NewHr,NewMin);
			Box1b(BracketColor1, "SETTINGS");
			rectfill(screen,112,250,650,599,BLACK);
			min_old=70; /* Don't wait */
		PutTime(164,264,10);
/* spawnl(P_WAIT,"C:\\LCARS24\\SOUND\\JUKEBOX.EXE","C:\\LCARS24\\SOUND\\JUKEBOX.EXE","C:\\LCARS24\\SOUND\\TRANSFER.WAV", NULL); */
			SaveAlarm();
			return;
			case 350: Screenshot792("Time8.bmp");
				goto loopback;
			case 351: Screenshot1024("Time10.bmp");
				goto loopback;
		default:
/* spawnl(P_WAIT,"C:\\LCARS24\\SOUND\\JUKEBOX.EXE","C:\\LCARS24\\SOUND\\JUKEBOX.EXE","C:\\LCARS24\\SOUND\\SPECIFY.WAV", NULL); */
			goto loopback;
	}
}
void DateSettingMode()
{
	int NewMonth, NewDay, NewYear, WhichCalendar, z;
	int MaxDay=31;

	NewMonth=DateMonth;
	NewDay=DateDay;
	NewYear=DateYear;

	rectfill(screen,112,250,650,599,BLACK);
	DateSettingDisplay(NewMonth,NewDay);
	PopUp1(120,255,LILAC,"SET DATE");
	SettingGuide(2,120,255,LILAC);

	for( z=0; z < 6; ++z)
		  {
		  t=DateDisplay[z];
		  DateSetting[z]=(t);
	}
	ForcedTimeDisplay(456,280,4); /* So it won't wait for a new minute */
	if( NewYear < 1990 ) NewYear=1990;
	itoa( NewYear, YearDisplay, 10);
	MarsF(342,344,2,MANGO,BLACK, YearDisplay);
	PutsLuna(342, 416,ORANGE,BLACK, "PG UP/DN");

loopback:
	do {
		PutTime(456,280,4); /* Same x position and size as above */
	} while (!kbhit());

	c=GetKey();
	switch( c )
	{
		case F1:
		case F2:
		case F3:
		case F4:
		case F5:
		case 27:
			Box1b(BracketColor1, "SETTINGS");
			rectfill(screen,112,250,650,599,BLACK);
			ForcedTimeDisplay(164,264,10);
			return;
		case DOWNARROW:
			--NewMonth;
			if(NewMonth < 1) NewMonth=12;
			WhichCalendar=GetWhichCalendar(NewYear);
			MaxDay=GetLengthOfMonth(WhichCalendar, NewMonth);
			if(NewDay > MaxDay) NewDay=MaxDay;
			DateSettingDisplay(NewMonth,NewDay);
			goto loopback;
		case UPARROW:
			++NewMonth;
			if(NewMonth > 12 ) NewMonth=1;
			WhichCalendar=GetWhichCalendar(NewYear);
			MaxDay=GetLengthOfMonth(WhichCalendar, NewMonth);
			if(NewDay > MaxDay) NewDay=MaxDay;
			DateSettingDisplay(NewMonth,NewDay);
			goto loopback;
		case LEFTARROW:
			--NewDay;
			WhichCalendar=GetWhichCalendar(NewYear);
			MaxDay=GetLengthOfMonth(WhichCalendar, NewMonth);
			if(NewDay < 1) NewDay=MaxDay;
			DateSettingDisplay(NewMonth,NewDay);
			goto loopback;
		case RIGHTARROW:
			++NewDay;
			WhichCalendar=GetWhichCalendar(NewYear);
			MaxDay=GetLengthOfMonth(WhichCalendar, NewMonth);
			if(NewDay > MaxDay) NewDay=1;
			DateSettingDisplay(NewMonth,NewDay);
			goto loopback;
		case 13:
			WhichCalendar=GetWhichCalendar(NewYear);
			MaxDay=GetLengthOfMonth(WhichCalendar, NewMonth);
			if(NewDay > MaxDay) NewDay=MaxDay;
			RegisterDateSetting(NewMonth,NewDay,NewYear);
			Box1b(BracketColor1, "SETTINGS");
			rectfill(screen,112,250,650,599,BLACK);
			min_old=70; /* Don't wait */
					day_old=32;
/*			PutDate(); */
			NextMonthCalender(1);
			PutTime(164,264,10);
			PanelBeep();
			return;
		case PGDNKEY: --NewYear;
			if( NewYear < 1990 ) NewYear=1990;
			if( NewYear > 2030 ) NewYear=2030;
			itoa( NewYear, YearDisplay, 10);
			rectfill(screen,340,344,423,404,BLACK);
			MarsF(342,344,2,MANGO,BLACK, YearDisplay);
			WhichCalendar=GetWhichCalendar(NewYear);
			MaxDay=GetLengthOfMonth(WhichCalendar, NewMonth);
			if(NewDay > MaxDay) {
				NewDay=MaxDay;
				DateSettingDisplay(NewMonth,NewDay);
			}
			goto loopback;
		case PGUPKEY: ++NewYear;
			if( NewYear < 1990 ) NewYear=1990;
			if( NewYear > 2030 ) NewYear=2030;
			itoa( NewYear, YearDisplay, 10);
			rectfill(screen,340,344,423,404,BLACK);
			MarsF(342,344,2,MANGO,BLACK, YearDisplay);
			WhichCalendar=GetWhichCalendar(NewYear);
			MaxDay=GetLengthOfMonth(WhichCalendar, NewMonth);
			if(NewDay > MaxDay) {
				NewDay=MaxDay;
				DateSettingDisplay(NewMonth,NewDay);
			}
			goto loopback;
		default:
			ScoldUser();
			 	goto loopback;
	}
}
void SettingsMode()
{
	Box1b(NAPLES,"SETTINGS");
	rectfill(screen,112,250,650,599,BLACK);
	ForcedTimeDisplay(375,275,6); /* So it won't wait for a new minute */
	SettingSelect();
/*	PanelBeep(); */
loopback:
	do {
		PutTime(375,275,6); /* Same x position and size as above */
	} while (!kbhit());

	c=GetKey();
	switch( c )
	{
		case 27:
		case F2:
		case F3:
		case F4:
		case F5:
			Box1b(BracketColor1, "SETTINGS");
			rectfill(screen,112,250,650,599,BLACK);
			ForcedTimeDisplay(164,264,10);
			PanelBeep();
			return;
		case 49:
			SettingType=1;
			TimeSettingMode();
			PanelBeep();
			return;
		case 50: DateSettingMode();
			PanelBeep();
			return;
		case 51:
			if(BlasterOK==FALSE || AudioOff==TRUE) {
				AudioError();
				goto loopback;
			}
			SettingType=2;
			TimeSettingMode();
			PanelBeep();
			return;
		case 52:
			OptionSettingMode();
			PanelBeep();
			return;
		case 350: Screenshot792("Sttngs8.bmp");
			PanelBeep();
			goto loopback;
		case 351: Screenshot1024("Sttngs10.bmp");
			PanelBeep();
			goto loopback;
		default: ScoldUser();
			 	goto loopback;
	}
}
void SetLcarsPath()
{
/*	chdir(LcarsPath); */
}
void Recover()
{
	set_color_depth(DepthFound);
	if(ScreenSize==1024) set_gfx_mode(GFX_AUTODETECT, 1024, 768, 0, 0);
		else set_gfx_mode(GFX_AUTODETECT, 800, 600, 0, 0);
	Screen1(1);
	old_sec=70;
	min_old=70;
	day_old=32;
	AlarmDisplay();
	SetLcarsPath();
}
void FindCurrentBracketColors()
{
	switch( ColorScheme )
	{
		case 1:	BracketColor1=PALEBLUE;
				BracketColor2=BIGBLUE;
				break;
		case 2:	BracketColor1=MANGO;
				BracketColor2=BRICK;
				break;
		default:  BracketColor1=ORANGE;
				BracketColor2=PALEBLUE;
	}
}
int WarmRecover()
{
	SetLcarsPath();
	FindCurrentBracketColors();
	Screen1(1);
	old_sec=70;
	min_old=70;
	day_old=32;
	AlarmDisplay();
}
void SpecsMode()
{
	strcpy(CurrentFile,"C:\\LCARS24\\DATA\\LCSPECS.TXT");
	OpenTxt("C:\\LCARS24\\DATA\\LCSPECS.TXT");
	BeepSet=TRUE;
}
void ChangeFolder(char PathAndFilename[80])
{ /* parses out an application's pathname and changes to that path
	to it can access its support files */

	char PathnameOnly[80];
	char Command[80];
	int Place, a;

	fix_filename_slashes(PathAndFilename);
	a=1;
	for(;;) {  /* find the last backslash */
		if( PathAndFilename[a]==92 ) Place=a;
		if( PathAndFilename[a]==0 ) break;
		++a;
	}
	strcpy(PathnameOnly,PathAndFilename);
	PathnameOnly[Place]=(null);
	strcpy(Command, "CD ");
	strcat(Command, PathnameOnly);
	system( Command );
}
void DoLaunch()
{
	if(Relaunch==TRUE) system("launch");
}

void LaunchDisplay(char *ProgramName,char *ProgramPath)
{
	int a,b,c;

	a=StrLenMars(3,ProgramName);
	b=StrLenFont21(ProgramPath);
	if(a>b) c=a;
		else c=b;
	rectfill(screen,0,0,800,600, BLACK);
	PopsicleSticks(LILAC);
	MarsF(400-(c*.5), 248, 3, ORANGE, BLACK, ProgramName);
	PutsFont21(400-(c*.5),354,LAVENDER,ProgramPath);
}
void FilesMode()
{
	Files24Mode();
	WarmRecover();
}
void MakeLauncherBat()
{
	char Arg1[5]; /* This allows LCARS 24 to get out of the way
				  completely when launching a resource-hungry DOS
				  program then restart fresh when that program is
				  closed, skipping the LCARS 24 startup fanfare */

	strcpy(Ln[0],"echo off");
	strcpy(Ln[1],"cd ");
	strcat(Ln[1],ProgramPath[PWy]);
	strcpy(Ln[2],get_filename(ProgramPath[PWy]));
	Ln[1][strlen(Ln[1])-strlen(Ln[2])-1]=(null); /* trim cd command */
	Ln[2][strlen(Ln[2])-4]=(null); /* trim execution command */

	strcpy(Ln[3],"cd ");
	strcat(Ln[3],LcarsPath);
	strcpy(Ln[4],LcarsExeName);
	strcat(Ln[4]," ");
	itoa(ScreenSize,Arg1,10); /* display size previously specified by the user */
	strcat(Ln[4],Arg1);
	strcat(Ln[4]," ");
	strcat(Ln[4],"skip"); /* skip intro */
	strcpy(Ln[5],"echo off");
	strcpy(Ln[6],"");
	EndText=6;
	strcpy(CurrentFile, "LAUNCH.BAT");
	SaveTextFile();
}
int AppsMode()
{
/*
	int Result, i;

	PickAppScreen();
	CopyAppList();
retry:
	Result=PickWindowActive();
	if(Result==0) {
		WarmRecover();
		return(0);
	}
	if( ! (__file_exists(ProgramPath[PWy])) ) {
		MarsF(163,124-70,2,BRICK,BLACK,"PROGRAM NOT");
		MarsF(163,124,2,BRICK,BLACK,"INSTALLED");
		rest(1600);
		rectfill(screen,163,124-70,420,182, BLACK);
		goto retry;
	}
	if( Result==1 ) {
		ProgramType=2;
		if( Ln[PWy][0]==33 ) {
			ProgramType =1;
			for( i=0; i< strlen(Ln[PWy]); ++i)
				Highlight[i]=Ln[PWy][i+1];
			strcpy(Ln[PWy],Highlight);
		}
		LaunchDisplay(Ln[PWy],ProgramPath[PWy]);
		rest(1000);
		remove_timer();
		Relaunch=TRUE;
		if(ProgramType==2) {
			release_screen();
			set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		}
		MakeLauncherBat();
		atexit(DoLaunch);
		allegro_exit();
		exit(0);
	} else WarmRecover();
*/
	return(0);
}
int DataMode()
{
	int Result;

repeat:

	Result=LibraryWindowActive();

	if( Result==1 ) {
		strcpy(NewName, Ln[FileNum]);
		strcpy(CurrentFile, "C:\\LCARS24\\DATA\\");
		strcat(CurrentFile, NewName);
		if( strnicmp("BMP", get_extension(NewName),3 )==0 ) {
			Viewscreen(CurrentFile);
			goto repeat;
		}
		if( strnicmp("JPG", get_extension(NewName),3 )==0 ) {
			Viewscreen(CurrentFile);
			goto repeat;
		}
		if( strnicmp("GIF", get_extension(NewName),3 )==0 ) {
			Viewscreen(CurrentFile);
			goto repeat;
		}
		if( strnicmp("TXT", get_extension(NewName),3 )==0 ) {
			LcReader(CurrentFile);
			goto repeat;
		}
		if( strnicmp("HTM", get_extension(NewName),3 )==0 ) {
			LcHtml(CurrentFile);
			goto repeat;
		}
		if( strnicmp("SFM", get_extension(NewName),3 )==0 ) {
			LcSfml(CurrentFile);
			goto repeat;
		}
		if( strnicmp("MSD", get_extension(NewName),3 )==0 ) {
			LcSfml(CurrentFile);
			goto repeat;
		}
	} else {
		WarmRecover();
		return(0);
	}
}
int StopBreak()
{
	WarmRecover();
	return(1);
}
void Intro()
{
	char Report[5];
	int pos;
	int GifNum;
	char filespec[80] ="C:\\LCARS24\\SYSTEM\\GIF\\";

	if(EndGifList !=0) {
		srand( (unsigned int)time( NULL ) );
		GifNum=rand() % EndGifList;
		strcat(filespec,GifList[GifNum]);
	}

	Brackets1(BracketColor1, BracketColor2);
	Boxes();
	Wrapper(60,30);
	LoadScorpioFont();
	LoadFont21();
	LoadMono13();
	MarsF(546, 10, 3, ORANGE, BLACK, "LCARS 24");
	ButtonType1(562,153,PALEBLUE,"SYSTEM INIT");

	PutsLuna(546,110,ORANGE,BLACK,"32-BIT SYSTEM INTERFACE");
	itoa( DepthFound, Report, 10);
	pos=586+StrLenLuna("32-BIT SYSTEM INTERFACE");
	PutsLuna(pos,110, LILAC, BLACK, Report);
	PutsLuna(pos+StrLenLuna(Report),110, LILAC, BLACK, "-BIT COLOR");
	LoadFont19();
/*	LoadWeb11(); */
	LoadArial10();
	PutStarDate(180,68,MANGO);
	PanelBeep();
	rest(150);
	QuickGifView(60, filespec);

	PutsFont21(180,518,BIGBLUE,"www.startrek.com");

	if( BlasterOK==TRUE) {
		MarsF(270, 280-30, 4, PURPLE, BLACK, "GOING TO");
		MarsF(180, 414-30, 4, PURPLE, BLACK, "STANDBY MODE");
	} else {
		MarsF(250, 280-30, 4, PURPLE, BLACK, "SOUND CARD");
		MarsF(180, 414-30, 4, PURPLE, BLACK, "NOT RESPONDING");
	}

	rectfill(screen,559,144,671,190,BLACK);
	rest(200);
	ButtonType1(562,153,PALEBLUE,"SYSTEM INIT");

	FindOS();
/*
	if(DosDetected) PutsFont21(180,100, PALEBLUE, "DOS DETECTED");
		else {
			PutsFont21(180,100, ORANGE, "WINDOWS DETECTED");
			PutsFont21(180,132, ORANGE, "SHUTTING DOWN LCARS SOUND SYSTEM");
		}
*/
	if(__file_exists("C:\\LCARS24\\APPSLIST.TXT")) {
		strcpy( CurrentFile, "C:\\LCARS24\\APPSLIST.TXT" );
		LoadAppList();
	} else NoAppList=TRUE;
	if(! ( __file_exists("c:\\lcars24\\system\\dos-ver.txt")))
		system("ver>C:\\LCARS24\\SYSTEM\\DOS-VER.TXT");
			else rest(200);
	strcpy(CurrentFile,"C:\\LCARS24\\SYSTEM\\DOS-VER.TXT");
	LoadTextFile();
	strcpy(DosVerStr,Ln[1]);
	rectfill(screen,498+61,144,610+61,190,BLACK);
/*	LoadWebFont("Web11.sff"); */ /* no longer used */
	LoadMapFonts();
	ButtonType1(562,153,PURPLE,"SYSTEM INIT");
	if(BlasterOK==TRUE) PanelBeep();
		else rest(350);
	rectfill(screen,498+61,144,610+61,190,BLACK);
	if(BlasterOK==TRUE) PanelBeep();
		else rest(200);
	ButtonType1(562,153,NAPLES,"ONLINE");
	ButtonType1(682,153,ORANGE,"ENABLED");
	if(LcarsPlayWav("C:\\LCARS24\\VOICE\\STANDING.WAV")) rest(900);
	rectfill(screen,112,10,799,uy-10,BLACK);
	rectfill(screen,112,250,790,590,BLACK);
}
int MathMode()
{
	min_old=70;
	BeepSet=TRUE;
	strcpy(CurrentPath,"");
	rectfill(screen,0,0,800,600, BLACK);
	Brackets1(BracketColor1,BracketColor2);
	Box1a(ORANGE, "CLEAR", "F10", "", "");
	Box2a(PALEBLUE, "RESTORE PREV");
	EscBox1b(LILAC, "CLOSE");
	Br1F2Box(PALEBLUE, "HELP", "F11");
	Box3bm(ORANGE);
	Box4bm(MANGO);
	Box5bm(BRICK);
	MarsF(780-(StrLenScorpio("MATH SERVICE")*2),10,2, ORANGE,BLACK,"MATH SERVICE");
	PutsLuna(780-(StrLenScorpio("MATH SERVICE")*2),110-28,PURPLE,BLACK,"EDITABLE INPUT LINE");
	rectfill(screen,14,130,109,130+14,BracketColor1);
	PutsLuna(106-StrLenLuna("INPUT EXPRESSION")+2, 130, BLACK,BracketColor1, "INPUT EXPRESSION");
	rectfill(screen,14,287-19,109,287+14,BracketColor2);
	PutsLuna(106-StrLenLuna("ANSWER"),287, BLACK,BracketColor2, "ANSWER");

	PutsFont21(140,338,BRICK,"+ (add)	- (subtract)	 * (multiply)	/ (divide)	^ or ** (exponent)");
	PutsFont21(140,395,MANGO,"acos, asin, atan, cos, sin, tan, exp, ln, log, sqrt, abs, cosh, sinh, tanh");

	PutsFont21(140,452,ORANGE,"2 + 2 ");
	EnterSymbol(140+StrLenFont21("2 + 2 "),452,1,MANGO);
	PutsFont21(250,452,ORANGE,"74/(1.83^2) ");
	EnterSymbol(250+StrLenFont21("74/(1.83^2) "),452,1,MANGO);
	PutsFont21(450,452,ORANGE,"atan(7) + 2*pi + sqrt(59) ");
	EnterSymbol(450+StrLenFont21("atan(7) + 2*pi + sqrt(59) "),452,1,MANGO);

	PutsFont21(300,509,BIGBLUE,"(pi or PI = 3.14159265358979323836)");
	MathLineInput();
}
int DosMode()
{
	min_old=70;
	BeepSet=TRUE;
	rectfill(screen,0,0,800,600, BLACK);
	Brackets1(BracketColor1,BracketColor2);
	rectfill(screen,10,308,110,532,BRICK);
	Box1a(ORANGE, "CLEAR", "F10", "", "");
	Box2a(PALEBLUE, "RESTORE PREV");
	EscBox1b(LILAC, "CLOSE");
	MarsF(780-(StrLenScorpio("DOS ACCESS")*2),10,2, ORANGE,BLACK,"DOS ACCESS");
	PutsLuna(780-(StrLenScorpio("DOS ACCESS")*2),108-28,PURPLE,BLACK,"EDITABLE COMMAND LINE");
	PutsLuna(780-(StrLenScorpio("DOS ACCESS")*2),108-8,PURPLE,BLACK,"SCROLLABLE OUTPUT");
	rectfill(screen,14,130,109,130+14,BracketColor1);
	PutsLuna(107-StrLenLuna("INPUT COMMAND"), 130, BLACK,BracketColor1, "INPUT COMMAND");
	rectfill(screen,14,287-19,109,287+14,BracketColor2);
	PutsLuna(14,287, BLACK,BracketColor2, "COMMANDS");
	PutsLuna(14,312, BLACK,BRICK, "CHDIR/CD");
	PutsLuna(14,330, BLACK,BRICK, "CLS");
	PutsLuna(14,348, BLACK,BRICK, "COPY");
	PutsLuna(14,366, BLACK,BRICK, "DEL/ERASE");
	PutsLuna(14,384, BLACK,BRICK, "DIR");
	PutsLuna(14,402, BLACK,BRICK, "EXIT");
	PutsLuna(14,420, BLACK,BRICK, "FORMAT (OFFLINE)");
	PutsLuna(14,438, BLACK,BRICK, "MKDIR/MD");
	PutsLuna(14,456, BLACK,BRICK, "RENAME/REN");
	PutsLuna(14,474, BLACK,BRICK, "RMDIR/RD");
	PutsLuna(14,492, BLACK,BRICK, "TYPE");
	PutsLuna(14,510, BLACK,BRICK, "VER");
	DriveChange=0;
	DirectoryChange=0;
	strcpy(CurrentPath, ustrupr(LcarsPath));
	strcpy(PathOfDriveC, CurrentPath);
	strcpy(PathOfDriveA, "A:\\");
	chdir(CurrentPath);
	ClearTextBuf();
	++Font21[32]; /* gives the space the same pitch as 0-e */
	DosLineInput();
	--Font21[32]; /* restore pitch of space to normal */
	if(DriveChange==1) {
		setdisk(2);
		SetLcarsPath();
	}
/*	if(DirectoryChange==1) */ SetLcarsPath();
	CurrentDrive=2;
}
void LcarsInit()
{
	BlasterOK=10; /* set to TRUE/FALSE after test */
	MuteBeeps=FALSE;
	BeepSet=FALSE;

	m=1.25;	/* magnification factor from VGA for brackets */
	uy=200;	/* brackets: upper edge of divider */
	ly=217;	/* brackets: lower edge of divider */

	strcpy(CurrentTrack,"song");
	strcpy(TimeDisplay,"12:34");
	strcpy(DateDisplay,"01/01");
	strcpy(SecDisplay,"00");
	strcpy(SecWhenAlarmSet,"00"); /* to seed random music selection for alarm */
	strcpy(TimeSetting,"12:34");
	strcpy(DateSetting,"10/29");
	strcpy(YearDisplay,"2473");

	old_sec=70;
	min_old=70;
	day_old=32;
	SettingType=0;
	AlarmHour=5;
	AlarmMin=55;
	SingleAlarmOnOff=0;
	MidiPlaying=0;
	strcpy(AlarmString,"12:00 A.M.");
	DriveChange=0;
	DirectoryChange=0;
	CurrentDrive=2;
	strcpy(StarDate,"-300000.0");
	null=0;
	AlarmType=0;
	ColorScheme=0;
	AudioOff=FALSE; /* temporary if TRUE (for bad versions of DJGPP) */
	SnoozeVal=12;
	SnoozeAlarmMin=70;
	Endgame=0;
	MilitaryTime=0;
	SlideshowActive=FALSE;
	Autorun=0;
}



