/*    LCcolor.h, color routines for LCARS 24
   Sets the 8 standard Starfleet LCARS colors and their
   antialiasing tones, plus black and gray
*/
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#ifndef PROGEDIT_H
#define PROGEDIT_H


#include <math.h>
#include <float.h>
#include "allegro.h"
#include "lcars24.h"
#include "filemenu.h"
#include "text24.h"

int capX;
int F2F3Disabled;


void PeClearAllBottomLabels()
void PeBottomLabels()
void PePutTime(int color)
int PeSafety()
void PeScreen1()
void PeColorChart()
void PeInfoxy()
void PeDisplayFilename()
void PeDisplayFrameTop()
int PePick(char MenuMode[10])
void PeDoSave()
int PeDoOpen()
int PeDoNew()
void PeDoSaveAs()
void PeDoFind()
void PeDoFindAndReplace()
void PeDoNext()
void PeDoHelp()
void PeDoGuide()
void PeDoMath()
void PeClearWindow()
void PePutOneChar()


int PeEdit()
{
	int Result;
	int Saved=0;

	x=1;
	y=0;
	T24DrawCursor();

loopback:
	PeInfoxy();
	T24DrawCursor();
	do {
		PePutTime(BIGBLUE);
	} while(!kbhit());
	c=GetKey();
	T24DrawCursor();
	switch( c )
	{
		case 1:  SelectAll();
			goto loopback;
		case 3:  T24DoCopy();
			goto loopback;
		case 4:	HighlightWord();
			goto loopback;
		case 6:  PeDoFind();
			goto loopback;
		case 8:  if(ControlKeyStatus() != 0) PeDoFindAndReplace();
				else Backspace();
			Action=1;
			goto loopback;
		case 9:	Tab();
			Action=1;
			goto loopback;
		case 12: PeDoNext();
			Action=1;
			goto loopback;
		case 13: Xreturn();
				Action=1;
				goto loopback;
		case 20: T24DoTextColor();
				goto loopback;
		case 21: CtrlU();
				goto loopback;
		case 22: T24DoPaste();
				goto loopback;
		case 24: T24DoCut();
				goto loopback;
		case 25: CtrlY();
				Action=1;
				goto loopback;
		case LEFTARROW: if(ShiftKeyStatus() != 0) SelectLeft();
					else CursorLeft();
				goto loopback;
		case RIGHTARROW: if(ShiftKeyStatus() != 0) SelectRight();
					else CursorRight();
				goto loopback;
		case CTRLUPARROW:
		case UPARROW:  if(ShiftKeyStatus() != 0) SelectUp();
					else CursorUp();
				goto loopback;
		case CTRLDOWNARROW:
		case DOWNARROW: if(ShiftKeyStatus() != 0) SelectDown();
					else CursorDown();
				goto loopback;
		case DELKEY: DelKey();
				Action=1;
				goto loopback;
		case PGUPKEY: PageUp();
				goto loopback;
		case PGDNKEY: PageDown();
				goto loopback;
		case HOMEKEY: CursorBOL();
				goto loopback;
		case ENDKEY: CursorEOL();
				goto loopback;
		case CTRLLEFTARROW: WordLeft();
				goto loopback;
		case CTRLRIGHTARROW: if(ShiftKeyStatus() != 0) SelectWordRight();
						else WordRight();
				goto loopback;
		case CTRLHOMEKEY: TopOfFile();
				goto loopback;
		case CTRLENDKEY: BottomOfFile();
				goto loopback;
		case F1:
		case 19: PeDoSave();
				Saved=1;
				goto loopback;
		case F2: if(F2F3Disabled==TRUE) {
				PeColorChart();
				goto loopback;
			 } else {
				PeDoOpen();
				goto loopback;
			 }
		case 15: if(F2F3Disabled==TRUE) goto loopback;
                		else PeDoOpen();
				goto loopback;
		case F3: if(F2F3Disabled==TRUE) {
				PeDoGuide();
				goto loopback;
			 } else {
				PeDoNew();
				goto loopback;
			 }
		case F4: PeDoSaveAs();
				goto loopback;
		case F10: PeDoMath();
				goto loopback;
		case F11:	PeDoHelp();
				PanelBeep();
				goto loopback;
		case F12: if(Action!=0) {
				Result=PeSafety();
				if(Result==1) return(Saved);
				if(Result==2) {
					goto loopback;
				}
				if(Result==3) {
					SaveTextFile();
					Saved=1;
					return(Saved);
				}
			} else {
					return(Saved);
			}
		case 350: Screenshot792("Proged8.bmp");
			goto loopback;
		case 351: Screenshot1024("Proged10.bmp");
			goto loopback;
		default: if( c > 31 && c < 126) {
				PePutOneChar();
				Action=1;
			}
		goto loopback; /* unreachable safety net */
	}
}
int ProgEditMode(char *filespec)
{
	int Result,z;

	T24Init();
	MonoType=1;
	lp=24;
	NumLns=21;
	PopMinOld=70;
	PeScreen1();
	strcpy(CurrentFile, filespec);
	PeDisplayFilename();
	T24buf=create_bitmap(784,504);
	T24linebuf=create_bitmap(784,lp);
	T24ClearWindow();
	AutoCorrectOff=TRUE;
	F2F3Disabled=FALSE;
	if(memicmp(CurrentFile,"NAMELESS.TXT",12) != 0) {
		strcpy( CurrentFile, filespec);
		if( LoadSourceCode() !=0) PeScreen1();
		PeDisplayFilename();
		if(strnicmp("SFM",get_extension(filespec),3)==0) {
			F2F3Disabled=TRUE;
			PeBottomLabels();
		}
	}
	T24RefreshAll();
	T24DrawCursor();
	PanelBeep();
	Result=PeEdit();
	destroy_bitmap(T24buf);
	destroy_bitmap(T24linebuf);
	MonoType=0;
	F2F3Disabled=FALSE;
	return(Result);
}
int OpenProgEdit(char *filespec)



#endif


