/*	 Jigsaw puzzle app for LCARS 24
	Requires image files and piece file
*/
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#ifndef JIGSAW_H
#define JIGSAW_H


#include "lcars24.h"
#include "parts.h"
#include "getkey.h"
#include "textio.h"
#include "playwav.h"
#include "headline.h"
#include "scrnshot.h"
#include "errmsg.h"
#include "mars28.h"
#include "common.h"

typedef struct jigsaw {

	char locked;
	int x;
	int y;
	int homex;
	int homey;
	int mapx;
	int mapy;
	int priority;
	int slant;

} JIGSAW;

JIGSAW JgsPiece[55];
int JgsPriority[55];

RLE_SPRITE *JgsCursorSprite;
BITMAP *JgsCursorBackbmp;

BITMAP *JgsPieceMap;
BITMAP *JgsSegment;
BITMAP *JgsSegmentMask;

BITMAP *JgsDragBmp;
BITMAP *JgsSlantBmp;
BITMAP *JgsHandoffBmp;
BITMAP *JgsDragEraseBmp;
BITMAP *JgsBackscreen;

int JgsX;
int JgsY;
int JgsPrevX;
int JgsPrevY;
int JgsCursorRepeat;
int JgsActivity;
int JgsPuzzleNum;
char JgsDragging;
char JgsLockedFlag;
char JgsPiecesRemaining;
char JgsPieceMapLoaded;

int JigsawMode();

#endif
