/* Htmview, to display a Web page */
/* Usage: OpenHtml(char *filespec) to take a snapshot of the screen
		then restore it when the viewer closes, or
		or LcHtml(char *filespec) to call the viewer directly
*/

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "htmview.h"

void Info(int y) /* just for debugging */
{
	char LineNum[8];

	return; /* unplugged for release */
	rectfill(screen,540,13,620,27+12,LILAC);
	PutsLuna(550,20,BLACK,LILAC, "LINE");
	itoa(y+1,LineNum,10);  /* y+1 for line number */
	PutsLuna(580,20,BLACK,LILAC, LineNum);
}
void SetDefault()
{
	DefaultLeftMargin=10;
	BaseLeftMargin=10;
	LeftMargin=BaseLeftMargin;
	stripping=FALSE;
	OlOn=FALSE;
	UlOn=FALSE;
	DrawBullet=FALSE;
	DrawImage=FALSE;
	DrawOrderedListNum=FALSE;
	HtmlUnderline=FALSE;
	OrderedListEndingLine=EndText;
	OrderedListNum=0;
	HtmlPx=660;
	HtmlPy=310;
	HtmlPd=LEFTARROW;
	TextHeight=10;
	linefill=0;
	rm=90;
	ItemLinebreak=FALSE;
	Preformat=FALSE;
	Headline=0;
	Endbuf=10;
	prevtxty=0;
	ItalicsOn=FALSE;
	DisplayHtmlTags=FALSE;
}
void LoadBackImage()
{
	NoBackImage=TRUE;
	if(! __file_exists("C:\\LCARS24\\SYSTEM\\BACK.JPG")) {
		NoBackImage=TRUE;
		return;
	}
	backimage = load_jpeg("C:\\LCARS24\\SYSTEM\\BACK.JPG", the_palette);
	if (! backimage) {
		NoBackImage=TRUE;
		return;
	}
}
int HtmlDisplayJpeg(char *filespec, int x, int y)
{
	BITMAP *web_image;
	PALETTE web_palette;


	web_image=load_jpeg(filespec, web_palette);
	if (!web_image) {
		return(86);
	}
	if(DepthFound > 8) set_palette(web_palette);
	blit(web_image, workbuf, 0, 0, x, y, web_image->w,web_image->h);
	ImageWidth=web_image->w;
	ImageHeight=web_image->h;
	destroy_bitmap(web_image);
	return(0);
}
int HtmlDisplayBmp(char *filespec, int x, int y)
{
	BITMAP *web_image;
	PALETTE web_palette;

	web_image=load_bmp(filespec, web_palette);
	if (!web_image) {
		return(86);
	}
	if(DepthFound > 8) set_palette(web_palette);
	blit(web_image, workbuf, 0, 0, x+1, y+1, web_image->w,web_image->h);

	rect(workbuf, x, y, x+web_image->w+2, y+web_image->h+2, TextColor);

	destroy_bitmap(web_image);
	return(0);
}
int HtmlDisplayGif(char *filespec, int x, int y)
{
	BITMAP *web_image;

	web_image=load_gif(filespec, 0);
	if (!web_image) {
		return(86);
	}
	blit(web_image, workbuf, 0, 0, x+1, y+1, web_image->w,web_image->h);
	ImageWidth=web_image->w;
	ImageHeight=web_image->h;
	destroy_bitmap(web_image);
	return(0);
}
void ProcessImage(int y)
{
	char ImageFilespec[100];
	char TempFilename[100];
	int Width=64;
	int Height=20;
	int Border=0;
	int h=20;
	int Left;

	if(ParseTagbuf(ImageTag, "width")==0) Width=atoi(ParseResult);
	if(ParseTagbuf(ImageTag, "height")==0) Height=atoi(ParseResult);

	ImageHeight=Height;
	ImageWidth=Width;
	Left=BaseLeftMargin;
	if(ParseTagbuf(ImageTag, "hspace")==0) Left=atoi(ParseResult);

	if(ParseTagbuf(ImageTag, "src")==0) {
		strcpy(TempFilename, ParseResult);
		strcpy(ImageFilespec,"C:\\LCARS24\\DATA\\");
		strcat(ImageFilespec,TempFilename);
	}

	if(! __file_exists(ImageFilespec)) {
		if(ParseTagbuf(ImageTag, "alt")==0) {
			PutsArial10(workbuf,Left+10,y+10,TextColor,ParseResult);
			Width = (strlen(ParseResult)+2)*7;
		}
		rect(workbuf,Left,y,Left+Width,y+Height,TextColor);
		goto out;
	}

	if(stricmp( "GIF", get_extension(ImageFilespec))==0) {
		if(HtmlDisplayGif(ImageFilespec, Left, y) !=0) {
			rect(workbuf,Left,y,Left+Width,y+Height,TextColor);
		}
	} else {
		rect(workbuf,Left,y,Left+Width,y+Height,TextColor);
	}
	if(stricmp( "JPG", get_extension(ImageFilespec))==0) {
		if(HtmlDisplayJpeg(ImageFilespec, Left, y) !=0) goto out;
	}

	if(ParseTagbuf(ImageTag, "border")==0) Border=atoi(ParseResult);
	if(Border >0) rect(workbuf,Left-1,y+1,Left+ImageWidth+1,y+ImageHeight+1,TextColor);

out:
	while(h < ImageHeight) h += 17;
	h +=17;
	HtmlGraphicY +=h;
}
void CenterHeadline()
{
	char s[100], p[100];
	int sp, pp;

return;

/*	LeftMargin=100; */

/* The following is bypassed for now, because there can be
more tags and other garbage in a file to mess this up. */

	sp=0;
	pp=0;
	memset(p,(null),100);

	strcpy(s,Ln[HtmlDisplayLine]);
	while( s[sp] !=0 && s[sp] !='>' ) sp++;
	sp++;

	while( s[sp] !=0 && s[sp] !='<' ) {
		t=s[sp];
		p[pp]=(t);
		sp++;
		pp++;
	}

}
int TranslateGlyph()
{
	if(memicmp( GlyphBuf,"&lt;",GlyphX)==0) return('<');
	if(memicmp( GlyphBuf,"&gt;",GlyphX)==0) return('>');
	if(memicmp( GlyphBuf,"&amp;",GlyphX)==0) return('&');
	if(memicmp( GlyphBuf,"&quot;",GlyphX)==0) return(34);
	if(memicmp( GlyphBuf,"&nbsp;",GlyphX)==0) return(' ');
	return('?');
}
int InvokeTag(int TagX)
{
	if(memicmp(TagBuf,"<ALINK>",7)==0 && Headline==0) {
		TextColorHolder=TextColor;
		TextColor=AlinkColor;
		HtmlUnderline=TRUE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"<A ",3)==0 && Headline==0) {
		TextColorHolder=TextColor;
		TextColor=AlinkColor;
		HtmlUnderline=TRUE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"</A>",TagX)==0) {
		TextColor=TextColorHolder;
		HtmlUnderline=FALSE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"<B>",TagX)==0) {
		if(Headline==0) Bold=TRUE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"</B>",TagX)==0) {
		Bold=FALSE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"<BODY>",6)==0) {
/*		memset(BodyTag,(null),1024); */
/*		memset(TagBuf,(null),1024);	 */
		HtmlGraphicY +=17;
		linefill=0;
		LeftMargin=BaseLeftMargin;
		return(TRUE);
	}
	if(memicmp(TagBuf,"<BODY ",6)==0) {  /* ?? */
		strcpy(BodyTag,TagBuf);
		memset(TagBuf,(null),1024);
/*		ProcessBodySpecs();						*/
/*		return(TRUE);								*/
	}
	if(memicmp(TagBuf,"<BR>",TagX)==0) {
/*		if(IgnoreLinebreak=TRUE) return(TRUE); */
		HtmlGraphicY +=17;
		linefill=0;
		LeftMargin=BaseLeftMargin;
		return(TRUE);
	}
	if(memicmp(TagBuf,"<CODE>",TagX)==0) {
		return(TRUE);
	}
	if(memicmp(TagBuf,"</CODE>",TagX)==0) {
		return(TRUE);
	}
	if(memicmp(TagBuf,"<DIR>",TagX)==0) {
		UlOn=TRUE;
		LeftMargin=BaseLeftMargin+40;
		linefill=0;
		ItemLinebreak=TRUE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"</DIR>",TagX)==0) {
		UlOn=FALSE;
		LeftMargin=BaseLeftMargin;
		linefill=0;
		HtmlGraphicY +=17;
		ItemLinebreak=FALSE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"<EM>",TagX)==0) {
		ItalicsOn=TRUE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"</EM>",TagX)==0) {
					 ItalicsOn=FALSE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"<FONT",5)==0) {
		if(ParseTagbuf(TagBuf, "color")==0)
		TextColor=ParseColorSpec(ParseResult);
		return(TRUE);
	}
	if(memicmp(TagBuf,"<H1",3)==0) {
		memset(HeadlineStr,(null),128);
		HeadX=0;
		linefill=0;
		HtmlGraphicY +=34;
		Headline=1;
		return(TRUE);
	}
	if(memicmp(TagBuf,"</H1",4)==0) {
		if(Headline==1 && ReadOnly==FALSE) Headline26(workbuf, LeftMargin, HtmlGraphicY, TextColor, HeadlineStr);
		linefill=0;
		HtmlGraphicY +=34;
		Headline=0;
		return(TRUE);
	}
	if(memicmp(TagBuf,"<H2",3)==0) {
		memset(HeadlineStr,(null),128);
		HeadX=0;
		linefill=0;
		HtmlGraphicY +=34;
		Headline=2;
		return(TRUE);
	}
	if(memicmp(TagBuf,"</H2",4)==0) {
		if(Headline==2 && ReadOnly==FALSE) Headline21(workbuf, LeftMargin, HtmlGraphicY, TextColor, HeadlineStr);
		linefill=0;
		HtmlGraphicY +=34;
		Headline=0;
		return(TRUE);
	}
	if(memicmp(TagBuf,"<H3",3)==0) {
		memset(HeadlineStr,(null),128);
		HeadX=0;
		linefill=0;
		HtmlGraphicY +=34;
		Headline=3;
		return(TRUE);
	}
	if(memicmp(TagBuf,"</H3",4)==0) {
		if(Headline==3 && ReadOnly==FALSE) Headline19(workbuf, LeftMargin, HtmlGraphicY, TextColor, HeadlineStr);
		linefill=0;
		HtmlGraphicY +=34;
		Headline=0;
		return(TRUE);
	}
	if(memicmp(TagBuf,"<H4",3)==0) {
		linefill=0;
		HtmlGraphicY +=34;
		Headline=0;
		Bold=TRUE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"</H4",4)==0) {
		linefill=0;
		HtmlGraphicY +=34;
		Headline=0;
		Bold=FALSE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"<H5",3)==0) {
		linefill=0;
		HtmlGraphicY +=34;
		Headline=0;
		return(TRUE);
	}
	if(memicmp(TagBuf,"</H5",4)==0) {
		linefill=0;
		HtmlGraphicY +=34;
		Headline=0;
		return(TRUE);
	}
	if(memicmp(TagBuf,"<H6",3)==0) {
		linefill=0;
		HtmlGraphicY +=34;
		Headline=0;
		return(TRUE);
	}
	if(memicmp(TagBuf,"</H6",4)==0) {
		linefill=0;
		HtmlGraphicY +=34;
		Headline=0;
		return(TRUE);
	}
	if(memicmp(TagBuf,"<HR",3)==0) {
		HtmlGraphicY += 17;
		if(ReadOnly==FALSE) {
			xor_mode(TRUE);
			rectfill(workbuf,38, HtmlGraphicY+5, 600, HtmlGraphicY+6, WHITE);
			xor_mode(FALSE);
		}
		HtmlGraphicY += 17;
		Headline=0;
		return(TRUE);
	}
	if(memicmp(TagBuf,"<I>",TagX)==0) {
		if(Headline==0) ItalicsOn=TRUE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"</I>",TagX)==0) {
					 ItalicsOn=FALSE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"<IMG",4)==0) {
		strcpy(ImageTag,TagBuf);
		DrawImage=TRUE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"<LI",3)==0) {
		if(UlOn==TRUE) {
			DrawBullet=TRUE;
			DrawOrderedListNum=FALSE;
			linefill=0;
			HtmlGraphicY +=17;
		}
		if(OlOn==TRUE) {
			DrawOrderedListNum=TRUE;
			DrawBullet=FALSE;
			linefill=0;
			HtmlGraphicY +=17;
								++OrderedListNum;
			if(ParseTagbuf(TagBuf,"value")==0) OrderedListNum=atoi(ParseResult);
		}
		return(TRUE);
	}
	if(memicmp(TagBuf,"<MENU",5)==0) {
		UlOn=TRUE;
		LeftMargin=BaseLeftMargin+40;
		linefill=0;
		ItemLinebreak=TRUE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"</MENU>",7)==0) {
		UlOn=FALSE;
		LeftMargin=BaseLeftMargin;
		linefill=0;
		HtmlGraphicY +=17;
		ItemLinebreak=FALSE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"<OL",3)==0) {
		OlOn=TRUE;
		LeftMargin=BaseLeftMargin+40;
		OrderedListEndingLine=HtmlLineNum;
		linefill=0;
		ItemLinebreak=TRUE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"</OL>",TagX)==0) {
		OlOn=FALSE;
		LeftMargin=BaseLeftMargin;
		linefill=0;
		HtmlGraphicY +=17;
		OrderedListNum=0;
		ItemLinebreak=FALSE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"<P>",TagX)==0) {
		linefill=0;
		if(Headline !=0 && ReadOnly==FALSE) {
			if(Headline==1) Headline26(workbuf, LeftMargin, HtmlGraphicY, TextColor, HeadlineStr);
			if(Headline==2) Headline21(workbuf, LeftMargin, HtmlGraphicY, TextColor, HeadlineStr);
			if(Headline==3) Headline19(workbuf, LeftMargin, HtmlGraphicY, TextColor, HeadlineStr);
			memset(HeadlineStr,(null),128);
			HeadX=0;
			HtmlGraphicY +=34;
		} else {
			HtmlGraphicY +=17;
			Headline=0;
		}
		return(TRUE);
	}

	if(memicmp(TagBuf,"<P",2)==0) {
		linefill=0;
		HtmlGraphicY +=17;
		Headline=0;
		return(TRUE);
	}
	if(memicmp(TagBuf,"</P>",TagX)==0) {
		linefill=0;
		HtmlGraphicY +=17;
		Headline=0;
		return(TRUE);
	}
	if(memicmp(TagBuf,"<PRE",3)==0) {
		Preformat=TRUE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"</PRE>",TagX)==0) {
		Preformat=FALSE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"<STRONG>",TagX)==0) {
		Bold=TRUE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"</STRONG>",TagX)==0) {
		Bold=FALSE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"<TABLE",6)==0) {
		strcpy(TableTag,TagBuf);
		ProcessTableSpecs();
		return(TRUE);
	}
	if(memicmp(TagBuf,"</TABLE>",TagX)==0) {
		Cellspacing=0;
		Cellpadding=0;
		Cellnumber=0;
		rm=90;
		rect(workbuf,0,HtmlGraphicY,774,4810,BackgroundColor);
		return(TRUE);
	}
	if(memicmp(TagBuf,"<TD>",4)==0) {
		Cellnumber++;
/*$$$		BaseLeftMargin += ((Cellpadding*2)+Cellspacing+CellRight-Cellwidth);
*/
		LeftMargin=BaseLeftMargin;
		IgnoreLinebreak=TRUE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"<TD",3)==0) {
		strcpy(TableTag,TagBuf);
		ProcessCellSpecs();
		Cellnumber++;
/*		BaseLeftMargin += ((Cellpadding*2)+Cellspacing+CellRight-Cellwidth);
*/
		LeftMargin=BaseLeftMargin;
		IgnoreLinebreak=TRUE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"</TD>",TagX)==0) {
		IgnoreLinebreak=FALSE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"<TR",3)==0) {
		Cellnumber=0;
		BaseLeftMargin=DefaultLeftMargin;
		LeftMargin=BaseLeftMargin;
		CellRight=0;
		HtmlGraphicY +=17;
		linefill=0;
		return(TRUE);
	}
	if(memicmp(TagBuf,"<UL",3)==0) {
		UlOn=TRUE;
		LeftMargin=BaseLeftMargin+40;
		linefill=0;
/* ?? */	ItemLinebreak=TRUE;
		return(TRUE);
	}
	if(memicmp(TagBuf,"</UL>",TagX)==0) {
		UlOn=FALSE;
		LeftMargin=BaseLeftMargin;
		linefill=0;
		HtmlGraphicY +=17;
		ItemLinebreak=FALSE;
		return(TRUE);
	}
	return(FALSE);
}
void HtmlDrawOrderedListNumber(BITMAP *bmp,int y)
{
		  int z, k, i, pos;

	char Output[12];
	itoa(OrderedListNum,Output,10);
	strcat(Output,".");
	pos=BaseLeftMargin+26-StrLenArial10(Output);
		  k=strlen(Output);
	for(z = 0; z < k; ++z) {
		i=Output[z];
		BlitArial10(bmp,pos,y,TextColor,i);
					 pos += Arial10[i]-65;
	}
}
void HtmlDrawBullet(int y)
{
	rect(workbuf,BaseLeftMargin+26,y+4,BaseLeftMargin+28,y+8,TextColor);
	rectfill(workbuf,BaseLeftMargin+25,y+5,BaseLeftMargin+29,y+7,TextColor);
}
int OutputText()
{
	char Capture[1800];
	int i;
	int k;
	int j;
	int pos;
	int tabpos;
	unsigned int t;
	int TagX;
	char gliphing=FALSE;
	int UnderlineStart;

	StrongShadow=FindStrongShadow(TextColor,BackgroundColor);
	memset(TagBuf,(null),1024);
	if(linefill==0) pos = LeftMargin;
	j = strlen(Ln[HtmlDisplayLine]);
	strcpy(Capture, Ln[HtmlDisplayLine]);
	strcat(Capture," ");
	t = (null);
	Capture[j+1] = (t);
	t=32;
	TagX=0;
	for(k = 0; k <= j; ++k) {
		t=Capture[k];
		if(t=='<') stripping=TRUE;
		if(t=='>') stripping=FALSE;
		if(stripping==TRUE) {
			TagBuf[TagX]=(t);
			++TagX;
			if(DisplayHtmlTags==FALSE) goto cycle;
		}
		if(t=='>') {
			TagBuf[TagX]=(t);
			++TagX;
			InvokeTag(TagX);
			memset(TagBuf,(null),1024);
			TagX=0;
			if(DisplayHtmlTags==FALSE) goto cycle;
		}

		if(t=='&') gliphing=TRUE;
		if(t==';' && gliphing==TRUE) {
			gliphing=FALSE;
			Capture[k]=TranslateGlyph(GlyphX);
			memset(GlyphBuf,(null),12);
			GlyphX=0;
		}
		if(gliphing==TRUE) {
			GlyphBuf[GlyphX]=(t);
			++GlyphX;
			goto cycle;
		}

		if(DrawImage==TRUE) return(0);
		HtmlTextOutput=TRUE;

/*						??????
if(ItemLinebreak==TRUE && k==j) {
	linefill=0;
		  pos = LeftMargin;
	HtmlGraphicY += 17;
	return(0);
}
*/


/* ###### */
if(linefill==0) pos=LeftMargin;
if( linefill >= rm && (Capture[k]==32 || Capture[k]=='/' || Capture[k]=='\\' || Capture[k]=='-' || Capture[k]=='=')  )  {
	linefill=0;
		  pos = LeftMargin;
	++k;
/*	if(Capture[k+1]==32) ++k; */
	HtmlGraphicY += 17;
}

/* if(Capture[k]==32) Capture[k]=95; */

		UnderlineStart=pos;
		if( Capture[k] < 32 && Capture[k] != 9 ) i = (t);
		else i = Capture[k];
		if(ReadOnly==FALSE && Capture[k] != 9 ) {
			if(Headline==0) {
			if(Bold==TRUE) BlitArial10(workbuf,pos+1,HtmlGraphicY+11-TextHeight,StrongShadow,i);
			BlitArial10(workbuf,pos,HtmlGraphicY+11-TextHeight,TextColor,i);
			++linefill;
			} else {
				HeadlineStr[HeadX]=i;
				HeadX++;
			}
		}

/* ##### */

		if( Capture[k] == 9 ) {
			tabpos=0;
			while( pos-x >= tabpos) tabpos += 40;
			pos = tabpos + x;
		} else pos += Arial10[i]-65;

		if(ReadOnly==FALSE && DrawBullet==TRUE) HtmlDrawBullet(HtmlGraphicY);
		DrawBullet=FALSE;


		if(ReadOnly==FALSE && DrawOrderedListNum==TRUE) HtmlDrawOrderedListNumber(workbuf,HtmlGraphicY);
		DrawOrderedListNum=FALSE;

		if(ReadOnly==FALSE && HtmlUnderline==TRUE) hline(workbuf,UnderlineStart, HtmlGraphicY+12,pos,TextColor);


cycle: 		t=32; /* Just for the label */

	}
	return(0);
}
void HtmlDrawPointer(int txty)
{
	int offset;

	offset = (txty*17);
	switch( HtmlPd )
	{
		case LEFTARROW:
blit(workbuf,screen,HtmlPx+20,offset+HtmlPy-50,HtmlPx+13+20,HtmlPy,18,18);
			NorthwestArrowSymbol(HtmlPx+13, HtmlPy, RED);
				return;
		case RIGHTARROW:
blit(workbuf,screen,HtmlPx-20,offset+HtmlPy-50,HtmlPx+13-20,HtmlPy,18,18);
			NorthwestArrowSymbol(HtmlPx+13, HtmlPy, RED);
				return;
		case UPARROW:
blit(workbuf,screen,HtmlPx,offset+HtmlPy+17-50,HtmlPx+13,HtmlPy+17,18,18);
			NorthwestArrowSymbol(HtmlPx+13, HtmlPy, RED);
				return;
		case DOWNARROW:
blit(workbuf,screen,HtmlPx,offset+HtmlPy-17-50,HtmlPx+13,HtmlPy-17,18,18);
			NorthwestArrowSymbol(HtmlPx+13, HtmlPy, RED);
	}
}
void HtmlLargeFileRefresh(int txty)
{
	int i,z, Start;

/*	txty=txty*3; */

	/* wierd, but because were using three array */
			  /* elements merged into one at input			*/

/* Info(txty); */
	if(txty==0) SetDefault();
	if(NoBackImage==TRUE) clear_to_color(workbuf,BackgroundColor);
		else blit(backimage,workbuf,0,0,0,0,800,500);
	HtmlGraphicY=10;
	OlOn=FALSE;
	UlOn=FALSE;
	DrawBullet=FALSE;
		  DrawOrderedListNum=FALSE;
	HtmlUnderline=FALSE;
	Start=0;
	OrderedListNum=0;

	memset(GlyphBuf,(null),12);
	if(txty < 100) goto read_from_top;

/* Find where to start reading tags above the current scroll position */


/*	if(txty > prevtxty) goto bypass; */

	Start=txty-100;  /* was 300 with array cheat */

	do {
		if(Start < 0) break;
		if(Ln[Start][0]==(null)) break;
/* 		if(memicmp( Ln[Start],"<P>",3)==0) break;  ??	*/
		--Start;
	}while(1);


read_from_top:

/* Read the tags before the current view area (a drag!) */

	if( Start < 0 ) Start=0;
	ReadOnly=TRUE;
	HtmlDisplayLine=Start;
	linefill=0;
	do {
					 OutputText();
		HtmlDisplayLine++;
	} while (HtmlDisplayLine < txty);

bypass:
	prevtxty=txty;

/* Now try to render the current screenful */
	DrawImage=FALSE;
	ReadOnly=FALSE;

	HtmlDisplayLine=txty;
	HtmlGraphicY=10;

	do {
/*		HtmlLineNum=(txty/3)+ (HtmlDisplayLine/3); */
		HtmlLineNum=txty+ HtmlDisplayLine;

		HtmlTextOutput=FALSE;
/* preformatted text */
/* ?? */	if(Preformat==TRUE) {
			HtmlGraphicY += 17;
			linefill=0;
		}

/* formatted text */
		if( Ln[HtmlDisplayLine][0] != (null) ) OutputText();
		if(stripping==TRUE) {
			if( Ln[HtmlDisplayLine][0] != (null) ) OutputText();
		}
/* inline image */
		if(DrawImage==TRUE) {
			ProcessImage(HtmlGraphicY);
			DrawImage=FALSE;
		}
/* get next line */
skip:		HtmlDisplayLine++;
		if(HtmlDisplayLine >= EndText) break;
		if(HtmlTextOutput==TRUE && linefill==0) HtmlGraphicY += 17;
	} while(HtmlGraphicY < 490);

/* Update the view area */
	blit(workbuf,screen,0,0,13,50,774,478);
	HtmlDrawPointer(0);
}
int HtmlLargeFileControl(int txty )
{
	rectfill(screen,540,13,620,27+12,LILAC);
	DisplayHtmlTags = FALSE;
	prevtxty=txty;
	HtmlLargeFileRefresh(txty);

loopback:
	do {

	c = GetKey();
	switch( c )
		{

		case F9: HtmlLargeFileRefresh(txty);
			goto loopback;
/*
		case F10: ColorStyle = !ColorStyle;
			if(ColorStyle) {
				BackgroundColor=LightGray;
				HtmlLargeFileRefresh(txty);
				goto loopback;
			} else {
				BackgroundColor=BLACK;
				HtmlLargeFileRefresh(txty);
				goto loopback;
			}
*/
		case F12: DisplayHtmlTags = !DisplayHtmlTags;
			HtmlLargeFileRefresh(txty);
			goto loopback;
		case LEFTARROW: HtmlPd=LEFTARROW;
				HtmlPx -=20;
				if(HtmlPx < 40) HtmlPx=40;
				HtmlDrawPointer(0);
				goto loopback;
		case UPARROW:	if(HtmlPy==70 && txty==0) goto loopback;
				HtmlPd=UPARROW;
				HtmlPy -=17;
				if(HtmlPy < 70) {
					HtmlPy=70;
					if(txty>0) txty-=1;
					HtmlLargeFileRefresh(txty);
				}
				HtmlDrawPointer(0);
				goto loopback;
		case RIGHTARROW: HtmlPd=RIGHTARROW;
				HtmlPx +=20;
				if(HtmlPx > 740) HtmlPx=740;
				HtmlDrawPointer(0);
				goto loopback;
		case DOWNARROW: HtmlPd=DOWNARROW;
				HtmlPy +=17;
				if(HtmlPy > 510) {
					HtmlPy=510;
					if(txty<EndText-16) txty+=1;
					if(txty<1) txty = 0;
					HtmlLargeFileRefresh(txty);
				}
				HtmlDrawPointer(0);
				goto loopback;
		case HOMEKEY: if(txty<1) goto loopback;
			txty=0;
			HtmlLargeFileRefresh(txty);
			goto loopback;
		case ENDKEY: if(txty>=EndText-16) goto loopback;
			txty=EndText-16;
			if(txty>=EndText-16) {
				txty=EndText-16;
			}
			if(txty > EndText) txty=EndText;
			HtmlLargeFileRefresh(txty);
			goto loopback;
		case PGUPKEY:
			if(txty<1) goto loopback;
			txty -=4;
			if(txty<1) txty = 0;
			HtmlLargeFileRefresh(txty);
			goto loopback;
		case PGDNKEY: if(txty>=EndText-17) goto loopback;
			txty +=4;
			if(txty>=EndText-24) {
				txty=EndText-24;
			}
			if(txty<1) txty = 0;
			if(txty > EndText) txty=EndText;
			HtmlLargeFileRefresh(txty);
			goto loopback;
		case 27: return(1);
		case 350: Screenshot792("Webvw8.bmp");
				PanelBeep();
				goto loopback;
		case 351: Screenshot1024("Webvw10.bmp");
				PanelBeep();
				goto loopback;
		default: goto loopback;
		}
	}while(1);
}
void HtmlRender(int txty)
{
	int i,z, Start;

/*	txty=txty*3; */  /* wierd, but because were using three array */
			  /* elements merged into one at input			*/

/* Info(txty); */
	if(txty==0) SetDefault();
	if(NoBackImage==TRUE) clear_to_color(workbuf,BackgroundColor);
		else blit(backimage,workbuf,0,0,0,0,800,500);
	HtmlGraphicY=10;
	OlOn=FALSE;
	UlOn=FALSE;
	DrawBullet=FALSE;
	DrawOrderedListNum=FALSE;
	HtmlUnderline=FALSE;
	Headline=FALSE;
	Start=0;
	OrderedListNum=0;

	memset(GlyphBuf,(null),12);

/* Render whole back buffer, since it's a small page */
	DrawImage=FALSE;
	ReadOnly=FALSE;

	HtmlDisplayLine=txty;
	HtmlGraphicY=10;

	do {
/*		HtmlLineNum=(txty/3)+ (HtmlDisplayLine/3); */
		HtmlLineNum=(txty)+ (HtmlDisplayLine);

		HtmlTextOutput=FALSE;
/* preformatted text */
/* ?? */	if(Preformat==TRUE) {
			HtmlGraphicY += 17;
			linefill=0;
		}

/* formatted text */
		if( Ln[HtmlDisplayLine][0] != (null) ) OutputText();
		if(stripping==TRUE) {
			if( Ln[HtmlDisplayLine][0] != (null) ) OutputText();
		}
/* inline image */
		if(DrawImage==TRUE) {
			ProcessImage(HtmlGraphicY);
			DrawImage=FALSE;
		}
/* get next line */
skip:		HtmlDisplayLine++;
		if(HtmlDisplayLine >= EndText) break;
		if(HtmlTextOutput==TRUE && linefill==0) HtmlGraphicY += 17;
	} while(HtmlGraphicY < 4810);
	Endbuf=(HtmlGraphicY-10)/17;
/* Update the view area */
/*	blit(workbuf,screen,0,0,13,50,774,490); */
	HtmlDrawPointer(txty);

/* Info((Endbuf); */ /* limit of buffer = 240 */

}

void HtmlRefresh(int txty)
{
	blit(workbuf,screen,0,(txty*17)+10,13,60,774,478); /*was 480 */
	HtmlDrawPointer(txty);
/*	Info(Endbuf); */
}
int HtmlControl(int txty )
{
	DisplayHtmlTags = FALSE;
/*
	if(EndText >= 240) {
		destroy_bitmap(workbuf);
		workbuf = create_bitmap(774,500);
		set_palette(the_palette);
		HtmlLargeFileControl(txty);
		return(1);
	}
*/
	HtmlRender(txty);
	HtmlRefresh(txty);
/*
	if(Endbuf >= 240) {
		destroy_bitmap(workbuf);
		workbuf = create_bitmap(774,500);
		set_palette(the_palette);
		HtmlLargeFileControl(txty);
		return(1);
	}
*/
loopback:
	do {

	c = GetKey();
	switch( c )
		{
		case LEFTARROW: HtmlPd=LEFTARROW;
				HtmlPx -=20;
				if(HtmlPx < 40) HtmlPx=40;
				HtmlDrawPointer(txty);
				goto loopback;
		case UPARROW:	if(HtmlPy==70 && txty==0) goto loopback;
				HtmlPd=UPARROW;
				HtmlPy -=17;
				if(HtmlPy < 70) {
					HtmlPy=70;
					if(txty>0) txty-=1;
					HtmlRefresh(txty);
				}
				HtmlDrawPointer(txty);
				goto loopback;
		case RIGHTARROW: HtmlPd=RIGHTARROW;
				HtmlPx +=20;
				if(HtmlPx > 740) HtmlPx=740;
				HtmlDrawPointer(txty);
				goto loopback;
		case DOWNARROW: HtmlPd=DOWNARROW;
				HtmlPy +=17;
				if(HtmlPy > 510) {
					HtmlPy=510;
					if(txty<Endbuf-22) txty+=1;
					if(txty<1) txty = 0;
					HtmlRefresh(txty);
				}
				HtmlDrawPointer(txty);
				goto loopback;
		case HOMEKEY: if(txty<1) goto loopback;
			txty=0;
			HtmlRefresh(txty);
			goto loopback;
		case ENDKEY: if(txty>=Endbuf-22) goto loopback;
			txty=Endbuf-22;
			if(txty>=Endbuf-22) txty=Endbuf-22;
			if(txty > Endbuf) txty=Endbuf-22;
			HtmlRefresh(txty);
			goto loopback;
		case PGUPKEY:
			if(txty<1) goto loopback;
			txty -=4;
			if(txty<1) txty = 0;
			HtmlRefresh(txty);
			goto loopback;
		case PGDNKEY: if(txty>=Endbuf-22) goto loopback;
			txty +=4;
			if(txty>=Endbuf-22) txty=Endbuf-22;
			if(txty<1) txty = 0;
			if(txty > Endbuf) txty=Endbuf;
			HtmlRefresh(txty);
			goto loopback;
		case 27: return(1);
		case 350: Screenshot792("Webvw8.bmp");
				PanelBeep();
				goto loopback;
		case 351: Screenshot1024("Webvw10.bmp");
				PanelBeep();
				goto loopback;
		default: goto loopback;
		}
	}while(1);
}
int LcHtml(char *filespec)
{
	int temp;

	null=0;
	rectfill(screen,0,0,800,600, BLACK);
	PopsicleSticks(LILAC);
	Title("WEB VIEW");
	rectfill(screen,0,550,800,600, BLACK);
	OfflineType4(-5,550, BIGBLUE, "BACK");
	EscSymbol(130, 551, 2, NAPLES);
	rectfill(screen,312,550,437,587,LILAC);
	PutsLuna(317,569, BLACK,LILAC, "PGUP/PGDN/HOME/END");
	OfflineType5(445,550, LILAC, "POINT/SCROLL");
	ButtonType2(593, 550, BLACK, LILAC, "SELECT");
	EnterSymbol(711, 550, 2, NAPLES);
	UpArrowSymbol(563, 550, NAPLES);
	DownArrowSymbol(586, 550, NAPLES);
	LeftArrowSymbol(563,569,NAPLES);
	RightArrowSymbol(586,569,NAPLES);
	PutsFont21(213,558,ORANGE,"OFFLINE");
	rectfill(screen,13,50,787,540, BLACK);  /* ?? */

	strcpy(UrlStr,filespec);

	workbuf = create_bitmap(774,4810);

/*	LoadBackImage(); */ /* Don't. Something wrong.*/
	NoBackImage=TRUE;

	HtmDefaultColors();
	HtmlNumLines=24;
	BaseLeftMargin=10;
	DisplayHtmlTags = FALSE;
	ColorStyle=0;
	SetDefault();

	strcpy(CurrentFile, filespec);

	if(LoadHtmlFile() == 1) {
		temp=BackgroundColor;
		strcpy(UrlStr,"--");
		strcat(UrlStr,TitleBuf);
		PutsLuna(158,20,BLACK,LILAC, UrlStr);
		BackgroundColor=temp; /* Luna above resets it. */
		HtmlControl(0);
	} else {
		NormalLoadError(filespec);
	}

	destroy_bitmap(workbuf);
/*	if (backimage) destroy_bitmap(backimage); */ /* See above. */
	LcarsColors();
	TimeColor=NAPLES;
	BracketColor1=ORANGE;
	BracketColor2=PALEBLUE;
	return(0);
}
int OpenHtml(char *filespec)
{  /* saves the screen then restores it when LcHtml closes */
	BITMAP *bmp = create_bitmap(800,600);
	clear_to_color(bmp,BLACK);
	blit(screen, bmp, 0, 0, 0, 0, 800, 600);
	LcHtml(filespec);
	rectfill(screen,0,0,800,600, BLACK);
	blit(bmp, screen, 0, 0, 0, 0, 800, 600);
	destroy_bitmap(bmp);
	return(0);
}


