/* GrSet.c, to set Allegro graphics for LCARS */
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#include "lcars24.h"
#include "grset.h"

int Find1024Driver()
{
	set_color_depth(32);
	if (set_gfx_mode(GFX_AUTODETECT, 1024, 768, 0, 0) == 0) return(32);
	set_color_depth(24);
	if (set_gfx_mode(GFX_AUTODETECT, 1024, 768, 0, 0) == 0) return(24);
	set_color_depth(16);
	if (set_gfx_mode(GFX_AUTODETECT, 1024, 768, 0, 0) == 0) return(16);
	set_color_depth(15);
	if (set_gfx_mode(GFX_AUTODETECT, 1024, 768, 0, 0) == 0) return(15);
	set_color_depth(8);
	if (set_gfx_mode(GFX_AUTODETECT, 1024, 768, 0, 0) == 0) return(8);
	exit(0);
}
int Find800Driver()
{
	set_color_depth(32);
	if (set_gfx_mode(GFX_AUTODETECT, 800, 600, 0, 0) == 0) return(32);
	set_color_depth(24);
	if (set_gfx_mode(GFX_AUTODETECT, 800, 600, 0, 0) == 0) return(24);
	set_color_depth(16);
	if (set_gfx_mode(GFX_AUTODETECT, 800, 600, 0, 0) == 0) return(16);
	set_color_depth(15);
	if (set_gfx_mode(GFX_AUTODETECT, 800, 600, 0, 0) == 0) return(15);
	set_color_depth(8);
	if (set_gfx_mode(GFX_AUTODETECT, 800, 600, 0, 0) == 0) return(8);
	exit(0);
}
void GrSet()
{
	PALETTE pal;

	if(ScreenSize==1024) DepthFound=Find1024Driver();
	else DepthFound=Find800Driver();
	if( DepthFound==8) {
		generate_332_palette(pal);
		set_palette(pal);
	}
	acquire_screen();
	clear_to_color(screen, makecol(0, 0, 0));
}
/* eof */

