/* Updated 01/29/05 9:35 P.M. */
/* Top Header for FILES 24, a graphical file manager for LCARS 24 */
/* Includes various files viewers and music players 			*/
/* Requires various support programs, font files, and MIDI patch files 	*/
/* Handles only the LCARS 24 folder tree plus files directly on
	drives A and C 							*/
/* Added lyr files to display lyrics while playing a midi 		*/
/* Deletion of folders implemented for Empty Recycle 			*/
/* Checking clipboard upon deletion/Empty Recycle implemented 		*/
/* Delete from floppy no longer sending to Recycle 			*/
/* Fixed name cursor 							*/
/* Deletion of empty folder fixed 					*/
/* Individual folder deletion from Recycle fixed 			*/
/* Prohibition of deletion of folder w/ name matching jailed one fixed 	*/
/* Fixed Windows filename-case trouble, F24W2Paste cursor bug 7/21/03 	*/
/* Fixed F24W3 cursor bug when scrolling up from left of folders 	*/
/* UpdateAll() implemented for paste, delete 				*/
/* Last of the known bugs fixed 7/22/03, ready for first release 	*/
/* Modified for FreeDOS32 (solved findfirst problem), jpeg loading added */

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "files24.h"


void LoadLyricsFile(char *filespec)
{ /* called by DisplayLyrics(char *filespec), below */
	long z;
	int i;
	unsigned short t;
	PACKFILE *Fp;

	for(z=0; z <= 29; ++z) {
		memset(LongLine[z],(null),120);
	}
	Fp=pack_fopen(filespec, "r");
	z=0;
	i=0;
	t=32;
	do {
		if(pack_feof(Fp)) break;
		t=pack_getc(Fp);
			if(t==13) {
			 ++z;
			 i=0;
		}  else {
			if(i > 99) {	/* was 79 */
				++z;
				i=0;
			}
			LongLine[z][i]=(t);
			if (t> 31 || t==9) ++i;
			if(t < 32 && t !=9) LongLine[z][i]=(null);
		}
	}  while(1);
	t=26;
	EndText=z-1;
	memset(LongLine[z],(t),8);
	pack_fclose(Fp);
}
int DisplayLyrics(char *LyricsFilespec, char *MidiFilespec)
{
	int gy, i, z, Result;
	int txty=0;
	BITMAP *bmp=create_bitmap(800,600);

/*	if(DosDetected==FALSE) return(86);  */

	clear_bitmap(bmp);
	blit(screen, bmp, 0, 0, 0, 0, 800, 600);
	int MaxX_holder=MaxX;
	int MaxY_holder=MaxY;
	MaxX=799;
	MaxY=599;
	rectfill(screen,0,0,800,600, BLACK);
	PopsicleSticks(LILAC);
	Title("SONG LYRICS");
	PutsLuna(180,20, BLACK,LILAC, MakeDisplayName(LyricsFilespec));
	PutsLuna(600,566, BLACK,LILAC, "CLOSE: ESC");
	PutsLuna(135,566, BLACK,LILAC, "PLAYING");
	PutsLuna(180,566, BLACK,LILAC, MakeDisplayName(MidiFilespec));

	LoadLyricsFile(LyricsFilespec);
	gy=52;
	for( z=0; z < 26; ++z) {
		rectfill(screen,1,gy,799,gy+19,BLACK);
		if(LongLine[txty+z][0]==33) {
			for(i=0; i< strlen(LongLine[txty+z]); ++i)
				Highlight[i]=LongLine[txty+z][i+1];
			PutsFont14(38,gy,MANGO,BLACK,Highlight);
		}
		if(LongLine[txty+z][0]==35) {
			for(i=0; i< strlen(LongLine[txty+z]); ++i)
				Highlight[i]=LongLine[txty+z][i+1];
			PutsFont14(38,gy,PALEBLUE,BLACK,Highlight);
		}
		if(LongLine[txty+z][0] >= 36)
			PutsFont14(38,gy,PURPLE,BLACK,LongLine[txty+z]);
		gy += 19;
	}

	if(__file_exists(MidiFilespec)) {
Result=spawnl(P_WAIT,"C:\\LCARS24\\SYSTEM\\MIDI24\\MIDI24.EXE","C:\\LCARS24\\SYSTEM\\MIDI24\\MIDI24.EXE",MidiFilespec, NULL);
	remove_timer();
	} else {
loopback:
		do {
			c=GetKey();
			switch(c)
			{
				case ESC: goto out;
				default: goto loopback;
			}
		}while(1);
	}
out:
	blit(bmp, screen, 0, 0, 0, 0, 800, 600);
	destroy_bitmap(bmp);
	MaxX=MaxX_holder;
	MaxY=MaxY_holder;
	return(1);
}
int F24PlayMidi(char *Song)
{
	int Result;
	int x=284;
	int y=360;

	F24EraseLowerMessageBoxes();
	PutsLuna(x+18,y+20, LILAC, BLACK, get_filename(Song));
	ButtonType3(x, y+44, LILAC, LILAC, "STOP");
	EscSymbol(x+117,y+44,2, ORANGE);
/*	LcarsPlayMidi(Song); */

Result=spawnl(P_WAIT,"C:\\LCARS24\\SYSTEM\\MIDI24\\MIDI24.EXE","C:\\LCARS24\\SYSTEM\\MIDI24\\MIDI24.EXE",Song, NULL);
	remove_timer();
	rectfill(screen,x,y+20,x+220,y+136,BLACK);
	F24LowerMessageBoxes();
/*	install_timer(); */
	return(Result);
}
int DoMidi(char *Song)
{
	int Result;
	char LyricsFilespec[100];

	strcpy(LyricsFilespec, "C:\\LCARS24\\ALARM\\LYRICS\\X");

	if(stricmp(Song, "C:\\LCARS24\\ALARM\\MYDIR.MID")==0)
		strcpy(LyricsFilespec, "C:\\LCARS24\\ALARM\\LYRICS\\MYDIR.LYR");

	if(stricmp(Song, "C:\\LCARS24\\ALARM\\EARTH.MID")==0)
		strcpy(LyricsFilespec, "C:\\LCARS24\\ALARM\\LYRICS\\EARTH.LYR");

	if(stricmp(Song, "C:\\LCARS24\\ALARM\\SOFINE.MID")==0)
		strcpy(LyricsFilespec, "C:\\LCARS24\\ALARM\\LYRICS\\SOFINE.LYR");

	if(stricmp(Song, "C:\\LCARS24\\ALARM\\BELIEVE.MID")==0)
		strcpy(LyricsFilespec, "C:\\LCARS24\\ALARM\\LYRICS\\BELIEVE.LYR");

	if(stricmp(Song, "C:\\LCARS24\\ALARM\\POWER.MID")==0)
		strcpy(LyricsFilespec, "C:\\LCARS24\\ALARM\\LYRICS\\POWER.LYR");

	if(stricmp(Song, "C:\\LCARS24\\ALARM\\APPLE.MID")==0)
		strcpy(LyricsFilespec, "C:\\LCARS24\\ALARM\\LYRICS\\APPLE.LYR");

	if(stricmp(Song, "C:\\LCARS24\\ALARM\\WOLF.MID")==0)
		strcpy(LyricsFilespec, "C:\\LCARS24\\ALARM\\LYRICS\\WOLF.LYR");

	if(stricmp(Song, "C:\\LCARS24\\ALARM\\FLY.MID")==0)
		strcpy(LyricsFilespec, "C:\\LCARS24\\ALARM\\LYRICS\\FLY.LYR");

	if(stricmp(Song, "C:\\LCARS24\\ALARM\\MINDSNAP.MID")==0)
		strcpy(LyricsFilespec, "C:\\LCARS24\\ALARM\\LYRICS\\MINDSNAP.LYR");

	if(stricmp(Song, "C:\\LCARS24\\ALARM\\WIND.MID")==0)
		strcpy(LyricsFilespec, "C:\\LCARS24\\ALARM\\LYRICS\\WIND.LYR");

	if(__file_exists(LyricsFilespec)) {
		Result=DisplayLyrics(LyricsFilespec, Song);
	} else F24PlayMidi(Song);
	return(Result);
}
int F24MpxPlay(char *Song)
{
	int Result;
	int x=284;
	int y=360;

/*	if(DosDetected==FALSE) return(86); */

	F24EraseLowerMessageBoxes();
	PutsLuna(x+18,y+20, LILAC, BLACK, get_filename(Song));
	ButtonType3(x, y+44, LILAC, LILAC, "STOP");
	EscSymbol(x+117,y+44,2, ORANGE);
Result=spawnl(P_WAIT, "C:\\LCARS24\\MP3\\MPXPLAY.EXE", "C:\\LCARS24\\MP3\\MPXPLAY.EXE","-f0", "-sl 0","-sv 200",Song, NULL);
	rectfill(screen,x,y+20,x+220,y+136,BLACK);
	F24LowerMessageBoxes();
	return(Result);
}
int F24PlayWav(char *Song)
{
	int Result;
	int x=284;
	int y=360;

	F24EraseLowerMessageBoxes();
	PutsLuna(x+18,y+20, LILAC, BLACK, get_filename(Song));
	ButtonType3(x, y+44, LILAC, LILAC, "STOP");
	EscSymbol(x+117,y+44,2, ORANGE);
	LcarsPlayWav(Song);
	rectfill(screen,x,y+20,x+220,y+136,BLACK);
	F24LowerMessageBoxes();
	return(Result);
}

void F24Bumpers()
{
	RightBumper26(303,13,LILAC);
	RightBumper26(303,MidY-26,LILAC);
	RightBumper26(303,562,LILAC);
	LeftBumper26(476,13,LILAC);
	LeftBumper26(476,MidY-26,LILAC);
	LeftBumper26(476,562,LILAC);
}
void F24NeElbow()
{
	NortheastElbow(315,MinY,LILAC);
}
void F24SeElbow()
{
	SoutheastElbow(315,MaxY,LILAC);
}
void F24NwElbow()
{
	NorthwestElbow(465,MinY,LILAC);
}
void F24SwElbow()
{
	SouthwestElbow(465,MaxY,LILAC);
}
void F24EraseUpperElbows()
{
	rectfill(screen,303,12,476,MidY+1,BLACK);
}
void F24EraseLowerElbows()
{
	rectfill(screen,303,MidY-27,476,588,BLACK);
}
void UpperSwitchBox()
{
	F24EraseUpperElbows();
	F24EraseLowerSwitchBox();
	F24Bumpers();
	LeftArrowSymbol(361-2, 184, NAPLES);
	RightArrowSymbol(410-2, 184, NAPLES);
	DownArrowSymbol(386-2, 202, NAPLES);
}
void LowerSwitchBox()
{
	F24EraseUpperSwitchBox();
	F24EraseLowerElbows();
	F24Bumpers();
	LeftArrowSymbol(361-2, 600-184, NAPLES);
	RightArrowSymbol(410-2, 600-184, NAPLES);
	UpArrowSymbol(386-2, 600-202, NAPLES);
	rectfill(screen,12,588-26,297,588,LILAC);
}
void F24EraseUpperSwitchBox()
{
	rectfill(screen,340,100,440,MidY-68,BLACK);
}
void F24EraseLowerSwitchBox()
{
	rectfill(screen,340,MidY+40,440,500,BLACK);
}
void F24Reinit(char ActiveWindow)
{
	OldF1y=1;
	OldF3y=1;
	F24W1Offset=0;
	F24W3Offset=0;
	F24Circus(ActiveWindow);
}
int F24FileView(char *filespec)
{
	int Result;

	if( strnicmp( "BMP", get_extension(filespec),3 )==0 ) {
		Result=Viewscreen(filespec);
		return(Result);
	}
	if( strnicmp( "JPG", get_extension(filespec),3 )==0 ) {
		Result=Viewscreen(filespec);
		return(Result);
	}
	if( strnicmp( "GIF", get_extension(filespec),3 )==0 ) {
		Result=Viewscreen(filespec);
		return(Result);
	}
	if( strnicmp( "TXT", get_extension(filespec),3 )==0 ) {
		Result=OpenTxt(filespec);
		return(Result);
	}
	if( strnicmp( "BAT", get_extension(filespec),3 )==0 ) {
		Result=OpenProgEdit(filespec);
		return(Result);
	}
	if( strnicmp( "MID", get_extension(filespec),3 )==0 ) {
		Result=DoMidi(filespec);
		return(Result);
	}
	if( strnicmp( "WAV", get_extension(filespec),3 )==0 ) {
		Result=F24PlayWav(filespec);
		return(Result);
	}
	if( strnicmp( "MP3", get_extension(filespec),3 )==0 ) {
		Result=F24MpxPlay(filespec);
		return(Result);
	}
	if( strnicmp( "OGG", get_extension(filespec),3 )==0 ) {
		Result=F24MpxPlay(filespec);
		return(Result);
	}
	if( strnicmp("SFM", get_extension(filespec),3 )==0 ) {
		Result=OpenSfml(filespec);
		return(Result);
	}
	if( strnicmp("MSD", get_extension(filespec),3 )==0 ) {
		Result=OpenSfml(filespec);
		return(Result);
	}
	if( strnicmp( "HTM", get_extension(filespec),3 )==0 ) {
		OpenHtml(filespec);
		return(Result);
	}
	if( strnicmp( "LYR", get_extension(filespec),3 )==0 ) {
		DisplayLyrics(filespec, "nothing");
		return(Result);
	}
	if( strnicmp( "CFG", get_extension(filespec),3 )==0 ) {
		Result=OpenProgEdit(filespec);
		return(Result);
	}
	if( strnicmp( "CPP", get_extension(filespec),3 )==0 ) {
		Result=OpenProgEdit(filespec);
		return(Result);
	}
	if( strnicmp( "PAS", get_extension(filespec),3 )==0 ) {
		Result=OpenProgEdit(filespec);
		return(Result);
	}
	if( stricmp("C", get_extension(filespec))==0) {
		Result=OpenProgEdit(filespec);
		return(Result);
	}
	if( stricmp("H", get_extension(filespec))==0) {
		Result=OpenProgEdit(filespec);
		return(Result);
	}
	if( stricmp("CONFIG.SYS", get_filename(filespec))==0) {
		Result=OpenProgEdit(filespec);
		return(Result);
	}
	if( strnicmp( "KK8", get_extension(filespec),3 )==0 ) {
		Result=OpenProgEdit(filespec);
		return(Result);
	}
	if( strnicmp( "SDK", get_extension(filespec),3 )==0 ) {
		Result=OpenProgEdit(filespec);
		return(Result);
	}
	if( strnicmp( "XWD", get_extension(filespec),3 )==0 ) {
		Result=OpenProgEdit(filespec);
		return(Result);
	}
	return(1);
}
int F24Help()
{
	int Result;

	Result=OpenTxt("C:\\LCARS24\\LC24APPS\\FILES24\\FILES24.TXT");
	return(Result);
}
void F24GetNameCursor()
{
	int q,z;

	cx=F24InputPos;
	for( z=0; z<dx-1; ++z) {
		q=KeyInStr[z];
		cx=cx+ Font19[q] -65;
	}
	cy=F24InputY+33;
	xor_mode(TRUE);
	rectfill(screen,cx,cy-10,cx+8,cy-8,WHITE);
	xor_mode(FALSE);
}
void F24GetNameDisplayInputString()
{
	rectfill(screen,F24InputPos, F24InputY, 480, F24InputY+23, BLACK);
	PutsFont19(F24InputPos,F24InputY,ORANGE,KeyInStr);
}
void F24GetNameCursorLeft()
{
	if( dx==1) return;
	--dx;
}
void F24GetNameCursorRight()
{
	k=strlen( KeyInStr);
	if( dx > k) return;
	++dx;
}
void F24GetNameDel()
{
	int z;

	k=strlen(KeyInStr);
	if(dx > k) return;
	for(z=dx-1; z < k; ++z) KeyInStr[z]=KeyInStr[z+1];
	F24GetNameDisplayInputString();
}
void F24GetNameBS()
{
	int z;

	if( dx <= 1) return;
	F24GetNameCursorLeft();
	k= strlen( KeyInStr);
	for( z=dx-1; z < k; ++z) KeyInStr[z]=KeyInStr[z+1];
	F24GetNameDisplayInputString();
}
void F24GetNameDisplayChar()
{
	int q,z;

	if( c < 32) return;
	c=toupper(c);
	q=StrLenFont19(KeyInStr);
	if(q > 400) return;
	k= strlen( KeyInStr);
	if(dx < k &&  q > 380) return;
	if(dx < k) for(z=k; z >= dx; --z) KeyInStr[z]=KeyInStr[z-1];
	if(!(dx-1 > k)) KeyInStr[dx-1]=( c);
	F24GetNameDisplayInputString();
	F24GetNameCursorRight();
}
int F24GetKeyboardInput()
{
	dx=(strlen(KeyInStr)+1);
loopback:
	F24GetNameCursor();
	do {
		c=GetKey();
		F24GetNameCursor();
		switch( c)
		{
			case ESC: 	return(27);
			case 13: 	if(strlen(KeyInStr)==0) goto loopback;
					strcpy(NewName,KeyInStr);
					return(13);
			case BS:	F24GetNameBS();
					goto loopback;
			case DELKEY:	F24GetNameDel();
					goto loopback;
			case LEFTARROW: F24GetNameCursorLeft();
					goto loopback;
			case RIGHTARROW: if(KeyInStr[dx-1]=='.') goto loopback;
					F24GetNameCursorRight();
					goto loopback;
			default:  	if( is_filechar(c)) {
						 c=toupper(c);
						F24GetNameDisplayChar();
					} else {
						if(c=='\\') F24GetNameDisplayChar();
					}
					goto loopback;
		}
	} while(1);
}
void F24SelectFolder(int x, int y, char *Label, int Hue)
{
	char TruncateStr[80]; /* to prevent Windows from displaying
				 a long folder name */
	strcpy(TruncateStr, Label);
	TruncateStr[9]=(null);
	strcpy(Label,TruncateStr);
	rectfill(screen,x,y,x+80,y+30,Hue);
	rectfill(screen,x+117,y,x+125,y+30,Hue);
	PutsLuna(x+94-StrLenLuna(Label)-16,y+14,BLACK,Hue,Label);
}
void F24DrawFolder(int x,int y, char *Label, char Status)
{
	char TruncateStr[80]; /* to prevent Windows from displaying
				 a long folder name */

	strcpy(TruncateStr, Label);
	TruncateStr[9]=(null);
	strcpy(Label,TruncateStr);

	rectfill(screen,x,y,x+80,y+30,ORANGE);
	PutsLuna(x+94-StrLenLuna(Label)-16,y+14,BLACK,ORANGE,Label);
	if(strcmp(Content,"0")==0)
		PutsScorpio(x+115-(strlen(Content)*10), y+2, BRICK,Content);
	else PutsScorpio(x+115-(strlen(Content)*10), y+2, PALEBLUE,Content);
	rectfill(screen,x+117,y,x+125,y+30,ORANGE);
	if( Status >= 1) rectfill(screen,x-34+6,y+20,x-34+10+2,y+22,ORANGE);
	if( Status==2) rectfill(screen,x-34+6+2,y+16,x-34+8+2,y+26,ORANGE);
}
void F24SortFiles()
{
	char bag[80];
	int f;
	int r=0;
	char done,ch;
	int z,i;

	for( z=0; z<NumOfFiles; ++z) {
		for( i=0; i<80; ++i) {
			ch=F24FileArray[z][i];
			if( ch !=(null)) ch=toupper(ch);
			F24FileArray[z][i]=ch;
		}
	}
	do {
		done=TRUE;
		for (f=0; f<NumOfFiles; ++f) {
			r=strcmp(F24FileArray[f],F24FileArray[f+1]);
			if( r > 0) {
				strcpy(bag,F24FileArray[f]);
				strcpy(F24FileArray[f],F24FileArray[f+1]);
				strcpy(F24FileArray[f+1],bag);
				done=FALSE;
			}
		}
	} while ( done==FALSE);
}
void F24FindFiles(char *mask)
{
	struct ffblk fblock;
	int Found;

	NumOfFiles=0;
	Found=findfirst(mask, &fblock, FA_ARCH);
	while ( !Found) {
		NumOfFiles++;
		strcpy(F24FileArray[NumOfFiles], fblock.ff_name);
		Found=findnext( &fblock);
	}
}
void F24SortFolders()
{
	char bag[80];
	int f;
	int r=0;
	char done;

	do {
		done=TRUE;
		for (f=0; f<=NumOfFolders-1; ++f) {
			r=stricmp(F24FolderArray[f],F24FolderArray[f+1]);
			if( r > 0)	 {
				strcpy(bag,F24FolderArray[f]);
				strcpy(F24FolderArray[f],F24FolderArray[f+1]);
				strcpy(F24FolderArray[f+1],bag);
				done=FALSE;
			}
		}
	} while ( done==FALSE);
	strcpy(F24FolderArray[1], "C:\\");
	strcpy(F24FolderArray[2], "LCARS24");
}
int F24FolderExists(char *mask)
{  /* returns 0 if the folder exists (specify full path name) */
	int Result;
	struct ffblk fblock;
	int Found;

	Found=findfirst(mask, &fblock, FA_DIREC);
	if( !Found) Result=0;
	else Result=1;
	return(Result);
}
void F24ShowFolders()
{
	struct ffblk fblock;
	int Found, z;
	char *path, *mask;

	path="C:\\LCARS24\\";
	mask="C:\\LCARS24\\*";
	NumOfFolders=0;
	Found=findfirst(mask, &fblock, FA_DIREC);
	while ( !Found) {
		if( fblock.ff_attrib != FA_ARCH) {
			NumOfFolders++;
			strcpy(F24FolderArray[NumOfFolders], fblock.ff_name);

		}
		Found=findnext( &fblock);
	}
/************************************** experimental */
strcpy(F24W1FullPath[0],"C:\\LCARS24");
strcpy(F24W3FullPath[0],"C:\\LCARS24");
/************************************** experimental */

	F24SortFolders();
	for(z=0;z<=NumOfFolders;++z) {
		strcpy(F24W1Folders[z],F24FolderArray[z]);
		strcpy(F24W3Folders[z],F24FolderArray[z]);

/************************************** experimental */
if(z>0 && z < NumOfFolders-1) {
	strcpy(F24W1FullPath[z], path);
	strcat(F24W1FullPath[z],F24FolderArray[z+2]); /* init left folder tree */
	strcpy(F24W3FullPath[z],F24W1FullPath[z]); /* init right folder tree */
}
/************************************** experimental */

	}
	F24W1EndList=NumOfFolders;
	F24W3EndList=NumOfFolders;

/* SaveReport(); */  /************************ experimental */
}
void F24InspectOneFolder(char *mask)
{
	struct ffblk fblock;
	int Found;

	NumOfFolders=0;
	Found=findfirst(mask, &fblock, FA_DIREC);
	while ( !Found) {
		if( fblock.ff_attrib != FA_ARCH) {
			NumOfFolders++;
		}
		Found=findnext( &fblock);
	}
	strcat(mask,".*");
	NumOfFiles=0;
	Found=findfirst(mask, &fblock, FA_ARCH);
	while ( !Found) {
		NumOfFiles++;
		Found=findnext( &fblock);
	}
}
void F24W1SilentExpand(int treepos)
{  /* to help UpDateAll() restore unnesting for redisplay */
	struct ffblk fblock;
	char mask[100]="c:\\LCARS24\\";
	int Found, Count,Parent,NestingLevel, zz;

/*	NestingLevel=F24W1Info[treepos][2]; */
	strcat( mask, F24W1Folders[treepos]);
/*
		if(NestingLevel==2) {
			Parent=F24W1FindParent(2);
			strcat(mask,F24W1Folders[Parent]);
			strcat(mask,"\\");
		}
*/
	strcat( mask, "\\*");
	NumOfFolders=0;
	Found=findfirst(mask, &fblock, FA_DIREC);
	while ( !Found) {
		if( fblock.ff_attrib != FA_ARCH) {
			NumOfFolders++;
			strcpy(F24FolderArray[NumOfFolders], fblock.ff_name);
		}
		Found=findnext( &fblock);
	}
	F24SortFolders();
/*	Count=NumOfFolders-2; */
	Count=NumOfFolders-F24W1Info[treepos][2]-1;
	F24W1EndList+=Count;
	for(zz=F24W1EndList; zz>=treepos+1+Count; --zz) {
		strcpy(F24W1Folders[zz],F24W1Folders[zz-Count]);
		F24W1Info[zz][0]=F24W1Info[zz-Count][0];
	}
	for(zz=0; zz<Count; ++zz) {
		strcpy(F24W1Folders[treepos+1+zz],F24FolderArray[zz+3]);
	}
	for(zz=treepos+1;zz<treepos+1+Count;++zz) {
		strcpy( mask, "c:\\LCARS24\\");
/*
		NestingLevel=F24W1Info[zz][2];
		if(NestingLevel==2) {
			Parent=F24W1FindParent(2);
			strcat(mask,F24W1Folders[Parent]);
			strcat(mask,"\\");
		}
*/
		strcat( mask, F24W1Folders[treepos]);
		strcat( mask, "\\");
		strcat( mask, F24W1Folders[zz]);
		strcat( mask, "\\*");
		F24InspectOneFolder(mask);
		F24W1Info[zz][0]=NumOfFiles;
		F24W1Info[zz][2]=2;
		F24W1Info[zz][1]=0;
		if(NumOfFolders>F24W1Info[zz][2]) F24W1Info[zz][1]=2;
		F24W1Info[zz][2]=2;
		F24W1Info[zz][3]=0;

	}
}
void F24W3SilentExpand(int treepos)
{
	struct ffblk fblock;
	char mask[100]="c:\\LCARS24\\";
	int Found, Count, zz;

	strcat( mask, F24W3Folders[treepos]);
	strcat( mask, "\\*");
	NumOfFolders=0;
	Found=findfirst(mask, &fblock, FA_DIREC);
	while ( !Found) {
		if( fblock.ff_attrib != FA_ARCH) {
			NumOfFolders++;
			strcpy(F24FolderArray[NumOfFolders], fblock.ff_name);
		}
		Found=findnext( &fblock);
	}
	F24SortFolders();
	Count=NumOfFolders-F24W3Info[treepos][2]-1;
	F24W3EndList+=Count;
	for(zz=F24W3EndList; zz>=treepos+1+Count; --zz) {
		strcpy(F24W3Folders[zz],F24W3Folders[zz-Count]);
		F24W3Info[zz][0]=F24W3Info[zz-Count][0];
	}
	for(zz=0; zz<Count; ++zz) {
		strcpy(F24W3Folders[treepos+1+zz],F24FolderArray[zz+3]);
	}
	for(zz=treepos+1;zz<treepos+1+Count;++zz) {
		strcpy( mask, "c:\\LCARS24\\");
		strcat( mask, F24W3Folders[treepos]);
		strcat( mask, "\\");
		strcat( mask, F24W3Folders[zz]);
		strcat( mask, "\\*");
		F24InspectOneFolder(mask);
		F24W3Info[zz][0]=NumOfFiles;
		F24W3Info[zz][2]=2;
		F24W3Info[zz][1]=0;
		if(NumOfFolders>F24W3Info[zz][2]) F24W3Info[zz][1]=2;
		F24W3Info[zz][2]=2;
		F24W3Info[zz][3]=0;

	}
}
void F24UpdateAll()
{ /* updates both folder trees and content of their highlighted folders,
even for the opposite window, whether open or visible there or not, for use
after copying or deleting files, not after renaming, making or deleting a
folder */

	char mask[100]="c:\\LCARS24\\*.*";
	int i,z,k;

	if(strcmp(F24W4PastePath, "A:\\")==0) F24DriveA();
	F24FindFiles("C:\\*.*");
	itoa(NumOfFiles,Content,10);
	rectfill(screen,598,88, 628, 118,BLACK);
	F24DrawFolder(514,72+16,"DRIVE C", 0);

	if(strcmp(F24W4PastePath, "C:")==0) F24SelectFolder(514,72+16,"DRIVE C",NAPLES);

	for(z=0;z<=F24W2EndList;++z) memset(F24W2List[z],(null),80);
	F24FindFiles(F24W1ListTitle);
	F24SortFiles();
	for(z=0;z<=NumOfFiles;++z) strcpy(F24W2List[z], F24FileArray[z]);
	F24W2EndList=NumOfFiles;
	F24W1Info[F24W1CurrentPathElement+2][0]=NumOfFiles;

	k=strlen(F24W1FullPath[F24W1CurrentPathElement+2]);
	z=0;
	do { /* reflect W1 info to W3 */
		if(memicmp(F24W1FullPath[F24W1CurrentPathElement+2],F24W3FullPath[z],k)==0) {
			F24W3Info[z][0]=F24W1Info[F24W1CurrentPathElement+2][0];
			break;
		}
		z++;
	} while(z < F24W3EndList);

	for(z=0;z<=F24W4EndList;++z) memset(F24W4List[z],(null),80);
	F24FindFiles(F24W3ListTitle);
	F24SortFiles();
	for(z=0;z<=NumOfFiles;++z) strcpy(F24W4List[z], F24FileArray[z]);
	F24W4EndList=NumOfFiles;
	F24W3Info[F24W3CurrentPathElement+2][0]=NumOfFiles;

	k=strlen(F24W3FullPath[F24W3CurrentPathElement+2]);
	z=0;
	do { /* reflect W3 info to W1 */
		if(memicmp(F24W3FullPath[F24W3CurrentPathElement+2],F24W1FullPath[z],k)==0) {
			F24W1Info[z][0]=F24W3Info[F24W3CurrentPathElement+2][0];
			break;
		}
		z++;
	} while(z < F24W1EndList);

	F24W1Refresh();
	F24W3Refresh();
	F24W2Refresh();
	F24W4Refresh();
}
int SaveReport() /* for testing of nesting functions */
{
	long z;
	int i;
	unsigned short cr=13;
	unsigned short lf=10;
	unsigned short t;
	PACKFILE *Fp;

	Fp = pack_fopen("c:\\lcars24\\data\\a-list.txt", "w");
	z=0;
	i=0;
	t=32;
	do {
		if( z > F24W1EndList) break;
		t = F24W1FullPath[z][i];
		if(  t == (null) ) {
			pack_putc( (cr), Fp);
			pack_putc( (lf), Fp);
			++z;
			i=0;
		} else {
			pack_putc( (t), Fp);
			++i;
		}
	}  while(1);
	z=0;
	i=0;
	t=32;
	do {
		if( z > F24W3EndList) break;
		t = F24W3FullPath[z][i];
		if(  t == (null) ) {
			pack_putc( (cr), Fp);
			pack_putc( (lf), Fp);
			++z;
			i=0;
		} else {
			pack_putc( (t), Fp);
			++i;
		}
	}  while(1);
	pack_fclose( Fp );
	return(0);
}
void F24RecursiveFolderRename(char *old, char *new)
{  /* fixes the names of all affected paths after renaming a folder,
		on both folder trees, without disturbing anything else */
	int z,i,k,k2;
	char RightStr[80];

	k=strlen(old);
	z=0;
	do {
		if(memicmp(old, F24W1FullPath[z],k)==0) {
			if(stricmp(old, F24W1FullPath[z]) !=0) {
				k2=strlen(F24W1FullPath[z]);
				memset(RightStr,(null),80);
				for(i=0; i<k2-k-1; i++) RightStr[i]=F24W1FullPath[z][k+i];
				strcpy(F24W1FullPath[z],new);
				strcat(F24W1FullPath[z],RightStr);
			}
		}
		z++;
	} while(z < F24W1EndList);

	z=0;
	do {
		if(memicmp(old, F24W3FullPath[z],k)==0) {
			if(stricmp(old, F24W3FullPath[z]) !=0) {
				k2=strlen(F24W3FullPath[z]);
				memset(RightStr,(null),80);
				for(i=0; i<k2-k-1; i++) RightStr[i]=F24W3FullPath[z][k+i];
				strcpy(F24W3FullPath[z],new);
				strcat(F24W3FullPath[z],RightStr);
			}
		}
		z++;
	} while(z < F24W3EndList);
/*
rectfill(screen,43,588-26,297,588,LILAC);
PutsLuna(43,569, BLACK,LILAC, old);
rectfill(screen,482,588-26,788,588,LILAC);
PutsLuna(516,569, BLACK,LILAC, new);
*/
/* SaveReport(); */
}
int F24Dialog(int x, int y, char *Str, char *Str2)
{
	PutsLuna(x,y+20, LILAC, BLACK, Str);
	ButtonType2(x, y+44, ORANGE, MANGO, Str2);
	EnterSymbol(x+118, y+58-14, 2, NAPLES);
	ButtonType3(x, y+44+47, LILAC, LILAC, "CANCEL");
	EscSymbol(x+117,y+44+47,2, ORANGE);
loopback:
	do {
		c=GetKey();
		switch( c)
		{
			case ESC: rectfill(screen,x,y+20,x+200,y+136,BLACK);
					return(27);
			case 13:  rectfill(screen,x,y+20,x+200,y+136,BLACK);
					return(1);
			default: goto loopback;
		}
	} while(1);
}
void F24CopyError(int errnum)
{
	F24EraseLowerMessageBoxes();
	if(errnum==1) F24Dialog(284,360, "CANNOT READ SOURCE","CANCEL");
	if(errnum==2) F24Dialog(284,360, "DISK ERROR","CANCEL");
	if(errnum==3) F24Dialog(284,360, "WRITE ERROR","CANCEL");
	rectfill(screen,284,388,400,416,BLACK);
	F24LowerMessageBoxes();
}
void F24DeleteOneFolder(char *folderspec)
{ 		/* Calling function must deal with recycle status. */
	char filespec[100];
	char ComStr[100];
	char mask[100];
	int z;

	strcpy(mask,folderspec);
	strcat(mask,"\\*.*");
	F24FindFiles(mask);
	for(z=1; z<=NumOfFiles; ++z) {
		strcpy(filespec,folderspec);
		strcat(filespec,"\\");
		strcat(filespec,F24FileArray[z]);
		remove(filespec);
	}
	rmdir(folderspec);
}
void F24DeleteAllFoldersFromRecycleBin()
{
	int i;
	char PaddyWagon[100]="C:\\LCARS24\\RECYCLE\\";
	struct ffblk fblock;
	int Found;
	char *mask;

	mask="c:\\LCARS24\\RECYCLE\\*";
	NumOfFolders=0;
	Found=findfirst(mask, &fblock, FA_DIREC);
	while ( !Found) {
		if( fblock.ff_attrib != FA_ARCH) {
			NumOfFolders++;
			strcpy(F24FolderArray[NumOfFolders], fblock.ff_name);
		}
		Found=findnext( &fblock);
	}
	if(NumOfFolders <3) return; /* 1 dot, 2 dots in DOS */
	for( i=3; i<=NumOfFolders; ++i) {
		memset(PaddyWagon,(null),99);
		strcpy(PaddyWagon, "C:\\LCARS24\\RECYCLE\\");
		strcat(PaddyWagon, F24FolderArray[i]);
		F24DeleteOneFolder(PaddyWagon);
	}
}

int F24Box(int Hue,int Pos,char *Label1,char *Label2,char *Label3,char *Label4)
{
	int boxtop, alignment;

	MaxX=440;

	if(Pos < 5) alignment=10; /* to adjust gap from elbow */
	if(Pos >= 5) alignment=-20; /* was 19 */
	boxtop=alignment+(56*Pos);
	rectfill(screen,MaxX-100,boxtop,MaxX,boxtop+(52),Hue); /* 48 ==> 51 */
	PutsLuna(MaxX-96,boxtop+4, BLACK, Hue,Label1);
	PutsLuna(MaxX-2-StrLenLuna(Label2),boxtop+4,BLACK,Hue,Label2);
	PutsLuna(MaxX-96,boxtop+35, BLACK,Hue, Label3);
	PutsLuna(MaxX-2-StrLenLuna(Label4),boxtop+35,BLACK,Hue,Label4);
}
int F24SmallBox(int Hue,int Pos,char *Label1,char *Label2)
{
	int boxtop, alignment;

	MaxX=440;
	boxtop=428+((Pos-8)*37);
	rectfill(screen,MaxX-100,boxtop,MaxX,boxtop+33,Hue); /* 48 ==> 51 */
	PutsLuna(MaxX-96,boxtop+16, BLACK, Hue,Label1);
	PutsLuna(MaxX-2-StrLenLuna(Label2),boxtop+16,BLACK,Hue,Label2);
}
int F24EraseLowerMessageBoxes()
{
	F24Box(BLACK, 7, "","","","");
	F24SmallBox(BLACK, 8, "","");
	F24SmallBox(BLACK, 9, "","");
	F24SmallBox(BLACK, 10, "","");
}
void F24UpperMessageBoxes()
{
	F24Box(MANGO, 1, "MAKE NEW","","FOLDER","F1");
	F24Box(BRICK, 2, "RENAME","F2","","");
	F24Box(PALEBLUE, 3, "RECHECK FLOPPY","","","F3");
}
void F24LowerMessageBoxes()
{
	if(strcmp(F24W4PastePath,"A:\\")==0) {
		if(F24W2Open==TRUE && F24W4Open==TRUE) {
			F24SmallBox(LAVENDER, 8, "COPY ALL", "F8");
			F24W2MoveOK=FALSE;
			goto copypaste;
		}
	}
	if(strcmp(F24W2PastePath,F24W4PastePath)==0) {
		if(F24W2Open==TRUE && F24W4Open==TRUE) {
			F24Box(MANGO, 7, "SAME FOLDER","","LEFT & RIGHT","");
			F24W2MoveOK=FALSE;
			goto copypaste;
		}
	}
	if(ActiveWindow==2) {
		if(F24W2Open==TRUE && F24W4Open==TRUE && stricmp(F24W4Path,F24W2Path) !=0) {
			F24Box(PALEBLUE, 7, "MOVE FILE","","TO RIGHT","F6");
			F24SmallBox(LAVENDER, 8, "COPY ALL", "F8");
/*			F24Box(LAVENDER, 8, "MOVE ALL", "F7", "COPY ALL", "F8"); */
			F24W2MoveOK=TRUE;
		}
	}
	if(ActiveWindow==4) {
		if(F24W2Open==TRUE && F24W4Open==TRUE && stricmp(F24W4Path,F24W2Path) !=0) {
			F24Box(PALEBLUE, 7, "MOVE FILE","","TO LEFT","F6");
			F24SmallBox(LAVENDER, 8, "COPY ALL", "F8");
/*			F24Box(LAVENDER, 8, "MOVE ALL", "F7", "COPY ALL", "F8"); */
			F24W4MoveOK=TRUE;
		}
	}
copypaste:
	if(F24W2Open==TRUE && F24W4Open==TRUE)
		F24SmallBox(PURPLE, 9, "COPY","F9");
		F24SmallBox(MANGO, 10, "PASTE","F10");
}

