/* CHESS24, the chess app for LCARS 24B */
/* Powered by Faile, a chess engine */
/* Copyright (c) 2000 Adrien M. Regimbald */
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#ifndef CHESS24_H
#define CHESS24_H


#include "lcars24.h"
#include "parts.h"
#include "getkey.h"
#include "headline.h"
#include "scrnshot.h"
#include "faile.h"
#include "protos.h"
#include "extvars.h"
#include "rand.h"
#include "book.h"

/* faile stuff */
/*
char divider[50]="-------------------------------------------------";
*/
/*
move_s dummy={0,0,0,0,0,0,0};
*/
int board[144], moved[144], ep_square, white_to_move, wking_loc,
  bking_loc, white_castled, black_castled, result, ply, pv_length[PV_BUFF],
  history_h[144][144], pieces[33], squares[144], num_pieces, i_depth, fifty,
  fifty_move[PV_BUFF], game_ply;

long int nodes, raw_nodes, qnodes, piece_count, killer_scores[PV_BUFF],
  killer_scores2[PV_BUFF], moves_to_tc, min_per_game, inc, time_left,
  opp_time, time_cushion, time_for_move, cur_score, start_piece_count,
  last_root_score;

bool xb_mode, captures, searching_pv, post, time_exit, time_failure,
  allow_more_time, bad_root_score;

move_s pv[PV_BUFF][PV_BUFF], killer1[PV_BUFF], killer2[PV_BUFF],
 killer3[PV_BUFF], dummy;

rtime_t start_time;

d_long h_values[14][144], ep_h_values[144], wck_h_values[2], wcq_h_values[2],
  bck_h_values[2], bcq_h_values[2], color_h_values[2], cur_pos,
  rep_history[PV_BUFF];

hash_s *hash_table;

unsigned long int hash_mask, hash_max_mb;



/* LCARS stuff */
unsigned char ChessFont[2304];	/* a 16x48 font for chess pieces */
int BoardX;					/* where to place the board */
int BoardY;
char GameOver;
char CursorParked;			/* cursor off the board, to the right */
char ParkedY;
int BackHue;				/* light or dark square, for erasing */
int Light, Dark;
int chx,chy;				/* board coordinates */
int BoardContent[8][8];		/* separate record of what is where */
int OldOccupant;
int EnemyColor;
char HighlightOK;
int MenuResult;
int MatePosted;
char Reinit;
char PlayerMove[6];
char ComputerMove[6];


int FaileMessage(char *Str);
void Skip();
int faile();
void DisplayComputerMove();
void DisplayPlayerMove(int startx,int starty);
int DebugInfo();
int MateMessage(char *Str);
int CheckMessage();
int EraseCheckMessage();
int OrangeMessage(char *Str);
int EraseOrangeMessage();
int PlayerColorMessage();
int PawnPromotionDialog(int px, int py);
int Menu(int px, int py);
int LoadChessFont();
int BlitChessman(int TargetChar, int chx, int chy, int Hue);
int GetBackHue();
int Ch24Erase();
int ParkCursor();
void Ch24CursorUp();
void Ch24CursorDown();
void Ch24CursorLeft();
void Ch24CursorRight();
void DrawPiece(int Piece, int bx, int by, char mode);
int UpdateBoard();
void UndoIllegalMove();
void HighlightComputerMove();
void GetPlayerMove();
int ChessWindowActive();
int InspectSquare();
void SetBoard();
int DrawBoard(int chx, int chy);
void Ch24Init();
int Chess24Mode();

#endif

