/* Borg Solitaire for LCARS 24, based on Klondike Solitaire
   * Face cards have pictures of Voyager crew members, including the
     Doctor, plus Q and Barklay as Borg!
   * Names of some of the arrays and functions are based on
     the traditional nomenclature for the various piles of cards
     in Klondike Solitaire:
      Stock: dealer's face-down pile
      Waste: face-up pile of cards dealt
      Foundations: four piles at top filled by suit
      Tableaus: seven piles below filled by alternating colors
            (abbreviated to Tab in the code)
   * First public release 07/26/03
*/
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#ifndef BORG_H
#define BORG_H


#include "lcars24.h"
#include "cards.h"
#include "brack1.h"
#include "parts.h"
#include "getkey.h"
#include "playwav.h"
#include "headline.h"
#include "scrnshot.h"
#include "lcreader.h"
#include "mars28.h"


void SolBox1a(int Hue);
void SolBox2a(int Hue);
void SolBox1b(int Hue);
void SolBox2b(int Hue);
void SolBox3b(int Hue);
void SolBox4b(int Hue);
void SolBox5b(int Hue);
void SolElbowSignage(int Hue1, int Hue2);
void SolBoxes();
int Sol24Help();
void SolW1Cursor();
int DrawSpot(int x, int y);
void SolUndoOn();
void SolUndoOff();
void EraseTab(int TabNum);
int DrawPregnantTab(int TabNum, int NumCards);
int DrawTab(int TabNum);
int DrawSplitTab(int TabNum);
int TransferOK(int Dest, int Guest);
int DrawCardString(int x, int y);
int DragFromTab();
int DragFromWaste();
int DragFromFoundation();
int FlipHoleCard(int TabNum);
int TabToFoundation(int TabNum);
int WasteToFoundation();
int SolGiveCards();
int UpdateWasteDisplay();
int SolDeckEmpty();
int SolNewGame();
int SolDisplayNew();
int DrawSolStock();
int UndoDeal();
int UndoWasteToTab();
int UndoWasteToFoundation();
int UndoTabToFoundation();
void UndoFoundationToTab();
void UndoTabToTab();
int SolUndo();
int SolGameWon();
int SolitaireWindowActive();
void SolInit();
void SolStartScreen();
int SolitaireMode();

#endif

