/* Alarm, alarm-clock functions of LCARS 24 */

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "alarm.h"


void NextMonthCalender(char Displayed)
{
	time_t x;
	struct tm *t;
	int M;
	double Y;
	int raw;
	int wc,sd,ml,pos;

	if(Displayed) goto off;
	time(&x);
	t = localtime(&x);
	M = t->tm_mon+1;
	t = localtime(&x);
	Y = t->tm_year+1900;

	if(M==12) {
		M=1;
		Y++;
	} else M++;

	rectfill(screen,455,10,790,96,BLACK);
	rectfill(screen,570,106,790,190,BLACK);
	pos=PutCalendarTitle(Y,M,770,10,PURPLE);
	LeftBumper26(566,10,PURPLE);
	rectfill(screen,566,10,pos-7,36,PURPLE);
	PutsLuna(pos-11-StrLenLuna("OFF: ESC"),17, BLACK,PURPLE, "OFF: ESC");
	wc=GetWhichCalendar(Y);
	sd=GetStartingDayOfMonth(wc, M);
	if( sd > 7 ) sd -= 7;
	ml=GetLengthOfMonth(wc,M);
	PutCalendar(sd, ml, 466);

	SnoozeAlarmMin=80; /* disable date update */

	return;

off:	rectfill(screen,500,10,570,36,BLACK);
	rectfill(screen,570,10,800,190,BLACK);
	SnoozeAlarmMin=70;
	PutDate();
}
int SnoozeMode()
{
	char TitleStr[32];
	char SnoozeStr[3];
	char CountdownStr[3];
	int Countdown, PrevMin;

	itoa( SnoozeVal, SnoozeStr, 10);
	strcpy(TitleStr,"SNOOZE: ");
	strcat(TitleStr,SnoozeStr);
	strcat(TitleStr," MINUTES");
	rectfill(screen,0,0,800,600,BLACK);
	PopsicleSticks(LILAC);
	Title(TitleStr);
	ButtonType3(559, 111, LILAC, LILAC, "CANCEL");
	EscSymbol(559+117, 111, 2, MANGO);

	PutTime(164,241,10);
	PrevMin=Minutes;

	Countdown=SnoozeVal;
	itoa( Countdown, CountdownStr, 10);
	MarsF(488-(StrLenMars(4,CountdownStr)),73,4,MANGO, BLACK, CountdownStr);
	PutsFont21(410-(StrLenMars(4,CountdownStr)),119, LILAC,"ALARM IN");
	PutsFont21(494,119, LILAC,"MINUTES");
	PanelBeep();

loopback:
	do {
		PutTime(164,241,10);
		if(Minutes==SnoozeAlarmMin) return(0);
		if(Minutes !=PrevMin) {
			rectfill(screen,410-(StrLenMars(4,CountdownStr)),73,490,186,BLACK);
			Countdown--;
			itoa( Countdown, CountdownStr, 10);
			MarsF(488-(StrLenMars(4,CountdownStr)),73,4,MANGO, BLACK, CountdownStr);
			PutsFont21(410-(StrLenMars(4,CountdownStr)),119, LILAC,"ALARM IN");
			PrevMin=Minutes;
		}
	} while (!kbhit());
	c=GetKey();
	switch( c )
		{
		case 27: 	SnoozeAlarmMin=70;
				return(27);
		case 350: Screenshot792("Snooze.bmp");
				PanelBeep();
				goto loopback;
		default: 	ScoldUser();
				goto loopback;
	}
}
int AlarmDisplay()
{
	char SnoozeStr[32];

	rectfill(screen,387,138,580,191,BLACK);
	PutsScorpio(388, 144, PALEBLUE, "ALARM:");
	if( SingleAlarmOnOff==1 ) {
		PutsScorpio(455,144,PALEBLUE,AlarmString);
		itoa( SnoozeVal, SnoozeStr, 10);
		strcat(SnoozeStr,"-MINUTE SNOOZE");
		if(SnoozeVal >0) PutsLuna(455, 178, MANGO, BLACK, SnoozeStr);
	} else {
		PutsScorpio(455,144,ORANGE,"OFF");
/*		rectfill(screen,455,177,552,190,BLACK); */
	}
}
int Play(char *Song)
{
	int Result;

/*	Result=LcarsPlayMidi(Song); */

	Result=spawnl(P_WAIT,"C:\\LCARS24\\SYSTEM\\MIDI24\\MIDI24.EXE","C:\\LCARS24\\SYSTEM\\MIDI24\\MIDI24.EXE",Song, NULL);

	PutTime(164,264,10);
	rectfill(screen,659,286,760,424,BLACK); /* seconds */

	return(Result);
}
void DosTimeKick()
{
	struct time now;

	gettime( &now);
}
void PlayInRotation(int ListStart)
{
	char DosFileArray[100][16];
	char CurrentTrack[80]="song";
	int Result=0;
	struct ffblk f;
	int Found;
	char *mask="C:\\LCARS24\\ALARM\\*.mid";
	int NumOfMidis,i;

	NumOfMidis=0;
	Found=findfirst(mask, &f, FA_ARCH);
	if( Found ) {

/*	LcReader("C:\\LCARS24\\ALARM\\*.mid"); */
		return;			/* no midi files found */
	}
	while ( !Found ) {
		strcpy(DosFileArray[NumOfMidis], f.ff_name);
		Found=findnext( &f );
		NumOfMidis++;
	}
	--NumOfMidis;

	while(ListStart > NumOfMidis) ListStart -=NumOfMidis;
	if( ListStart < 0 ) ListStart=0;

	i=ListStart;
	do {
	strcpy(CurrentTrack, "C:\\LCARS24\\ALARM\\" );
	strcat(CurrentTrack, DosFileArray[i] );

	rectfill(screen,496,90,780,160,BLACK);
	PutsFont21(500, 90, SEABLUE, "PLAYING");
	PutsFont21(500, 120, SEABLUE, ustrupr(DosFileArray[i]));
	DosTimeKick();
	PutTime(164,264,10);

	release_screen();

	Result=Play(CurrentTrack);
	acquire_screen();
	if( Result==1) return;
	++i;
	if( i > NumOfMidis ) i=0;
	} while(!keypressed());
}
void MidiDJ()
{
	int ListStart=0;

	ListStart=atoi(SecWhenAlarmSet);
	PlayInRotation(ListStart);
}
void LoadAlarm()
{
	PACKFILE *Fp;

	strcpy(CurrentFile,"C:\\LCARS24\\SYSTEM\\ALarmset.LC");
	if ( ( Fp=pack_fopen(CurrentFile, "rb" ))==NULL ) {
		return;
	} else{
		AlarmHour=pack_getc(Fp);
		AlarmMin=pack_getc(Fp);
		SnoozeVal=pack_getc(Fp);
		MuteBeeps=pack_getc(Fp);
		AlarmType=pack_getc(Fp);
		ColorScheme=pack_getc(Fp);
		Endgame=pack_getc(Fp);
		AudioOff=pack_getc(Fp);
		MilitaryTime=pack_getc(Fp);
	}
	pack_fclose( Fp );
	if(SnoozeVal < 0 || SnoozeVal > 18) SnoozeVal=0;
}
void SaveAlarm()
{
	PACKFILE *Fp;

	strcpy(CurrentFile,"C:\\LCARS24\\SYSTEM\\ALARMSET.LC");
	if ( ( Fp=pack_fopen(CurrentFile, "wb" ))==NULL ) {
		return;
	} else{
		pack_putc( AlarmHour, Fp);
		pack_putc( AlarmMin, Fp);
		pack_putc( SnoozeVal, Fp);
		pack_putc( MuteBeeps, Fp);
		pack_putc( AlarmType, Fp);
		pack_putc( ColorScheme, Fp);
		pack_putc( Endgame, Fp);
		pack_putc( AudioOff, Fp);
		pack_putc( MilitaryTime, Fp);
	}
	pack_fclose( Fp );
}
void AlarmMessageBox1a(int Hue)
{
	int boxtop;

	boxtop=10;
	rectfill(screen,10,boxtop,110,boxtop+54, Hue);
}
void AlarmMessageBox2a(int Hue)
{
	int boxtop;

	boxtop=68;
	rectfill(screen,10,boxtop,110,boxtop+54, Hue);
	PutsLuna(14,boxtop + 28 + 9, BLACK, Hue, "STOP");
	PutsLuna(77,boxtop + 4, BLACK, Hue, "SPACE");
	PutsLuna(91,boxtop + 28 + 9, BLACK, Hue, "ESC");
}
void Mp3AlarmMessageBox2a(int Hue)
{
	int boxtop;

	boxtop=68;
	rectfill(screen,10,boxtop,110,boxtop+54, Hue);
	PutsLuna(14,boxtop + 28 + 9, BLACK, Hue, "STOP");
	PutsLuna(91,boxtop + 28 + 9, BLACK, Hue, "ESC");
}

void Mp3Alarm()
{
	char DosFileArray[100][16];
	char CurrentTrack[80]="song";
	int Result=0;
	struct ffblk f;
	int Found;
	char *mask="C:\\LCARS24\\MP3\\*.mp3";
	int NumOfMp3s,i,ListStart;
	char filesfound;

	Mp3AlarmMessageBox2a(NAPLES);

	ButtonType3(597, 153, LILAC, LILAC, "STOP");
	EscSymbol(597+117,153,2, ORANGE);

	ListStart=0;
	NumOfMp3s=0;
	Found=findfirst(mask, &f, FA_ARCH);
	if( Found ) {
		filesfound=FALSE;
		goto ogg_search;	/* no mp3 files found */
	}
	filesfound=TRUE;
	while ( !Found ) {
		strcpy(DosFileArray[NumOfMp3s], f.ff_name);
		Found=findnext( &f );
		NumOfMp3s++;
	}
	--NumOfMp3s;

ogg_search:
	strcpy(mask,"C:\\LCARS24\\MP3\\*.ogg");
	Found=findfirst(mask, &f, FA_ARCH);
	if( Found ) {

		if(filesfound==FALSE) return;	/* no mp3 or ogg files found */
	}
	while ( !Found ) {
		strcpy(DosFileArray[NumOfMp3s], f.ff_name);
		Found=findnext( &f );
		NumOfMp3s++;
	}
	--NumOfMp3s;

	while(ListStart > NumOfMp3s) ListStart -=NumOfMp3s;
	if( ListStart < 0 ) ListStart=0;

	i=ListStart;

	Result=117;
	do {
		strcpy(CurrentTrack, "C:\\LCARS24\\MP3\\" );
		strcat(CurrentTrack, DosFileArray[i] );

		rectfill(screen,500,90,780,144,BLACK);
		PutsFont21(500, 90, WHITE, "PLAYING");
		PutsFont21(500, 120, WHITE, ustrupr(DosFileArray[i]));
		PutTime(164,264,10);

		release_screen();
Result=spawnl(P_WAIT, "C:\\LCARS24\\MP3\\MPXPLAY.EXE", "C:\\LCARS24\\MP3\\MPXPLAY.EXE","-f0", "-sl 0","-sv 200",CurrentTrack, NULL);
		acquire_screen();
		++i;
		if( i > NumOfMp3s ) i=0;
	} while(Result > 109 );

}
void VoiceAlarm()
{
	char RestoreMute=FALSE;
	int result=0;

	if(MuteBeeps==TRUE) {
		MuteBeeps=FALSE;
		RestoreMute=TRUE;
	}
	while(result==0) {
		result=PanelBeep();
		if(result != 0) break;
		result=ScoldUser();
		if(result !=0 ) break;
		PutTime(164,264,10);
	}
	if(RestoreMute==TRUE) MuteBeeps=TRUE;
}
void RedAlert()
{
	int TimeColorHolder;

	TimeColorHolder=TimeColor;

	TimeColor=WHITE;
/*
	min_old=70;
	PutTime(164,264,10);
*/
/*	if(DosDetected==FALSE) return; */

	MidiPlaying=1;
	/* erase all but A.M./P.M from Standby or Snooze screen */
	rectfill(screen,0,0,800,uy-4,BLACK); /* upper window */
	rectfill(screen,659,286,760,424,BLACK); /* seconds */
	rectfill(screen,0,550,800,600,BLACK); /* lower Snooze frame */
	rectfill(screen,160,240,650,550,BLACK); /* Snooze time */
	Brackets1(WHITE, RED);
	AlarmMessageBox1a(RED);
	AlarmMessageBox2a(PURPLE);
	rectfill(screen,10,308,110,591,DARKRED);
	PutsLuna(14,254+60, BLACK, DARKRED, "TIME UPDATED");
	PutsLuna(14,254+16+60, BLACK, DARKRED, "BETWEEN");
	PutsLuna(14,254+32+60, BLACK, DARKRED, "TRACKS");
	MarsF(280, 50, 4, PURPLE, BLACK, "ALARM");
	min_old=70;
	PutTime(164,264,10);
	remove_timer();

	switch( AlarmType )
	{
		case 1:	Mp3Alarm();
				break;
		case 2:	VoiceAlarm();
				break;
		default:  MidiDJ();
				BlasterOK=10; /* trap rare problem */
				break;
	}
	old_sec=70;
	min_old=70;
	day_old=32;
	MidiPlaying=0;
	install_timer();

	if(SnoozeAlarmMin==70 && SnoozeVal > 0) {
		SnoozeAlarmMin=AlarmMin+SnoozeVal-1;
		if(SnoozeAlarmMin > 59) SnoozeAlarmMin -=60;
		if(SnoozeMode() !=27) return; /* main will activate alarm */
	}
	TimeColor=TimeColorHolder;
	Screen1(1); /* done, resume Standby mode */
	old_sec=70;
	min_old=70;
	day_old=32;
	PutDate();
	PutTime(164,264,10);
}
int MidiMusicMode()
{
	MidiPlaying=1;
	Screen1(1);
	rectfill(screen,120,2,800,uy-4,BLACK); /* clear upper window */
	rectfill(screen,659,286,760,424,BLACK); /* erase seconds */
	Brackets1(BIGBLUE, PALEBLUE);
	AlarmMessageBox1a(BIGBLUE);
	AlarmMessageBox2a(NAPLES);
	rectfill(screen,10,308,110,591,BIGBLUE);
	PutsLuna(14,254+60, BLACK, BIGBLUE, "TIME UPDATED");
	PutsLuna(14,254+16+60, BLACK, BIGBLUE, "BETWEEN");
	PutsLuna(14,254+32+60, BLACK, BIGBLUE, "TRACKS");
	MarsF(780-StrLenMars(2,"MIDI MUSIC"), 10, 2, ORANGE, BLACK, "MIDI MUSIC");

	MidiDJ();

	old_sec=70;
	min_old=70;
	day_old=32;
	MidiPlaying=0;
	remove_timer();
	Screen1(1);
	PutDate();
	PutTime(164,264,10);
}
int Mp3MusicMode()
{
	MidiPlaying=1;
	Screen1(1);
	rectfill(screen,120,2,800,uy-4,BLACK); /* clear upper window */
	rectfill(screen,659,286,760,424,BLACK); /* erase seconds */
	Brackets1(BRICK, MANGO);
	AlarmMessageBox1a(BRICK);
	AlarmMessageBox2a(NAPLES);
	rectfill(screen,10,308,110,591,BRICK);
	PutsLuna(14,254+60, BLACK, BRICK, "TIME UPDATED");
	PutsLuna(14,254+16+60, BLACK, BRICK, "BETWEEN");
	PutsLuna(14,254+32+60, BLACK, BRICK, "TRACKS");
	MarsF(780-StrLenMars(2,"MP3 MUSIC"), 10, 2, ORANGE, BLACK, "MP3 MUSIC");

	Mp3Alarm();

	old_sec=70;
	min_old=70;
	day_old=32;
	MidiPlaying=0;
	remove_timer();
	Screen1(1);
	PutDate();
	PutTime(164,264,10);
}

