/*	PickBoth, functions for picking and running apps
	and for picking and opening library files
*/
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "pickboth.h"


void AppsMessageBox1a(int Hue)
{
	int boxtop;

	boxtop = 10;
	rectfill(screen,10,boxtop,110,boxtop+54, Hue);
	PutsLuna(14,boxtop + 26 + 9, BLACK, Hue, "CANCEL");
	PutsLuna(90,boxtop + 26 + 9, BLACK, Hue, "ESC");
}
void AppsMessageBox2a(int Hue)
{
	rectfill(screen,10,68,110,68+58, Hue);
}
void AppsMessageBox4b(int Hue)
{  /* nonstandard; don't copy */
	int boxtop;

	boxtop=590 - (54*4) - 6;

	rectfill(screen,10,boxtop-3,110,boxtop+53+3,BLACK);
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
	PutsLuna(14,boxtop + 26 + 9, BLACK, Hue, "LAUNCH");
	PutsLuna(79,boxtop + 26 + 9, BLACK, Hue, "ENTER");
}

void AppPageOne()
{
	AppPage=1;
	rectfill(screen,374,270,795,600, BLACK);
	PutsFont21(378,270,ORANGE,"LCARS 24 PROGRAMS: PAGE 1");

	ButtonType4(374, 576-(6*47)+14, PURPLE, "BLACKJACK", "F1", SEABLUE);
	ButtonType4(374, 576-(5*47)+14, PURPLE, "CHESS", "F2", SEABLUE);
	ButtonType4(374, 576-(4*47)+14, PURPLE, "CROSSWORD", "F3", SEABLUE);
	ButtonType4(374, 576-(3*47)+14, LILAC, "DOS ACCESS", "F4", SEABLUE);
	ButtonType4(374, 576-(2*47)+14, LILAC, "FILES 24", "F5", SEABLUE);
	ButtonType4(374, 576-(1*47)+14, BIGBLUE, "WORLD MAP", "F6", SEABLUE);

	ButtonType4(579, 576-(6*47)+14, LILAC, "MATH", "F7", SEABLUE);
	ButtonType4(579, 576-(5*47)+14, PURPLE, "SOLITAIRE", "F8", SEABLUE);
	ButtonType4(579, 576-(4*47)+14, LILAC, "TEXT 24", "F9", SEABLUE);
	ButtonType4(579, 576-(3*47)+14, LILAC, "UNIT CONVERSION", "F10", SEABLUE);

	ButtonType7(579, 576-(2*47)+14, ORANGE, "LAST PAGE", "F11", BIGBLUE);
	ButtonType5(579, 576-(1*47)+14, ORANGE, "NEXT PAGE", "F12", LAVENDER);
}
void AppPageTwo()
{
	AppPage=2;
	rectfill(screen,374,270,795,600, BLACK);
	PutsFont21(378,270,ORANGE,"LCARS 24 PROGRAMS: PAGE 2");

	ButtonType4(374, 576-(6*47)+14, LILAC, "BRIEFING", "F1", SEABLUE);
	ButtonType4(374, 576-(5*47)+14, LILAC, "EDIT PROGRAM", "F2", SEABLUE);
	ButtonType4(374, 576-(4*47)+14, BIGBLUE, "LCARS", "F3", SEABLUE);
	ButtonType4(374, 576-(3*47)+14, LILAC, "PHONEBOOK", "F4", SEABLUE);
	ButtonType4(374, 576-(2*47)+14, MANGO, "PLANETS", "F5", SEABLUE);
	ButtonType4(374, 576-(1*47)+14, BIGBLUE, "STARFLEET", "F6", SEABLUE);

	ButtonType4(579, 576-(6*47)+14, BIGBLUE, "SYSTEM INFO", "F7", SEABLUE);
	ButtonType4(579, 576-(5*47)+14, PURPLE, "WARBIRD", "F8", SEABLUE);
	ButtonType4(579, 576-(4*47)+14, BIGBLUE, "WORLD TIME", "F9", SEABLUE);
	ButtonType4(579, 576-(3*47)+14, BIGBLUE, "VIEW 360", "F10", SEABLUE);

	ButtonType7(579, 576-(2*47)+14, ORANGE, "PREV PAGE", "F11", BIGBLUE);
	ButtonType5(579, 576-(1*47)+14, ORANGE, "NEXT PAGE", "F12", LAVENDER);

/*	vline(screen,792,10,589,BORG); */ /* to verify alignment */

}
void AppPageThree()
{
	AppPage=3;
	rectfill(screen,374,270,795,600, BLACK);
	PutsFont21(378,270,ORANGE,"LCARS 24 PROGRAMS: PAGE 3");

	ButtonType4(374, 576-(6*47)+14, BIGBLUE, "PERIODIC TABLE", "F1", SEABLUE);
	ButtonType4(374, 576-(5*47)+14, MANGO, "PARODY: GATES", "F2", SEABLUE);
	ButtonType4(374, 576-(4*47)+14, LILAC, "MIDI MUSIC", "F3", SEABLUE);
	ButtonType4(374, 576-(3*47)+14, LILAC, "MP3 MUSIC", "F4", SEABLUE);
	ButtonType4(374, 576-(2*47)+14, PURPLE, "SUDOKU", "F5", SEABLUE);
	ButtonType4(374, 576-47+14, LILAC, "HEALTH: BMI", "F6", MANGO);

	ButtonType4(579, 576-(6*47)+14, PURPLE, "KAKURO", "F7", BIGBLUE);
	ButtonType4(579, 576-(5*47)+14, PURPLE, "GO", "F8", SEABLUE);
	ButtonType4(579, 576-(4*47)+14, PURPLE, "JIGSAW", "F9", PALEBLUE);

	ButtonType6(579, 576-(2*47)+14, ORANGE, "PREV PAGE", "F11", BIGBLUE);
	ButtonType5(579, 576-(1*47)+14, ORANGE, "FIRST PAGE", "F12", LAVENDER);

}
void PickAppScreen()
{
	rectfill(screen,0,0,800,600, BLACK);
	Brackets1(BracketColor1, BracketColor2);
	AppsMessageBox1a(LILAC);
	AppsMessageBox2a(BracketColor1);
	rectfill(screen,10,308,110,589,BracketColor1);
	AppsMessageBox4b(NAPLES);
	MarsF(780-(StrLenScorpio("SELECT PROGRAM")*2)+6,10,2, BracketColor1,BLACK,"SELECT PROGRAM");

	PutsLuna(14,226+60-18, BLACK, BracketColor2, "FILE:");
	PutsLuna(14,226+60, BLACK, BracketColor2, "APPSLIST.TXT");
	ButtonType1(500+62,106,LILAC,"UTILITY");
	ButtonType1(620+62,106,BIGBLUE,"REFERENCE");
	ButtonType1(500+62,153,PURPLE,"GAME");
	ButtonType1(620+62,153,MANGO,"SIMULATION");

	PutsFont21(128,270,ORANGE,"DOS PROGRAMS");

	PutsFont19(128,64,BRICK,"LAUNCHING OF");
	PutsFont19(128,64+24,BRICK,"DOS PROGRAMS");
	PutsFont19(128,64+48,BRICK,"OFFLINE IN");
	PutsFont19(128,64+48+24,BRICK,"WINDOWS VERSION");

	BracketArrows(1);
	AppPageOne();
	TelescopeBracket(50);
}
void PickWindowCursor()
{
	int gx,gy;

	gx=200+120-16;
	gy=372-80-14+((OldPWy-PickWindowOffset)*32);
	EnterSymbol(gx,gy,1,BLACK);
	if(PWx==1) gx=200+120-16;
	gy=372-80-14+((PWy-PickWindowOffset)*32);
	if(PWx<2) EnterSymbol(gx,gy,1,NAPLES);
	OldPWy=PWy;
}
void PickWindowRefresh()
{
	int bottom,z,i;
	char TruncateStr[80]; /* to prevent Windows from displaying
				 a long filename */

	rectfill(screen,140,300,340,599, BLACK);
	bottom=EndText;
	if(EndText>8) bottom=8;
	for(z=1;z<=bottom;++z) {
		if( Ln[PickWindowOffset+z][0] == 33 ) {
			for( i=0; i< strlen(Ln[PickWindowOffset+z]); ++i) Highlight[i]=Ln[PickWindowOffset+z][i+1];
			RightPutsFont21(288,276+(z*32),MANGO,Highlight);
		} else {
			strcpy(TruncateStr, ustrupr(Ln[z+PickWindowOffset]));
			if( PickMode != 1) TruncateStr[12]=(null);
			if( stricmp( "", get_extension(Ln[z+PickWindowOffset]) )==0 ) {
				RightPutsFont21(288,276+(z*32),PALEBLUE,TruncateStr);
			}
		}
	}
}
void PickWindowUp()
{
	if( PWy == 1 ) return;
	--PWy;
	if(PWy-PickWindowOffset < 1) --PickWindowOffset;
}
void PickWindowDn()
{
	if( PWy >= EndText-1 ) return;
	++PWy;
	if(PWy-PickWindowOffset > 8) ++PickWindowOffset;
}
int PickWindowActive()
{
	int z, OffsetHolder;

	PWx=1;
	PWy=1;
	OldPWy=1;
	PickWindowOffset=0;
	PickWindowRefresh();
	PickWindowCursor();
	c=0;
	c=PanelBeep();

loopback:
	do {
		UpdateIdle();
	} while(!keypressed());
		if(c==0) c = GetKey();
		switch( c )
		{
			case ESC: return(0);
			case 13: c=0;
				ScoldUser();
				goto loopback;
/*
				if(Ln[PWy][0] < 33) goto clear;
					else return(1);
*/
			case PGUPKEY: OffsetHolder = PickWindowOffset;
				if( PWy == 1 ) goto clear;
				for(z=1;z<=7;++z) PickWindowUp();
				if(PickWindowOffset != OffsetHolder) PickWindowRefresh();
				goto cursor;
			case PGDNKEY: OffsetHolder = PickWindowOffset;
				if( PWy >= EndText-1 ) goto clear;
				for(z=1;z<=7;++z) PickWindowDn();
				if(PickWindowOffset != OffsetHolder) PickWindowRefresh();
				goto cursor;
			case UPARROW:
				if( PWy == 1 ) goto clear;
				--PWy;
				if(PWy-PickWindowOffset < 1) {
					--PickWindowOffset;
					PickWindowRefresh();
				}
				goto cursor;
			case DOWNARROW:
				if( PWy >= EndText-1 ) goto clear;
				++PWy;
				if(PWy-PickWindowOffset > 8) {
					++PickWindowOffset;
					PickWindowRefresh();
				}
				goto cursor;
			case LEFTARROW:
			case RIGHTARROW: c=ScoldUser();
				goto loopback;
			case F1: if( PickMode != 1) goto clear;
				if(AppPage==1) {
					BlackjackMode();
					return(0);
				}
				if(AppPage==2) {
					BmiMode();
					return(0);
				}
				if(AppPage==3) {
					PeriodicTableMode();
					return(0);
				} else goto clear;
			case F2: if( PickMode != 1) goto clear;
				if(AppPage==1) {
/*					Chess24Mode();    */
					ScoldUser();
					goto clear;
				}
				if(AppPage==2) {
					ProgEditMode("NAMELESS.TXT");
					return(0);
				}
				if(AppPage==3) {
					GatesMode();
					return(0);
				} else goto clear;
			case F3: if( PickMode != 1) goto clear;
				if(AppPage==1) {
					CrosswordMode();
					return(0);
				}
				if(AppPage==2) {
					DataMode();
					return(0);
				}
				if(AppPage==3) {
					if(BlasterOK==FALSE || AudioOff==TRUE) {
						AudioError();
						goto clear;
					}
					MidiMusicMode();
					return(0);
				} else goto clear;
			case F4: if( PickMode != 1) goto clear;
				if(AppPage==1) {
			/*		DosMode(); */
					ScoldUser();
					goto clear;
				}
				if(AppPage==2) {
					PhoneBookMode();
					return(0);
				}
				if(AppPage==3) {
					if(BlasterOK==FALSE || AudioOff==TRUE) {
						AudioError();
						goto clear;
					}
			/*		Mp3MusicMode(); */
					ScoldUser();
					goto clear;
				} else goto clear;
			case F5: if( PickMode != 1) goto clear;
				if(AppPage==1) {
					Files24Mode();
					return(0);
				}
				if(AppPage==2) {
					PlanetsMode();
					return(0);
				} 
				if(AppPage==3) {
					SudokuMode();
					return(0);
				} else goto clear;
			case F6: if( PickMode != 1) goto clear;
				if(AppPage==1) {
					MapMode();
					return(0);
				}
				if(AppPage==2) {
					StarshipMode();
					return(0);
				} else goto clear;
			case F7: if( PickMode != 1) goto clear;
					if(AppPage==1) {
						MathMode();
						return(0);
					}
					if(AppPage==2) {
						SystemInfoMode();
						return(0);
					} 
				if(AppPage==3) {
					KakuroMode();
					return(0);
				} else goto clear;
			case F8: if( PickMode != 1) goto clear;
					if(AppPage==1) {
						SolitaireMode();
						return(0);
					}
					if(AppPage==2) {
						WarbirdMode();
						return(0);
					}
				if(AppPage==3) {
					GoMode();
					return(0);
				} else goto clear;
			case F9: if( PickMode != 1) goto clear;
					if(AppPage==1) {
						Text24Mode("NAMELESS.TXT");
						return(0);
					}
					if(AppPage==2) {
						TimeZoneMode();
						return(0);
					} 
				if(AppPage==3) {
					JigsawMode();
					return(0);
				} else goto clear;
			case F10: if( PickMode != 1) goto clear;
					if(AppPage==1) {
						ConversionMode();
						return(0);
					}
					if(AppPage==2) {
						View360Mode();
						return(0);
					} else goto clear;
			case F11: if( PickMode != 1) goto clear;
					if(AppPage==1) {
						AppPageThree();
						c=PanelBeep();
						goto loopback;
					}
					if(AppPage==2) {
						AppPageOne();
						c=PanelBeep();
						goto loopback;
					}
					if(AppPage==3) {
						AppPageTwo();
						c=PanelBeep();
						goto loopback;
					} else goto clear;
			case F12: if( PickMode != 1) goto clear;
					if(AppPage==3) {
						AppPageOne();
						c=PanelBeep();
						goto loopback;
					}
					if(AppPage==1) AppPageTwo();
						else AppPageThree();
					c=PanelBeep();
					goto loopback;
			case CTRL_F1: Screenshot792("Pick8.bmp");
					c=PanelBeep();
					goto loopback;
			case CTRL_F2: Screenshot1024("Pick10.bmp");
					c=PanelBeep();
					goto loopback;
			default: c=ScoldUser();
					goto loopback;
		}
clear:  c=0;
	goto loopback;
cursor:
	PickWindowCursor();
	goto clear;
}

