/* 	periodic.c, embedded LCARS 24 applet
	Draws a color-coded periodic table with symbols and lets the user
	browse the names of the elements
	Usage:
	int PeriodicTableMode();
*/

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "periodic.h"


ELEMENT GetElementInfo(int AtNum)
{
ELEMENT e[118] = {
{"H", "Hydrogen", 0,0,MANGO},
{"He", "Helium", 17,0,NAPLES},
{"Li", "Lithium", 0,1,MANGO},
{"Be", "Beryllium", 1,1,ORANGE},
{"B", "Boron", 12,1,BRICK},
{"C", "Carbon", 13,1,BRICK},
{"N", "Nitrogen", 14,1,BRICK},
{"O", "Oxygen", 15,1,BRICK},
{"F", "Fluorine", 16,1,BRICK},
{"Ne", "Neon", 17,1,NAPLES},
{"Na", "Sodium", 0,2,MANGO},
{"Mg", "Magnesium", 1,2,ORANGE},
{"Al", "Aluminum", 12,2,PURPLE},
{"Si", "Silicon",  13,2,BRICK},
{"P", "Phosphorus", 14,2,BRICK},
{"S", "Sulfur", 15,2,BRICK},
{"Cl", "Chlorine", 16,2,BRICK},
{"Ar", "Argon", 17,2,NAPLES},
{"K", "Potassium", 0,3,MANGO},
{"Ca", "Calcium",  1,3,ORANGE},
{"Sc", "Scandium", 2,3,LILAC},
{"Ti", "Titanium", 3,3,LILAC},
{"V", "Vanadium",  4,3,LILAC},
{"Cr", "Chromium", 5,3,LILAC},
{"Mn", "Manganese", 6,3,LILAC},
{"Fe", "Iron", 7,3,LILAC},
{"Co", "Cobalt", 8,3,LILAC},
{"Ni", "Nickel", 9,3,LILAC},
{"Cu", "Copper", 10,3,LILAC},
{"Zn", "Zinc", 11,3,LILAC},
{"Ga", "Gallium", 12,3,PURPLE},
{"Ge", "Germanium", 13,3,PURPLE},
{"As", "Arsenic", 14,3,BRICK},
{"Se", "Selenium", 15,3,BRICK},
{"Br", "Bromine", 16,3,BRICK},
{"Kr", "Krypton", 17,3,NAPLES},
{"Rb", "Rubidium", 0,4,MANGO},
{"Sr", "Strontium", 1,4,ORANGE},
{"Y", "Yttrium", 2,4,LILAC},
{"Zr", "Zirconium ", 3,4,LILAC},
{"Nb", "Niobium",  4,4,LILAC},
{"Mo", "Molybdenum", 5,4,LILAC},
{"Tc", "Technetium", 6,4,LILAC},
{"Ru", "Ruthenium", 7,4,LILAC},
{"Rh", "Rhodium", 8,4,LILAC},
{"Pd", "Palladium", 9,4,LILAC},
{"Ag", "Silver", 10,4,LILAC},
{"Cd", "Cadmium", 11,4,LILAC},
{"In", "Indium",  12,4,PURPLE},
{"Sn", "Tin", 13,4,PURPLE},
{"Sb", "Antimony", 14,4,PURPLE},
{"Te", "Tellurium", 15,4,BRICK},
{"I", "Iodine", 16,4,BRICK},
{"Xe", "Xenon", 17,4,NAPLES},
{"Cs", "Cesium", 0,5,MANGO},
{"Ba", "Barium", 1,5,ORANGE},
{"La", "Lanthanum", 3,8,PALEBLUE},
{"Ce", "Cerium", 4,8,PALEBLUE},
{"Pr", "Praseodymium", 5,8,PALEBLUE},
{"Nd", "Neodymium", 6,8,PALEBLUE},
{"Pm", "Promethium", 7,8,PALEBLUE},
{"Sm", "Samarium", 8,8,PALEBLUE},
{"Eu", "Europium", 9,8,PALEBLUE},
{"Gd", "Gadolinium", 10,8,PALEBLUE},
{"Tb", "Terbium", 11,8,PALEBLUE},
{"Dy", "Dysprosium", 12,8,PALEBLUE},
{"Ho", "Holmium", 13,8,PALEBLUE},
{"Er", "Erbium", 14,8,PALEBLUE},
{"Tm", "Thulium", 15,8,PALEBLUE},
{"Yb", "Ytterbium", 16,8,PALEBLUE},
{"Lu", "Lutetium", 17,8,PALEBLUE},
{"Hf", "Hafnium", 3,5,LILAC},
{"Ta", "Tantalum", 4,5,LILAC},
{"W", "Tungsten", 5,5,LILAC},
{"Re", "Rhenium", 6,5,LILAC},
{"Os", "Osmium", 7,5,LILAC},
{"Ir", "Iridium", 8,5,LILAC},
{"Pt", "Platinum", 9,5,LILAC},
{"Au", "Gold", 10,5,LILAC},
{"Hg", "Mercury", 11,5,LILAC},
{"Tl", "Thallium", 12,5,PURPLE},
{"Pb", "Lead", 13,5,PURPLE},
{"Bi", "Bismuth", 14,5,PURPLE},
{"Po", "Polonium", 15,5,PURPLE},
{"At", "Astatine", 16,5,BRICK},
{"Rn", "Radon", 17,5,NAPLES},
{"Fr", "Francium", 0,6,MANGO},
{"Ra", "Radium", 1,6,ORANGE},
{"Ac", "Actinium", 3,9,TAN},
{"Th", "Thorium",  4,9,TAN},
{"Pa", "Protactinium", 5,9,TAN},
{"U", "Uranium", 6,9,TAN},
{"Np", "Neptunium", 7,9,TAN},
{"Pu", "Plutonium", 8,9,TAN},
{"Am", "Americium", 9,9,TAN},
{"Cm", "Curium", 10,9,TAN},
{"Bk", "Berkelium", 11,9,TAN},
{"Cf", "Californium", 12,9,TAN},
{"Es", "Einsteinium", 13,9,TAN},
{"Fm", "Fermium", 14,9,TAN},
{"Md", "Mendelevium", 15,9,TAN},
{"No", "Nobelium", 16,9,TAN},
{"Lr", "Lawrencium", 17,9,TAN},
{"Rf", "Rutherfordium", 3,6,LILAC},
{"Db", "Dubnium", 4,6,LILAC},
{"Sg", "Seaborgium", 5,6,LILAC},
{"Bh", "Bohrium", 6,6,LILAC},
{"Hs", "Hassium", 7,6,LILAC},
{"Mt", "Meitnerium", 8,6,LILAC},
{"Ds", "Darmstadtium", 9,6,LILAC},
{"Uuu", "Unununium", 10,6,LILAC},
{"Uub", "Ununbium", 11,6,LILAC},
{"Uut", "Ununtrium", 12,6,PURPLE},
{"Uuq", "Ununquadium", 13,6,PURPLE},
{"Uup", "Ununpentium", 14,6,PURPLE},
{"Uuh", "Ununhexium", 15,6,PURPLE},
{"Uus", "Ununseptium", 16,6,BRICK},
{"Uuo", "Ununoctium ", 17,6,NAPLES}
};

	return e[AtNum-1];
}

void DimCandidate(int x, int y, char *Symbol)
{
	if(y < 7) {
		x = (x * 35) + 82;
		y = (y * 50) + 77;
	} else {
		x = (x * 35) + 82-16;
		y = (y * 50) + 60;
	}

	RightBumper26(x+2,y+16,BIGBLUE);
	rectfill(screen,x,y+16,x+2,y+42,BIGBLUE);
	PutsFont14(x+6,y+24,BLACK,BIGBLUE,Symbol);
	EnterSymbol(x+20,y+10,1,RED);

}
void EraseCandidate(int x, int y)
{
	if(y < 7) {
		x = (x * 35) + 82;
		y = (y * 50) + 77;
	} else {
		x = (x * 35) + 82-16;
		y = (y * 50) + 60;
	}
	blit(PtBackbmp,screen,x,y-4,x,y-4,35,47);
}

void DrawCandidate(int x, int y, char *Symbol, char selected)
{
	if(y < 7) {
		x = (x * 35) + 82;
		y = (y * 50) + 77;
	} else {
		x = (x * 35) + 82-16;
		y = (y * 50) + 60;
	}

	if(selected==0) {   /* draw candidate in home position */
		x -= 6;
		y -= 12;

		RightBumper26(x+2,y+16,SEABLUE);
		rectfill(screen,x,y+16,x+2,y+42,SEABLUE);
		PutsFont14(x+6,y+24,BLACK,SEABLUE,Symbol);
		blit(screen,PtBackbmp,x,y,x,y,29,43);
	}
	if(selected==1) {
		draw_sprite(screen,PtSprite,x,y-4);
	}
	if(selected==2) {    /* erase */
		x -= 6;
		y -= 12;
		rectfill(screen,x,y,x+28,y+42,BLACK);
		rectfill(PtBackbmp,x,y,x+28,y+42,BLACK);
	}
	if(selected==3) {    /* make sprite */
		RightBumper26(x+2,y+16,SEABLUE);
		rectfill(screen,x,y+16,x+2,y+42,SEABLUE);
		PutsFont14(x+6,y+24,BLACK,SEABLUE,Symbol);
		EnterSymbol(x+20,y+10,1,YELLOW);
		blit(screen,PtSprite,x,y-4,0,0,35,47);
		floodfill(PtSprite,2,2,makecol(255,0,255));
		floodfill(PtSprite,27,40,makecol(255,0,255));
	}
}
void HighlightTag(int x, int y, int Hue, int AtNum, char *Symbol)
{
	char AtNumStr[4];

	if(y < 7) {
		x = (x * 35) + 82;
		y = (y * 50) + 77;
	} else {
		x = (x * 35) + 82-16;
		y = (y * 50) + 60;
	}

	rectfill(screen,x,y,x+28,y+42,BLACK);
	itoa(AtNum, AtNumStr, 10);
	PutsFont14(x+24-StrLenLuna(AtNumStr),y+5,Hue,BLACK,AtNumStr);
	PutsFont14(x+6,y+24,Hue,BLACK,Symbol);
}

void DrawTag(int x, int y, int Hue, int AtNum, char *Symbol)
{
	char AtNumStr[4];

	if(y < 7) {
		x = (x * 35) + 82;
		y = (y * 50) + 77;
	} else {
		x = (x * 35) + 82-16;
		y = (y * 50) + 60;
	}


	if(PeriodicMode==0) {
		rectfill(screen,x,y,x+28,y+42,Hue);
		itoa(AtNum, AtNumStr, 10);
		PutsFont14(x+24-StrLenLuna(AtNumStr),y+5,BLACK,Hue,AtNumStr);
		PutsFont14(x+6,y+24,BLACK,Hue,Symbol);
		F36Color(Hue,BLACK);
/* upper left */
		rectfill(screen, x,y,x+1,y+1,bc);
		putpixel(screen, x+2,y,ac3);
		putpixel(screen, x+3,y,ac2);
		putpixel(screen, x,y+2,ac3);
		putpixel(screen, x,y+3,ac2);
		putpixel(screen, x+1,y+1,ac2);
/* upper right */
		rectfill(screen, x+27,y,x+28,y+1,bc);
		putpixel(screen, x+26,y,ac3);
		putpixel(screen, x+25,y,ac2);
		putpixel(screen, x+28,y+2,ac3);
		putpixel(screen, x+28,y+3,ac2);
		putpixel(screen, x+27,y+1,ac2);
/* lower left */
		rectfill(screen, x,y+42,x+1,y+42-1,bc);
		putpixel(screen, x+2,y+42,ac3);
		putpixel(screen, x+3,y+42,ac2);
		putpixel(screen, x,y+42-2,ac3);
		putpixel(screen, x,y+42-3,ac2);
		putpixel(screen, x+1,y+42-1,ac2);
/* lower right */
		rectfill(screen, x+27,y+42,x+28,y+42-1,bc);
		putpixel(screen, x+26,y+42,ac3);
		putpixel(screen, x+25,y+42,ac2);
		putpixel(screen, x+28,y+42-2,ac3);
		putpixel(screen, x+28,y+42-3,ac2);
		putpixel(screen, x+27,y+42-1,ac2);
	} else {
		itoa(AtNum, AtNumStr, 10);
		PutsFont14(x+24-StrLenLuna(AtNumStr),y+5,Hue,BLACK,AtNumStr);
	}

}
void DrawPeriodicTable()
{
	ELEMENT e;
	int AtNum;

	for(AtNum=1; AtNum <119; AtNum++) {
		e=GetElementInfo(AtNum);
		DrawTag(e.x,e.y,e.color, AtNum,e.symb);
	}

	PutsLuna(82,77-21,MANGO,BLACK,"ALKALI METALS");
	PutsLuna(641,77-21,NAPLES,BLACK,"NOBLE GASES");

	PutsLuna(82+35,77+50-21,ORANGE,BLACK,"ALKALINE EARTH METALS");
	PutsLuna(82+(12*35),77+50-21,BRICK,BLACK,"NONMETALS");

	PutsLuna(82+(3*35),206,LILAC,BLACK,"TRANSITIONAL METALS");

	PutsLuna(82+(12*35),77+350,PURPLE,BLACK,"OTHER METALS");

	PutsLuna(82,400+60+5,PALEBLUE,BLACK,"LANTHANIDES");
	PutsLuna(82,450+60+5,TAN,BLACK,"ACTINIDES");
}
int TableWindowActive()
{
	int AtNum = 1;
	ELEMENT e;

	rectfill(screen,210,13,750,39,LILAC);
	UpArrowSymbol(94+170,82,YELLOW);
	PutsLuna(94+170+18+2,82,YELLOW,BLACK,"/");
	DownArrowSymbol(94+170+24+6,82,YELLOW);
	PutsLuna(705-StrLenLuna("PUZZLE: F9"),20, BLACK,LILAC, "PUZZLE: F9");
	PeriodicMode=0;
	DrawPeriodicTable();
	PanelBeep();

loopback:

	e=GetElementInfo(AtNum);
	HighlightTag(e.x,e.y,e.color, AtNum,e.symb);
	DrawTag(7,0,e.color, AtNum,e.symb);
	rectfill(screen, 369,77+24,500,77+44,BLACK);
	PutsFont14(370,77+24,e.color,BLACK,e.name);

	do {
		PopPutTime(0);
	} while(!keypressed());
	c = GetKey();
	switch( c )
	{
		case F12:	return(0);
		case UPARROW:   DrawTag(e.x,e.y,e.color, AtNum,e.symb);
				++AtNum;
				if(AtNum > 118) AtNum = 1;
				goto loopback;
		case DOWNARROW: DrawTag(e.x,e.y,e.color, AtNum,e.symb);
				--AtNum;
				if(AtNum < 1) AtNum = 118;
				goto loopback;
		case F9:	return(1);
		case 350: 	Screenshot792("Period8.bmp");
				goto loopback;
		case 351: 	Screenshot1024("Period10.bmp");
				goto loopback;
		default:	goto loopback;
	}
	return(0);
}
void PeekIndication()
{
	rectfill(screen,400,13,500,39,LILAC);
	PutsLuna(500-StrLenLuna("PEEK: F1"),20, BLACK,LILAC, "PEEK: F1");
}
void Cheat(int AtNum)
{
	ELEMENT e;

	rectfill(screen,0,50,800,558,BLACK);
	e=GetElementInfo(AtNum);
	PeriodicMode=0;
	DrawTag(e.x,e.y,e.color, AtNum,e.symb);
	PeriodicMode=1;
	rectfill(screen,400,13,500,39,LILAC);
	PutsLuna(500-StrLenLuna("BACK: F1"),20, BLACK,LILAC, "BACK: F1");

loopback:
	do {
		PopPutTime(0);
	} while(!keypressed());
	c = GetKey();

	switch( c )
	{
		case 27:
		case F1:        blit(PtBackbmp,screen,0,0,0,0,750,588);
				PeekIndication();
				return;
		case CTRL_F1: 	Screenshot792("Peek.bmp");
				goto loopback;
		default:	goto loopback;
	}
}
void Chirp()
{
	SetCurrentFile("\\wav\\lc1.wav");
	if(exists(CurrentFile)) LcarsPlayWav(CurrentFile);
		else PanelBeep();
}
int PtDrag(int AtNum, int y)
{
	ELEMENT e;
	int x, oldx, oldy;

	oldx=x=9;
	oldy=y;
	e=GetElementInfo(AtNum);
	DrawCandidate(x, y, e.symb, 3);
	DrawCandidate(x, y, e.symb, 1);
	PeekIndication();

loopback:
	do {
		PopPutTime(0);
	} while(!keypressed());
	c = GetKey();
	switch( c )
	{
		case 13:	e=GetElementInfo(AtNum);
				DimCandidate(x,y, e.symb);
				if( x != e.x) goto loopback;
				if( y != e.y) goto loopback;
				if(oldx==e.x && oldy==e.y) {
					EraseCandidate(oldx,oldy);
					PeriodicMode=0;
					DrawTag(e.x,e.y,e.color, AtNum,e.symb);
					Chirp();
					PeriodicMode=1;
					return(1);
				}
				goto loopback;
		case F12:        return(27);
		case UPARROW:	if(y==0) goto loopback;
				oldy=y;
				y--;
				EraseCandidate(oldx,oldy);
				oldy=y;
				DrawCandidate(x, y, e.symb, 1);
				goto loopback;
		case DOWNARROW: if(y==9) goto loopback;
				oldy=y;
				y++;
				EraseCandidate(oldx,oldy);
				oldy=y;
				DrawCandidate(x, y, e.symb, 1);
				goto loopback;
		case LEFTARROW:	if(x==0) goto loopback;
				oldx=x;
				x--;
				EraseCandidate(oldx,oldy);
				oldx=x;
				DrawCandidate(x, y, e.symb, 1);
				goto loopback;
		case RIGHTARROW: if(x==17) goto loopback;
				oldx=x;
				x++;
				EraseCandidate(oldx,oldy);
				oldx=x;
				DrawCandidate(x, y, e.symb, 1);
				goto loopback;
		case F1:	Cheat(AtNum);
				DrawCandidate(x, y, e.symb, 1);
				goto loopback;
		case F9:	return(1);
		case CTRL_F1: 	Screenshot792("Drag.bmp");
				goto loopback;
		default:	goto loopback;
	}
	return(0);
}
void PtPutScore(int score)
{
	char str[4];

	itoa(score, str, 10);
	rectfill(screen,251,13,276,39,LILAC);
	PutsLuna(252,20, BLACK,LILAC, str);
}

int PeriodicPuzzleMode()
{
	int x, y, z, Result, score, dealt;
	int PeriodicDeck[118];
	char ondeck[3];
	ELEMENT e;

	rectfill(screen,210,13,750,39,LILAC);
	PutsLuna(705-StrLenLuna("SOLUTION: F9"),20, BLACK,LILAC, "SOLUTION: F9");
	PutsLuna(214,20, BLACK,LILAC, "SCORE: ");
	PtPutScore(0);
	PeekIndication();
	PeriodicMode=1;
	rectfill(screen,0,50,800,558,BLACK);
	DrawPeriodicTable();
	PtBackbmp=create_bitmap(750,588);
	blit(screen,PtBackbmp,0,0,0,0,750,588);
	x=9;
	y=score=0;
	PtSprite=create_bitmap(35,47);

	for(z=0; z<118; ++z) PeriodicDeck[z]=z+1;
	shuffle(PeriodicDeck, 118);
	ondeck[0] = PeriodicDeck[0];
	ondeck[1] = PeriodicDeck[1];
	ondeck[2] = PeriodicDeck[2];
	dealt = 3;

	e=GetElementInfo(ondeck[0]);
	DrawCandidate(x, 0, e.symb, 0);
	PutsFont14(385-StrLenFont14(e.name),84,SEABLUE,BLACK,e.name);
	e=GetElementInfo(ondeck[1]);
	DrawCandidate(x, 1, e.symb, 0);
	PutsFont14(385-StrLenFont14(e.name),134,SEABLUE,BLACK,e.name);
	e=GetElementInfo(ondeck[2]);
	DrawCandidate(x, 2, e.symb, 0);
	PutsFont14(385-StrLenFont14(e.name),184,SEABLUE,BLACK,e.name);
	blit(screen,PtBackbmp,0,0,0,0,750,588);
	EnterSymbol((x*35)+107,(y*50)+81,1,NAPLES);
	PanelBeep();

loopback:
	do {
		PopPutTime(0);
	} while(!keypressed());
	c = GetKey();
	switch( c )
	{
		case 13:	EnterSymbol((x*35)+107,(y*50)+81,1,BLACK);
				DrawCandidate(x,y,"",2); /* erase */
				Result=PtDrag(ondeck[y], y);
				blit(screen,PtBackbmp,0,0,0,0,750,588);
				if(Result==27) return(27);
				goto more;
		case F12: 	return(0);
		case UPARROW:	if(y==0) goto loopback;
				EnterSymbol((x*35)+107,(y*50)+81,1,BLACK);
				y--;
				EnterSymbol((x*35)+107,(y*50)+81,1,NAPLES);
				goto loopback;
		case DOWNARROW: if(y==2) goto loopback;
				EnterSymbol((x*35)+107,(y*50)+81,1,BLACK);
				y++;
				EnterSymbol((x*35)+107,(y*50)+81,1,NAPLES);
				goto loopback;
		case F1:	Cheat(ondeck[y]);
				EnterSymbol((x*35)+107,(y*50)+81,1,NAPLES);
				goto loopback;
		case F9:	rectfill(screen,0,50,800,558,BLACK);
				destroy_bitmap(PtBackbmp);
				destroy_bitmap(PtSprite);
				return(1);
		case CTRL_F1: 	Screenshot792("Puzzle.bmp");
				goto loopback;
				goto loopback;
		default:	goto loopback;
	}

more:
	score++;
	PtPutScore(score);
	if(score >=118) {
		rectfill(screen,0,50,800,558,BLACK);
		PutsFont21(82+(7*35),127+21,SEABLUE,"PUZZLE COMPLETE");
		destroy_bitmap(PtBackbmp);
		destroy_bitmap(PtSprite);
		return(1);
	}
	e=GetElementInfo(ondeck[y]);
	rectfill(screen,383-StrLenFont14(e.name),(y*50)+84,387,(y*50)+103,BLACK);
	DrawCandidate(x,y,"",2); /* erase */
	EnterSymbol((x*35)+107,(y*50)+81,1,NAPLES);
	if(dealt>117) goto loopback;
	ondeck[y] = PeriodicDeck[dealt];
	dealt++;
	e=GetElementInfo(ondeck[y]);
	DrawCandidate(x, y, e.symb, 0);
	PutsFont14(385-StrLenFont14(e.name),(y*50)+84,SEABLUE,BLACK,e.name);
	blit(screen,PtBackbmp,300,(y*50)+84,300,(y*50)+84,85,20);
	goto loopback;
}
int PeriodicTableMode()
{
	int Result;

	rectfill(screen,0,0,800,600,BLACK);
	PopsicleSticks(LILAC);
	Title("PERIODIC TABLE");

	UpArrowSymbol(44+170,20,BLACK);
	PutsLuna(44+170+18+2,20,BLACK,LILAC,"/");
	DownArrowSymbol(44+170+24+6,20,BLACK);

	PutsLuna(705-StrLenLuna("CLOSE: F12"),566, BLACK,LILAC, "CLOSE: F12");
	min_old=70;

switchback:
	Result = TableWindowActive();
	if(Result==1) Result=PeriodicPuzzleMode();
	if(Result==1) goto switchback;
	return(Result);
}

