/*	 Mapfonts, for the LCARS 24 world map, microjustified

	fonts with upper- and lowercase, etc., but no antialiasing
	Usage:	PutsBlock11(BITMAP *bmp,int x,int y, int Hue, char *Str)
			PutsFont13(BITMAP *bmp,int x,int y, int Hue, char *Str)
			PutsFont18(BITMAP *bmp,int x,int y, int Hue, char *Str)
			PutsFont24(BITMAP *bmp,int x,int y, int Hue, char *Str)
			(where Hue is the foreground color)
			StrLenB11(char *Str)
			StrLenFont13(char *Str)
			StrLenFont18(char *Str)
			StrLenFont24(char *Str)
	The font data should be loaded at the beginning of the
	program, by calling LoadMapFonts().
*/
/* AMWVNMHAH test */

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#include "mapfonts.h"


int LoadBlock11()
{
	int c;

	long z;
	PACKFILE *Fp;

	memset(Block11, (null), 12544);
	SetCurrentFile("\\SYSTEM\\FONTS\\BLOCK11.SFF");
	Fp = pack_fopen(CurrentFile, "rb");
	if ( Fp == 0) return(FontLoadError(CurrentFile));
	for(z = 0; z < 12544; ++z ) Block11[z] = pack_getc(Fp);
	pack_fclose( Fp );
	return(0);
}

int StrLenB11(char *Str)
{
	char Capture[1800];
	int i;
	int k;
	int pos;
	size_t j;

	pos = 1;
	j = strlen(Str);
	strcpy(Capture, Str);
	if( Capture[j-1] <= 32 ) Capture[j-1] = 32;
	if( Capture[j] <= 32 ) Capture[j] = 32;
	k=(null);
	Capture[j+1] = (k);
	for(k = 0; k < j; ++k) {
		i = Capture[k];
		if( Capture[k] == 9 ) pos = (40 + ((pos/40)*40) );
			else pos += Block11[i]-65;
	}
	return(pos);
}

int BlitBlock11(BITMAP *bmp,int TargetChar, int x, int y, int Hue)
{
	int a,b;
	int z;
	unsigned char i;
	static unsigned char BitVal[] = { 128,64,32,16,8,4,2,1 };

	if( TargetChar <= 32 ) return(1);
	z=(TargetChar-30)*64;
	for(b=0; b<16; ++b) {
		for(a=0; a<8; ++a) {
			i = Block11[b+z] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x, b+y, Hue);
		}
	}
	for(b=0; b<25; ++b) {
		for(a=0; a<8; ++a) {
			i = Block11[b+z+32] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x+8, b+y, Hue);
		}
	}
	return(0);
}

int PutsBlock11(BITMAP *bmp,int x,int y, int Hue, char *Str)
{
	char Capture[1800];
	int i;
	int k;
	int pos;
	size_t j;
	int tabpos;
	unsigned int t;

	t=32;
	pos = x;
	j = strlen(Str);
	strcpy(Capture, Str);
	k=(null);
	Capture[j+1] = (k);
	for(k = 0; k < j; ++k) {
		if( Capture[k] < 32 && Capture[k] != 9 ) i = (t);
		else i = Capture[k];
		if(y>0 && Capture[k] != 9 ) {
			BlitBlock11(bmp,i,pos,y,Hue);
		}
		if( Capture[k] == 9 ) {
			tabpos=0;
			while( pos-x >= tabpos) tabpos += 40;
			pos = tabpos + x;
		} else pos += Block11[i]-65;
	}
	return(0);
}

int LoadFont13()
{
	int c;

	long z;
	PACKFILE *Fp;

	memset(Font13, (null), 12544);
	SetCurrentFile("\\SYSTEM\\FONTS\\FONT13.SFF");
	Fp = pack_fopen(CurrentFile, "rb");
	if ( Fp == 0) return(FontLoadError(CurrentFile));
	for(z = 0; z < 12544; ++z ) Font13[z] = pack_getc(Fp);
	pack_fclose( Fp );
	return(0);
}

int StrLenFont13(char *Str)
{
	char Capture[1800];
	int i;
	int k;
	int pos;
	size_t j;

	pos = 1;
	j = strlen(Str);
	strcpy(Capture, Str);
	if( Capture[j-1] <= 32 ) Capture[j-1] = 32;
	if( Capture[j] <= 32 ) Capture[j] = 32;
	k=(null);
	Capture[j+1] = (k);
	for(k = 0; k < j; ++k) {
		i = Capture[k];
		if( Capture[k] == 9 ) pos = (40 + ((pos/40)*40) );
			else pos += Font13[i]-65;
	}
	return(pos);
}

int BlitFont13(BITMAP *bmp,int TargetChar, int x, int y, int Hue)
{
	int a,b;
	int z;
	unsigned char i;
	static unsigned char BitVal[] = { 128,64,32,16,8,4,2,1 };

	if( TargetChar <= 32 ) return(1);
	z=(TargetChar-30)*64;
	for(b=0; b<16; ++b) {
		for(a=0; a<8; ++a) {
			i = Font13[b+z] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x, b+y, Hue);
		}
	}
	for(b=0; b<25; ++b) {
		for(a=0; a<8; ++a) {
			i = Font13[b+z+32] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x+8, b+y, Hue);
		}
	}
	return(0);
}

int PutsFont13(BITMAP *bmp,int x,int y, int Hue, char *Str)
{
	char Capture[1800];
	int i;
	int k;
	int pos;
	size_t j;
	int tabpos;
	unsigned int t;

	t=32;
	pos = x;
	j = strlen(Str);
	strcpy(Capture, Str);
	k=(null);
	Capture[j+1] = (k);
	for(k = 0; k < j; ++k) {
		if( Capture[k] < 32 && Capture[k] != 9 ) i = (t);
		else i = Capture[k];
		if(y>0 && Capture[k] != 9 ) {
			BlitFont13(bmp,i,pos,y,Hue);
		}
		if( Capture[k] == 9 ) {
			tabpos=0;
			while( pos-x >= tabpos) tabpos += 40;
			pos = tabpos + x;
		} else if(MonoType==0) pos += Font13[i]-65;
		else pos += 9;
	}
	return(0);
}

int LoadFont18()
{
	int c;

	long z;
	PACKFILE *Fp;

	memset(Font18, (null), 12544);
	SetCurrentFile("\\SYSTEM\\FONTS\\BLOCK18.SFF");
	Fp = pack_fopen(CurrentFile, "rb");
	if ( Fp == 0) return(FontLoadError(CurrentFile));
	for(z = 0; z < 12544; ++z ) Font18[z] = pack_getc(Fp);
	pack_fclose( Fp );
	return(0);
}

int StrLenFont18(char *Str)
{
	char Capture[1800];
	int i;
	int k;
	int pos;
	size_t j;

	pos = 1;
	j = strlen(Str);
	strcpy(Capture, Str);
	if( Capture[j-1] <= 32 ) Capture[j-1] = 32;
	if( Capture[j] <= 32 ) Capture[j] = 32;
	k=(null);
	Capture[j+1] = (k);
	for(k = 0; k < j; ++k) {
		i = Capture[k];
		if( Capture[k] == 9 ) pos = (40 + ((pos/40)*40) );
			else pos += Font18[i]-65;
	}
	return(pos);
}

int BlitFont18(BITMAP *bmp,int TargetChar, int x, int y, int Hue)
{
	int a,b;
	int z;
	unsigned char i;
	static unsigned char BitVal[] = { 128,64,32,16,8,4,2,1 };

	if( TargetChar <= 32 ) return(1);
	z=(TargetChar-30)*64;
	for(b=0; b<30; ++b) {
		for(a=0; a<8; ++a) {
			i = Font18[b+z] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x, b+y, Hue);
		}
	}
	for(b=0; b<30; ++b) {
		for(a=0; a<8; ++a) {
			i = Font18[b+z+32] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x+8, b+y, Hue);
		}
	}
	return(0);
}

int PutsFont18(BITMAP *bmp,int x,int y, int Hue, char *Str)
{
	char Capture[1800];
	int i;
	int k;
	int pos;
	size_t j;
	int tabpos;
	unsigned int t;

	t=32;
	pos = x;
	j = strlen(Str);
	strcpy(Capture, Str);
	k=(null);
	Capture[j+1] = (k);
	for(k = 0; k < j; ++k) {
		if( Capture[k] < 32 && Capture[k] != 9 ) i = (t);
		else i = Capture[k];
		if(y>0 && Capture[k] != 9 ) {
			BlitFont18(bmp,i,pos,y,Hue);
		}
		if( Capture[k] == 9 ) {
			tabpos=0;
			while( pos-x >= tabpos) tabpos += 40;
			pos = tabpos + x;
		} else if(MonoType==0) pos += Font18[i]-65;
		else pos += 9;
	}
	return(0);
}

int LoadFont24()
{
	int c;

	long z;
	PACKFILE *Fp;

	memset(Font24, (null), 12544);
	SetCurrentFile("\\SYSTEM\\FONTS\\BLOCK24.SFF");
	Fp = pack_fopen(CurrentFile, "rb");
	if ( Fp == 0) return(FontLoadError(CurrentFile));
	for(z = 0; z < 12544; ++z ) Font24[z] = pack_getc(Fp);
	pack_fclose( Fp );
	return(0);
}

int StrLenFont24(char *Str)
{
	char Capture[1800];
	int i;
	int k;
	int pos;
	size_t j;

	pos = 1;
	j = strlen(Str);
	strcpy(Capture, Str);
	if( Capture[j-1] <= 32 ) Capture[j-1] = 32;
	if( Capture[j] <= 32 ) Capture[j] = 32;
	k=(null);
	Capture[j+1] = (k);
	for(k = 0; k < j; ++k) {
		i = Capture[k];
		if( Capture[k] == 9 ) pos = (40 + ((pos/40)*40) );
			else pos += Font24[i]-65;
	}
	return(pos);
}

int BlitFont24(BITMAP *bmp,int TargetChar, int x, int y, int Hue)
{
	int a,b;
	int z;
	unsigned char i;
	static unsigned char BitVal[] = { 128,64,32,16,8,4,2,1 };

	if( TargetChar <= 32 ) return(1);
	z=(TargetChar-30)*64;
	for(b=0; b<30; ++b) {
		for(a=0; a<8; ++a) {
			i = Font24[b+z] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x, b+y, Hue);
		}
	}
	for(b=0; b<30; ++b) {
		for(a=0; a<8; ++a) {
			i = Font24[b+z+32] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x+8, b+y, Hue);
		}
	}
	return(0);
}

int PutsFont24(BITMAP *bmp,int x,int y, int Hue, char *Str)
{
	char Capture[1800];
	int i;
	int k;
	int pos;
	size_t j;
	int tabpos;
	unsigned int t;

	t=32;
	pos = x;
	j = strlen(Str);
	strcpy(Capture, Str);
	k=(null);
	Capture[j+1] = (k);
	for(k = 0; k < j; ++k) {
		if( Capture[k] < 32 && Capture[k] != 9 ) i = (t);
		else i = Capture[k];
		if(y>0 && Capture[k] != 9 ) {
			BlitFont24(bmp,i,pos,y,Hue);
		}
		if( Capture[k] == 9 ) {
			tabpos=0;
			while( pos-x >= tabpos) tabpos += 40;
			pos = tabpos + x;
		} else pos += Font24[i]-65;
	}
	return(0);
}

void LoadMapFonts()
{
	LoadFont13();
	LoadFont24();
	LoadFont18();
	LoadBlock11();
}
/* eof */

