/* 12/31/09 */

/* Launcher.c, menu for selecting and running programs */



#include "launcher.h"

int LrDoLaunch(int num)
{
	switch( num )
	{
		case 0:		BmiMode();
				return(0);
		case 1:		BriefingMode();
				return(0);
		case 2:	/*	DosMode(); */
				return(1);
		case 3:		ProgEditMode("NAMELESS.TXT");
				return(0);
		case 4:		Files24Mode();
				return(0);
		case 5:		DataMode();
				return(0);
		case 6:		MathMode();
				return(0);
		case 7:		PeriodicTableMode();
				return(0);
		case 8:		PhoneBookMode();
				return(0);
		case 9:		StarshipMode();
				return(0);
		case 10:	SystemInfoMode();
				return(0);
		case 11:	Text24Mode("NAMELESS.TXT");
				return(0);
		case 12:	ConversionMode();
				return(0);
		case 13:	MapMode();
				return(0);
		case 14:	TimeZoneMode();
				return(0);
		case 15:	BlackjackMode();
				return(0);
		case 16: /*	Chess24Mode(); */
				return(1);
		case 17:	CrosswordMode();
				return(0);
		case 18:	GoMode();
				return(0);
		case 19:	JigsawMode();
				return(0);
		case 20:	KakuroMode();
				return(0);
		case 21:	GatesMode();
				return(0);
		case 22:	PlanetsMode();
				return(0);
		case 23:	View360Mode();
				return(0);
		case 24:	SolitaireMode();
				return(0);
		case 25:	SudokuMode();
				return(0);
		case 26:	WarbirdMode();
				return(0);
		default:	return(1);
	}
}

void LoadRecentProgramList()
{
	PACKFILE *Fp;
	int z;

	SetCurrentFile("\\SYSTEM\\RECENT.LC");
	if ( ( Fp=pack_fopen(CurrentFile, "rb" ))==NULL ) {
		memset(RecentProgs,0,14);
		return;
	} else{
		for(z=0; z<12; z++) RecentProgs[z]=pack_getc(Fp);
	}
	pack_fclose( Fp );
}
void SaveRecentProgramList()
{
	PACKFILE *Fp;
	int z;

	SetCurrentFile("\\SYSTEM\\RECENT.LC");
	if ( ( Fp=pack_fopen(CurrentFile, "wb" ))==NULL ) {
		return;
	} else{
		for(z=0; z<12; z++) pack_putc(RecentProgs[z], Fp);
	}
	pack_fclose( Fp );
}


LCAPP GetProgInfo(int num)
{
LCAPP app[27] = {
{"BODY-MASS INDEX", LILAC},
{"BRIEFING", LILAC},
{"DOS ACCESS", DARKGRAY},
{"EDIT PROGRAM", LILAC},
{"FILES", LILAC},
{"LCARS", BIGBLUE},
{"MATH", LILAC},
{"PERIODIC TABLE", LILAC},
{"PHONEBOOK", LILAC},
{"STARFLEET", BIGBLUE},
{"SYSTEM INFO", BIGBLUE},
{"TEXT 24", LILAC},
{"UNIT CONVERSION", LILAC},
{"WORLD MAP", BIGBLUE},
{"WORLD TIME", BIGBLUE},
{"BLACKJACK", PURPLE},
{"CHESS", DARKGRAY},
{"CROSSWORD", PURPLE},
{"GO", PURPLE},
{"JIGSAW", PURPLE},
{"KAKURO", PURPLE},
{"LAME DESKTOP", MANGO},
{"PLANETS", MANGO},
{"RUNABOUT", MANGO},
{"SOLITAIRE", PURPLE},
{"SUDOKU", PURPLE},
{"WARBIRD", PURPLE},
};

	return(app[num-1]);
}

void LrDebugInfo(int val)
{
	char ValStr[8];

	rectfill(screen,339,13,360,27+12,PALEBLUE);
	itoa(val,ValStr,10);
	PutsLuna(340,20,BLACK,PALEBLUE, ValStr);
}


int LauncherRefresh(char col)
{
	int bottom,z,x;
	int head, listlength;
	LCAPP item;

	if(col==1) {
		z=1;
		x=15+((col)*175);
		rectfill(screen,x-176,112,x,550, BLACK);
		while(RecentProgs[z-1] !=0) {
			item=GetProgInfo(RecentProgs[z-1]);
			RightPutsFont19(x,88+(z*24),item.color,item.name);
			z++;
		}
		listlength=z-1;
		return(listlength);
	}
	if(col==2) {
		head=0;
		listlength=15;
	}
	if(col==3) {
		head=15;
		listlength=12;
	}
	if(col==4) {
		listlength=0;
		return(listlength);
	}

	x=15+((col)*175);

	rectfill(screen,x-176,112,x,550, BLACK);
	bottom=listlength;

	for(z=1;z<=bottom;++z) {
		item=GetProgInfo(z+head);
		RightPutsFont19(x,88+(z*24),item.color,item.name);
	}
	return(listlength);
}

void LauncherScreen()
{
	int capX;

	rectfill(screen,0,0,800,600, BLACK);
	PopsicleSticks(PALEBLUE);
	capX=ColorTitle("SELECT PROGRAM",ORANGE);
/*	PutsLuna(capX,20,BLACK,PALEBLUE,"LCARS 24 LIBRARY"); */
	min_old=70;
	PePutTime(ORANGE);
	LeftArrowSymbol(228, 566, BLACK);
	RightArrowSymbol(253, 566, BLACK);
	DownArrowSymbol(278, 566, BLACK);
	UpArrowSymbol(303, 566, BLACK);
	PutsLuna(679,566, BLACK,LILAC, "CLOSE: ESC");
}


void LrTest(int num)
{
	LCAPP item;
	char message[64];

	rectfill(screen,439,13,660,27+12,PALEBLUE);
	item=GetProgInfo(num);
	strcpy(message, item.name);
	strcat(message, " NOT INSTALLED");
	PutsLuna(440,20,BLACK,PALEBLUE, message);
}

void LrCursor(char cx, char cy, char cmd)
{
	int gx,gy;

	gx=206+((cx-1)*175);
	gy=90+(cy*24);
	if(cmd==0) EnterSymbol(gx,gy,1,BLACK);
		else EnterSymbol(gx,gy,1,WHITE);
}

void LrUpdateRecent(int num)
{
	char label[24];
	char filecountstr[8];
	int filecount;
	int z, existing;

	if(num==3 || num==17) return; /* DOS box, chess */

	existing=80;
	for(z=0; z<12; z++) if(RecentProgs[z]==num) existing=z;
	LrDebugInfo(existing);

	if(existing !=80) for(z=existing; z<12; z++) RecentProgs[z]=RecentProgs[z+1];


	for(z=11; z>0; z--) RecentProgs[z]=RecentProgs[z-1];

	RecentProgs[0]=num;


	filecount=LauncherRefresh(1);
	LrListLength[0]=filecount;
	itoa(filecount,filecountstr,10);
	strcpy(label, "RECENT: ");
	strcat(label, filecountstr);
	OfflineType4(60,60, LrMenuColor[0], label);

}

int LauncherMenuControl()
{
	int c, OffsetHolder;
	int cx,cy,num;

	cx=cy=1;
	LrOffset[cx-1]=0;
	c=0;
	LrCursor(1,1,1);
	c=PanelBeep();

newcx:
	cy=1;
	LrOffset[cx-1]=0;

loopback:
	do {
		PePutTime(ORANGE);
	} while(!keypressed());
	c = GetKey();
	switch( c )
	{
		case ESC: 	return(27);
		case 13:        if(cx==1) num=RecentProgs[cy-1];
				if(cx==2) num=cy;
				if(cx==3) num=cy+15;
				LrTest(num);
				/* if(cx==2 || cx==3) */ LrUpdateRecent(num);
				SaveRecentProgramList();
				if(LrDoLaunch(num-1) !=0) goto loopback;
				return(0);

/*				goto loopback; */
		case HOMEKEY: 	if(cy==1) goto loopback;
                                OffsetHolder = LrOffset[cx-1];
				LrCursor(cx,cy-LrOffset[cx-1],0);
				cy=1;
				LrOffset[cx-1]=0;
				LrCursor(cx,cy-LrOffset[cx-1],1);
				if(LrOffset[cx-1] != OffsetHolder) LauncherRefresh(cx);
				goto loopback;
		case ENDKEY: 	if(cy==LrListEnd[cx-1]) goto loopback;
                                OffsetHolder = LrOffset[cx-1];
				LrCursor(cx,cy-LrOffset[cx-1],0);
				cy=LrListLength[cx-1];
				LrOffset[cx-1]=LrListEnd[cx-1]-10;
				if(cy < 15) LrOffset[cx-1]=0;
				LrCursor(cx,cy-LrOffset[cx-1],1);
				if(LrOffset[cx-1] != OffsetHolder) LauncherRefresh(cx);
				goto loopback;
		case PGUPKEY: 	if(cy==1) goto loopback;
                                OffsetHolder = LrOffset[cx-1];
				LrCursor(cx,cy-LrOffset[cx-1],0);
				cy-=17;
				LrOffset[cx-1]-=17;
				if(cy < 1) {
					cy=1;
                                        LrOffset[cx-1]=0;
				}
				if(cy > LrListLength[cx-1]) cy=LrListLength[cx-1];
				LrCursor(cx,cy-LrOffset[cx-1],1);
				if(LrOffset[cx-1] != OffsetHolder) LauncherRefresh(cx);
				goto loopback;
		case PGDNKEY: 	if(cy >= LrListLength[cx-1]) goto loopback;
/*				if(LrListLength[cx-1]<18) goto loopback; */
				OffsetHolder = LrOffset[cx-1];
				LrCursor(cx,cy-LrOffset[cx-1],0);
				cy+=18;
				LrOffset[cx-1]+=18;
				if(cy>=LrListEnd[cx-1]-18) {
					cy=LrListEnd[cx-1];
					LrOffset[cx-1]=LrListEnd[cx-1]-13;
				}
				if(cy > LrListLength[cx-1]) {
					LrOffset[cx-1]-=cy-LrListLength[cx-1];
  					cy=LrListLength[cx-1];
				}
				if(cy < 18) LrOffset[cx-1]=0;
				LrCursor(cx,cy-LrOffset[cx-1],1);
				if(LrOffset[cx-1] != OffsetHolder) LauncherRefresh(cx);
				goto loopback;
		case UPARROW: 	if(cy==1) goto loopback;
				LrCursor(cx,cy-LrOffset[cx-1],0);
				--cy;
				if(cy-LrOffset[cx-1] < 1) {
					--LrOffset[cx-1];
					LauncherRefresh(cx);
				}
				LrCursor(cx,cy-LrOffset[cx-1],1);
				goto loopback;
		case DOWNARROW: if( cy >= LrListLength[cx-1]) goto loopback;
				LrCursor(cx,cy-LrOffset[cx-1],0);
				++cy;
				if(cy-LrOffset[cx-1] > 18) {
					++LrOffset[cx-1];
					LauncherRefresh(cx);
				}
				LrCursor(cx,cy-LrOffset[cx-1],1);
				goto loopback;
		case LEFTARROW:
				if(cx==1) goto loopback;
				LrCursor(cx,cy-LrOffset[cx-1],0);
				OffsetHolder = LrOffset[cx-1];
				LrOffset[cx-1] = 0;
				if(OffsetHolder !=0) LauncherRefresh(cx);
				cx--;
				cy=1;
				LrCursor(cx,cy-LrOffset[cx-1],1);
				LrOffset[cx-1]=0;
				goto newcx;
		case RIGHTARROW:
				if(cx==3) goto loopback;
				LrCursor(cx,cy-LrOffset[cx-1],0);
				OffsetHolder = LrOffset[cx-1];
				LrOffset[cx-1] = 0;
				if(OffsetHolder !=0) LauncherRefresh(cx);
				cx++;
				cy=1;
				LrCursor(cx,cy-LrOffset[cx-1],1);
				LrOffset[cx-1]=0;
				goto newcx;
		case 350: 	Screenshot792("Launch8.bmp");
				c=PanelBeep();
				goto loopback;
		case 351: 	Screenshot1024("Launch10.bmp");
				c=PanelBeep();
				goto loopback;
		default: 	c=ScoldUser();
				goto loopback;
	}

	return(0);
}

int LauncherWindowActive()
{
	char label[24];
	char filecountstr[8];
	int filecount;

	LrMenuColor[0]=LAVENDER;
	LrMenuColor[1]=LILAC;
	LrMenuColor[2]=PURPLE;
	LrMenuColor[3]=DARKGRAY;
	LrOffset[0]=0;
	LrOffset[1]=0;
	LrOffset[2]=0;
	LrOffset[3]=0;
	LauncherScreen();
	LoadRecentProgramList();
	filecount=LauncherRefresh(1);
	LrListLength[0]=filecount;
	itoa(filecount,filecountstr,10);
	strcpy(label, "RECENT: ");
	strcat(label, filecountstr);
	OfflineType4(60,60, LrMenuColor[0], label);
	filecount=LauncherRefresh(2);
	LrListLength[1]=filecount;
	itoa(filecount,filecountstr,10);
	strcpy(label, "UTIL/REF: ");
	strcat(label, filecountstr);
	OfflineType4(60+175,60, LrMenuColor[1], label);
	filecount=LauncherRefresh(3);
	LrListLength[2]=filecount;
	itoa(filecount,filecountstr,10);
	strcpy(label, "GAME/SIM: ");
	strcat(label, filecountstr);
	OfflineType4(60+(175*2),60, LrMenuColor[2], label);
	filecount=LauncherRefresh(4);
	LrListLength[3]=filecount;
	itoa(filecount,filecountstr,10);
	strcpy(label, "EXTERN (OFF): ");
	strcat(label, filecountstr);
	OfflineType4(60+(175*3),60, LrMenuColor[3], label);
	return(LauncherMenuControl());
}

