/* WARBIRD, the tic-tac-toe app for LCARS 24 */
/* Powered by a school assignment by Alastair Francis */
/* No copyright stated */
/* The opponent is always X, displayed as a Romulan Warbird. */
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#ifndef WARBIRD_H
#define WARBIRD_H


#include "lcars24.h"
#include "parts.h"
#include "getkey.h"
#include "mars28.h"
#include "brack1.h"
#include "wb3.h"
#include "wb5.h"


int BoardX;
int BoardY;
char WbGameOver;
char InProgress;
int WbSqSize;
PALETTE the_palette;
BITMAP *bmp1,*rom,*voy; /* background snapshot, Romulans, Voyager */
char Scratchpad9[9];
char Scratchpad25[25];
int HumanMove;
int Wb5HumanMove;
int Wb3Level, Wb5Level;
char OpponentGoesFirst;
char WbPlayMode;


void Wb5GrayMessage(char *message);
void Wb5PrimeCursor();
void Wb5EraseCursor();
void Wb5DrawCursor();
void Wb5UnparkCursor();
int Wb5ParkCursor();
int Wb5MarkPlayerSpot();
int Wb5MarkOpponenSpot();
void Wb5CursorLeft();
void Wb5CursorRight();
void Wb5CursorUp();
void Wb5CursorDown();
void WbClearBottom();
void Wb5Clear();
void WbPrimeCursor();
void WbEraseCursor();
void WbDrawCursor();
void Wb3UnparkCursor();
int WbParkCursor();
int WbMarkPlayerSpot();
int WbMarkOpponenSpot();
void WbCursorLeft();
void WbCursorRight();
void WbCursorUp();
void WbCursorDown();
void WbBox1a(int Hue);
void WbBox2a(int Hue);
void WbBox1b(int Hue, char *Str1, char *Str2);
void WbBox2b(int Hue, char *Str1, char *Str2);
void WbBox3b(int Hue, char *Str1, char *Str2);
void WbBox4b(int Hue, char *Str1, char *Str2);
void WbBox5b(int Hue, char *Str1, char *Str2);
int WbBoxBlank(int Hue);
void WbElbowSignage(int Hue1, int Hue2);
void WbBoxes();
void WbPostTieGame();
void Wb5PostTieGame();
void Wb3PostWinner(int Winner);
void Wb5PostWinner(int Winner);
void Wb5NewGame();
void Wb3NewGame();
void Wb5GetPlayerTypeX(Wb5PlayerType* a_Wb5Player);
void Wb5GetPlayerTypeO(Wb5PlayerType* a_Wb5Player);
void Wb3GetPlayerTypeX(Wb3PlayerType* a_Wb3Player);
void Wb3GetPlayerTypeO(Wb3PlayerType* a_Wb3Player);
int WbSetWhoGoesFirst();
void WbPostSkillLevel();
int Wb5SetSkillLevel();
int WbSetSkillLevel();
Wb5GamePiece Wb5GetWhoGoesFirst();
Wb3GamePiece WbGetWhoGoesFirst();
int Warbird3WindowActive(int redraw);
int Warbird5WindowActive();
void Wb5ShowStars();
void WbShowStars();
int WbDrawGrid();
int Wb5DrawGrid();
int Wb3Screen();
int Wb5Screen();
void Wb5Brackets();
void Wb5Box(int Hue, int Pos, char *Label1, char *Label2);
void Wb5MessageBoxes();
void Wb5LowerMessageBoxes();
int Wb5Screen();
int WarbirdMode();

#endif

