/* Htmview, to display a Web page */
/* Usage: OpenHtml(char *filespec) to take a snapshot of the screen
		then restore it when the viewer closes, or
		or LcHtml(char *filespec) to call the viewer directly
*/

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#ifndef HTMVIEW_H
#define HTMVIEW_H


#include "htmproc.h"
#include "htmload.h"
#include "winfont.h"
#include "jpeg.h"
#include "algif.h"

void Info(int y); /* just for debugging */
void SetDefault();
void LoadBackImage();
int HtmlDisplayJpeg(char *filespec, int x, int y);
int HtmlDisplayBmp(char *filespec, int x, int y);
int HtmlDisplayGif(char *filespec, int x, int y);
void ProcessImage(int y);
void CenterHeadline();
int TranslateGlyph();
int InvokeTag(int TagX);
void HtmlDrawOrderedListNumber(BITMAP *bmp,int y);
void HtmlDrawBullet(int y);
int OutputText();
void HtmlDrawPointer(int txty);
void HtmlLargeFileRefresh(int txty);
int HtmlLargeFileControl(int txty );
void HtmlRender(int txty);
void HtmlRefresh(int txty);
int HtmlControl(int txty );
int LcHtml(char *filespec);
int OpenHtml(char *filespec);

#endif

