/*    cards.h, reusable routines for card games */
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#ifndef CARDS_H
#define CARDS_H


#include "lcars24.h"
#include "headline.h"
#include "scrnshot.h"

int cw; /* card width (initialize to 71) */
int ch; /* card height (initialize to 100) */
char Animate; /* initialize to 0 */
BITMAP *faces;
PALETTE faces_palette;


void Down0(int x,int y);
void Down1(int x,int y);
void Down2(int x,int y);
void Down3(int x,int y);
void Down4(int x,int y);
void Down5(int x,int y);
void Down6(int x,int y);
void Down7(int x,int y);
void Down8(int x,int y);
void Down9(int x,int y);
void DownO(int x,int y);
void DownA(int x,int y);
void DownJ(int x,int y);
void DownK(int x,int y);
void DownQ(int x,int y);

int shuffle(int *deck, int n_cards);
int DrawDownCard(int x, int y, int Full);
void DrawSmallSpots(int x, int y, char *suit);
void CenterSpot(int x, int y, char *suit);
void TwoSpots(int x, int y, char *suit);
void FourSpots(int x, int y, char *suit);
void SixSpots(int x, int y, char *suit);
void EightSpots(int x, int y, char *suit);
void DrawAce(int x, int y, char *suit);
void Draw2(int x, int y, char *suit);
void Draw3(int x, int y, char *suit);
void Draw4(int x, int y, char *suit);
void Draw5(int x, int y, char *suit);
void Draw6(int x, int y, char *suit);
void Draw7(int x, int y, char *suit);
void Draw8(int x, int y, char *suit);
void Draw9(int x, int y, char *suit);
void Draw10(int x, int y, char *suit);
void DrawJack(int x, int y, char *suit);
void DrawQueen(int x, int y, char *suit);
void DrawKing(int x, int y, char *suit);
void DrawPhantom(int px, int py, int NumCards);
int DrawCard(int x, int y, int value);
void DelayedShutdown();

#endif

