/* Calendar functions of LCARS 24 */

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#ifndef CALENDAR_H
#define CALENDAR_H


#include "lcars24.h"
#include "parts.h"
#include "getkey.h"
#include "mars28.h"
#include "brack1.h"
#include "playwav.h"
#include "lccolor.h"
#include "standby.h"
#include "scrnshot.h"
#include "headline.h"
#include "alarm.h"


int IsLeap(int yr);
int PutCalendarTitle(int yy, int mm, int x, int y, int Color);
void PutDayOfWeek(int Day);
void PutCalendar(int StartingDay, int LengthOfMonth, int offset);
int GetWhichCalendar(int Year);
int GetStartingDayOfMonth(int WhichCalendar, int WhichMonth);
int GetLengthOfMonth( int WhichCalendar, int mm);
void CalendarControl(int yy, int mm, int dd, int wd);
void PutDate();


#endif

