/* Ferengi Blackjack for LCARS 24 */
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#ifndef BLACKJAK_H
#define BLACKJAK_H


#include "lcars24.h"
#include "cards.h"
#include "brack1.h"
#include "parts.h"
#include "getkey.h"
#include "playwav.h"
#include "headline.h"
#include "scrnshot.h"
#include "lcreader.h"


int BjDrawSpot(int x, int y);
void BjBox1a(int Hue);
void BjBox2a(int Hue);
void BjClearBox2a();
void BjBox1b(int Hue, char *Str);
void BjBox2b(int Hue);
void BjBox3b(int Hue);
void BjBox4b(int Hue);
void BjBox5b(int Hue);
void BjElbowSignage(int Hue1, int Hue2);
void BjBoxes();
int BlackjackHelp();
int BjCardVal(int CardCode);
int GetBasicStrategy();
int DisplayL2Count(int Value);
int DisplayCount(int Value);
int GetCountAdvice();
int GetL2CountAdvice();
void DisplayCountAdvice();
void DisplayBasicStrategy();
void EraseDisplayOfBasicStrategy();
void BjNoticeButton(int hand);
void BjEnterPrompt(int Col1, int Col2, char *Message);
void ShufflePrompt();
void UpperOptionPrompt(char *Message);
void EraseUpperOptionPrompt();
void LowerOptionPrompt(char *Message);
void EraseLowerOptionPrompt();
void DoubleAfterSplitPrompt();
void UpDownPrompt(char *Message);
void HitStandPrompt();
void BetPrompt();
void PairSplitPrompt();
void DealerWinMessage();
void PlayerWinMessage();
void PostDealerScore();
void PostPlayerScore();
void PostHand1Score();
void PostHand2Score();
void PostHand3Score();
void PostHand4Score();
void PushMessage();
void PayBlackjackMessage();
void InsurancePayoffMessage();
void BjDrawStock();
void ShufflingMessage();
void EmergencyShuffle();
void NewShuffle();
void ReportStake();
void DrawBettingArea();
void DrawBettingMessage();
void DrawLatinum(int a, int b);
void DrawLatinumToBuffer(int a, int b);
void DrawOneRowOfLatinum(int amount, int tier);
void DrawStake();
void BjDisplayNew();
void ShowDealerHoleCard();
void SellInsurance();
void BjNewHand();
int DealerHit();
int BjAcknowledge();
void ShowSplitWinnings(int hand, int Amount);
void ShowWinnings();
void PayInsurance();
void SpreadLatinumBet(int x, int y, int Amount);
int ChangeBet(int x, int y, int Amount);
void BjTakesnapshot();
void BjRestoreBackground();
void RestoreFromHand2();
void RestoreFromHand3();
void PlaceInsurance();
void BjPush();
int SplitResultMessage(int Hand, char *Str);
void CheckEachSplitHand();
void CheckForPlayerWin();
void CheckForDealerWin();
int PlayerBust();
int PlayerHasBlackjack();
int PlayerStand();
int PlayerHit();
int BjDeal();
int UndoBet();
int PlaceSplitBet(int Hand);
int PlaceDoubleDown();
int PlaceSplitDoubleDown(int Hand);
int PlaceBet(int Amount);
int ReduceBet(int Amount);
int SplitHit();
int SplitPair();
int SplitStand();
int BlackjackWindowActive();
void BjInit();
int BlackjackMode();

#endif

