/* Htmlproc, part 1 of the LCARS 24 Web-page renderer */

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "htmproc.h"

/* Universal instruction reader **********************************/
/* Usage:	Result=ParseTagbuf(Tagbuf, "src");				*/
/*		Tagbuf: img src="mydog.gif" width="200" height="400"	*/
/*		Declared array ParseResult filled as: mydog.gif  		*/
/*		Returns 0 upon success, 86 upon failure			*/
/*		Works for items with or without quote marks		*/
/*		Not case sensitive										*/
/*****************************************************************/
int ParseTagbuf(char *s, char *w)
{
	int j, cliff, Result;
	int c=32;  /* becomes 34 if quote found after equal sign */
	size_t slen, wlen;
	int pos=0;

	wlen=strlen(w);
	slen=strlen(s);
	cliff=(slen-wlen)-2;  /* danger point for string comparison */

	while(strnicmp(s,w,wlen) !=0 && pos < cliff) {
		s++;
		pos++;
	}

	s += wlen;

	if( *s == '=' ) {
		s++;
		Result=0;		  /* The tagbuf has what you asked for. */
		if( *s == 34) {  /* Dealing with quote marks.			 */
			s++;	  /* Some tags use them; some don't.	 */
			c=34;	 /* If not, c=32, as assigned.			*/
		}
	} else {
		Result=86;
	}
	if(Result==0) {  /* Deliver the goods */
		memset(ParseResult,(null),100);
		j=0;
		while( *s != c ) {  /* c=quote mark if made so above */
			if( *s==0 | *s== '>') break; /* guard rail */
			t=*s;
			ParseResult[j]=(t);
			j++;
			s++;
		}
	}

	return(Result);
}


int GetNamedColor(char *ColorName)
{
	if(stricmp(ColorName,"black")==0) return(BLACK);
	if(stricmp(ColorName,"green")==0) return(WEB_GREEN);
	if(stricmp(ColorName,"silver")==0) return(WEB_SILVER);
	if(stricmp(ColorName,"lime")==0) return(WEB_LIME);
	if(stricmp(ColorName,"gray")==0) return(WEB_GRAY);
	if(stricmp(ColorName,"olive")==0) return(WEB_OLIVE);
	if(stricmp(ColorName,"white")==0) return(WHITE);
	if(stricmp(ColorName,"yellow")==0) return(WEB_YELLOW);
	if(stricmp(ColorName,"maroon")==0) return(WEB_MAROON);
	if(stricmp(ColorName,"navy")==0) return(WEB_NAVY);
	if(stricmp(ColorName,"red")==0) return(WEB_RED);
	if(stricmp(ColorName,"blue")==0) return(WEB_BLUE);
	if(stricmp(ColorName,"purple")==0) return(WEB_PURPLE);
	if(stricmp(ColorName,"teal")==0) return(WEB_TEAL);
	if(stricmp(ColorName,"fuchsia")==0) return(WEB_FUCHSIA);
	if(stricmp(ColorName,"aqua")==0) return(WEB_AQUA);
	return(-1);
}
int hex2i(char *s) /* converts two-char hex string to 1-byte int value */
{	           /* called by the function below */
	int Result;

	Result=-1;

	if(*s > 47 && *s < 58) Result=(*s-48)*16;	  /* 0 to 9 */
	if(*s > 64 && *s < 71) Result=(*s-65+10)*16;  /* A to F */
	if(*s > 96 && *s < 103) Result=(*s-97+10)*16; /* a to f */
	if(Result == -1) return(-1);  				/* bad input */

	s++;
	if(*s > 47 && *s < 58) Result+=*s-48;
	if(*s > 64 && *s < 71) Result+=(*s-65+10);
	if(*s > 96 && *s < 103) Result+=(*s-97+10);
	if(Result == -1) return(-1);

	return(Result);
}
int ParseColorSpec(char *s)
{
	char rgb[3][3];
	int r,g,b;

	if(*s=='#') {
		s++;
		rgb[0][0]=*s;
		s++;
		rgb[0][1]=*s;
		s++;
		rgb[1][0]=*s;
		s++;
		rgb[1][1]=*s;
		s++;
		rgb[2][0]=*s;
		s++;
		rgb[2][1]=*s;
		return(makecol(hex2i(rgb[0]),hex2i(rgb[1]),hex2i(rgb[2])));
	} else return(GetNamedColor(s));
}
void ProcessBodySpecs()
{
	int tr,tg,tb,br,bg,bb;

	if(ParseTagbuf(BodyTag, "bgcolor")==0) {
		BackgroundColor=ParseColorSpec(ParseResult);
	} else BackgroundColor=BLACK;
	TableColor=BackgroundColor;
	CellColor=BackgroundColor;
	if(ParseTagbuf(BodyTag, "text")==0) {
		TextColor=ParseColorSpec(ParseResult);
	} else TextColor=WHITE;

	tr=getr(TextColor);
	tg=getg(TextColor);
	tb=getb(TextColor);
	br=getr(BackgroundColor);
	bg=getg(BackgroundColor);
	bb=getb(BackgroundColor);
/* if(br>0x90 && bg>0x90 && bb>0x90 && tr>0x60 && tg>0x60 && tb>0x60) */
if(br+bg+bb > 510 && tr+tg+tb > 510) BackgroundColor=BLACK;
/*
	if(ParseTagbuf(BodyTag, "leftmargin")==0) {
		DefaultLeftMargin=atoi(ParseResult);
		BaseLeftMargin=DefaultLeftMargin;
		LeftMargin=BaseLeftMargin;
	}
*/
}
void ProcessTableSpecs()
{
	int Width;

	if(ParseTagbuf(TableTag, "bgcolor")==0) {
		TableColor=ParseColorSpec(ParseResult);
		CellColor=TableColor;
	}
	if(ParseTagbuf(TableTag, "width")==0) {
		Width=atoi(ParseResult);
		if(ParseResult[strlen(ParseResult)-1]=='%')
			Tablewidth=Tablewidth*Width/100;
				else Tablewidth=Width;
	}

	if(Tablewidth > 774) Tablewidth=774;
/*	Cellwidth=Tablewidth; */
/*	rm=(Tablewidth/10)+DefaultLeftMargin; */
	if(ParseTagbuf(TableTag, "cellspacing")==0) Cellspacing=atoi(ParseResult);
	if(ParseTagbuf(TableTag, "cellpadding")==0) Cellpadding=atoi(ParseResult);

}
void ProcessCellSpecs()
{
	int Width;

	rm=90;
	if(ParseTagbuf(TableTag, "width")==0) {
		Width=atoi(ParseResult);
		if(ParseResult[strlen(ParseResult)-1]=='%')
			Cellwidth=Tablewidth*Width/100;
				else Cellwidth=Width;
	}
	if(Cellwidth > Tablewidth) Cellwidth=Tablewidth;
	rm=((Cellwidth/8)*(Cellnumber+1))+Cellpadding;

	if(ParseTagbuf(TableTag, "bgcolor")==0)
		CellColor=ParseColorSpec(ParseResult);


	rectfill(workbuf,CellRight,HtmlGraphicY-3,CellRight+Cellwidth,4810,CellColor);
	CellRight+=Cellwidth;

	if(ParseTagbuf(TableTag, "cellspacing")==0) Cellspacing=atoi(ParseResult);
	if(ParseTagbuf(TableTag, "cellpadding")==0) Cellpadding=atoi(ParseResult);
}
void HtmDefaultColors()
{
	BackgroundColor=BLACK;
	TableColor=BLACK;
	CellColor=BLACK;
	TextColor=WHITE;
	Bold=FALSE;
	WEB_GREEN=makecol(0x00,0x80,0x00);
	WEB_SILVER=makecol(0xC0,0xC0,0xC0);
	WEB_LIME=makecol(0x00,0xFF,0x00);
	WEB_GRAY=makecol(0x80,0x80,0x80);
	WEB_OLIVE=makecol(0x80,0x80,0x00);
	WEB_YELLOW=makecol(0xFF,0xFF,0x00);
	WEB_MAROON=makecol(0x80,0x00,0x00);
	WEB_NAVY=makecol(0x00,0x00,0x80);
	WEB_RED=makecol(0xFF,0x00,0x00);
	WEB_BLUE=makecol(0x00,0x33,0x99);
	WEB_PURPLE=makecol(0x80,0x00,0x80);
	WEB_TEAL=makecol(0x00,0x80,0x80);
	WEB_FUCHSIA=makecol(0xFF,0x00,0xFF);
	WEB_AQUA=makecol(0x00,0xFF,0xFF);
	LinkColor=WEB_GREEN;
	VlinkColor=WEB_MAROON,
	AlinkColor=WEB_BLUE;
	memset(TagBuf,(null),1024);
	memset(ImageTag,(null),1024);
	memset(BodyTag,(null),1024);
	memset(TableTag,(null),1024);
	Cellspacing=8;
	Cellpadding=8;
	Cellnumber=0;
	Tablewidth=774;
	CellRight=0;
	IgnoreLinebreak=FALSE;
	LastWidth=0;
	BaseLeftMargin=10;
	LeftMargin=10;
}

