/*  Giveview.c, to show a small animated gif in double width and height */
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file \LCARS24\DATA\COPYING.TXT for details.
 */


#include "gifview.h"


void ticker(void)
{
    ticks++;
}

int QuickGifView(char *filespec)
{
	BITMAP **frames;
	int *durations;
	int i, n, e, a, b;

	ticks = 0;
	if( ! exists(filespec) ) {
		allegro_message("Could not open %s.\n", filespec);
		return(-1);
	}

	n = algif_load_animation(filespec, &frames, &durations);

	if(!n) {
		allegro_message("Could not open %s.\n", filespec);
		return(-1);
	}

	install_int_ex(ticker, BPS_TO_TIMER(100));


	BITMAP *buf = create_bitmap(640,348);
	clear_to_color(buf, BLACK);


	a=320;
	if(frames[0]->w < 320) a=frames[0]->w;
	b=174;
	if(frames[0]->h < 174) b=frames[0]->h;


	for(i = 0; i < n; i++) {
		vsync();
		draw_sprite(buf, frames[i], 0, 0);
		vsync();
		stretch_blit(buf, screen,0,0,a,b,120,242,640,348);
		e = ticks + durations[i];
		while(ticks < e ) rest(2);
	}

	if(n) {
		for(i = 0; i < n; i++) destroy_bitmap(frames[i]);
		free(frames);
		free(durations);
	}
	destroy_bitmap(buf);
	rectfill(screen,120,242,760,590,BLACK);
	return(0);
}

/* eof */




