
/*	GetKey.c, keyboard handlers for LCARS 24  */
/* 	Windosws version */


#include "getkey.h"

int GetKey(void)
{
	int key, lo, hi, Result;

	key=readkey();
	if(key==0x5200) return(key);  /* left */
	if(key==0x5300) return(key);  /* right */
	if(key==0x3F08) return(key);  /* backspace */
	if(key==0x4140) return(91);  /* open bracket */
	if(key==0x425B) return(93);  /* close bracket */
	if(key==0x465D) return(92);  /* backslash */
	if(key==0x4160) return(123);  /* open brace */
	if(key==0x427B) return(125);  /* close brace */

	lo=key & 0x00FF;
	hi=(key & 0xFF00) >> 8;
	Result=( (lo == 0) ? hi : lo );
	IdleTime=0;
	if(lo == 0) {
		simulate_ukeypress(key,hi);
		ureadkey(NULL);
		if (key_shifts & KB_SHIFT_FLAG) key += 1;
		if (key_shifts & KB_CTRL_FLAG) key += 2;
		if (key_shifts & KB_ALT_FLAG) key += 4;
		clear_keybuf();
		if(key==0x6500) return(58);  /* colon */
		if(key==0x6501) return(42);  /* asterisk */
		if(key==0x6300) return(64);  /* at sign */
		if(key==0x6301) return(96);  /* backquote */

		return(key);
	} else return(Result);
}
END_OF_FUNCTION(GetKey)

int ShiftKeyStatus()
{
	ureadkey(0);
	if(key_shifts & KB_SHIFT_FLAG) return(2);
		else return(0);
}
int ControlKeyStatus()
{
	ureadkey(0);
	if(key_shifts & KB_CTRL_FLAG) return(1);
		else return(0);
}
int AltKeyStatus()
{
	ureadkey(0);
	if(key_shifts & KB_ALT_FLAG) return(4);
		else return(0);
}
int is_filechar(char c)
{
	/* check if a character is valid for controlled filename input */

	 c=tolower(c);
	 return ( ((c>='0') && (c<='9')) || ((c>='a') && (c<='z')) ||
		 (c=='_') || (c==':') || (c=='?') || (c=='.') || (c=='-'));
}


