/* second part of the file manager FILES 24 */

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "files24.h"


void DrawF24W1()
{
	F24EraseUpperElbows();
	F24Bumpers();
	MaxX=440;
	MaxY=MidY;
	MinY=13;
	F24NeElbow();
	F24SeElbow();
	F24UpperMessageBoxes();
}
void F24W1Cursor()
{
	int gx,gy;

	if(OldF1x==1) gx=53+((F24W1Info[OldF1y+1][2]*19)-19);
	if(OldF1x==2) gx=202+((F24W1Info[OldF1y+1][2]*19)-19);
	gy=17+44+((OldF1y-F24W1Offset)*36)-36;
	EnterSymbol(gx,gy,1,BLACK); /* F24W1Refresh helps erase old cursor */
	if(F1x==1) gx=53+((F24W1Info[F1y+1][2]*19)-19);
	if(F1x==2) gx=202+((F24W1Info[F1y+1][2]*19)-19);
	gy=17+44+((F1y-F24W1Offset)*36)-36;
	if(F1x<3) EnterSymbol(gx,gy,1,NAPLES);
	OldF1x=F1x;
	OldF1y=F1y;
}
int F24W1FindParent(int Level)
{
	int i;

	i=F1y;
	while( i>2 && F24W1Info[i][2] > Level-1) --i;
	return(i);
}
void F24W1Open()
{
	int bottom,p1,p2,z;
	char TruncateStr[80]; /* to prevent Windows from displaying
				 a long filename */

	p1=F24W1Info[OldF1y+1][2]*19; /* nesting level of folder to highlight */
	p2=F24W1Info[F24W1Current+1][2]*19; /* nesting level of folder to unhighlight */
	if(F24W1Current-F24W1Offset < 7 && F24W1Current-F24W1Offset > 0)
	F24SelectFolder(51+p2,((F24W1Current+1-F24W1Offset)*36)-36+16,F24W1Folders[F24W1Current+1],ORANGE);
	F24SelectFolder(51+p1,((F1y+1-F24W1Offset)*36)-36+16,F24W1Folders[F1y+1],NAPLES);
	F24W1Info[F1y+1][3]=1;
	F24W1Info[F24W1Current+1][3]=0;
	F24W1Current=F1y;

	F24W1CurrentPathElement=F1y-1;
	strcpy(F24W1ListTitle,F24W1FullPath[F24W1CurrentPathElement]);
	rectfill(screen,12,MidY-26,297,MidY,LILAC);
	rectfill(screen,10,MidY-10+24,264,558,BLACK);
	PutsLuna(43,MidY-19,BLACK,LILAC,MakeDisplayName(F24W1ListTitle));

	strcpy(F24W2Path,F24W1ListTitle);
	strcpy(F24W2PastePath,F24W1ListTitle);
	strcat(F24W2Path,"\\");
	strcat(F24W1ListTitle,"\\*.*");
	F24FindFiles(F24W1ListTitle);
	F24SortFiles();
	for(z=0;z<=NumOfFiles;++z) strcpy(F24W2List[z], F24FileArray[z]);
	F24W2EndList=NumOfFiles;
	bottom=F24W2EndList;
	F24W1Refresh();
	F24W1Cursor();
	if(F24W2EndList>8) bottom=8;
	for(z=0;z<=bottom;++z) {
		strcpy(TruncateStr, F24W2List[z]);
		TruncateStr[12]=(null);
		RightPutsFont19(174,MidY-10+(z*24), PALEBLUE,TruncateStr);
	}
	F24W2Offset=0;
	F2y=1;
	OldF2y=1;
	F24W2Open=TRUE;
}
void F24W1Contract( int Level)
{
	int i, Count;

	i=F1y+2;
	while( i<F24W1EndList && F24W1Info[i][2] >= Level) ++i;
	Count=i-(F1y+2);
	for(i=F1y+2; i<=F24W1EndList-Count; ++i) {
		strcpy(F24W1Folders[i],F24W1Folders[i+Count]);
		strcpy(F24W1FullPath[i-2],F24W1FullPath[i-2+Count]);
		F24W1Info[i][0]=F24W1Info[i+Count][0];
		F24W1Info[i][1]=F24W1Info[i+Count][1];
		F24W1Info[i][2]=F24W1Info[i+Count][2];
		F24W1Info[i][3]=F24W1Info[i+Count][3];
	}
	F24W1EndList-=(Count);
	if(F24W1Current>F1y) F24W1Current-=Count-1;
}
void F24W1Expand()
{
	struct al_ffblk fblock;
	int Found,z;
	char mask[128];
	int Count,Parent,NestingLevel;

	strcpy( mask, LcarsPath);
	strcat( mask, "\\");
	NestingLevel=F24W1Info[F1y+1][2];
	if(NestingLevel==2) {			  	/* for deeper nesting */
		Parent=F24W1FindParent(2);
		strcat(mask,F24W1Folders[Parent]);
		strcat(mask,"\\");
	}
	strcat( mask, F24W1Folders[F1y+1]);
	strcat( mask, "\\*");
	NumOfFolders=0;
	Found=al_findfirst(mask, &fblock, FA_DIREC);
	while ( !Found) {
		if( fblock.attrib != FA_ARCH) {
			NumOfFolders++;
			strcpy(F24FolderArray[NumOfFolders], fblock.name);
		}
		Found=al_findnext( &fblock);
	}
	al_findclose( &fblock );

	F24SortFolders();

	Count=NumOfFolders-2;
	F24W1EndList+=Count;
	F24W1Info[F1y+1][1]=1;
	for(z=F24W1EndList; z>=F1y+2+Count; --z) {
		strcpy(F24W1Folders[z],F24W1Folders[z-Count]);
		strcpy(F24W1FullPath[z-2],F24W1FullPath[z-2-Count]);
		F24W1Info[z][0]=F24W1Info[z-Count][0];
		F24W1Info[z][1]=F24W1Info[z-Count][1];
		F24W1Info[z][2]=F24W1Info[z-Count][2];
		F24W1Info[z][3]=F24W1Info[z-Count][3];
	}
	for(z=0; z<Count; ++z) {
		strcpy(F24W1Folders[F1y+2+z],F24FolderArray[z+3]);
		strcpy(F24W1FullPath[F1y+z],F24W1FullPath[F1y-1]);
		strcat(F24W1FullPath[F1y+z],"\\");
		strcat(F24W1FullPath[F1y+z],F24FolderArray[z+3]);
	}
	for(z=F1y+2;z<F1y+2+Count;++z) {
		strcpy( mask, LcarsPath);
		strcat( mask, "\\");
		if(NestingLevel==2) {			  /* for deeper nesting */
			Parent=F24W1FindParent(2);
			strcat(mask,F24W1Folders[Parent]);
			strcat(mask,"\\");
		}
		strcat( mask, F24W1Folders[F1y+1]);
		strcat( mask, "\\");

		strcat( mask, F24W1Folders[z]);
		strcat( mask, "\\*");
		F24InspectOneFolder(mask);
		F24W1Info[z][0]=NumOfFiles;
		F24W1Info[z][2]=NestingLevel+1;
		F24W1Info[z][1]=0;
		if(NumOfFolders>F24W1Info[z][2]) F24W1Info[z][1]=2;
		F24W1Info[z][2]=NestingLevel+1;
		F24W1Info[z][3]=0;  /* not highlighted */
	}
	if(F24W1Current>F1y) F24W1Current+=Count;
	F24W1Refresh();
	F24W1Cursor();
}
void F24W1Nest()
{
	int NestingLevel;

	if(F24W1Info[F1y+1][1]==0) return; /* no subfolders */

	NestingLevel=F24W1Info[F1y+1][2];
	if(F24W1Info[F1y+1][1]==1) {  /* - symbol displayed */
		F24W1Contract(NestingLevel+1);
		F24W1Info[F1y+1][1]=2; /* display + symbol */
		F24W1Refresh();
		F24W1Cursor();
		return;
	}
	if(F24W1Info[F1y+1][1]==2) F24W1Expand();
}
void F24W1Init()
{
	char mask[128];

	strcpy( mask, LcarsPath);
	strcat( mask, "\\*.*");
	F24FindFiles(mask);
	F24W1Info[2][0]=NumOfFiles;
	F24W1Info[2][1]=1; /* LCARS24 folder expanded by routine below */
	F24W1Info[2][2]=0; /* highest level in nest (disregarding C:\) */
	F24W1Info[2][3]=0; /* not yet highlighted */
	itoa(F24W1Info[2][0],Content,10);
	F24DrawFolder(51,36+16,F24W1Folders[2], F24W1Info[2][1]);

	for(F1y=3;F1y<=F24W1EndList;++F1y) {
		strcpy( mask, LcarsPath);
		strcat( mask, "\\");
		strcat( mask, F24W1Folders[F1y]);
		strcat( mask, "\\*");
		F24InspectOneFolder(mask);
		F24W1Info[F1y][0]=NumOfFiles;
		F24W1Info[F1y][1]=0; /* not yet expanded */
		F24W1Info[F1y][3]=0; /* not yet highlighted */
		if(NumOfFolders>2) F24W1Info[F1y][1]=2;
		F24W1Info[F1y][2]=1;
	}
}
void F24W1Refresh()
{
	int i,p2,z;
	int bottom=8;

	i=F24W1Offset;
	if(F24W1EndList-F24W1Offset<bottom) bottom=F24W1EndList-F24W1Offset;
	rectfill(screen,10,36+16,296,MidY-27,BLACK); /* 296 to erase cursor with deep nesting */
	for(z=2;z<=bottom;++z) {
		itoa(F24W1Info[z+i][0],Content,10);
F24DrawFolder(51+(F24W1Info[z+i][2])*19,(z*36)-36+16,F24W1Folders[z+i], F24W1Info[z+i][1]);
	}
/* maintain highlight when scrolling */
	p2=F24W1Info[F24W1Current+1][2]*19; /* nesting level of folder to unhighlight */
	if(F24W1Current-F24W1Offset < bottom && F24W1Current-F24W1Offset > 0 )
F24SelectFolder(51+p2,((F24W1Current+1-F24W1Offset)*36)-36+16,F24W1Folders[F24W1Current+1],NAPLES);
}
void F24MakeFolder()
{
	char MakePath[128];
	int Result;

	strcpy( MakePath, LcarsPath);
	strcat( MakePath, "\\");
	F24Box(BLACK, 1, "","","","");
	F24Box(BLACK, 2, "","","","");
	F24Box(BLACK, 3, "","","","");
	memset(KeyInStr,(null),80);

	rectfill(screen,10,MidY-10+24,780,560,BLACK);
	OfflineType4(47, MidY+64, LILAC, "MAKE FOLDER");
	F24Box(MANGO, 1, "","","CANCEL","ESC");

	F24InputY=MidY+74;
	F24InputPos=183+StrLenFont19(MakePath);
	PutsFont19(183,F24InputY, LILAC,MakePath);

	F24GetNameDisplayInputString();
	Result=F24GetKeyboardInput();
	if( Result==27) goto out;
	strcat(MakePath,KeyInStr);
/*	Result=mkdir(MakePath, S_IWUSR); 	DJGPPP version */
	Result=mkdir(MakePath);		/* pure GCC version */
	fix_filename_slashes(MakePath);

	if(Result==0) {
		goto out;
	} else {
	rectfill(screen,220,77,480,MidY-13-64,BLACK);
		if(exists(MakePath)) {
	PutsFont19(338,77,MANGO,"NAME IN USE");
	PutsFont19(338,77+32,MANGO,"CANNOT MAKE");
		} else {
			PutsFont19(338,77,MANGO,"INVALID NAME");
			PutsFont19(338,77+32,MANGO,"CANNOT MAKE");
		}
/*	sleep(1); */
	}
	if(Result != 0) Result=27;
out:
	rectfill(screen,303,77,476,MidY-96,BLACK);
	rectfill(screen,10,MidY-10+24,780,560,BLACK);
	F24UpperMessageBoxes();
	F24W2Refresh();
	F24W4Refresh();
	if(Result != 27) F24Reinit(1);
}
void F24RenamingProhibitedMessage()
{
	PutsFont19(338,77,MANGO,"CRITICAL FOLDER");
	PutsFont19(338,77+32,MANGO,"DO NOT RENAME");
/*	sleep(1); */
}
void F24DeletionProhibitedMessage()
{
	PutsFont19(338,77,MANGO,"CRITICAL FOLDER");
	PutsFont19(338,77+32,MANGO,"DO NOT DELETE");
/*	sleep(1); */
}
void F24RecycleProhibitedMessage()
{
	PutsFont19(338,77,MANGO,"FOLDER WITH");
	PutsFont19(338,96+13,MANGO,"MATCHING NAME");
	PutsFont19(338,128+13,MANGO,"IN RECYCLE BIN");
	PutsFont19(338,160+13,ORANGE,"CANNOT DELETE");
	PutsFont19(338,192+13,LAVENDER,"RENAME FIRST");
	PutsFont19(338,224+13,LAVENDER,"(PRESS F2)");
/*	sleep(3); */
}
int F24RenamingProhibitedCheck(char *Str)
{
	if(stricmp(get_filename(Str),"ABC-TXT")==0) return(1);
	if(stricmp(get_filename(Str),"ALARM")==0) return(1);
	if(stricmp(get_filename(Str),"BMP")==0) return(1);
	if(stricmp(get_filename(Str),"DATA")==0) return(1);
	if(stricmp(get_filename(Str),"DOSAPPS")==0) return(1);
	if(stricmp(get_filename(Str),"LC24APPS")==0) return(1);
	if(stricmp(get_filename(Str),"MP3")==0) return(1);
	if(stricmp(get_filename(Str),"PHONE")==0) return(1);
	if(stricmp(get_filename(Str),"RECYCLE")==0) return(1);
	if(stricmp(get_filename(Str),"SOUND")==0) return(1);
	if(stricmp(get_filename(Str),"SYSTEM")==0) return(1);
	if(stricmp(get_filename(Str),"MP3\\MPXPLAY")==0) return(1);
	if(stricmp(get_filename(Str),"SYSTEM\\FONTS")==0) return(1);
	if(stricmp(get_filename(Str),"SYSTEM\\MIDI24")==0) return(1);
	if(stricmp(get_filename(Str),"LC24APPS\\CHESS24")==0) return(1);
	if(stricmp(get_filename(Str),"LC24APPS\\CROSSWRD")==0) return(1);
	if(stricmp(get_filename(Str),"LC24APPS\\EDITBMP")==0) return(1);
	if(stricmp(get_filename(Str),"LC24APPS\\FILES24")==0) return(1);
	if(stricmp(get_filename(Str),"DOSAPPS\\MSPACMAN")==0) return(1);
	if(stricmp(get_filename(Str),"DOSAPPS\\PACMAN")==0) return(1);
	if(stricmp(get_filename(Str),"LC24APPS\\SOL24")==0) return(1);
	if(stricmp(get_filename(Str),"LC24APPS\\BLACKJAK")==0) return(1);
	if(stricmp(get_filename(Str),"DOSAPPS\\SOLSYS")==0) return(1);
	if(stricmp(get_filename(Str),"LC24APPS\\TEXT24")==0) return(1);
	return(0);
}
void F24W1Rename()
{
	char RenamePath[128];
	char OldPath[128];
	char NewPath[128];
	char CheckStr[128];
	int z, Result;
	char OpenStatus=FALSE;

	strcpy( RenamePath, LcarsPath);
	strcat( RenamePath, "\\");
	F24Box(BLACK, 1, "","","","");
	F24Box(BLACK, 2, "","","","");
	F24Box(BLACK, 3, "","","","");
	memset(KeyInStr,(null),80);
	memset(NewPath,(null),128);
	memset(OldPath,(null),128);

	if(F24W1Info[F1y+1][2] < 1) {
		F24RenamingProhibitedMessage();
		Result=27;
		goto out;
	}

	strcpy(RenamePath,F24W1FullPath[F1y-1]);
	strcpy(CheckStr,RenamePath);

	if(strcmp(CheckStr,F24W2PastePath)==0) OpenStatus=TRUE;

	if( F24RenamingProhibitedCheck(CheckStr)==1) {
		F24RenamingProhibitedMessage();
		Result=27;
		goto out;
	}

	rectfill(screen,10,MidY-10+24,780,560,BLACK);
	OfflineType4(47, MidY+64, LILAC, "RENAME");
	OfflineType4(47, MidY+64+47, PURPLE, "CURRENT NAME");
	F24Box(BRICK, 2, "CANCEL","ESC","","");
	strcpy(KeyInStr,get_filename(F24W1FullPath[F1y-1]));
	F24InputPos=183+StrLenFont19(F24W1FullPath[F1y-1])-StrLenFont19(KeyInStr);
	F24InputY=MidY+74;

	PutsFont19(183,F24InputY, LILAC,F24W1FullPath[F1y-1]);
	PutsFont19(183,F24InputY+47, PURPLE,F24W1FullPath[F1y-1]);

	strcpy(NewPath,RenamePath);
	NewPath[strlen(RenamePath)-strlen(KeyInStr)]=(null);

	F24GetNameDisplayInputString();
	Result=F24GetKeyboardInput();
	if( Result==27) goto out;

	strcpy(OldPath,RenamePath);
	strcat(NewPath,KeyInStr);
	Result=rename(OldPath,NewPath);


	if(Result==0) {
		goto out;
	} else {
	rectfill(screen,303,77,476,MidY-13-64,BLACK);
		if(exists(NewPath)) {
	PutsFont19(338,77,MANGO,"NAME IN USE");
	PutsFont19(338,77+32,MANGO,"CANNOT RENAME");
		} else {
			PutsFont19(338,77,MANGO,"INVALID NAME");
			PutsFont19(338,77+32,MANGO,"CANNOT USE");
		}
/*	sleep(1); */
	}
	if(Result != 0) Result=27;
out:
	rectfill(screen,303,77,476,MidY-96,BLACK);
	rectfill(screen,10,MidY-10+24,780,560,BLACK);

	F24UpperMessageBoxes();

	if(Result==0) {
		strcpy(F24W1FullPath[F1y-1], NewPath);
		strcpy(F24W1Folders[F1y+1],KeyInStr);
		F24W1Refresh();
		F24W1Cursor();

		k=strlen(OldPath);
		z=0;
		do { /* reflect W1 name change to W3 */
			if(memicmp(OldPath,F24W3FullPath[z],k)==0) {
				strcpy(F24W3FullPath[z],NewPath);
				strcpy(F24W3Folders[z+2],KeyInStr);
				F24W3Refresh();
				break;
			}
			z++;
		} while(z < F24W3EndList);

		F24RecursiveFolderRename(OldPath, NewPath);
	}

	if(OpenStatus==TRUE) {
		strcpy(F24W1ListTitle,F24W1FullPath[F24W1CurrentPathElement]);
		rectfill(screen,12,MidY-26,297,MidY,LILAC);
		PutsLuna(43,MidY-19,BLACK,LILAC,MakeDisplayName(F24W1ListTitle));
		strcpy(F24W2Path,F24W1ListTitle);
		strcat(F24W2Path,"\\");
		strcpy(F24W2PastePath,F24W1ListTitle);
	}
/*
	if(OpenStatus==TRUE) F24W1Open;
		else F24W2Refresh();
*/

	F24W2Refresh();
	F24W4Refresh();
/*
rectfill(screen,43,588-26,440-111-32,588,LILAC);
PutsLuna(43,569, BLACK,LILAC, F24W1FullPath[F24W1CurrentPathElement]);
strcpy(Report,KeyInStr);
strcat(Report,"--");
strcat(Report,NewName);
strcat(Report,"--");

PutsLuna(43,569, BLACK,LILAC, Report);
*/
/* SaveReport(); */
}
void F24W1DeleteFolder()
{
	int Result,i,z;
	char CmdStr[128];
	char RecyclePath[128];
	char SourcePath[128];
	char CheckStr[128];
	char DupStr[128];
	char FolderContentStr[128];
	char PaddyWagon[128];

	strcpy( CmdStr, "md ");
	strcat( CmdStr, LcarsPath);
	strcat( CmdStr, "\\RECYCLE\\");
	strcpy( RecyclePath, LcarsPath);
	strcat( RecyclePath, "\\RECYCLE\\");
	strcpy( SourcePath, LcarsPath);
	strcat( SourcePath, "\\");
	F24Box(BLACK, 1, "","","","");
	F24Box(BLACK, 2, "","","","");
	F24Box(BLACK, 3, "","","","");

	if(F24W1Info[F1y+1][2] < 1) {
		F24DeletionProhibitedMessage();
		Result=27;
		goto out;
	}

	if(F24W1Info[F1y+1][2]==2) {
		i=F1y+1;
		while(F24W1Info[i][2]==2) --i;
		strcat(SourcePath,F24W1Folders[i]);
		strcat(SourcePath,"\\");
	}

	strcpy(CheckStr,SourcePath);
	strcat(CheckStr,F24W1Folders[F1y+1]);
	strcpy(FolderContentStr,CheckStr);

	if( F24RenamingProhibitedCheck(CheckStr)==1) {
		F24DeletionProhibitedMessage();
		Result=27;
		goto out;
	}

	if(strncmp(CheckStr,RecyclePath,18) ==0) {
		Result=F24Dialog(284,160, F24W1Folders[F1y+1],"DELETE");
		if(Result !=1) goto out;
		else {
			strcpy(FolderContentStr,CheckStr);
			strcat(FolderContentStr,"\\*.*");
			goto skip_recycle;
		}
	}

	memset(DupStr,(null),128);
	strcpy(DupStr,RecyclePath);
	strcat(DupStr,F24W1Folders[F1y+1]);

	if(F24FolderExists(DupStr)==0) {
		F24RecycleProhibitedMessage();
		Result=27;
		goto out;
	}

	Result=F24Dialog(284,160, F24W1Folders[F1y+1],"DELETE");
	if(Result !=1) goto out;


/* actually do something: make a subfolder in the recycle bin */
	strcat(RecyclePath,F24W1Folders[F1y+1]);
	if(F24FolderExists(RecyclePath) != 0) {
		strcat( CmdStr, F24W1Folders[F1y+1]);
		system(CmdStr);
	}

/* makes sure the folder is not empty, since DOS is such a pain */
	strcat(FolderContentStr,"\\*.*");
	F24FindFiles(FolderContentStr);  /* reports NumOfFiles, used below */

/* copy files to the new subfolder in the recycle bin */
	if(NumOfFiles > 0) {
		memset(CmdStr,(null),128);
		strcpy(CmdStr,"copy ");
		strcat(CmdStr,CheckStr);
		strcat(CmdStr,"\\*.* ");
		strcat(CmdStr,RecyclePath);
		strcat(CmdStr,">NUL");
		system(CmdStr);
	}

skip_recycle:

/* delete files from the condemned folder */
/*	strcat(FolderContentStr,"\\*.*");  */
	F24FindFiles(FolderContentStr);
	if(NumOfFiles > 0) {
		memset(CmdStr,(null),128);
		strcpy(CmdStr,CheckStr);
		strcat(CmdStr,"\\*.* ");
		F24FindFiles(CmdStr);
		for(z=0; z<=NumOfFiles; ++z) {
			strcpy(PaddyWagon,CheckStr);
			strcat(PaddyWagon,"\\");
			strcat(PaddyWagon,F24FileArray[z]);
			remove(PaddyWagon);
		}
	}
/* remove the now-empty condemned folder */
	rmdir(CheckStr);
out:
	rectfill(screen,284,77,480,MidY-13-64,BLACK);
	F24UpperMessageBoxes();
	if(Result != 27) F24Reinit(1);
}
int F24W1Active()
{
	int i;

	F24EraseUpperSwitchBox();
	F24EraseLowerSwitchBox();
	DrawF24W1();
	MaxX=440;
	F1x=2;
	OldF1x=2;
	if(F1y < F24W1Offset+1) F1y=F24W1Offset+1;
	F24W1Cursor();
	CheckBeep();
loopback:
/*
	itoa(F24W1Info[F1y+1][2],Report,10);
	rectfill(screen,516,13,564,39,LILAC);
	PutsLuna(516,19, BLACK,LILAC, Report);
*/
	clear_keybuf();
	do {
		UpdateIdle();
	} while(!keypressed());
		c=GetKey();
		switch( c)
		{
			case BS:
				if(F1x==1 && F1y > 1 && F24W1Info[F1y+1][1]==1) F24W1Nest();
				goto loopback;
			case DELKEY: if(F1x==2) {
								 F24W1DeleteFolder();
					goto loopback;
				}
				if(F1x==1 && F1y > 1 && F24W1Info[F1y+1][1]==1) F24W1Nest();
				goto loopback;
			case 13: if(F1x==2) F24W1Open();
/* deep nesting acknowledged but not expanded */
		/*		if(F24W1Info[F1y+1][2] > 1 && F1x==1) goto loopback; */
				if(F1x==1 && F1y > 1) F24W1Nest();
				goto loopback;
			case F1: F24MakeFolder();
				goto loopback;
			case F2: F24W1Rename();
				goto loopback;
			case F3: 	F24CheckFloppy();
				goto loopback;
			case F4: /* SaveReport(); */
				goto loopback;
			case F11: F24Help();
				PanelBeep();
				goto loopback;
			case F12: return(0);
			case UPARROW:
				if( F1y==1) goto loopback;
				--F1y;
				if(F1y-F24W1Offset < 1) {
					--F24W1Offset;
					F24W1Refresh();
				}
				goto cursor;
			case DOWNARROW:
				if( F1y >= F24W1EndList-1) goto loopback;
				++F1y;
				if(F1y-F24W1Offset > 7) {
					++F24W1Offset;
					F24W1Refresh();
				}
				goto cursor;
			case PGUPKEY:
				for( i=0; i<4; i++) {
					if( F1y==1) { break; goto loopback; }
					--F1y;
					if(F1y-F24W1Offset < 1) {
						--F24W1Offset;
						F24W1Refresh();
					}
				}
				goto cursor;
			case PGDNKEY:
				for( i=0; i<4; i++) {
					if( F1y >= F24W1EndList-1) { break; goto loopback; }
					++F1y;
					if(F1y-F24W1Offset > 7) {
						++F24W1Offset;
						F24W1Refresh();
					}
				}
				goto cursor;
			case LEFTARROW:
				if(F1x>1) --F1x;
				F24W1Cursor();
				goto loopback;
			case RIGHTARROW:
				++F1x;
				F24W1Cursor();
				if(F1x==3) {
					UpperSwitchBox();
					return(1);
				}
				goto cursor;
			case CTRL_F1: Screenshot792("Files8.bmp");
				PanelBeep();
				goto loopback;
			default: goto loopback;
		}
cursor:
	F24W1Cursor();
	goto loopback;
}
void DrawF24W2()
{
	char CheckStr[128];
	F24EraseLowerElbows();
	F24Bumpers();
	MaxX=440;
	MaxY=588;
	MinY=MidY-26;
	F24NeElbow();
	F24SeElbow();
	F24LowerMessageBoxes();

	strcpy( CheckStr, LcarsPath);
	strcat( CheckStr, "\\RECYCLE\\*.*");
	if(stricmp(F24W1ListTitle, CheckStr)==0) {
		PutsLuna(43,569, BLACK,LILAC, "Empty Recycle folder: F5");
        	DisplayEmptyRecycle=TRUE;
	} else DisplayEmptyRecycle=FALSE;
	if(F24W1EndList==0) DisplayEmptyRecycle=FALSE;
}
void F24W2Cursor()
{
	int gx,gy;

	gx=190;
	gy=MidY-6+((OldF2y-F24W2Offset)*24);
	EnterSymbol(gx,gy,1,0);
	if(F2x==1) gx=190;
	gy=MidY-6+((F2y-F24W2Offset)*24);
	if(F2x<2) EnterSymbol(gx,gy,1,NAPLES);
	OldF2y=F2y;
}
void F24W2Refresh()
{
	int bottom, z;
	char TruncateStr[80]; /* to prevent Windows from displaying
				 a long filename */

	rectfill(screen,10,MidY-10+24,300,560,BLACK);
	bottom=F24W2EndList;
	if(F24W2EndList>8) bottom=8;
	for(z=1;z<=bottom;++z) {
		strcpy(TruncateStr,F24W2List[z+F24W2Offset]);
		TruncateStr[12]=(null);
		RightPutsFont19(174,MidY-10+(z*24),PALEBLUE,TruncateStr);
	}
}
void F24W2Up()
{
	if( F2y==1) return;
	--F2y;
	if(F2y-F24W2Offset < 1) --F24W2Offset;
}
void F24W2Dn()
{
	if( F2y >= F24W2EndList) return;
	++F2y;
	if(F2y-F24W2Offset > 8) ++F24W2Offset;
}
void F24W2Clipboard()
{
	memset(FileClipboard,(null),128);
	rectfill(screen,482,588-26,788,588,LILAC);
	if(F24W2EndList==0) {
		PutsLuna(516,569, BLACK,LILAC, "CLIPBOARD CLEARED");
		strcpy( FileClipboard, "***");
	} else {
		PutsLuna(516,569, BLACK,LILAC, "CLIPBOARD:");
		PutsLuna(516+StrLenLuna("CLIPBOARD: "),569,BLACK,LILAC,F24W2List[F2y]);
		strcpy(FileClipboard,F24W2Path);
		strcat(FileClipboard,F24W2List[F2y]);
		strcpy(SourceFilename,F24W2List[F2y]);
	}
/*	rectfill(screen,43,588-26,440-111-32,588,LILAC);
	PutsLuna(43,569, BLACK,LILAC, FileClipboard);
*/
}
void F24W2Delete()
{
	char PaddyWagon[128];
	char RecycleName[128];
	char TempStr[128];
	char Message[128];
	int Result=0;
	int Failure, gy;

	F24EraseLowerMessageBoxes();
	Result=F24Dialog(284,360, F24W2List[F2y],"DELETE");
	if(Result==1) {
		gy=MidY-13+((OldF2y-F24W2Offset)*24);
		rectfill(screen,12,gy,198,gy+21,BLACK);
		strcpy( TempStr, LcarsPath);
		strcat( TempStr, "\\RECYCLE\\");
		strcpy(PaddyWagon,F24W2Path);
		strcat(PaddyWagon,F24W2List[F2y]);
		if( stricmp( TempStr, F24W2Path) != 0) {
			strcpy(RecycleName, TempStr);
			strcat(RecycleName,F24W2List[F2y]);
			Failure=rename(PaddyWagon,RecycleName);
			if(Failure !=0) {
				strcpy(Message,PaddyWagon);
				strcat(Message,"--DEL FAILURE");
				rectfill(screen,12,588-26,297,588,ORANGE);
				PutsLuna(43,569, BLACK,ORANGE, Message);
			/*	sleep(1); */
			} else {
				if( stricmp( PaddyWagon, FileClipboard)==0) {
					rectfill(screen,482,588-26,788,588,LILAC);
					PutsLuna(516,569, BLACK,LILAC, "CLIPBOARD EMPTY");
					strcpy( FileClipboard, "***");
				}
			}
		}  else remove(PaddyWagon);

		F24UpdateAll();
		F24W2Cursor();
	}
	F24LowerMessageBoxes();
/*
strcpy(Message,PaddyWagon);
strcat(Message,"--DEL");
if(Failure !=0) strcat(Message," FAILED");
rectfill(screen,12,588-26,297,588,LILAC);
PutsLuna(43,569, BLACK,LILAC, Message);
*/
}
void F24W2Move()
{ /* moves selected file from W2 to W4, called by F6 keypress in W2 */
	char Dest[128];
	char Source[128];
	char CheckExisting[128];
	char CmdStr[128];
	int Result=1;
	int gy;

/* setup for checking for identical filename at destination */
	strcpy(CheckExisting,F24W4Path);  /* OK */
	strcpy(SourceFilename,F24W2List[F2y]);
	strcat(CheckExisting,SourceFilename);

/* check user intent to overwrite if matching filename found */
	if(exists(CheckExisting)) {
		F24EraseLowerMessageBoxes();
		Result=F24Dialog(284,360, "EXISTING FILE HAS SAME FILENAME","CANCEL");
		F24LowerMessageBoxes();
		F24Box(PALEBLUE, 7, "MOVE FILE","","TO RIGHT","F6");
		return;
	}

	gy=MidY-13+((OldF2y-F24W2Offset)*24);
	rectfill(screen,12,gy,198,gy+21,BLACK); /* small visual effect */

	strcpy(Dest,F24W4PastePath);
	if(memicmp(F24W4PastePath,"A:\\",3) !=0) strcat(Dest,"\\");
	strcat(Dest, F24W2List[F2y]);
	strcpy(Source,F24W2Path);
	strcat(Source,F24W2List[F2y]);

	if(rename(Source, Dest)==0) goto out; /* the fast way */

	Result=CopyFile(Source,Dest);
	if(Result==1 || Result==2 || Result==3) F24CopyError(Result);

	if(Result==4) {
		memset(CmdStr,(null),128);
		strcpy(CmdStr,"copy ");
		strcat(CmdStr,Source);
		strcat(CmdStr," ");
		strcat(CmdStr,F24W2PastePath);
		strcat(CmdStr,">NUL");
		system(CmdStr);
	}
	remove(Source);
out:
	F24UpdateAll();
	F24W2Cursor();
}
void F24W2Paste()
{
	char CmdStr[128];
	char Dest[128];
	char CheckExisting[128];
	int Result=1;
	char CopyAll=FALSE;

	if(F24W2PastePath[0]==0) return;

/* check for empty clipboard */
	if( strcmp( "***", FileClipboard)==0) {
		rectfill(screen,482,588-26,788,588,LILAC);
		PutsLuna(516,569, BLACK,LILAC, "CLIPBOARD EMPTY");
		return;
	}
/* check for illegal "COPY ALL" clipboard */
	if( memicmp( F24W1ListTitle, FileClipboard,strlen(F24W1ListTitle))==0) {
		F24EraseLowerMessageBoxes();
		Result=F24Dialog(284,360, "CANNOT COPY TO SOURCE","CANCEL");
		rectfill(screen,284,388,400,416,BLACK);
		  	F24LowerMessageBoxes();
		return;
	}
/* check for legal "COPY ALL" clipboard */
/* The list has to be different from source to get past the above check. */
	if( strcmp( get_filename( FileClipboard), "*.*")==0) {
		F24EraseLowerMessageBoxes();
		PutsFont19(284,388,ORANGE,"WARNING");
		Result=F24Dialog(284,396, "MATCHING FILES WILL BE OVERWRITTEN","COPY ALL");
		rectfill(screen,284,388,400,416,BLACK);
		F24LowerMessageBoxes();
		if(Result==1) {
			CopyAll=TRUE;
			goto DoPaste;
		}
		else return;
	}

/* setup for checking for identical filename at destination */
	strcpy(CheckExisting,F24W2Path);
	strcat(CheckExisting,SourceFilename);

/* check for destination=source */
	if( stricmp( CheckExisting, FileClipboard)==0) {
		F24EraseLowerMessageBoxes();
		Result=F24Dialog(284,360, "CANNOT COPY FILE TO ITSELF","CANCEL");
		F24LowerMessageBoxes();
		return;
	}

/* check user intent to overwrite if matching filename found */
	if(exists(CheckExisting)) {
		F24EraseLowerMessageBoxes();
		Result=F24Dialog(284,360, "EXISTING FILE HAS SAME FILENAME","OVERWRITE");
		if(Result != 1) return;
		F24LowerMessageBoxes();
	}
DoPaste:
	if(Result==0) return;
	if(CopyAll==TRUE) {
		Result=4;
		goto bypass;
	}
	if(Result==0) return;
	strcpy(Dest,F24W2PastePath);
	if(memicmp(F24W2PastePath,"A:\\",3) !=0) strcat(Dest,"\\");
	strcat(Dest,get_filename(FileClipboard));
	Result=CopyFile(FileClipboard,Dest);
	if(Result==1 || Result==2 || Result==3) F24CopyError(Result);
bypass:
	if(Result==4) {
		memset(CmdStr,(null),128);
		strcpy(CmdStr,"copy ");
		strcat(CmdStr,FileClipboard);
		strcat(CmdStr," ");
		strcat(CmdStr,F24W2PastePath);
		strcat(CmdStr,">NUL");
		system(CmdStr);
	}
	F24UpdateAll();
	F24W2Cursor();
/*
rectfill(screen,12,588-26,297,588,BRICK);
PutsLuna(43,569, BLACK,BRICK, FileClipboard);
rectfill(screen,482,588-26,788,588,PALEBLUE);
PutsLuna(516,569, BLACK,PALEBLUE, Dest);
*/
	if(Result !=0) {
		rectfill(screen,482,588-26,788,588,BRICK);
		PutsLuna(516,569, BLACK,BRICK, "LCARS COPY FAILURE");
	}
}
void F24W2Clear()
{
	int z;

	for(z=0; z <= 999; ++z) {
		memset(F24W2List[z],(null),128);
	}
	rectfill(screen,10,MidY-10+24,300,560,BLACK);
}
void F24W2EmptyRecycle()
{
	char PaddyWagon[128];
	char TempStr[128];
	int Result=0;
	int z;

	strcpy( TempStr, LcarsPath);
	strcat( TempStr, "\\RECYCLE\\");
	F24EraseLowerMessageBoxes();
	Result=F24Dialog(284,360, "ALL FILES & FOLDERS IN RECYCLE BIN","DELETE");
	if(Result==1) {
		if( stricmp( FileClipboard, TempStr)==0) {
			rectfill(screen,482,588-26,788,588,LILAC);
			PutsLuna(516,569, BLACK,LILAC, "CLIPBOARD EMPTY");
			strcpy( FileClipboard, "***");
		}
		for(z=0; z<=F24W2EndList; ++z) {
			strcpy(PaddyWagon, TempStr);
			strcat(PaddyWagon,F24W2List[z]);
			remove(PaddyWagon);
		}
		F24DeleteAllFoldersFromRecycleBin();
		rectfill(screen,12,588-26,297,588,LILAC); /* erase F5 indication */
		DisplayEmptyRecycle=FALSE;
		F24W2Clear();
		LowerSwitchBox();
		F24EraseLowerSwitchBox();
		F24Reinit(1);
	}
	F24LowerMessageBoxes(); /* restore boxes, regardless */
}
void F24W2CopyAll()
{
	memset(FileClipboard,(null),128);
	rectfill(screen,482,588-26,788,588,LILAC);
	strcpy(FileClipboard,F24W1ListTitle);
	PutsLuna(516,569, BLACK,LILAC, "CLIPBOARD:");
	PutsLuna(516+StrLenLuna("CLIPBOARD: "),569,BLACK,LILAC,FileClipboard);
}
int F24W2Active()
{
	char FullPathAndFilename[128];
	int z;

	F24EraseUpperSwitchBox();
	F24EraseLowerSwitchBox();
	ActiveWindow=2;
	DrawF24W2();
	MaxX=440;
	if(F2y < F24W2Offset+1) F2y=F24W2Offset+1;
	F2x=1;
	F24W2Cursor();
loopback:
	clear_keybuf();
	do {
		UpdateIdle();
	} while(!keypressed());
		c=GetKey();
		switch( c)
		{
			case DELKEY:
				F24W2Delete();
				goto loopback;
			case 13:
				strcpy(FullPathAndFilename,F24W2Path);
				strcat(FullPathAndFilename,F24W2List[F2y]);
				if( ! exists(FullPathAndFilename)) goto cursor;
				F24FileView(FullPathAndFilename);
				goto cursor;
			case F5: if(DisplayEmptyRecycle==FALSE) goto loopback;
				F24W2EmptyRecycle();
				goto cursor;
			case F6: if(F24W2MoveOK==TRUE) F24W2Move();
				goto loopback;
			case F7: if(strcmp(F24W4PastePath,"A:\\")==0) goto loopback;
				goto loopback;
			case F8: F24W2CopyAll();
				goto loopback;
			case F9: F24W2Clipboard();
				goto loopback;
			case F10: F24W2Paste();
				goto loopback;
			case F11: F24Help();
				goto loopback;
			case F12: return(0);
			case PGUPKEY: OffsetHolder=F24W2Offset;
				if( F2y==1) goto loopback;
				for(z=1;z<=4;++z) F24W2Up();
				if(F24W2Offset != OffsetHolder) F24W2Refresh();
				goto cursor;
			case PGDNKEY: OffsetHolder=F24W2Offset;
				if( F2y >= F24W2EndList) goto loopback;
				for(z=1;z<=7;++z) F24W2Dn();
				if(F24W2Offset != OffsetHolder) F24W2Refresh();
				goto cursor;
			case UPARROW:
				if( F2y==1) goto loopback;
				--F2y;
				if(F2y-F24W2Offset < 1) {
					--F24W2Offset;
					F24W2Refresh();
				}
				goto cursor;
			case DOWNARROW:
				if( F2y >= F24W2EndList) goto loopback;
				++F2y;
				if(F2y-F24W2Offset > 8) {
					++F24W2Offset;
					F24W2Refresh();
				}
				goto cursor;
			case LEFTARROW:
				if(F2x>1) --F2x;
				goto cursor;
			case RIGHTARROW:
				++F2x;
				if(F2x==2) {
					F24W2Cursor();
					LowerSwitchBox();
					return(2);
				}
			case CTRL_F1: Screenshot792("Files8.bmp");
				goto loopback;
			default: goto loopback;
		}
cursor:
	F24W2Cursor();
	goto loopback;
}
void DrawF24W3()
{
	F24EraseUpperElbows();
	F24Bumpers();
	MaxX=779;
	MaxY=MidY;
	MinY=13;
	F24NwElbow();
	F24SwElbow();
	MaxX=440;
	F24UpperMessageBoxes();
}
void F24DrivesCursor()
{
	int gx,gy;

	if(OldF3x==2) gx=453+63-19;
	if(OldF3x==1) gx=602+63-19;
	gy=25+(Olddy*36);
	if(OldF3x<3)EnterSymbol(gx,gy,1,BLACK);
	if(F3x==2) gx=453+63-19;
	if(F3x==1) gx=602+63-19;
	gy=25+(dy*36);
	if(F3x<3) EnterSymbol(gx,gy,1,NAPLES);
	OldF3x=F3x;
	Olddy=dy;
}
void F24W3Cursor()
{
	int gx,gy;

	if(OldF3x==2) gx=453+63+((F24W3Info[OldF3y+1][2]*19)-19);
	if(OldF3x==1) gx=602+63+((F24W3Info[OldF3y+1][2]*19)-19);
	gy=97+((OldF3y-F24W3Offset)*36);
	if(OldF3x<3)EnterSymbol(gx,gy,1,0);
	if(F3x==2) gx=453+63+((F24W3Info[F3y+1][2]*19)-19);
	if(F3x==1) gx=602+63+((F24W3Info[F3y+1][2]*19)-19);
	gy=97+((F3y-F24W3Offset)*36);
	if(F3x<3) EnterSymbol(gx,gy,1,NAPLES);
	OldF3x=F3x;
	OldF3y=F3y;
}
int F24W3FindParent(int Level)
{
	int i;

	i=F3y;
	while( i>2 && F24W3Info[i][2] > Level-1) --i;
	return(i);
}
void F24Unhighlight()
{
	int p2;

	F24DrawOffline(514,88, "DRIVE C");
	F24DrawOffline(514,52, "DRIVE A");
	p2=F24W3Info[F24W3Current+1][2]*19; /* nesting level of folder to unhighlight */
	if(F24W3Current-F24W3Offset < 6 && F24W3Current-F24W3Offset > 0)
	F24SelectFolder(514+p2,((F24W3Current+1-F24W3Offset)*36)+36+16,F24W3Folders[F24W3Current+1],ORANGE);
}
void F24W3Open()
{
	int bottom,p1,z;
	char TruncateStr[80]; /* to prevent Windows from displaying
				 a long filename */

	DriveCurrent=3;
	p1=F24W3Info[OldF3y+1][2]*19; /* nesting level of folder to highlight */
	F24Unhighlight();
	F24SelectFolder(514+p1,((F3y+1-F24W3Offset)*36)+36+16,F24W3Folders[F3y+1],NAPLES);
	F24W3Info[F3y+1][3]=1;
	F24W3Info[F24W3Current+1][3]=0;
	F24W3Current=F3y;

	F24W3CurrentPathElement=F3y-1;
	strcpy(F24W3ListTitle,F24W3FullPath[F24W3CurrentPathElement]);
	rectfill(screen,516,MidY-26,788,MidY,LILAC);
	rectfill(screen,483,MidY-10+24,700,558,BLACK);
	PutsLuna(516,MidY-19,BLACK,LILAC,MakeDisplayName(F24W3ListTitle));

	strcpy(F24W4Path,F24W3ListTitle);
	strcpy(F24W4PastePath,F24W3ListTitle);
	strcat(F24W4Path,"\\");
	strcat(F24W3ListTitle,"\\*.*");
	F24FindFiles(F24W3ListTitle);
	F24SortFiles();
	for(z=0;z<=NumOfFiles;++z) strcpy(F24W4List[z], F24FileArray[z]);
	F24W4EndList=NumOfFiles;
	bottom=F24W4EndList;
	F24W3Refresh();
	F24W3Cursor();
	if(F24W4EndList>8) bottom=8;
	for(z=0;z<=bottom;++z) {
		strcpy(TruncateStr, F24W4List[z]);
		TruncateStr[12]=(null);
		RightPutsFont19(647,MidY-10+(z*24), PALEBLUE,TruncateStr);
	}
	F24W4Offset=0;
	F4y=1;
	OldF4y=1;
	F24W4Open=TRUE;
}
void F24W3Contract( int Level)
{
	int i, Count;

	i=F3y+2;
	while( i<F24W3EndList && F24W3Info[i][2] >= Level) ++i;
	Count=i-(F3y+2);
	for(i=F3y+2; i<=F24W3EndList-Count; ++i) {
		strcpy(F24W3Folders[i],F24W3Folders[i+Count]);
		strcpy(F24W3FullPath[i-2],F24W3FullPath[i-2+Count]);
		F24W3Info[i][0]=F24W3Info[i+Count][0];
		F24W3Info[i][1]=F24W3Info[i+Count][1];
		F24W3Info[i][2]=F24W3Info[i+Count][2];
		F24W3Info[i][3]=F24W3Info[i+Count][3];
	}
	F24W3EndList-=(Count);
	if(F24W3Current>F3y) F24W3Current-=Count-1;
}
void F24W3Expand()
{
	struct al_ffblk fblock;
	int Found,z;
	char mask[128];
	int Count,Parent,NestingLevel;

	strcpy( mask, LcarsPath);
	strcat( mask, "\\");
	NestingLevel=F24W3Info[F3y+1][2];
	if(NestingLevel==2) {			  	/* for deeper nesting */
		Parent=F24W3FindParent(2);
		strcat(mask,F24W3Folders[Parent]);
		strcat(mask,"\\");
	}
	strcat( mask, F24W3Folders[F3y+1]);
	strcat( mask, "\\*");
	NumOfFolders=0;
	Found=al_findfirst(mask, &fblock, FA_DIREC);
	while ( !Found) {
		if( fblock.attrib != FA_ARCH) {
			NumOfFolders++;
			strcpy(F24FolderArray[NumOfFolders], fblock.name);
		}
		Found=al_findnext( &fblock);
	}
	al_findclose( &fblock );

	F24SortFolders();

	Count=NumOfFolders-2;
	F24W3EndList+=Count;
	F24W3Info[F3y+1][1]=1;
	for(z=F24W3EndList; z>=F3y+2+Count; --z) {
		strcpy(F24W3Folders[z],F24W3Folders[z-Count]);
		strcpy(F24W3FullPath[z-2],F24W3FullPath[z-2-Count]);
		F24W3Info[z][0]=F24W3Info[z-Count][0];
		F24W3Info[z][1]=F24W3Info[z-Count][1];
		F24W3Info[z][2]=F24W3Info[z-Count][2];
		F24W3Info[z][3]=F24W3Info[z-Count][3];
	}
	for(z=0; z<Count; ++z) {
		strcpy(F24W3Folders[F3y+2+z],F24FolderArray[z+3]);
		strcpy(F24W3FullPath[F3y+z],F24W3FullPath[F3y-1]);
		strcat(F24W3FullPath[F3y+z],"\\");
		strcat(F24W3FullPath[F3y+z],F24FolderArray[z+3]);
	}
	for(z=F3y+2;z<F3y+2+Count;++z) {
		strcpy( mask, LcarsPath);
		strcat( mask, "\\");
		if(NestingLevel==2) {			  /* for deeper nesting */
			Parent=F24W3FindParent(2);
			strcat(mask,F24W3Folders[Parent]);
			strcat(mask,"\\");
		}
		strcat( mask, F24W3Folders[F3y+1]);
		strcat( mask, "\\");

		strcat( mask, F24W3Folders[z]);
		strcat( mask, "\\*");
		F24InspectOneFolder(mask);
		F24W3Info[z][0]=NumOfFiles;
		F24W3Info[z][2]=NestingLevel+1;
		F24W3Info[z][1]=0;
		if(NumOfFolders>F24W3Info[z][2]) F24W3Info[z][1]=2;
		F24W3Info[z][2]=NestingLevel+1;
		F24W3Info[z][3]=0;  /* not highlighted */
	}
	if(F24W3Current>F3y) F24W3Current+=Count;
	F24W3Refresh();
	F24W3Cursor();
}
void F24W3Nest()
{
	int NestingLevel;

	if(F24W3Info[F3y+1][1]==0) return; /* no subfolders */

	NestingLevel=F24W3Info[F3y+1][2];
	if(F24W3Info[F3y+1][1]==1) {  /* - symbol displayed */
		F24W3Contract(NestingLevel+1);
		F24W3Info[F3y+1][1]=2; /* display + symbol */
		F24W3Refresh();
		F24W3Cursor();
		return;
	}
	if(F24W3Info[F3y+1][1]==2) F24W3Expand();
}
void F24W3InitA()
{
	strcpy(Content,"OFF");
	F24DrawFolder(514,52,"DRIVE A", 0);
}
void F24W3InitC()
{
	F24DrawOffline(514,88, "DRIVE C");
}
void F24W3Init()
{
	int i;
					/* It's just a copy of the F24W1 tree.*/
	for(i=0; i<=F24W1EndList; ++i) {  	/* Therefore, must be called */
		F24W3Info[i][0]=F24W1Info[i][0];	 /* only after F24W1Init.		  */
		F24W3Info[i][1]=F24W1Info[i][1];	 /* They have to be the same. */
		F24W3Info[i][2]=F24W1Info[i][2];
		F24W3Info[i][3]=F24W1Info[i][3];
	}
	F24W3Offset=0;
/*	F24W3InitA();  */
/*	F24W3InitC();  */
	F3y=1;
}
int F24FileSize(char *mask)
{
	struct al_ffblk fblock;
	int Found;

	Found=al_findfirst(mask, &fblock, FA_ARCH);
	return(fblock.size);
	al_findclose( &fblock );
}
unsigned long F24FloppyDiskSpace()
{
	/* unplugged for MinGW */

/*
	struct _diskfree_t d;
	long FloppyBytesFree;

	_dos_getdiskfree(1, &d);
	FloppyBytesFree = d.avail_clusters * d.bytes_per_sector;

	return(FloppyBytesFree);
*/
return(0);

}
int F24DriveA()
{
	int bottom,z;
	unsigned long FloppyFree;
	char Report[16];
	char TruncateStr[80]; /* to prevent Windows from displaying
				 a long filename */
return(0);
	DriveCurrent=1;
	F24Unhighlight();
	F24SelectFolder(514,52,"DRIVE A",NAPLES);
	if(F24CheckFloppy()==0) return(0);
	strcpy(F24W3ListTitle, "A:");
	rectfill(screen,516,MidY-26,788,MidY,LILAC);
	PutsLuna(516,MidY-19,BLACK,LILAC,"A:\\		 FREE:");
	FloppyFree=F24FloppyDiskSpace();
	itoa(FloppyFree,Report,10);
	strcat(Report," BYTES");
	PutsLuna(608,MidY-19,BLACK,LILAC,Report);
	rectfill(screen,512,MidY-10+24,700,558,BLACK); /* clear F24W4 */
	memset(F24W4Path,(null),128);
	strcpy(F24W4Path,F24W3ListTitle);
	strcat(F24W4Path,"\\");
	strcpy(F24W4PastePath,F24W4Path);  /* A:\ */
	strcat(F24W3ListTitle,"\\*.*");
	F24FindFiles(F24W3ListTitle);
	F24SortFiles();
	for(z=0;z<=NumOfFiles;++z) strcpy(F24W4List[z], F24FileArray[z]);
	F24W4EndList=NumOfFiles;
	bottom=F24W4EndList;
	if(F24W4EndList>8) bottom=8;
	for(z=0;z<=bottom;++z) {
		strcpy(TruncateStr, F24W4List[z]);
		TruncateStr[12]=(null);
		PutsFont19(516,MidY-10+(z*24), PALEBLUE,TruncateStr);
	}

	F24W4Offset=0;
	F4y=1;
	OldF4y=1;
	F24W4Open=TRUE;
	return(0);
}
void F24DriveC()
{
	int bottom,z;
	char TruncateStr[80]; /* to prevent Windows from displaying
				 a long filename */
return;

	DriveCurrent=2;
	F24Unhighlight();
	F24SelectFolder(514,88,"DRIVE C",NAPLES);
	strcpy(F24W3ListTitle, "C:");
	rectfill(screen,516,MidY-26,788,MidY,LILAC);
	PutsLuna(516,MidY-19,BLACK,LILAC,"C:\\");
	rectfill(screen,512,MidY-10+24,700,558,BLACK); /* clear F24W4 */

	memset(F24W4Path,(null),128);
	strcpy(F24W4Path,F24W3ListTitle);
	strcat(F24W4Path,"\\");
	strcpy(F24W4PastePath,F24W4Path); /* C:\ */
	strcat(F24W3ListTitle,"\\*.*");
	F24FindFiles(F24W3ListTitle);
	F24SortFiles();
	for(z=0;z<=NumOfFiles;++z) strcpy(F24W4List[z], F24FileArray[z]);
	F24W4EndList=NumOfFiles;
	bottom=F24W4EndList;
	if(F24W4EndList>8) bottom=8;
	for(z=0;z<=bottom;++z) {
		strcpy(TruncateStr, F24W4List[z]);
		TruncateStr[12]=(null);
		PutsFont19(516,MidY-10+(z*24), PALEBLUE,TruncateStr);
	}
	F24W4Offset=0;
	F4y=1;
	OldF4y=1;
	F24W4Open=TRUE;
}
void F24W3Refresh()
{
	int i,p2,zz;
	int bottom;

	bottom=6;
	i=F24W3Offset;
	if(F24W3EndList-F24W3Offset<bottom) bottom=F24W3EndList-F24W3Offset;

	rectfill(screen,482,36+87,788,MidY-27,BLACK);
	F24DrawOffline(514,88, "DRIVE C");
	F24DrawOffline(514,52, "DRIVE A");

	for(zz=2;zz<=bottom;++zz) {
		itoa(F24W3Info[zz+i][0],Content,10);
F24DrawFolder(514+(F24W3Info[zz+i][2])*19,(zz*36)+36+16,F24W3Folders[zz+i], F24W3Info[zz+i][1]);
	}
	if(DriveCurrent==1 || DriveCurrent==2) goto skip;
/* maintain highlight when scrolling */
	p2=F24W3Info[F24W3Current+1][2]*19; /* nesting level of folder to unhighlight */
	if(F24W3Current-F24W3Offset < bottom && F24W3Current-F24W3Offset > 0 ) {
if(F24W3Info[F24W3Current+1][3]==1 && F24W3Current < F24W3EndList) /* should be highlighted */
F24SelectFolder(514+p2,((F24W3Current+1-F24W3Offset)*36)+36+16,F24W3Folders[F24W3Current+1],NAPLES);
	}

skip:

	if(DrivesActive==1) {
		if(DriveCurrent==2) F24DriveC();
		if(DriveCurrent==1) F24DriveA();
	}
}
int F24FloppyReady()
{
/*
	int result;
	char buffer[512];

	result=biosdisk(2,0,0,0,0,1,buffer);
	return(result);
*/
return(0); /* unplugged for MinGW */
}
int F24CheckFloppy()
{
	char Content[4]="OFF";

return(0);
	if(F24FloppyReady() !=0x80) { /* floppy detected */
		F24FindFiles("A:\\*.*");
		itoa(NumOfFiles,Content,10);
		rectfill(screen,598,54, 628, 80,BLACK);
		PutsScorpio(598+30-(strlen(Content)*10),54,PALEBLUE,Content);
		return(1);
	} else {
		rectfill(screen,598,54, 628, 80,BLACK);
		strcpy(Content,"OFF");
		PutsScorpio(598, 54, BRICK,Content);
		return(0);
	}
}
int F24Drives()
{
	DrivesActive=1;
	F3x=1;
	dy=2;
	Olddy=3;
	F24DrivesCursor();


loopback:
	do {
		UpdateIdle();
	} while(!keypressed());
		c=GetKey();
		switch( c) {
			case F3: 	F24CheckFloppy();
				goto loopback;
			case F2: F24W3Refresh();
					goto cursor;
			case F11: F24Help();
				goto loopback;
			case F12: return(0);
			case 13:  if(dy==2 && F3x==1) F24DriveC();
					if(dy==1 && F3x==1) F24DriveA();
					goto loopback;
			case UPARROW:
					dy=1;
					goto cursor;
			case DOWNARROW:
					++dy;
					if(dy>2) {
						dy=2;
						F3y=1;
						DrivesActive=0;
						EnterSymbol(453+63-19,25+108-36,1,BLACK);
						EnterSymbol(602+63-19,25+108-36,1,BLACK);
						return(0);
					}
						else goto cursor;
			case LEFTARROW: ++F3x;
					F24DrivesCursor();
					if(F3x==3) {
						dy=2;
						F3y=1;
						DrivesActive=0;
						return(0);
					}
					goto loopback;
			case RIGHTARROW: if(F3x>1) --F3x;
				goto cursor;
			default: goto loopback;
		}
cursor:
	F24DrivesCursor();
	goto loopback;
return (0); /* unreachable, just to shut the compiler up */
}
void F24W3Rename()
{
	char RenamePath[128];
	char OldPath[128];
	char NewPath[128];
	char CheckStr[128];
	int z, Result;

	strcpy( RenamePath, LcarsPath);
	strcat( RenamePath, "\\");
	F24Box(BLACK, 1, "","","","");
	F24Box(BLACK, 2, "","","","");
	F24Box(BLACK, 3, "","","","");
	memset(KeyInStr,(null),80);
	memset(NewPath,(null),128);
	memset(OldPath,(null),128);

	if(F24W3Info[F3y+1][2] < 1) {
		F24RenamingProhibitedMessage();
		Result=27;
		goto out;
	}
	strcpy(RenamePath,F24W3FullPath[F3y-1]);
	strcpy(CheckStr,RenamePath);

	if( F24RenamingProhibitedCheck(CheckStr)==1) {
		F24RenamingProhibitedMessage();
		Result=27;
		goto out;
	}

	rectfill(screen,10,MidY-10+24,780,560,BLACK);
	OfflineType4(47, MidY+64, LILAC, "RENAME");
	OfflineType4(47, MidY+64+47, PURPLE, "CURRENT NAME");
	F24Box(BRICK, 2, "CANCEL","ESC","","");
	strcpy(KeyInStr,get_filename(F24W3FullPath[F3y-1]));
	F24InputPos=183+StrLenFont19(F24W3FullPath[F3y-1])-StrLenFont19(KeyInStr);
	F24InputY=MidY+74;

	PutsFont19(183,F24InputY, LILAC,F24W3FullPath[F3y-1]);
	PutsFont19(183,F24InputY+47, PURPLE,F24W3FullPath[F3y-1]);

	strcpy(NewPath,RenamePath);
	NewPath[strlen(RenamePath)-strlen(KeyInStr)]=(null);

	F24GetNameDisplayInputString();
	Result=F24GetKeyboardInput();
	if( Result==27) goto out;

	strcpy(OldPath,RenamePath);
	strcat(NewPath,KeyInStr);
	Result=rename(OldPath,NewPath);

	if(Result==0) {
		goto out;
	} else {
	rectfill(screen,303,77,476,MidY-13-64,BLACK);
		if(exists(NewPath)) {
	PutsFont19(338,77,MANGO,"NAME IN USE");
	PutsFont19(338,77+32,MANGO,"CANNOT RENAME");
		} else {
			PutsFont19(338,77,MANGO,"INVALID NAME");
			PutsFont19(338,77+32,MANGO,"CANNOT USE");
		}
/*	sleep(1); */
	}
	if(Result != 0) Result=27;

out:
	rectfill(screen,303,77,476,MidY-96,BLACK);
	rectfill(screen,10,MidY-10+24,780,560,BLACK);

	F24UpperMessageBoxes();
	F24W2Refresh();
	F24W4Refresh();

	if(Result==0) {
		strcpy(F24W3FullPath[F3y-1], NewPath);
		strcpy(F24W3Folders[F3y+1],KeyInStr);
		F24W3Refresh();
		F24W3Cursor();

		k=strlen(OldPath);
		z=0;
		do { /* reflect W3 name change to W1 */
			if(memicmp(OldPath,F24W1FullPath[z],k)==0) {
				strcpy(F24W1FullPath[z],NewPath);
				strcpy(F24W1Folders[z+2],KeyInStr);
				F24W1Refresh();
				break;
			}
			z++;
		} while(z < F24W1EndList);
	}
	F24RecursiveFolderRename(OldPath, NewPath);
}
void F24W3DeleteFolder()
{
	int Result,i,z;
	char CmdStr[128];
	char RecyclePath[128];
	char SourcePath[128];
	char CheckStr[128];
	char DupStr[128];
	char FolderContentStr[128];
	char PaddyWagon[128];

	strcpy( CmdStr, "md ");
	strcat( CmdStr, LcarsPath);
	strcat( CmdStr, "\\RECYCLE\\");
	strcpy( RecyclePath, LcarsPath);
	strcat( RecyclePath, "\\RECYCLE\\");
	strcpy( SourcePath, LcarsPath);
	strcat( SourcePath, "\\");
	F24Box(BLACK, 1, "","","","");
	F24Box(BLACK, 2, "","","","");
	F24Box(BLACK, 3, "","","","");

	if(F24W3Info[F3y+1][2] < 1) {
		F24DeletionProhibitedMessage();
		Result=27;
		goto out;
	}

	if(F24W3Info[F3y+1][2]==2) {
		i=F3y+1;
		while(F24W3Info[i][2]==2) --i;
		strcat(SourcePath,F24W3Folders[i]);
		strcat(SourcePath,"\\");
	}

	strcpy(CheckStr,SourcePath);
	strcat(CheckStr,F24W3Folders[F3y+1]);
	strcpy(FolderContentStr,CheckStr);

	if( F24RenamingProhibitedCheck(CheckStr)==1) {
		F24DeletionProhibitedMessage();
		Result=27;
		goto out;
	}

	if(strncmp(CheckStr,RecyclePath,18) ==0) {
		Result=F24Dialog(284,160, F24W3Folders[F3y+1],"DELETE");
		if(Result !=1) goto out;
		else {
			strcpy(FolderContentStr,CheckStr);
			strcat(FolderContentStr,"\\*.*");
			goto skip_recycle;
		}
	}

	memset(DupStr,(null),128);
	strcpy(DupStr,RecyclePath);
	strcat(DupStr,F24W3Folders[F3y+1]);

	if(F24FolderExists(DupStr)==0) {
		F24RecycleProhibitedMessage();
		Result=27;
		goto out;
	}

	Result=F24Dialog(284,160, F24W3Folders[F3y+1],"DELETE");
	if(Result !=1) goto out;


/* actually do something: make a subfolder in the recycle bin */
	strcat(RecyclePath,F24W3Folders[F3y+1]);
	if(F24FolderExists(RecyclePath) != 0) {
		strcat( CmdStr, F24W3Folders[F3y+1]);
		system(CmdStr);
	}

/* makes sure the folder is not empty, since DOS is such a pain */
	strcat(FolderContentStr,"\\*.*");
	F24FindFiles(FolderContentStr);  /* reports NumOfFiles, used below */

/* copy files to the new subfolder in the recycle bin */
	if(NumOfFiles > 0) {
		memset(CmdStr,(null),128);
		strcpy(CmdStr,"copy ");
		strcat(CmdStr,CheckStr);
		strcat(CmdStr,"\\*.* ");
		strcat(CmdStr,RecyclePath);
		strcat(CmdStr,">NUL");
		system(CmdStr);
	}

skip_recycle:

/* delete files from the condemned folder */
	F24FindFiles(FolderContentStr);
	if(NumOfFiles > 0) {
		memset(CmdStr,(null),128);
		strcpy(CmdStr,CheckStr);
		strcat(CmdStr,"\\*.* ");
		F24FindFiles(CmdStr);
		for(z=0; z<=NumOfFiles; ++z) {
			strcpy(PaddyWagon,CheckStr);
			strcat(PaddyWagon,"\\");
			strcat(PaddyWagon,F24FileArray[z]);
			remove(PaddyWagon);
		}
	}

/* remove the now-empty condemned folder */
	rmdir(CheckStr);
out:
	rectfill(screen,284,77,480,MidY-13-64,BLACK);
	F24UpperMessageBoxes();
	if(Result != 27) F24Reinit(3);
}
int F24W3Active()
{
	int i;

	F24EraseUpperSwitchBox();
	F24EraseLowerSwitchBox();
	DrawF24W3();
	MaxX=788;
	F3x=1;
	OldF3x=1;
	if(F3y < F24W3Offset+1) F3y=F24W3Offset+1;
	F24W3Cursor();
loopback:
	clear_keybuf();
	do {
		UpdateIdle();
	} while(!keypressed());
		c=GetKey();
		switch( c)
		{
			case BS:
				if(F3x==2 && F3y > 1 && F24W3Info[F3y+1][1]==1 && F3y >1) F24W3Nest();
				goto loopback;
			case DELKEY:
				if(F3x==1) {
					F24W3DeleteFolder();
					goto loopback;
				}
				if(F3x==2 && F3y > 1 && F24W3Info[F3y+1][1]==1 && F3y >1) F24W3Nest();
				goto loopback;
			case F1: F24MakeFolder();
				goto loopback;
			case F2: F24W3Rename();
				goto loopback;
			case F3: 	F24CheckFloppy();
					goto loopback;
			case F4: /* SaveReport(); */
				goto loopback;
			case F11: F24Help();
					goto loopback;
			case F12: return(0);
			case 13: if(F3x==1) F24W3Open();
/* deep nesting acknowledged but not expanded */
	/* 			if(F24W3Info[F3y+1][2] > 1 && F3x==2) goto loopback; */
				if(F3x==2 && F3y >1) F24W3Nest();
				goto loopback;
			case UPARROW: if(F3y==1) goto loopback;
				--F3y;
				if( F3y==0) {
					if(F24Drives()==0) return(0);
					F3y=1;
					F24W3Cursor();
					if(F3x==3) {
						UpperSwitchBox();
						return(3);
					}
					F3x=1;
					F24W3Cursor();
					goto loopback;
				} else {
					if(F3y-F24W3Offset < 1) {
						--F24W3Offset;
						F24W3Refresh();
					}
				}
				goto cursor;
			case DOWNARROW:
				if( F3y >= F24W3EndList-1) goto loopback;
				++F3y;
				if(F3y-F24W3Offset > 5) {
					++F24W3Offset;
					F24W3Refresh();
				}
				goto cursor;
			case PGUPKEY:
				for( i=0; i<2; i++) {
					if( F3y==1) { break; goto loopback; }
					--F3y;
					if(F3y-F24W3Offset < 1) {
						--F24W3Offset;
						F24W3Refresh();
					}
				}
				goto cursor;
			case PGDNKEY:
				for( i=0; i<2; i++) {
					if( F3y >= F24W3EndList-1) { break; goto loopback; }
					++F3y;
					if(F3y-F24W3Offset > 5) {
						++F24W3Offset;
						F24W3Refresh();
					}
				}
				goto cursor;

			case RIGHTARROW: if(F3x>1) --F3x;
				F24W3Cursor();
				goto loopback;
			case LEFTARROW: ++F3x;
				F24W3Cursor();
				if(F3x==3) {
					UpperSwitchBox();
					return(3);
				}
				goto loopback;
			case CTRL_F1: Screenshot792("Files8.bmp");
				goto loopback;
			default: goto loopback;
		}
cursor:
	F24W3Cursor();
	goto loopback;
}
void DrawF24W4()
{
	char CheckStr[128];
	F24EraseLowerElbows();
	F24Bumpers();
	MaxX=779;
	MaxY=588;
	MinY=MidY-26;
	F24NwElbow();
	F24SwElbow();
	MaxX=440;
	F24LowerMessageBoxes();

	strcpy( CheckStr, LcarsPath);
	strcat( CheckStr, "\\RECYCLE\\*.*");
	if(stricmp(F24W3ListTitle, CheckStr)==0) {
		PutsLuna(43,569, BLACK,LILAC, "Empty Recycle folder: F5");
        	DisplayEmptyRecycle=TRUE;
	} else DisplayEmptyRecycle=FALSE;
	if(F24W3EndList==0) DisplayEmptyRecycle=FALSE;
}
void F24W4Cursor()
{
	int gx,gy;

	gx=663;
	gy=MidY-6+((OldF4y-F24W4Offset)*24);
	EnterSymbol(gx,gy,1,0);
	gx=663;
	gy=MidY-6+((F4y-F24W4Offset)*24);
	if(F4x<2) EnterSymbol(gx,gy,1,NAPLES);
	OldF4y=F4y;
}
void F24W4Up()
{
	if( F4y==1) return;
	--F4y;
	if(F4y-F24W4Offset < 1) --F24W4Offset;
}
void F24W4Dn()
{
	if( F4y >= F24W4EndList) return;
	++F4y;
	if(F4y-F24W4Offset > 8) ++F24W4Offset;
}
void F24W4Clipboard()
{
	memset(FileClipboard,(null),128);
	rectfill(screen,482,588-26,788,588,LILAC);
	if(F24W4EndList==0) {
		PutsLuna(516,569, BLACK,LILAC, "CLIPBOARD CLEARED");
		strcpy( FileClipboard, "***");
	} else {
		PutsLuna(516,569, BLACK,LILAC, "CLIPBOARD:");
		PutsLuna(516+StrLenLuna("CLIPBOARD: "),569,BLACK,LILAC,F24W4List[F4y]);
		strcpy(FileClipboard,F24W4Path);
		strcpy(SourceFilename,F24W4Path);
		strcat(FileClipboard,F24W4List[F4y]);
		strcpy(SourceFilename,F24W4List[F4y]);
	}
}
void F24W4Delete()
{
	char PaddyWagon[128];
	char RecycleName[128];
	char TempStr[128];
	char Message[128];
	int Result=0;
	int Failure, gy;

	F24EraseLowerMessageBoxes();
	Result=F24Dialog(284,360, F24W4List[F4y],"DELETE");
	if(Result==1) {
		gy=MidY-13+((OldF4y-F24W4Offset)*24);
		rectfill(screen,514,gy,656,gy+21,BLACK);
		strcpy(PaddyWagon,F24W4Path);
		strcat(PaddyWagon,F24W4List[F4y]);
		strcpy( TempStr, LcarsPath);
		strcat( TempStr, "\\RECYCLE\\");
		if( stricmp( TempStr, F24W4Path) != 0) {
			strcpy(RecycleName, TempStr);
			strcat(RecycleName,F24W4List[F4y]);
			Failure=rename(PaddyWagon,RecycleName);
			if(Failure !=0) {
				strcpy(Message,PaddyWagon);
				strcat(Message,"--DEL FAILURE");
				rectfill(screen,12,588-26,297,588,ORANGE);
				PutsLuna(43,569, BLACK,ORANGE, Message);
			/*	sleep(1); */
			} else {
				if( stricmp( PaddyWagon, FileClipboard)==0) {
					rectfill(screen,482,588-26,788,588,LILAC);
					PutsLuna(516,569, BLACK,LILAC, "CLIPBOARD EMPTY");
					strcpy( FileClipboard, "***");
				}
			}
		}  else remove(PaddyWagon);

		F24UpdateAll();
		F24W4Cursor();
	}
	F24LowerMessageBoxes();
/*
strcpy(Message,PaddyWagon);
strcat(Message,"--DEL");
if(Failure !=0) strcat(Message," FAILED");
rectfill(screen,12,588-26,297,588,LILAC);
PutsLuna(43,569, BLACK,LILAC, Message);
*/
}
void F24W4Move()
{ /* moves selected file from W4 to W2, called by F6 keypress in W4 */
	char Dest[128];
	char Source[128];
	char CheckExisting[128];
	char CmdStr[128];
	int Result=1;
	int gy;

/* setup for checking for identical filename at destination */
	strcpy(CheckExisting,F24W2Path);  /* OK */
	strcpy(SourceFilename,F24W4List[F4y]);
	strcat(CheckExisting,SourceFilename);

/* check user intent to overwrite if matching filename found */
	if(exists(CheckExisting)) {
		F24EraseLowerMessageBoxes();
		Result=F24Dialog(284,360, "EXISTING FILE HAS SAME FILENAME","CANCEL");
		F24LowerMessageBoxes();
		F24Box(PALEBLUE, 7, "MOVE FILE","","TO LEFT","F6");
		return;
	}
	gy=MidY-13+((OldF4y-F24W4Offset)*24);
	rectfill(screen,514,gy,656,gy+21,BLACK); /* small visual effect */
	strcpy(Dest,F24W2PastePath);
	if(memicmp(F24W2PastePath,"A:\\",3) !=0) strcat(Dest,"\\");
	strcat(Dest, F24W4List[F4y]);
	strcpy(Source,F24W4Path);
	strcat(Source,F24W4List[F4y]);

	if(rename(Source, Dest)==0) goto out; /* the fast way */

	Result=CopyFile(Source,Dest);
	if(Result==1 || Result==2 || Result==3) F24CopyError(Result);
	if(Result==4) {
		memset(CmdStr,(null),128);
		strcpy(CmdStr,"copy ");
		strcat(CmdStr,Source);
		strcat(CmdStr," ");
		strcat(CmdStr,F24W4PastePath);
		strcat(CmdStr,">NUL");
		system(CmdStr);
	}
	remove(Source);
out:
	F24UpdateAll();
	F24W4Cursor();
}
void F24W4Paste()
{
	char CmdStr[128];
	char CheckExisting[128];
	char Dest[128];
	int Result=1;
	int FileSize, FloppyFree, SpaceDebit;
	char CopyAll=FALSE;

	if(F24W4PastePath[0]==0) return;

/* check for empty clipboard */
	if( strcmp( "***", FileClipboard)==0) {
		rectfill(screen,482,588-26,788,588,LILAC);
		PutsLuna(516,569, BLACK,LILAC, "CLIPBOARD EMPTY");
		return;
	}
/* check for illegal "COPY ALL" clipboard */
	if( memicmp( F24W3ListTitle, FileClipboard,strlen(F24W3ListTitle))==0) {
		F24EraseLowerMessageBoxes();
		Result=F24Dialog(284,360, "CANNOT COPY TO SOURCE","CANCEL");
		F24LowerMessageBoxes();
		return;
	}
/* check for legal "COPY ALL" clipboard */
/* The list has to be different from source to get past the above check. */
	if( strcmp( get_filename( FileClipboard), "*.*")==0) {
		F24EraseLowerMessageBoxes();
		PutsFont19(284,388,ORANGE,"WARNING");
		Result=F24Dialog(284,396, "MATCHING FILES WILL BE OVERWRITTEN","COPY ALL");
		rectfill(screen,284,388,400,416,BLACK);
		F24LowerMessageBoxes();
		if(Result==1) {
			CopyAll=TRUE;
			goto DoPaste;
		}
		else return;
	}

/* setup for checking for existence of identical filename at destination */
	strcpy(CheckExisting,F24W4Path);
	strcat(CheckExisting,SourceFilename);

/* check for destination=source */
	if( stricmp( CheckExisting, FileClipboard)==0) {
		F24EraseLowerMessageBoxes();
		Result=F24Dialog(284,360, "CANNOT COPY FILE TO ITSELF","CANCEL");
		rectfill(screen,284,388,400,416,BLACK);
		F24LowerMessageBoxes();
		return;
	}

/* check user intent to overwrite if matching filename found */
	if(exists(CheckExisting)) {
		F24EraseLowerMessageBoxes();
		Result=F24Dialog(284,360, "EXISTING FILE HAS SAME FILENAME","OVERWRITE");
		rectfill(screen,284,388,400,416,BLACK);
		F24LowerMessageBoxes();
		if(Result !=1) return;
	}
/* check for sufficient disk space if destination is floppy */

	FileSize=F24FileSize(FileClipboard);
	FloppyFree=F24FloppyDiskSpace();
	SpaceDebit=FloppyFree-FileSize;

	if(strcmp(F24W4PastePath,"A:\\") == 0 && SpaceDebit <= 128) {
		F24EraseLowerMessageBoxes();
		Result=F24Dialog(284,360, "INSUFFICIENT FREE SPACE ON FLOPPY","CANCEL");
		rectfill(screen,284,388,400,416,BLACK);
		F24LowerMessageBoxes();
		return;
	}

DoPaste:
	if(Result==0) return;
	if(CopyAll==TRUE) {
		Result=4;
		goto bypass;
	}
	strcpy(Dest,F24W4PastePath);
	if(memicmp(F24W4PastePath,"A:\\",3) !=0) strcat(Dest,"\\");
	strcat(Dest,get_filename(FileClipboard));
	Result=CopyFile(FileClipboard,Dest);
	if(Result==1 || Result==2 || Result==3) F24CopyError(Result);
bypass:
	if(Result==4) {
		memset(CmdStr,(null),128);
		strcpy(CmdStr,"copy ");
		strcat(CmdStr,FileClipboard);
		strcat(CmdStr," ");
		strcat(CmdStr,F24W4PastePath);
		strcat(CmdStr,">NUL");
		system(CmdStr);
	}
	F24UpdateAll();
	F24W4Cursor();
/*
rectfill(screen,43,588-26,297,588,LILAC);
PutsLuna(43,569, BLACK,LILAC, Dest);
*/
}
void F24W4Clear()
{
	int z;

	for(z=0; z <= 999; ++z) {
		memset(F24W4List[z],(null),128);
	}
	rectfill(screen,512,MidY-10+24,720,560,BLACK);
}
void F24W4EmptyRecycle()
{
	char PaddyWagon[128];
	char TempStr[128];
	int Result=0;
	int z;

	strcpy( TempStr, LcarsPath);
	strcat( TempStr, "\\RECYCLE\\");
	F24EraseLowerMessageBoxes();
	Result=F24Dialog(284,360, "ALL FILES & FOLDERS IN RECYCLE BIN","DELETE");
	if(Result==1) {
		if( stricmp( FileClipboard, TempStr)==0) {
			rectfill(screen,482,588-26,788,588,LILAC);
			PutsLuna(516,569, BLACK,LILAC, "CLIPBOARD EMPTY");
			strcpy( FileClipboard, "***");
		}
		for(z=0; z<=F24W4EndList; ++z) {
			strcpy(PaddyWagon, TempStr);
			strcat(PaddyWagon,F24W4List[z]);
			remove(PaddyWagon);
		}
		F24DeleteAllFoldersFromRecycleBin();
		DisplayEmptyRecycle=FALSE;
		F24W4Clear();
		LowerSwitchBox();
		F24EraseLowerSwitchBox();
		F24Reinit(3);
	}
	F24LowerMessageBoxes();
}
void F24W4CopyAll()
{
	memset(FileClipboard,(null),128);
	rectfill(screen,482,588-26,788,588,LILAC);
	strcpy(FileClipboard,F24W3ListTitle);
	PutsLuna(516,569, BLACK,LILAC, "CLIPBOARD:");
	PutsLuna(516+StrLenLuna("CLIPBOARD: "),569,BLACK,LILAC,FileClipboard);
}
void F24W4Refresh()
{
	int bottom, z;
	char TruncateStr[80]; /* to prevent Windows from displaying
				 a long filename */

	rectfill(screen,483,MidY-10+24,720,560,BLACK);
	bottom=F24W4EndList;
	if(F24W4EndList>8) bottom=8;
	for(z=1;z<=bottom;++z) {
		strcpy(TruncateStr,F24W4List[z+F24W4Offset]);
		TruncateStr[12]=(null);
		RightPutsFont19(647,MidY-10+(z*24),PALEBLUE,TruncateStr);
	}
}
int F24W4Active()
{
	char FullPathAndFilename[128];
	int z;

	F24EraseUpperSwitchBox();
	F24EraseLowerSwitchBox();
	ActiveWindow=4;
	DrawF24W4();
	MaxX=440;
	F4x=1;
	if(F4y < F24W4Offset+1) F4y=F24W4Offset+1;
	F24W4Cursor();
loopback:
	clear_keybuf();
	do {
		UpdateIdle();
	} while(!keypressed());
		c=GetKey();
		switch( c)
		{
			case DELKEY:
				F24W4Delete();
				goto loopback;
			case 13:
				strcpy(FullPathAndFilename,F24W4Path);
				strcat(FullPathAndFilename,F24W4List[F4y]);
				if( ! exists(FullPathAndFilename) && DriveCurrent==1 ) {
					F24W4Clear();
					PutsFont19(516,MidY-10+(3*24),ORANGE,"CHECK FLOPPY");
					F24CheckFloppy();
					goto loopback;
				}
				if( ! exists(FullPathAndFilename)) goto cursor;
				F24FileView(FullPathAndFilename);
				goto cursor;
			case F3:
				goto loopback;
			case F5: if(DisplayEmptyRecycle==FALSE) goto loopback;
				F24W4EmptyRecycle();
				goto cursor;
			case F6: if(F24W4MoveOK==TRUE) F24W4Move();
				goto loopback;
			case F7: if(strcmp(F24W4PastePath,"A:\\")==0) goto loopback;
				goto loopback;
			case F8: F24W4CopyAll();
				goto loopback;
			case F9: F24W4Clipboard();
				goto loopback;
			case F10: F24W4Paste();
					goto loopback;
			case F11: F24Help();
				goto loopback;
			case F12: return(0);
			case PGUPKEY: OffsetHolder=F24W4Offset;
			if( F4y==1) goto loopback;
				for(z=1;z<=4;++z) F24W4Up();
				if(F24W4Offset != OffsetHolder) F24W4Refresh();
				goto cursor;
			case PGDNKEY: OffsetHolder=F24W4Offset;
				if( F4y >= F24W4EndList) goto loopback;
				for(z=1;z<=7;++z) F24W4Dn();
				if(F24W4Offset != OffsetHolder) F24W4Refresh();
				goto cursor;
			case UPARROW: if( F4y==1) goto loopback;
				--F4y;
				if(F4y-F24W4Offset < 1) {
					--F24W4Offset;
					F24W4Refresh();
				}
				goto cursor;
			case DOWNARROW: if( F4y >= F24W4EndList) goto loopback;
				++F4y;
				if(F4y-F24W4Offset > 8) {
					++F24W4Offset;
					F24W4Refresh();
				}
				goto cursor;
			case LEFTARROW:
				++F4x;
				if(F4x==2) {
					F24W4Cursor();
					LowerSwitchBox();
					return(4);
				}
				goto cursor;
			case CTRL_F1: Screenshot792("Files8.bmp");
				goto loopback;
			default: goto loopback;
		}
cursor:
	F24W4Cursor();
	goto loopback;
}
void F24Screen1()
{
	DrawF24W1();
	MinY=13;
	rectfill(screen,12,MinY,297,MinY+26,LILAC);
	rectfill(screen,12,MaxY-26,297,MaxY,LILAC);
	ColorTitle("FILES 24", LILAC);
	F24UpperMessageBoxes();
	MaxY=588;
	rectfill(screen,12,MaxY-26,297,MaxY,LILAC);
	MaxX=788;

/*		right	*/
	MaxY=27+12;
	rectfill(screen,482,MaxY-26,MaxX,MaxY,LILAC);
	MaxY=MidY;
	rectfill(screen,482,MaxY-26,MaxX,MaxY,LILAC);
	MaxY=588;
	rectfill(screen,482,MaxY-26,MaxX,MaxY,LILAC);
	PutsLuna(150,19, BLACK,LILAC, "HELP: F11");
	PutsLuna(220,19, BLACK,LILAC, "CLOSE: F12");
	PutsLuna(516,19, BLACK,LILAC, "DELETE: DEL");
}
void F24Circus(int Active)
{
	int z;
	F24Screen1();
	for(z=0; z<1000; ++z); {
		memset(F24FolderArray[z],(null),16);
		memset(F24FolderArray[z],(null),16);
	}
	F24ShowFolders();
	F24W1Init();
	F24W1Refresh();
	F24W3Init();
	F24W3Refresh();
	F24W1Refresh();
	F1y=OldF1y;
	if(Active==1) ActiveWindow=F24W1Active();
	if(Active==2) ActiveWindow=F24W2Active();
	if(Active==3) ActiveWindow=F24W3Active();
	if(Active==4) ActiveWindow=F24W4Active();
loopback:
	if(ActiveWindow==0) return;
	do {
		UpdateIdle();
	} while(!keypressed());
		c=GetKey();
		switch( c)
		{
			case F11: F24Help();
				goto loopback;
			case F12: return;
			case UPARROW:
				if(ActiveWindow==2) ActiveWindow=F24W1Active();
				if(ActiveWindow==4) ActiveWindow=F24W3Active();
				goto loopback;
			case DOWNARROW:
				if(ActiveWindow==1) ActiveWindow=F24W2Active();
				if(ActiveWindow==3) ActiveWindow=F24W4Active();
				goto loopback;
			case LEFTARROW:
				if(ActiveWindow==1) ActiveWindow=F24W1Active();
				if(ActiveWindow==2) ActiveWindow=F24W2Active();
				if(ActiveWindow==3) ActiveWindow=F24W1Active();
				if(ActiveWindow==4) ActiveWindow=F24W2Active();
				goto loopback;
			case RIGHTARROW:
				if(ActiveWindow==3) ActiveWindow=F24W3Active();
				if(ActiveWindow==1) ActiveWindow=F24W3Active();
				if(ActiveWindow==4) ActiveWindow=F24W4Active();
				if(ActiveWindow==2) ActiveWindow=F24W4Active();
				goto loopback;
			default: goto loopback;
		}
}
void F24Init()
{
	int z;

	for(z=0; z<1000; z++) {
		F24W1Info[z][3]=0; /* no folders highlighted at startup */
		F24W3Info[z][3]=0;
	}
	F24W1Offset=0;
	F24W2Offset=0;
	F24W3Offset=0;
	F24W4Offset=0;
	NumOfFiles=0;
	NumOfFolders=0;
	z=0;
	F1y=2;
	OldF1y=2;
	F2y=2;
	OldF2y=2;
	F3y=2;
	OldF3y=2;
	F4y=1;
	OldF4y=1;
	F24W3Current=2;
	F24W2Open=FALSE;
	F24W4Open=FALSE;
	F24W2MoveOK=FALSE;
	F24W4MoveOK=FALSE;
	MaxX=799;
	MaxY=599;
	MidY=345;
	ActiveWindow=1;
	F24InputPos=284;
	memset(F24W2PastePath,(null),128);
	memset(F24W4PastePath,(null),128);
	strcpy(FileClipboard, "***");
	DisplayEmptyRecycle=FALSE;
	DrivesActive=0;
	DriveCurrent=3;
}
int Files24Mode()
{
	F24Init();
	rectfill(screen,0,0,800,600,BLACK);
	BeepSet=TRUE;
	F24Circus(1);
	MaxX=799;
	MaxY=599;
}

