/* Drawline, support for rendering antialiased lines LCARS 24 */

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "drawline.h"


int PutGhostPixel(int x, int y, int color, int range, int step)
{
	int r1,b1,g1,r2,b2,g2;
	int dr,db,dg;
	int diffR, diffG, diffB;
	int fade, fadeR, fadeG, fadeB;
	int bgcolor;

/* safety net the calling program shouldn't require */
	if(range < 1) range=1;
	if( step < 0) step=1;
	if( step > range ) step=range;

/* for analyzing a calling program */
/*
if( step < 0) { putpixel(screen,x,y+2,makecol(0,255,255)); return(0); }
if( step > range ) { putpixel(screen,x,y+2,makecol(255,0,255)); return(0); }
*/


	dr=r1=getr(color);
	dg=g1=getg(color);
	db=b1=getb(color);

	bgcolor=getpixel(screen,x,y);
	if(color==bgcolor) return(-1);  /* for drawing with muliple lines */

	r2=getr(bgcolor);
	g2=getg(bgcolor);
	b2=getb(bgcolor);

	diffR=r1-r2;
	diffG=g1-g2;
	diffB=b1-b2;

	fade=range+1;

	fadeR=diffR/fade;
	fadeG=diffG/fade;
	fadeB=diffB/fade;


	dr -= (fadeR*step);
	dg -= (fadeG*step);
	db -= (fadeB*step);

	if(dr<0) dr=0;
	if(dg<0) dg=0;
	if(db<0) db=0;

	putpixel(screen,x,y,makecol(dr,dg,db));

	return(0);
}


int UpRight(BITMAP *bmp, float x1, float y1, float x2, float y2, int color, int width)
{
	int dx,dy,sdx,sdy,px,px2,py,py2,dxabs,dyabs,i,oldpx,oldpy;
	int temp,seg;
	int xseg,yseg,xstep,ystep,jaggies;
	float slope;
	float fdx, fdy, fd;
	int v[8];


	width--;

	dx=x2-x1;      /* horizontal distance of the line */
	dy=y2-y1;      /* vertical distance of the line */
	dxabs=abs(dx);
	dyabs=abs(dy);
	sdx=sgn(dx);
	sdy=sgn(dy);

	fdx = x1 - x2;
	fdy = y1 - y2;
	fd = sqrt(fdx * fdx + fdy * fdy);
	if(!fd) return(-1);

	width=width/2;
        v[0] = x1 - width * fdy / fd;
        v[1] = y1 + width * fdx / fd;

        v[2] = x1 + width * fdy / fd;
        v[3] = y1 - width * fdx / fd;

        v[4] = x2 + width * fdy / fd;
        v[5] = y2 - width * fdx / fd;

        v[6] = x2 - width * fdy / fd;
	v[7] = y2 + width * fdx / fd;
	width=(width*2);


	if(dxabs==dyabs) {			/* if perfect diagonal */
		polygon(bmp, 4, v, color);
		slope=(float)dy / (float)dx;

		px=i+v[0];
		px2=i+v[2];
		py=slope*i+v[1];
		py2=slope*i+v[3];

		for(i=0;i !=dx;i+=sdx) {
			px=i+v[0];
			px2=i+v[2];
			py=slope*i+v[1];
			py2=slope*i+v[3];

			PutGhostPixel(px,py-1,color,2,1);
			PutGhostPixel(px2+1,py2,color,2,2);

		}
		return(0);
	}

	if(dxabs>=dyabs) {			/* gentle slope */
		slope=(float)dy / (float)dx;
		temp=(float)dx / (float)dy;
		seg=abs((int)temp);
		oldpy=v[1];
		xseg= dxabs/dyabs;
		jaggies= dxabs % dyabs;
		if(jaggies) yseg= dyabs/jaggies;
			else yseg= 0;
		xseg++;
		yseg++;
		xstep=1;
		if(xseg==2 && width >0) v[3]++;
		width=(v[3]-v[1]);

		for(i=1;i !=dx;i+=sdx) {
			px=i+v[0];
			px2=i+v[0];
			py=slope*i+v[1];
			py2=slope*i+v[3];

			vline(bmp,px,py,py+width,color);

			if(xseg >2) {
				if(oldpy != py) xstep=1;
				oldpy=py;

				PutGhostPixel(px,py-1,color,xseg+1,xseg-xstep+1);
				PutGhostPixel(px2,py2+1,color,xseg,xstep);
			} else {
				if(oldpy == py) xstep=1;
				oldpy=py;

				PutGhostPixel(px2,py2+1,color,yseg+1,(yseg+1)-xstep);
				if(i==0) PutGhostPixel(px,py-1,color,yseg,yseg);
					else PutGhostPixel(px,py-1,color,yseg,xstep);
			}

			xstep++;
		}

	} else { 				/* steep slope */
		slope=(float)dx / (float)dy;
		temp=(float)dy / (float)dx;
		seg=abs((int)temp);
		oldpx=v[0];
		yseg= dyabs/dxabs;
		jaggies= dyabs % dxabs;
		if(jaggies) xseg= dxabs/jaggies;
			else xseg= 0;
		yseg++;
		xseg++;
		ystep=1;

		if(yseg==2 && width>0) v[0]--;
		width=(v[0]-v[2]);

		for(i=sdy;i!=dy;i+=sdy) {
			py=i+v[1];
			py2=i+v[1];
			px=slope*i+v[0];
			px2=slope*i+v[2];

			hline(bmp,px,py,px-width,color);

			if(yseg >2) {
				if(oldpx != px) ystep=1;
				oldpx=px;
				PutGhostPixel(px2+1,py2,color,yseg,yseg-ystep);
				PutGhostPixel(px-1,py,color,yseg,ystep);
			} else {
				if(oldpx == px) ystep=1;
				oldpx=px;
				PutGhostPixel(px-1,py,color,xseg+1,(xseg+1)-ystep);
/*				if(i==0) PutGhostPixel(px2+1,py2,color,xseg,xseg);
					else */ PutGhostPixel(px2+1,py2,color,xseg,ystep);

			}
			ystep++;
		}
	}
	return(0);
}


int DownRight(BITMAP *bmp, float x1, float y1, float x2, float y2, int color, int width)
{
	int dx,dy,sdx,sdy,px,px2,py,py2,dxabs,dyabs,i,oldpx,oldpy;
	int temp,seg;
	int xseg,yseg,xstep,ystep,jaggies;
	float slope;
	float fdx, fdy, fd;
	int v[8];


	width--;

	dx=x2-x1;      /* horizontal distance of the line */
	dy=y2-y1;      /* vertical distance of the line */
	dxabs=abs(dx);
	dyabs=abs(dy);
	sdx=sgn(dx);
	sdy=sgn(dy);

	fdx = x1 - x2;
	fdy = y1 - y2;
	fd = sqrt(fdx * fdx + fdy * fdy);
	if(!fd) return(-1);

	width=width/2;
        v[0] = x1 - width * fdy / fd;
        v[1] = y1 + width * fdx / fd;

        v[2] = x1 + width * fdy / fd;
        v[3] = y1 - width * fdx / fd;

        v[4] = x2 + width * fdy / fd;
        v[5] = y2 - width * fdx / fd;

        v[6] = x2 - width * fdy / fd;
	v[7] = y2 + width * fdx / fd;
	width=(width*2);


	if(dxabs==dyabs) {			/* if perfect diagonal */
		polygon(bmp, 4, v, color);
		slope=(float)dy / (float)dx;
		px=i+v[0];
		px2=i+v[2];
		py=slope*i+v[1];
		py2=slope*i+v[3];

		for(i=0;i !=dx;i+=sdx) {
			px=i+v[0];
			px2=i+v[2];
			py=slope*i+v[1];
			py2=slope*i+v[3];
			PutGhostPixel(px+1,py,color,2,1);
			PutGhostPixel(px2,py2+1,color,2,2);
		}
		return(0);
	}

	if(dxabs>=dyabs) {			/* gentle slope */
		slope=(float)dy / (float)dx;
		temp=(float)dx / (float)dy;
		seg=abs((int)temp);
		oldpy=v[1];
		xseg= dxabs/dyabs;
		jaggies= dxabs % dyabs;
		if(jaggies) yseg= dyabs/jaggies;
			else yseg= 0;
		xseg++;
		yseg++;
		xstep=1;
		if(xseg==2 && width >0) v[3]++;
		width=(v[3]-v[1]);

		for(i=0;i !=dx;i+=sdx) {
			px=i+v[0];
			px2=i+v[0];
			py=slope*i+v[1];
			py2=slope*i+v[3];

			vline(bmp,px,py,py+width,color);
			if(xseg >2) {
				if(oldpy != py) xstep=1;
				oldpy=py;
				PutGhostPixel(px,py-1,color,xseg,xstep);
				PutGhostPixel(px2,py2+1,color,xseg+1,xseg-xstep+1);
			} else {
				if(oldpy == py) xstep=1;
				oldpy=py;
				PutGhostPixel(px,py-1,color,yseg+1,(yseg+1)-xstep);
				if(i==0) PutGhostPixel(px2,py2+1,color,yseg,yseg);
					else PutGhostPixel(px2,py2+1,color,yseg,xstep);
			}
			xstep++;
		}

	} else { 				/* steep slope */
		slope=(float)dx / (float)dy;
		temp=(float)dy / (float)dx;
		seg=abs((int)temp);
		oldpx=v[0];
		yseg= dyabs/dxabs;
		jaggies= dyabs % dxabs;
		if(jaggies) xseg= dxabs/jaggies;
			else xseg= 0;
		yseg++;
		xseg++;
		ystep=1;

		if(yseg==2 && width>0) v[0]++;
		width=(v[0]-v[2]);

		for(i=0;i!=dy;i+=sdy) {
			py=i+v[1];
			py2=i+v[1];
			px=slope*i+v[0];
			px2=slope*i+v[2];

			hline(bmp,px,py,px-width,color);
			if(yseg >2) {
				if(oldpx != px) ystep=1;
				oldpx=px;
				PutGhostPixel(px+1,py,color,yseg+1,yseg-ystep+1);
				PutGhostPixel(px2-1,py2,color,yseg,ystep);
			} else {
				if(oldpx == px) ystep=0;
				oldpx=px;
				if(i==0) PutGhostPixel(px+1,py,color,xseg+1,xseg);
					else PutGhostPixel(px+1,py,color,xseg+1,ystep+1);
				PutGhostPixel(px2-1,py2,color,xseg+2,(xseg-ystep)+2);
			}
			ystep++;
		}
	}
	return(0);
}

int DrawLine(BITMAP *bmp, int x1, int y1, int x2, int y2, int color, int width)
{
	int holder, length, i;

	if(x1 > x2) {
		holder=x2;
		x2=x1;
		x1=holder;
		holder=y2;
		y2=y1;
		y1=holder;
	}

/* if horizontal */
	if(y1==y2) {
		rectfill(bmp,x1,y1,x2,y1+width-1,color);
		length=x2-x1;
		for( i=0; i <= length; ++i ) {
			PutGhostPixel(x1+i,y1-1,color,2,1);
			PutGhostPixel(x1+i,y1+width,color,2,2);
		}
		return(0);
	}

/* if vertical */
	if(x1==x2) {
		rectfill(bmp,x1,y1,x1+width-1,y2,color);
		length=y2-y1;
		for( i=0; i <= length; ++i ) {
			PutGhostPixel(x1-1,y1+i,color,2,1);
			PutGhostPixel(x1+width,y1+i,color,2,2);
		}
		return(0);
	}

/* if downhill to right */

	if(y2 > y1) {
		DownRight(bmp, x1, y1, x2, y2, color, width);
		return(0);
	}

/* if downhill to left (uphill to right) */

	if(y1 > y2) {
		UpRight(bmp, x1, y1, x2, y2, color, width);
		return(0);
	}
	return(0);
}


