/* CHESS24, the chess app for LCARS 24 */
/* Powered by Faile, a chess engine */
/* Copyright (c) 2000 Adrien M. Regimbald */
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#include "chess24.h"

int FaileMessage(char *Str)
{
	rectfill(screen,130,13,700,27+12,LILAC);
	PutsLuna(130,8+12,BLACK,LILAC, Str);
	PutsLuna(478,8+12,BLACK,LILAC, "PICK UP/DROP: ENTER KEY	MOVE: ARROW KEYS");
}
void Skip()
{
	/* do nothing */
}

/* This was faile's main */
int faile()
{
	char input[STR_BUFF], *p, output[STR_BUFF];
	move_s move, comp_move;
	int depth=4, comp_color;
	bool force_mode, show_board;
	double nps, elapsed;
	clock_t cpu_start=0, cpu_end=0;

	start_up();
	init_hash_values();
	init_hash_tables();
	init_game();
	init_book();
	xb_mode=FALSE;
	force_mode=FALSE;
	comp_color=0;
	show_board=TRUE;
	PanelBeep();

/* keep looping for input, responding to any: */

	while(TRUE) {

/* case where it's the computer's turn to move: */

		if(comp_color==white_to_move && !force_mode) {
			nodes=0;
			qnodes=0;
			ply=0;

			start_time=rtime();
			cpu_start=clock();
			comp_move=think();
			cpu_end=clock();

/* check for a game end: */
			if(((comp_color==1 && result !=white_is_mated) ||
				(comp_color==0 && result !=black_is_mated)) &&
				result !=stalemate && result !=draw_by_fifty &&
				result !=draw_by_rep) {

					comp_to_coord(comp_move, output);

					make(&comp_move, 0);

/* check to see if we draw by rep fifty after our move: */
					if(is_draw()) {
						result=draw_by_rep;
					} else if(fifty > 100) {
						result=draw_by_fifty;
					}
					reset_piece_square();
/* check to see if we mate our opponent with our current move: */
					if(!result) {
					if(xb_mode) {
						Skip();
					} else {
						Skip();
					}
				} else {
					if(xb_mode) {
						Skip();
					} else {
						Skip();
				}
/* Note: The brackets eventually come out even, and the code
works, but . . . ! */

			if(result==white_is_mated) {
				MateMessage("Black Mates");
			} else if(result==black_is_mated) {
				MateMessage("White Mates");
			} else if(result==draw_by_fifty) {
				MateMessage("Fifty-move rule");
			} else if(result==draw_by_rep) {
				MateMessage("draw--threefold repetition");
			} else {
				MateMessage("Draw");
			}
		}
	}
/* we have been mated or there is a draw: */
	else {
		if(result==white_is_mated) {
			MateMessage("Black Mates");
		} else if(result==black_is_mated) {
			MateMessage("White Mates");
		} else if(result==stalemate) {
			MateMessage("Stalemate");
		} else if(result==draw_by_fifty) {
			MateMessage("Fifty-move rule");
		} else if(result==draw_by_rep) {
			MateMessage("Threefold repetition");
		} else {
			MateMessage("Draw");
		}
	}

	}

	 /* get our input: */

	 if(!xb_mode) {
	if(show_board && strcmp(input, "help")) {
		Skip();
		display_board(stdout, 1-comp_color);
	 }
	OrangeMessage("YOUR MOVE");
	EnemyColor=comp_color;
	ChessWindowActive();
	strcpy(input, PlayerMove);
/*  rinput(input, STR_BUFF, stdin); */
	 }
	 else {
		EnemyColor=comp_color;
		ChessWindowActive();
		strcpy(input, PlayerMove);
		rinput(input, STR_BUFF, stdin);
	 }

	 /* check to see if we have a move.  If it's legal, play it. */
	 if(is_valid_comp(pgn_to_comp(input))) {
		/* good SAN input style move */
		move=pgn_to_comp(input);
		make(&move, 0);
		reset_piece_square();
		HighlightOK=TRUE;
		if(show_board) {
			Skip();
			display_board(stdout, 1-comp_color);
		}
	}
	else if(is_move(&input[0])) {
		/* good coordinate style input move */
	if(verify_coord(input, &move)) {
/* UpdateBoard(); */

		make(&move, 0);
		reset_piece_square();
		HighlightOK=TRUE;
		if(show_board) {
			Skip();
			display_board(stdout, 1-comp_color);
		}
	}
	else {
		HighlightOK=FALSE;
		Skip();
	}
	}
	else {

		/* make everything lower case for convenience: */
	for(p=input; *p; p++) *p=tolower(*p);

		/* command parsing: */
		if(!strcmp(input, "quit") || !strcmp(input, "exit")) {
	return(0);  /* shut_down(EXIT_SUCCESS); */
		}
		else if(!strcmp(input, "diagram") || !strcmp(input, "d")) {
	toggle_bool(&show_board);
		}
		else if(!strncmp(input, "perft", 5)) {
	sscanf(input+6, "%d", &depth);
	raw_nodes=0;
	perft(depth);
		Skip();
		}
		else if(!strcmp(input, "new")) {
	init_game();
	/* refresh our hash tables: */
	refresh_hash();
	force_mode=FALSE;
	comp_color=0;
		}
		else if(!strcmp(input, "xboard")) {
	xb_mode=TRUE;
	toggle_bool(&show_board);
	signal(SIGINT, SIG_IGN);
		Skip();
		}
		else if(!strcmp(input, "nodes")) {
		Skip();
		}
		else if(!strcmp(input, "nps")) {
	elapsed=(cpu_end-cpu_start)/(double) CLOCKS_PER_SEC;
	nps=(float) nodes/(float) elapsed;
	if(!elapsed)
		Skip();
	else
		Skip();
		}
		else if(!strcmp(input, "post")) {
	toggle_bool(&post);
	if(xb_mode)
	  post=TRUE;
		}
		else if(!strcmp(input, "nopost")) {
	post=FALSE;
		}
		else if(!strcmp(input, "random")) {
	continue;
		}
		else if(!strcmp(input, "hard")) {
	continue;
		}
		else if(!strcmp(input, "easy")) {
	continue;
		}
		else if(!strcmp(input, "?")) {
	continue;
		}
		else if(!strcmp(input, "white")) {
	white_to_move=1;
	comp_color=0;
	EnemyColor=0;
		}
		else if(!strcmp(input, "black")) {
	white_to_move=0;
	comp_color=1;
	EnemyColor=1;
		}
		else if(!strcmp(input, "force")) {
	force_mode=TRUE;
		}
		else if(!strcmp(input, "go")) {
	comp_color=white_to_move;
	EnemyColor=white_to_move;
	force_mode=FALSE;
		}
		else if(!strncmp(input, "time", 4)) {
	sscanf(input+5, "%ld", &time_left);
		}
		else if(!strncmp(input, "otim", 4)) {
	sscanf(input+5, "%ld", &opp_time);
		}
		else if(!strncmp(input, "level", 5)) {
	/* extract the time controls: */
	sscanf(input+6, "%ld %ld %ld", &moves_to_tc, &min_per_game, &inc);
	time_left=min_per_game*6000;
	opp_time=time_left;
	inc *=100;
		}
		else if(!strncmp(input, "result", 6)) {
	ics_game_end();
	init_game();
	force_mode=FALSE;
	comp_color=0;
		}
		else if(!strcmp(input, "help")) {
		Skip();
	 }
			else if(!xb_mode) {
				HighlightOK=FALSE;
			}
		}
	}
	return 0;
}
void DisplayComputerMove()
{
	rectfill(screen,559+18,340,780,371,BLACK);
	PutsFont21(559+18,340, SEABLUE, "COMPUTER MOVE: ");
	PutsFont21(680+18,340, SEABLUE, ComputerMove);
}
void DisplayPlayerMove(int startx,int starty)
{
	unsigned short t;

	/* convert move to string to feed to chess engine, e.g. "e2e4" */
	/* used for debugging */

	t=startx+97;
	PlayerMove[0]=(t);
	t=starty ^ 7;
	t+=49;
	PlayerMove[1]=(t);
	t=chx+97;
	PlayerMove[2]=(t);
	t=chy ^ 7;
	t+=49;
	PlayerMove[3]=(t);
}
int DebugInfo()
{ /* for analysis during development */
/*
	char xval[4];
	char yval[4];
	char Report[4];

	rectfill(screen,350,13,438,27+12,LILAC);
	PutsLuna(350,8+12,BLACK,LILAC, "PC=");
	itoa(BoardContent[chx][chy],Report,10);
	PutsLuna(380,8+12,BLACK,LILAC, Report);

	if(CursorParked==0) {
		rectfill(screen,440,13,640,27+12,LILAC);
		PutsLuna(450,8+12,BLACK,LILAC, "X=");
		itoa(chx,xval,10);
		PutsLuna(480,8+12,BLACK,LILAC, xval);
		PutsLuna(550,8+12,BLACK,LILAC, "Y=");
		itoa(chy,yval,10);
		PutsLuna(580,8+12,BLACK,LILAC, yval);
		InspectSquare();
	}
*/
}
int MateMessage(char *Str)
{
	rectfill(screen,600,BoardY+240,740,BoardY+240+31,BLACK);
	rectfill(screen,600,BoardY+240,740,BoardY+240+31,BLACK);
	PutsFont21(600,BoardY+240, SEABLUE, Str);
	EraseOrangeMessage();
	MatePosted==TRUE;
	UpdateBoard();
}
int CheckMessage()
{
	if(MatePosted==TRUE) return; /* Don't post both. */
	PutsFont21(600,BoardY+180, SEABLUE, "CHECK");
}
int EraseCheckMessage()
{
	rectfill(screen,600,BoardY+180,740,BoardY+180+31,BLACK);
}
int OrangeMessage(char *Str)
{
	rectfill(screen,600,BoardY+300,740,BoardY+331,BLACK);
	PutsFont21(600,BoardY+300,ORANGE, Str);
}
int EraseOrangeMessage()
{
	rectfill(screen,600,BoardY+300,740,BoardY+331,BLACK);
}
int PlayerColorMessage()
{
	rectfill(screen,600,BoardY+420,740,BoardY+451,BLACK);
	if(EnemyColor==0)
		PutsFont21(600,BoardY+420,BRICK, "PLAYER: WHITE");
	else
		PutsFont21(600,BoardY+420,PURPLE, "PLAYER: BLACK");
}
int PawnPromotionDialog(int px, int py)
{
	PutsFont21(px+18,py, ORANGE, "SELECT PAWN PROMOTION");
	py -=15;
	ButtonType3(px, py+47, ORANGE, LILAC, "QUEEN");
	ButtonType2(px, py+(47*2), MANGO, PALEBLUE, "KNIGHT");
	ButtonType2(px, py+(47*3), BLACK, BRICK, "ROOK");
	ButtonType2(px, py+(47*4), PURPLE, BRICK, "BISHOP");

	EnterSymbol(px+126, py+47+1, 2, ORANGE);
	F36_1(px+140, py+(47*2)+1, MANGO, BLACK);
	F36_2(px+140, py+(47*3)+1, PALEBLUE, BLACK);
	F36_3(px+140, py+(47*4)+1, LAVENDER, BLACK);

loopback:
	do {
		UpdateIdle();
	} while(!keypressed());
		c=GetKey();
		switch(c)
		{
/*		 case F10: return(0); */
			case 13: rectfill(screen,px,py+15,px+194,py+220+15,BLACK);
				PlayerMove[4]='q';
				return(wqueen);
			case 49: rectfill(screen,px,py+15,px+194,py+220+15,BLACK);
				PlayerMove[4]='n';
				return(wknight);
			case 50: rectfill(screen,px,py+15,px+194,py+220+15,BLACK);
				PlayerMove[4]='r';
				return(wrook);
			case 51: rectfill(screen,px,py+15,px+194,py+220+15,BLACK);
				PlayerMove[4]='b';
				return(wbishop);
			case CTRL_F1: Screenshot792("Chess8.bmp");
				goto loopback;
			case CTRL_F2: Screenshot1024("Chess10.bmp");
				goto loopback;
			default: goto loopback;
		}
}
int Menu(int px, int py)
{
	rectfill(screen,BoardX+490,BoardY,BoardX+540,540,BLACK);
	rectfill(screen,BoardX+490,BoardY,790,BoardY+331,BLACK);
	PutsFont21(px+18,py, ORANGE, "SELECT OPTION");
	py -=15;
	ButtonType3(px, py+47, ORANGE, MANGO, "NEW GAME");
	ButtonType2(px, py+(47*2), MANGO, PALEBLUE, "CHANGE SIDES");
	RightBumper36(px+157,py+(47*3),BRICK);
	ButtonType3(px, py+(47*4), ORANGE, LILAC, "CLOSE MENU");

	F36_1(px+140, py+47+1, ORANGE, BLACK);
	F36_2(px+140, py+(47*2)+1, PALEBLUE, BLACK);
	EscSymbol(px+117,py+(47*4)+1,2, ORANGE);

loopback:
	do {
		UpdateIdle();
	} while(!keypressed());
		c=GetKey();
		switch(c)
		{
			case ESC: rectfill(screen,px,py+15,px+194,py+220+15,BLACK);
				return(0);
			case 49: rectfill(screen,px,py+15,px+194,py+220+15,BLACK);
				MatePosted=FALSE;
				return(1);
			case 50: rectfill(screen,px,py+15,px+194,py+220+15,BLACK);
				return(2);
			case CTRL_F1: Screenshot792("Chess8.bmp");
				goto loopback;
			case CTRL_F2: Screenshot1024("Chess10.bmp");
				goto loopback;
			default: goto loopback;
		}
}
int LoadChessFont()
{
	int c;

	long z;
	PACKFILE *Fp;

	for(z=0; z < 2304; ++z) {
		ChessFont[z]=0;
	}
	SetCurrentFile("\\SYSTEM\\FONTS\\CHESSMEN.F48");
	Fp=pack_fopen(CurrentFile, "rb");
	if ( Fp == NULL) FontLoadError(CurrentFile);

	for(z=0; z < 2304; ++z) {
		ChessFont[z]=pack_getc(Fp);
	}
	pack_fclose(Fp);
	return(0);
}
int BlitChessman(int TargetChar, int chx, int chy, int Hue)
{ /* a stolen element from the LCARS 24B antialiasing font drivers */
  /* This little function just lays down solid color
	for 48-point bitmapped characters (chess men). */

	static unsigned char BitVal[] = { 128,64,32,16,8,4,2,1 };
	int a,b;
	int z;
	unsigned char i;

	z=(TargetChar-47)*144;
	for(b=0; b<48; ++b) {
		if(ChessFont[b+z] !=0) {
			for(a=0; a<8; ++a) {
				i=ChessFont[b+z] & BitVal[a];
				if(i==BitVal[a]) putpixel(screen,a+chx, b+chy, Hue);
			}
		}
	}
	for(b=0; b<48; ++b) {
		if(ChessFont[b+z+48] !=0) {
			for(a=0; a<8; ++a) {
				i=ChessFont[b+z+48] & BitVal[a];
				if(i==BitVal[a]) putpixel(screen,a+chx+8, b+chy, Hue);
			}
		}
	}
	for(b=0; b<48; ++b) {
		if(ChessFont[b+z+96] !=0) {
			for(a=0; a<8; ++a) {
				i=ChessFont[b+z+96] & BitVal[a];
				if(i==BitVal[a]) putpixel(screen,a+chx+16, b+chy, Hue);
			}
		}
	}
}
int GetBackHue()
{
	int a,b;

	a=chx >> 1;
	a=a <<1;
	b=chy >> 1;
	b=b <<1;
	if(a==chx && b==chy || a !=chx && b !=chy) BackHue=Light;
		else BackHue=Dark;
}
int Ch24Erase()
{
	GetBackHue();
rectfill(screen, BoardX+(chx*60), BoardY+(chy*60), BoardX+59+(chx*60), BoardY+59+(chy*60), BackHue);
}
int ParkCursor()
{
	EnterSymbol(BoardX+480+42,BoardY+300+6,1,NAPLES);
	CursorParked=1;
	ParkedY=5;
}
void Ch24CursorUp()
{
	if(CursorParked==1) {
		if(ParkedY==0) return;
		EnterSymbol(BoardX+480+42,BoardY+(ParkedY*60)+6,1,BLACK);
		--ParkedY;
		EnterSymbol(BoardX+480+42,BoardY+(ParkedY*60)+6,1,NAPLES);
		chy=ParkedY;
		if(chy==1 || chy==3 || chy==5 || chy==7) BackHue=Dark;
			else BackHue=Light;
		return;
	}
	if(chy==0) return;
	EnterSymbol(BoardX+42+(chx*60),BoardY+6+(chy*60),1,BackHue);
	--chy;
	EnterSymbol(BoardX+42+(chx*60),BoardY+6+(chy*60),1,NAPLES);
	if(BackHue==Dark) BackHue=Light;
		else BackHue=Dark;
}
void Ch24CursorDown()
{
	if(CursorParked==1) {
		if(ParkedY==7) return;
		EnterSymbol(BoardX+480+42,BoardY+(ParkedY*60)+6,1,BLACK);
		++ParkedY;
		EnterSymbol(BoardX+480+42,BoardY+(ParkedY*60)+6,1,NAPLES);
		chy=ParkedY;
		if(chy==1 || chy==3 || chy==5 || chy==7) BackHue=Dark;
			else BackHue=Light;
		return;
	}
	if(chy==7) return;
	EnterSymbol(BoardX+42+(chx*60),BoardY+6+(chy*60),1,BackHue);
	++chy;
	EnterSymbol(BoardX+42+(chx*60),BoardY+6+(chy*60),1,NAPLES);
	if(BackHue==Dark) BackHue=Light;
		else BackHue=Dark;
}
void Ch24CursorLeft()
{
	if(CursorParked==1) {
		CursorParked=0;
		EnterSymbol(BoardX+480+42,BoardY+(ParkedY*60)+6,1,BLACK);
		EnterSymbol(BoardX+420+42,BoardY+(ParkedY*60)+6,1,NAPLES);
		chy=ParkedY;
		if(chy==1 || chy==3 || chy==5 || chy==7) BackHue=Light;
			else BackHue=Dark;
		chx=7;
		chy=ParkedY;
		return;
	}
	if(chx==0) return;
	EnterSymbol(BoardX+42+(chx*60),BoardY+6+(chy*60),1,BackHue);
	--chx;
	EnterSymbol(BoardX+42+(chx*60),BoardY+6+(chy*60),1,NAPLES);
	if(BackHue==Dark) BackHue=Light;
		else BackHue=Dark;
}
void Ch24CursorRight()
{
	if(CursorParked==1) return;
	if(chx==7) return;
	EnterSymbol(BoardX+42+(chx*60),BoardY+6+(chy*60),1,BackHue);
	++chx;
	EnterSymbol(BoardX+42+(chx*60),BoardY+6+(chy*60),1,NAPLES);
	if(BackHue==Dark) BackHue=Light;
		else BackHue=Dark;
}
void DrawPiece(int Piece, int bx, int by, char mode)
{  /* mode: 0 for sitting man, 1 if being moved */
	int sx, sy;

	sx=BoardX-(mode*10);
	sy=BoardY+(mode*4);

	switch(Piece)
	{
		case wpawn:
			BlitChessman(48, sx+21+(bx*60), sy+6+(by*60), NAPLES);
			break;
		case bpawn:
			BlitChessman(48, sx+21+(bx*60), sy+6+(by*60), BLACK);
			break;
		case wbishop:
			BlitChessman(49, sx+21+(bx*60), sy+6+(by*60), NAPLES);
			break;
		case bbishop:
			BlitChessman(49, sx+21+(bx*60), sy+6+(by*60), BLACK);
			break;
		case wknight:
			BlitChessman(50, sx+21+(bx*60), sy+6+(by*60), NAPLES);
			break;
		case bknight:
			BlitChessman(50, sx+21+(bx*60), sy+6+(by*60), BLACK);
			break;
		case wrook:
			BlitChessman(51, sx+21+(bx*60), sy+6+(by*60), NAPLES);
			break;
		case brook:
			BlitChessman(51, sx+21+(bx*60), sy+6+(by*60), BLACK);
			break;
		case wqueen:
			BlitChessman(52, sx+21+(bx*60), sy+6+(by*60), NAPLES);
			break;
		case bqueen:
			BlitChessman(52, sx+21+(bx*60), sy+6+(by*60), BLACK);
			break;
		case wking:
			BlitChessman(53, sx+21+(bx*60), sy+6+(by*60), NAPLES);
			break;
		case bking:
			BlitChessman(53, sx+21+(bx*60), sy+6+(by*60), BLACK);
			break;
		case npiece: break;
		default: break;
	}
}
int UpdateBoard()
{
	int z;

	for(z=0; z<8; ++z) {
		BoardContent[z][7]=board[z+26];
		BoardContent[z][6]=board[z+26+12];
		BoardContent[z][5]=board[z+26+24];
		BoardContent[z][4]=board[z+26+36];
		BoardContent[z][3]=board[z+26+48];
		BoardContent[z][2]=board[z+26+60];
		BoardContent[z][1]=board[z+26+72];
		BoardContent[z][0]=board[z+26+84];
	}
	DrawBoard(BoardX,BoardY);
	for(chy=0; chy<8; ++chy) {
		for(chx=0; chx<8; ++chx) {
			DrawPiece(BoardContent[chx][chy], chx, chy, 0);
		}
	}
	ParkCursor();
}
void UndoIllegalMove()
{
	int x1,x2,y1,y2;
	int chx_holder=chx;
	int chy_holder=chy;

	x1=PlayerMove[0]-97;
	y1=PlayerMove[1]-49;
	x2=PlayerMove[2]-97;
	y2=PlayerMove[3]-49;
	y1=y1 ^ 7;
	y2=y2 ^ 7;

	chx=x2;
	chy=y2;
	Ch24Erase();
	DrawPiece(BoardContent[x1][y1], x1,y1,0);
	BoardContent[x1][y1]=BoardContent[x2][y2];
	BoardContent[x2][y2]=OldOccupant;
	chx=chx_holder;
	chy=chy_holder;
}
void HighlightComputerMove()
{
	int x1,x2,y1,y2;
	int chx_holder=chx;
	int chy_holder=chy;
	char x1val[2];
	char x2val[2];
	char y1val[2];
	char y2val[2];

	if(ComputerMove[0] < 97) return;
	if(HighlightOK==FALSE) return;
	x1=ComputerMove[0]-97;
	y1=ComputerMove[1]-49;
	x2=ComputerMove[2]-97;
	y2=ComputerMove[3]-49;
	y1=y1 ^ 7;
	y2=y2 ^ 7;

	chx=x1;
	chy=y1;
	Ch24Erase();
	chx=x2;
	chy=y2;
	circlefill(screen,BoardX+(x1*60)+30, BoardY+(y1*60)+30,16,makecol(189,119,0));
	circlefill(screen,BoardX+(x2*60)+30, BoardY+(y2*60)+30,16,makecol(189,119,0));
	DrawPiece(BoardContent[x2][y2], x2, y2, 0);
	chx=chx_holder;
	chy=chy_holder;
}
void GetPlayerMove()
{
	BITMAP *bmp=create_bitmap(480,488);
	int Piece;
	int chx_holder=chx;
	int chy_holder=chy;
	unsigned int even;

	Piece=InspectSquare();
	Ch24Erase();
	/* take snaphot of board without the man to be transported */
	clear_bitmap(bmp);
	blit(screen, bmp, BoardX, BoardY, 0, 0, 480, 480);
loopback2:
	/* use snaphot as background */
	blit(bmp, screen, 0, 0, BoardX, BoardY, 480, 480);
	DrawPiece(Piece, chx, chy, 1);
	EnterSymbol(BoardX+32+(chx*60),BoardY+10+(chy*60),1,ORANGE);

loopback:

	do {
		UpdateIdle();
	} while(!keypressed());
		c=GetKey();
		switch(c)
		{
			case F10: strcpy(PlayerMove, "quit");
					PlayerMove[4]=(null);
					return;
			case 13:	 PlayerMove[4]=(null); /* remove pawn promotion */
				DisplayPlayerMove(chx_holder,chy_holder);
				destroy_bitmap(bmp);
				Ch24Erase();
				DrawPiece(Piece, chx, chy, 0);
				BoardContent[chx_holder][chy_holder]=npiece;
				OldOccupant=BoardContent[chx][chy];
				BoardContent[chx][chy]=Piece;
				if(chy==0 && Piece==wpawn) {
					Piece=(PawnPromotionDialog(559,BoardY));
					Ch24Erase();
					DrawPiece(Piece, chx, chy, 0);
					BoardContent[chx][chy]=Piece;
								 DisplayPlayerMove(chx_holder,chy_holder);
				}
		/* if playing black */
				if(chy==7 && Piece==bpawn) {
					Piece=(PawnPromotionDialog(559,BoardY));
					Piece=Piece -1;
					Ch24Erase();
					DrawPiece(Piece, chx, chy, 0);
					BoardContent[chx][chy]=Piece;
								 DisplayPlayerMove(chx_holder,chy_holder);
				}
				ParkCursor();
				EraseOrangeMessage();
				if(MatePosted==FALSE) EraseCheckMessage();
				PutsFont21(600,BoardY+300,SEABLUE, "WORKING");
				if((InspectSquare() % 2)==EnemyColor) goto loopback;
				else return;
			case UPARROW: if(chy > 0) --chy;
				goto loopback2;
			case DOWNARROW: if(chy < 7) ++chy;
				goto loopback2;
			case LEFTARROW: if(chx > 0) --chx;
				goto loopback2;
			case RIGHTARROW: if(chx < 7) ++chx;
				goto loopback2;
			case HOMEKEY: if(chx > 0) --chx;
						if(chy > 0) --chy;
				goto loopback2;
			case PGUPKEY: if(chx < 7) ++chx;
				if(chy > 0) --chy;
				goto loopback2;
			case PGDNKEY: if(chx > 0) --chx;
				if(chy < 7) ++chy;
				goto loopback2;
			case ENDKEY: if(chx < 7) ++chx;
				if(chy < 7) ++chy;
				goto loopback2;
			case CTRL_F1: Screenshot792("Chess8.bmp");
				goto loopback;
			case CTRL_F2: Screenshot1024("Chess10.bmp");
				goto loopback;
			default: goto loopback;
		}
}
void ChessDoHelp()
{
	char HelpPath[80];

	strcpy(HelpPath, LcarsPath);
	strcat(HelpPath,"\\LC24APPS\\CHESS24\\FAILE.TXT");
	OpenHelp(HelpPath);
	min_old=70;
}

int ChessWindowActive()
{
	if(MenuResult==0) HighlightComputerMove();
		else {
			MenuResult=0;
			UpdateBoard();
			PlayerColorMessage();
		}
	if(in_check()) CheckMessage();
		else if(MatePosted==FALSE) EraseCheckMessage();
	if(Reinit==TRUE) {
		Reinit=FALSE;
		UpdateBoard();
	}
loopback:
	do {
		UpdateIdle();
	} while(!keypressed());
		c=GetKey();
		switch(c)
		{
			case F1: MenuResult=Menu(559,BoardY);
					Ch24CursorUp();
					Ch24CursorDown();
					OrangeMessage("YOUR MOVE");
					if(MenuResult==1) {
	rectfill(screen,BoardX+490,BoardY,BoardX+540,540,BLACK);
						strcpy(PlayerMove, "new");
						return;
					}
					if(MenuResult==2 && EnemyColor==0) {
	rectfill(screen,BoardX+490,BoardY,BoardX+540,540,BLACK);
						strcpy(PlayerMove, "black");
										EnemyColor==1;
						return;
					}
					if(MenuResult==2 && EnemyColor==1) {
	rectfill(screen,BoardX+490,BoardY,BoardX+540,540,BLACK);
						strcpy(PlayerMove, "white");
						EnemyColor==0;
						return;
					}
					goto loopback;
			case F2: 	ChessDoHelp();
					PanelBeep();
					goto loopback;
			case F9:  UpdateBoard();
					goto loopback;
			case F10: strcpy(PlayerMove, "quit");
					PlayerMove[4]=(null);
					return;
/*		 case F10: return(0); */
			case 13:  if(CursorParked==1) goto loopback;
/* empty square */		if(InspectSquare()==npiece) goto loopback;
/* enemy piece */	 if((InspectSquare() % 2)==EnemyColor) goto loopback;
				GetPlayerMove();

				return;
			case UPARROW: if(GameOver==1) goto loopback;
				Ch24CursorUp();
				goto loopback;
			case DOWNARROW: if(GameOver==1) goto loopback;
				Ch24CursorDown();
				goto loopback;
			case LEFTARROW: if(GameOver==1) goto loopback;
				Ch24CursorLeft();
				goto loopback;
			case RIGHTARROW: if(GameOver==1) goto loopback;
				Ch24CursorRight();
				goto loopback;
			case CTRL_F1: Screenshot792("Chess8.bmp");
				PanelBeep();
				goto loopback;
			case CTRL_F2: Screenshot1024("Chess10.bmp");
				PanelBeep();
				goto loopback;
			default: goto loopback;
		}
}
int InspectSquare()
{
	return(BoardContent[chx][chy]);
}
void SetBoard()
{
	BoardContent[0][0]=brook;
	BoardContent[1][0]=bknight;
	BoardContent[2][0]=bbishop;
	BoardContent[3][0]=bqueen;
	BoardContent[4][0]=bking;
	BoardContent[5][0]=bbishop;
	BoardContent[6][0]=bknight;
	BoardContent[7][0]=brook;

	for(chx=0; chx<8; ++chx) {
		BoardContent[chx][1]=bpawn;
		BoardContent[chx][2]=npiece;
		BoardContent[chx][3]=npiece;
		BoardContent[chx][4]=npiece;
		BoardContent[chx][5]=npiece;
		BoardContent[chx][6]=wpawn;
		BoardContent[chx][7]=BoardContent[chx][0] - 1;
	}
/*
	for(chy=0; chy<8; ++chy) {
		for(chx=0; chx<8; ++chx) {
			DrawPiece(BoardContent[chx][chy], chx, chy, 0);
		}
	}
*/
	  PlayerColorMessage();
}
int DrawBoard(int chx, int chy)
{
	int a,b,alt;

	alt=0;
	for(a=0; a<8; ++a) {
		alt=!alt;
		for(b=0; b<8; ++b) {
			alt=!alt;
			if(alt==0) rectfill(screen, chx+(a*60), chy+(b*60), chx+60+(a*60), chy+60+(b*60), Light);
				else  rectfill(screen, chx+(a*60), chy+(b*60), chx+60+(a*60), chy+60+(b*60), Dark);
		}
	}
}
void Ch24Init()
{
/* Faile stuff */
	hash_mask=0;
	hash_max_mb=0;
	ran_num=1;
	b_hash_mask=0;
	collisions=0;
	ran_num=1;

/* LCARS stuff */
	Dark=makecol(104,62,0);
	Light=makecol(145,87,0);
	BoardX=47;
	BoardY=60;
	GameOver=0;
	CursorParked=1;
	ParkedY=6;
	OldOccupant=npiece;
	EnemyColor=0;
	HighlightOK=TRUE;
	MenuResult=0;
	MatePosted=FALSE;
	Reinit=TRUE;
	strcpy(PlayerMove,"NONE");
	strcpy(ComputerMove,"NONE");
/*
	dummy={0,0,0,0,0,0,0};
*/
	dummy.ep=0;
	dummy.from=0;
	dummy.target=0;
	dummy.captured=0;
	dummy.promoted=0;
	dummy.castled=0;
	dummy.cap_num=0;
}
int Chess24Mode()
{
	Ch24Init();
	rectfill(screen,0,0,800,600,BLACK);
	PopsicleSticks(LILAC);
	ColorTitle("CHESS",PURPLE);
	PutsLuna(530+12,575-9, BLACK,LILAC, "MENU: F1");
	PutsLuna(600+6,575-9, BLACK,LILAC, "INFO: F2");
	PutsLuna(676,575-9, BLACK,LILAC, "CLOSE: F10");
	PutsLuna(71,575-9, BLACK,LILAC, "QR");
	PutsLuna(71+60,575-9, BLACK,LILAC, "QN");
	PutsLuna(71+120,575-9, BLACK,LILAC, "QB");
	PutsLuna(71+180,575-9, BLACK,LILAC, "Q");
	PutsLuna(71+240,575-9, BLACK,LILAC, "K");
	PutsLuna(71+300,575-9, BLACK,LILAC, "KB");
	PutsLuna(71+360,575-9, BLACK,LILAC, "KN");
	PutsLuna(71+420,575-9, BLACK,LILAC, "KR");
	PutsLuna(478,8+12,BLACK,LILAC, "PICK UP/DROP: ENTER KEY	MOVE: ARROW KEYS");
	DrawBoard(BoardX,BoardY);
	if(LoadChessFont() !=0) return(86);
	SetBoard();
	ParkCursor();
	faile();
	free (hash_table);
	free (b_hash_table);
}
/* eof */

