/* Calendar.c, calendar functions of LCARS 24 */

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file \LCARS24\DATA\COPYING.TXT for details.
 */

#include "calendar.h"


/* Leap year or not: IsLeap(2000) = 0; IsLeap(2004) = 1 */
int IsLeap(int yr)
{
	return((!(yr % 4) && (yr % 100)) || (!(yr % 400) && (yr % 1000)));
}

int PutCalendarTitle(int yy, int mm, int x, int y, int Color)
{
	static char MonthDisplay [12][16]={
		"JANUARY  ",
		"FEBRUARY ",
		"MARCH ",
		"APRIL ",
		"MAY ",
		"JUNE ",
		"JULY ",
		"AUGUST ",
		"SEPTEMBER ",
		"OCTOBER ",
		"NOVEMBER ",
		"DECEMBER "
	};
	char Year[5];
	char Title[18];
	int retval;

	itoa(yy, Year, 10);
	strcpy(Title,MonthDisplay[mm-1]);
	strcat(Title,Year);
	if(x==142) {
		PutsScorpio(x,y,Color,Title);
		rectfill(screen,StrLenScorpio(Title)+142+5,10,336+8,36,LILAC);
		RightBumper26(344,10,LILAC);
		PutsLuna(StrLenScorpio(Title)+142+11,17, BLACK,Color, "NEXT: ESC");
	}  else {
		retval=x-StrLenScorpio(Title);
		PutsScorpio(retval,y,Color,Title);
		mm--;
		if(mm==0) {
			mm=12;
			yy--;
		}
		itoa(yy, Year, 10);
		strcpy(Title,MonthDisplay[mm-1]);
		strcat(Title,Year);
		rectfill(screen,StrLenScorpio(Title)+142+5,10,336+8,36,LILAC);
	}
	return(retval);
}
void PutDayOfWeek(int Day)
{
	static char DayDisplay [7][12]={
		"     SUNDAY",
		"     MONDAY",
		"   TUESDAY",
		" WEDNESDAY",
		"  THURSDAY",
		"    FRIDAY",
		"  SATURDAY"
	};
	MarsF(780-(StrLenMars(3,DayDisplay[Day])), 10, 3, BracketColor1, BLACK, DayDisplay[Day]);
}
void PutCalendar(int StartingDay, int LengthOfMonth, int offset)
{
	int z=0;
	int x=10;
	int y=3;
	int xpos=x;
	int ypos=y;
	int Hue;

	static char CalDisplay [34][4]={
	"	", "  1", "  2", "  3", "  4", "  5", "  6", "  7",
			 "  8", "  9", " 10", " 11", " 12", " 13", " 14",
			 " 15", " 16", " 17", " 18", " 19", " 20", " 21",
			 " 22", " 23", " 24", " 25", " 26", " 27", " 28",
			 " 29", " 30", " 31", "***"
	};
	xpos=x + (StartingDay-3)*3;
	for( z=StartingDay; z <= (LengthOfMonth+StartingDay); z++) {
		xpos=xpos + 3;
		Hue=PALEBLUE;
		if(xpos >= x + 21) {
			xpos=x;
			ypos=ypos + 1;
			Hue=ORANGE;
		}
		if( xpos==x) Hue=ORANGE;
		if( xpos==x+18) Hue=BIGBLUE;
PutsFont19((xpos*10)+offset,(ypos*24)-24,Hue,CalDisplay[z-StartingDay]);
	if( z-StartingDay==(DayOfMonth) && offset==36)
PutsFont19((xpos*10)+offset,(ypos*24)-24,NAPLES,CalDisplay[z-StartingDay]);
	}
}
int GetWhichCalendar(int Year)
{
	if(Year < 100) Year +=1900;

	switch(Year) {
		case 1990:  return(2);
		case 1991:  return(3);
		case 1992:  return(4);
		case 1993:  return(12);
		case 1994:  return(7);
		case 1995:  return(1);
		case 1996:  return(2);
		case 1997:  return(10);
		case 1998:  return(5);
		case 1999:  return(6);
		case 2000: return(14);
		case 2001: return(2);
		case 2002: return(3);
		case 2003: return(4);
		case 2004: return(12);
		case 2005: return(7);
		case 2006: return(1);
		case 2007: return(2);
		case 2008: return(10);
		case 2009: return(5);
		case 2010: return(6);
		case 2011: return(7);
		case 2012: return(8);
		case 2013: return(3);
		case 2014: return(4);
		case 2015: return(5);
		case 2016: return(13);
		case 2017: return(1);
		case 2018: return(2);
		case 2019: return(3);
		case 2020: return(11);
		case 2021: return(6);
		case 2022: return(7);
		case 2023: return(1);
		case 2024: return(9);
		case 2025: return(4);
		case 2026: return(5);
		case 2027: return(6);
		case 2028: return(14);
		case 2029: return(2);
		case 2030: return(3);
		default: return(1);
	}
}
int GetStartingDayOfMonth(int WhichCalendar, int WhichMonth)
{
	int Leap=0;

	if( WhichCalendar > 7)
	{
		WhichCalendar=WhichCalendar -7;
		Leap=1;
	}
	switch( WhichMonth )
	{
		case 1: return(WhichCalendar);
		case 2: return(WhichCalendar+3);
		case 3: return(WhichCalendar+3+Leap);
		case 4: return(WhichCalendar+6+Leap);
		case 5: return(WhichCalendar+1+Leap);
		case 6: return(WhichCalendar+4+Leap);
		case 7: return(WhichCalendar+6+Leap);
		case 8: return(WhichCalendar+2+Leap);
		case 9: return(WhichCalendar+5+Leap);
		case 10: return(WhichCalendar+Leap);
		case 11: return(WhichCalendar+3+Leap);
		case 12: return(WhichCalendar+5+Leap);
	} while ( 1 );
	return(1);
}
int GetLengthOfMonth( int WhichCalendar, int mm)
{
	switch( mm )
	{
		case 4:
		case 6:
		case 9:
		case 11:	return(30);
		case 2:	if(WhichCalendar > 7) return(29);
					else return(28);
		default:	return(31);
	}
	return(0);
}
void CalendarControl(int yy, int mm, int dd, int wd)
{
	int WhichCalendar, StartingDay, LengthOfMonth;

	rectfill(screen,120,10,350,192,BLACK); /* erase whole calendar */
	/* Display month and year */
	PutCalendarTitle(yy,mm,142,10,LILAC);
	/* Generate and display calendar */
	WhichCalendar=GetWhichCalendar(yy);
	StartingDay=GetStartingDayOfMonth(WhichCalendar, mm);
	if( StartingDay > 7 ) StartingDay -= 7; /* ## */
	LengthOfMonth=GetLengthOfMonth(WhichCalendar, mm);
	PutCalendar(StartingDay, LengthOfMonth, 36);
	PutDayOfWeek(wd);
}

int GetDayOfWeek(int M, int D, int Y)
{
	int JD;

	JD = (1461*(Y+4800+(M-14)/12))/4+(367*(M-2-12*((M-14)/12)))/12
-(3*((Y+4900+(M-14)/12)/100))/4+D-32075;

	return( ( JD + 1 ) % 7 );
}

void PutDate()
{
	time_t x;
	struct tm *pt;
	int FakeYear, l_holder, r_holder, WeekDay;
	unsigned int t;
	int calnum, monthsize;

	if( MidiPlaying != 0 ) return;
	time(&x);
	pt=localtime(&x);
	DateMonth=pt->tm_mon+1;
/*	pt=localtime(&x); */
	DateDay=pt->tm_mday;
/*	WeekDay=pt->tm_wday; */
/*	pt=localtime(&x); */
	DateYear=pt->tm_year+1900;

	DateYear += DeltaYr;

	DateMonth += DeltaMo;
	if(DateMonth > 12) DateMonth -= 12;
	if(DateMonth < 0) DateMonth += 12;

	DateDay += DeltaDa;
	calnum=GetWhichCalendar(DateYear);
	monthsize=GetLengthOfMonth(calnum,DateMonth);
	if(DateDay > monthsize) DateMonth -= monthsize;
	if(DateDay < 0) DateMonth += monthsize;

	WeekDay=GetDayOfWeek(DateMonth, DateDay, DateYear);

	l_holder=DateMonth / 10;
	t=l_holder + 48;
	if(l_holder==0) t=32;
	DateDisplay[0]=(t);

	r_holder=DateMonth - (l_holder * 10);
	t=r_holder + 48;
	DateDisplay[1]=(t);

	l_holder=DateDay / 10;
	t=l_holder + 48;
	DateDisplay[3]=(t);
	r_holder=DateDay - (l_holder * 10);
	t=r_holder + 48;
	DateDisplay[4]=(t);

	DayOfMonth=DateDay;

	MarsF(600,106,3,TimeColor, BLACK, DateDisplay);

	FakeYear=DateYear;
	if( FakeYear < 2001) FakeYear=FakeYear + 11;
	CalendarControl(FakeYear,DateMonth,DateDay,WeekDay);
	day_old=DateDay;
}

