/* Alarm.c, alarm-clock functions of LCARS 24 */

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file \LCARS24\DATA\COPYING.TXT for details.
 */

#include "alarm.h"


void NextMonthCalender(char Displayed)
{
	int M;
	double Y;
	int wc,sd,ml,pos;

	if(Displayed) goto off;
	M = DateMonth;
	Y = DateYear;
	if(M==12) {
		M=1;
		Y++;
	} else M++;

	rectfill(screen,455,10,790,96,BLACK);
	rectfill(screen,570,106,790,190,BLACK);
	pos=PutCalendarTitle(Y,M,770,10,PURPLE);
	LeftBumper26(566,10,PURPLE);
	rectfill(screen,566,10,pos-7,36,PURPLE);
	PutsLuna(pos-11-StrLenLuna("OFF: ESC"),17, BLACK,PURPLE, "OFF: ESC");
	wc=GetWhichCalendar(Y);
	sd=GetStartingDayOfMonth(wc, M);
	if(sd > 7) sd -= 7; /* bug fix */
	ml=GetLengthOfMonth(wc,M);
	PutCalendar(sd, ml, 466);

	SnoozeAlarmMin=80; /* disable date update */

	return;

off:	rectfill(screen,500,10,570,36,BLACK);
	rectfill(screen,570,10,800,190,BLACK);
	SnoozeAlarmMin=70;
	PutDate();
}
int SnoozeMode()
{
	char TitleStr[32];
	char SnoozeStr[3];
	char CountdownStr[3];
	int Countdown, PrevMin;

	itoa( SnoozeVal, SnoozeStr, 10);
	strcpy(TitleStr,"SNOOZE: ");
	strcat(TitleStr,SnoozeStr);
	strcat(TitleStr," MINUTES");
	rectfill(screen,0,0,800,600,BLACK);
	PopsicleSticks(LILAC);
	Title(TitleStr);
	ButtonType3(559, 111, LILAC, LILAC, "CANCEL");
	EscSymbol(559+117, 111, 2, MANGO);

	PutTime(164,241,10);
	PrevMin=Minutes;

	Countdown=SnoozeVal;
	itoa( Countdown, CountdownStr, 10);
	MarsF(488-(StrLenMars(4,CountdownStr)),73,4,MANGO, BLACK, CountdownStr);
	PutsFont21(410-(StrLenMars(4,CountdownStr)),119, LILAC,"ALARM IN");
	PutsFont21(494,119, LILAC,"MINUTES");
	PanelBeep();

loopback:
	do {
		PutTime(164,241,10);
		if(Minutes==SnoozeAlarmMin) return(0);
		if(Minutes !=PrevMin) {
			rectfill(screen,410-(StrLenMars(4,CountdownStr)),73,490,186,BLACK);
			Countdown--;
			itoa( Countdown, CountdownStr, 10);
			MarsF(488-(StrLenMars(4,CountdownStr)),73,4,MANGO, BLACK, CountdownStr);
			PutsFont21(410-(StrLenMars(4,CountdownStr)),119, LILAC,"ALARM IN");
			PrevMin=Minutes;
		}
	} while (!keypressed());
	c=GetKey();
	switch( c )
		{
		case 27: 	SnoozeAlarmMin=70;
				return(27);
		case CTRL_F1: Screenshot792("Snooze.bmp");
				PanelBeep();
				goto loopback;
		default: 	ScoldUser();
				goto loopback;
	}
}

int AlarmDisplay()
{
	char SnoozeStr[32];

	rectfill(screen,387,138,580,190,BLACK);
	PutsScorpio(388, 144, PALEBLUE, "ALARM:");
	if( SingleAlarmOnOff==1 ) {
		PutsScorpio(455,144,PALEBLUE,AlarmString);
		itoa( SnoozeVal, SnoozeStr, 10);
		strcat(SnoozeStr,"-MINUTE SNOOZE");
		if(SnoozeVal >0) PutsLuna(455, 177, MANGO, BLACK, SnoozeStr);
	} else {
		PutsScorpio(455,144,ORANGE,"OFF");
	}
	return(0);
}
int LcarsPlayMidi(char *filespec)
{
	MIDI *the_music;
	int progress =0;
	int result = 1; /* returned if key pressed to stop it */

/*

return(Result);
*/

/*	install_keyboard(); */
/*	install_timer(); */
	set_volume_per_voice(1);
	if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0) {
		goto abort;
	}
/*	set_volume(255,255);   */

	the_music = load_midi(filespec);
	if (!the_music) goto noload;

	install_timer();
	play_midi(the_music, FALSE);

	do {
		poll_keyboard();
		if( progress != midi_pos ) {
			progress = midi_pos;
		}
		if( progress < 0 ) {
			result = 0;  /* no keypress */
			goto done;
		}
		rest(2);
	} while ((!key[KEY_ESC]) && (!key[KEY_SPACE]));

done:
	destroy_midi(the_music);
	remove_timer(); 
noload:	remove_sound();
abort:	/* remove_keyboard(); */

	return(result);  /* 0 if key pressed, 1 if not */
}
int Play(char *Song)
{
	int Result;

	Result=LcarsPlayMidi(Song);
	PutTime(164,264,10);
	rectfill(screen,659,286,760,424,BLACK); /* seconds */
	return(Result);
}
void DosTimeKick()
{
}
void PlayInRotation(int ListStart)
{
	char DosFileArray[100][128];
	char CurrentTrack[128];
	int Result=0;
	struct al_ffblk fblock;
	int Found;
	char mask[128];
	int NumOfMidis,i;

	strcpy(mask, LcarsPath);
	strcat(mask, "\\ALARM\\*.MID");
	NumOfMidis=0;
	Found=al_findfirst(mask, &fblock, FA_ALL);
	if( Found ) {
		return;		/* no midi files found */
	}
	while ( !Found ) {
		strcpy(DosFileArray[NumOfMidis], fblock.name);
		Found=al_findnext( &fblock );
		NumOfMidis++;
	}
	al_findclose( &fblock );
	--NumOfMidis;

	while(ListStart > NumOfMidis) ListStart -=NumOfMidis;
	if( ListStart < 0 ) ListStart=0;

	i=ListStart;
	do {
	strcpy(CurrentTrack, LcarsPath);
	strcat(CurrentTrack, "\\ALARM\\" );
	strcat(CurrentTrack, DosFileArray[i] );
	rectfill(screen,496,90,780,160,BLACK);
	PutsFont21(500, 90, SEABLUE, "PLAYING");
	PutsFont21(500, 120, SEABLUE, ustrupr(DosFileArray[i]));
	DosTimeKick();
	PutTime(164,264,10);

	release_screen();

	Result=Play(CurrentTrack);
	acquire_screen();
	if( Result==1) return;
	++i;
	if( i > NumOfMidis ) i=0;
	} while(!keypressed());
}
void MidiDJ()
{
	int ListStart=0;

	ListStart=atoi(SecWhenAlarmSet);
	PlayInRotation(ListStart);
}
void LoadAlarm()
{
	PACKFILE *Fp;

	SetCurrentFile("\\SYSTEM\\ALARMSET.LC");
	if ( ( Fp=pack_fopen(CurrentFile, "rb" ))==0 ) {
		return;
	} else{
		AlarmHour=pack_getc(Fp);
		AlarmMin=pack_getc(Fp);
		SnoozeVal=pack_getc(Fp);
		MuteBeeps=pack_getc(Fp);
		AlarmType=pack_getc(Fp);
		ColorScheme=pack_getc(Fp);
		Endgame=pack_getc(Fp);
		AudioOff=pack_getc(Fp);
		MilitaryTime=pack_getc(Fp);
	}
	pack_fclose( Fp );
	if(SnoozeVal < 0 || SnoozeVal > 18) SnoozeVal=0;
}
void SaveAlarm()
{
	PACKFILE *Fp;

	SetCurrentFile("\\SYSTEM\\ALARMSET.LC");
	if ( ( Fp=pack_fopen(CurrentFile, "wb" ))==NULL ) {
		return;
	} else{
		pack_putc( AlarmHour, Fp);
		pack_putc( AlarmMin, Fp);
		pack_putc( SnoozeVal, Fp);
		pack_putc( MuteBeeps, Fp);
		pack_putc( AlarmType, Fp);
		pack_putc( ColorScheme, Fp);
		pack_putc( Endgame, Fp);
		pack_putc( AudioOff, Fp);
		pack_putc( MilitaryTime, Fp);
	}
	pack_fclose( Fp );
}
void AlarmMessageBox1a(int Hue)
{
	int boxtop;

	boxtop=10;
	rectfill(screen,10,boxtop,110,boxtop+54, Hue);
}
void AlarmMessageBox2a(int Hue)
{
	int boxtop;

	boxtop=68;
	rectfill(screen,10,boxtop,110,boxtop+54, Hue);
	PutsLuna(14,boxtop + 28 + 9, BLACK, Hue, "STOP");
	PutsLuna(77,boxtop + 4, BLACK, Hue, "SPACE");
	PutsLuna(91,boxtop + 28 + 9, BLACK, Hue, "ESC");
}
void Mp3AlarmMessageBox2a(int Hue)
{
	int boxtop;

	boxtop=68;
	rectfill(screen,10,boxtop,110,boxtop+54, Hue);
	PutsLuna(14,boxtop + 28 + 9, BLACK, Hue, "STOP");
	PutsLuna(91,boxtop + 28 + 9, BLACK, Hue, "ESC");
}

void Mp3Alarm()
{
	char DosFileArray[100][16];
	char CurrentTrack[80]="song";
	int Result=0;
	struct al_ffblk fblock;
	int Found;
	char mask[80];
	int NumOfMp3s,i,ListStart;

	Mp3AlarmMessageBox2a(NAPLES);

	ButtonType3(597, 153, LILAC, LILAC, "STOP");
	EscSymbol(597+117,153,2, ORANGE);

	strcpy(mask, LcarsPath);
	strcat(mask, "\\MP3\\*.MP3");

	ListStart=0;
	NumOfMp3s=0;
	Found=al_findfirst(mask, &fblock, FA_ALL);
	if( Found ) {
		return;			/* no mp3 files found */
	}
	while ( !Found ) {
		strcpy(DosFileArray[NumOfMp3s], fblock.name);
		Found=al_findnext( &fblock );
		NumOfMp3s++;
	}
	al_findclose( &fblock );
	--NumOfMp3s;

	while(ListStart > NumOfMp3s) ListStart -=NumOfMp3s;
	if( ListStart < 0 ) ListStart=0;

	i=ListStart;

	Result=117;
	do {
		strcpy(CurrentTrack, LcarsPath);
		strcat(CurrentTrack, "\\MP3\\" );
		strcat(CurrentTrack, DosFileArray[i] );

		rectfill(screen,500,90,780,144,BLACK);
		PutsFont21(500, 90, WHITE, "PLAYING");
		PutsFont21(500, 120, WHITE, ustrupr(DosFileArray[i]));
		PutTime(164,264,10);

		release_screen();
		acquire_screen();
		++i;
		if( i > NumOfMp3s ) i=0;
	} while(Result > 109 );
}
void VoiceAlarm()
{
	char RestoreMute=FALSE;
	int result=0;

	if(MuteBeeps==TRUE) {
		MuteBeeps=FALSE;
		RestoreMute=TRUE;
	}
c=0;
	while(result==0) {
		result=PanelBeep();
		if(result != 0) break;
		result=ScoldUser();

if(c==32 || c==27) {
c=0;
break;
}

		if(result !=0 ) break;
		PutTime(164,264,10);
	}
	if(RestoreMute==TRUE) MuteBeeps=TRUE;
}
void RedAlert()
{
	int TimeColorHolder;

	TimeColorHolder=TimeColor;

	TimeColor=WHITE;

	MidiPlaying=1;
	/* erase all but A.M./P.M from Standby or Snooze screen */
	rectfill(screen,0,0,800,uy-4,BLACK); /* upper window */
	rectfill(screen,659,286,760,424,BLACK); /* seconds */
	rectfill(screen,0,550,800,600,BLACK); /* lower Snooze frame */
	rectfill(screen,160,240,650,550,BLACK); /* Snooze time */
	Brackets1(WHITE, RED);
	AlarmMessageBox1a(RED);
	AlarmMessageBox2a(PURPLE);
	rectfill(screen,10,308,110,591,DARKRED);
	PutsLuna(14,254+60, BLACK, DARKRED, "TIME UPDATED");
	PutsLuna(14,254+16+60, BLACK, DARKRED, "BETWEEN");
	PutsLuna(14,254+32+60, BLACK, DARKRED, "TRACKS");
	MarsF(280, 50, 4, PURPLE, BLACK, "ALARM");
	min_old=70;
	PutTime(164,264,10);
	remove_timer();

	switch( AlarmType )
	{
		case 1:	Mp3Alarm();
				break;
		case 2:	VoiceAlarm();
				break;
		default:  MidiDJ();
			/*	BlasterOK=10; */  /* trap rare problem */
				break;
	}
	old_sec=70;
	min_old=70;
	day_old=32;
	MidiPlaying=0;
	install_timer();

	if(SnoozeAlarmMin==70 && SnoozeVal > 0) {
		SnoozeAlarmMin=AlarmMin+SnoozeVal-1;
		if(SnoozeAlarmMin > 59) SnoozeAlarmMin -=60;
		if(SnoozeMode() !=27) return; /* main will activate alarm */
	}
	TimeColor=TimeColorHolder;
	Screen1(1); /* done, resume Standby mode */
	old_sec=70;
	min_old=70;
	day_old=32;
	PutDate();
	PutTime(164,264,10);
}
int MidiMusicMode()
{
	MidiPlaying=1;
	Screen1(1);
	rectfill(screen,120,2,800,uy-4,BLACK); /* clear upper window */
	rectfill(screen,659,286,760,424,BLACK); /* erase seconds */
	Brackets1(BIGBLUE, PALEBLUE);
	AlarmMessageBox1a(BIGBLUE);
	AlarmMessageBox2a(NAPLES);
	rectfill(screen,10,308,110,591,BIGBLUE);
	PutsLuna(14,254+60, BLACK, BIGBLUE, "TIME UPDATED");
	PutsLuna(14,254+16+60, BLACK, BIGBLUE, "BETWEEN");
	PutsLuna(14,254+32+60, BLACK, BIGBLUE, "TRACKS");
	MarsF(780-StrLenMars(2,"MIDI MUSIC"), 10, 2, ORANGE, BLACK, "MIDI MUSIC");

	MidiDJ();

	old_sec=70;
	min_old=70;
	day_old=32;
	MidiPlaying=0;
	remove_timer();
	Screen1(1);
	PutDate();
	PutTime(164,264,10);
	return(0);
}
int Mp3MusicMode()
{
	MidiPlaying=1;
	Screen1(1);
	rectfill(screen,120,2,800,uy-4,BLACK); /* clear upper window */
	rectfill(screen,659,286,760,424,BLACK); /* erase seconds */
	Brackets1(BRICK, MANGO);
	AlarmMessageBox1a(BRICK);
	AlarmMessageBox2a(NAPLES);
	rectfill(screen,10,308,110,591,BRICK);
	PutsLuna(14,254+60, BLACK, BRICK, "TIME UPDATED");
	PutsLuna(14,254+16+60, BLACK, BRICK, "BETWEEN");
	PutsLuna(14,254+32+60, BLACK, BRICK, "TRACKS");
	MarsF(780-StrLenMars(2,"MP3 MUSIC"), 10, 2, ORANGE, BLACK, "MP3 MUSIC");

	Mp3Alarm();

	old_sec=70;
	min_old=70;
	day_old=32;
	MidiPlaying=0;
	remove_timer();
	Screen1(1);
	PutDate();
	PutTime(164,264,10);
	return(0);
}

