* REALTY.PRG (08-11.a)
* usage: realty

SHOW 'REALTY test program'
SWITCH TALK OFF
RESET DATABASE
RESET REPORT
DROP VARIABLE ALL

* initialize database and tables
CREATE DATABASE realty
CREATE CURSOR 1 FOR realty
USE CURSOR 1
CREATE TABLE listing (listid NUMBER,addr CHAR(25),city CHAR(25),footage NUMBER,;
  bedrooms NUMBER,baths NUMBER,lotsize NUMBER,corner CHAR(1),schools CHAR(1),;
  price NUMBER)

CREATE TABLE descr (listid NUMBER,descr CHAR(80))

INSERT INTO listing (listid,addr,city,footage,bedrooms,baths,lotsize,corner,schools,price);
  VALUES(103,'addr','city',2400,4,2.5,.75,'n','y',170000)
INSERT INTO listing (listid,addr,city,footage,bedrooms,baths,lotsize,corner,schools,price);
  VALUES(102,'addr','city',1550,3,2,.45,'n','y',140000)
INSERT INTO listing (listid,addr,city,footage,bedrooms,baths,lotsize,corner,schools,price);
  VALUES(101,'addr','city',1800,3,2,.5,'y','n',150000)

INSERT INTO descr (listid,descr) VALUES (101,'2-car garage; Fenced yard')
INSERT INTO descr (listid,descr) VALUES (102,'New carpets/drapes')
INSERT INTO descr (listid,descr) VALUES (103,'3-car garage; Fruit trees')

* print a residential listing status report
ENTER hiprice PICTURE '#######.00' PROMPT 'Enter highest desireable price:'
SELECT listing.listid,listing.addr,listing.city,listing.footage,listing.bedrooms,;
  listing.baths,listing.lotsize,listing.corner,listing.schools,listing.price,;
  descr.descr FROM listing,descr;
  WHERE price<=&hiprice and listing.listid=descr.listid;
  ORDER BY listing.listid
DOREPORT
  REPORT output
    TO CONSOLE
    END
  REPORT PAGE HEADING
   PRINT TAB 25 '************************'
   PRINT TAB 25 '* Residential Listings *'
   PRINT TAB 25 '*     Ceiling Price    *'
   PRINT TAB 25 '*' TAB 31 hiprice PICTURE '$^^^,^^^.^^' '      *'
   PRINT TAB 25 '************************'
   PRINT SKIP '  Num City      Address                   Bedrm Baths Acres  Price' SKIP 2
   END
  REPORT HEADING BREAK AT listid
    PRINT SKIP listid PICTURE '^^^^^' ' ' city PICTURE '^^^^^^^^^^';
      TAB 17 addr TAB 43 bedrooms PICTURE '^^' TAB 49 baths PICTURE '^^';
      TAB 55 lotsize PICTURE '^.^^' '   ' TAB 62 price PICTURE '$^^^,^^^.^^'
    PRINT SKIP 'Comments:'
    IF corner='y'
      PRINT 'CORNER LOT'
      ENDIF
    IF schools='y'
      PRINT 'NEAR SCHOOLS'
      ENDIF
    END
  REPORT PAGE DETAIL
    IF descr <> ''
      PRINT descr
      ENDIF
    END
  REPORT FOOTING BREAK AT listid
    PRINT SKIP 2
    END
  ENDREPORT
DROP CURSOR 1
DROP VARIABLE ALL
DROP DATABASE realty
SWITCH DEFAULT
