@ECHO OFF
IF "%OS%"=="Windows_NT" SETLOCAL

:: Version number for this batch file
SET MyVer=1.24

:: Display "about"
ECHO.
ECHO AllHelp.bat,  Version %MyVer% for Windows NT 4 / 2000 / XP
ECHO Generate an HTML help file for "all" commands
ECHO.
ECHO Written by Rob van der Woude
ECHO http://www.robvanderwoude.com
ECHO.
ECHO Enhanced white space handling by Johan Parlevliet
ECHO.
ECHO.
ECHO.

IF NOT "%OS%"=="Windows_NT" SET MyVer=
IF NOT "%OS%"=="Windows_NT" GOTO End

ECHO Writing HTML header . . .
> allhelp.htm ECHO ^<HTML^>
>>allhelp.htm ECHO ^<HEAD^>
FOR /F "tokens=1 delims=[" %%A IN ('VER') DO SET Ver=%%A
FOR /F "tokens=1* delims= " %%A IN ('ECHO.%Ver%') DO SET Ver=%%B
>>allhelp.htm ECHO ^<TITLE^>Help for all %ver%commands^</TITLE^>
>>allhelp.htm ECHO ^<META NAME="generator" CONTENT="AllHelp.bat by Rob van der Woude"^>
>>allhelp.htm ECHO ^</HEAD^>
>>allhelp.htm ECHO.
>>allhelp.htm ECHO ^<BODY^>
>>allhelp.htm ECHO.
>>allhelp.htm ECHO ^<A NAME="Top"^>
>>allhelp.htm ECHO.
>>allhelp.htm ECHO ^<CENTER^>
>>allhelp.htm ECHO ^<H1^>%Ver%Help^</H1^>
FOR /F "tokens=* delims=" %%A IN ('VER') DO SET Ver=%%A
>>allhelp.htm ECHO ^<H3^>%Ver%^</H3^>
>>allhelp.htm ECHO ^</CENTER^>
>>allhelp.htm ECHO.
>>allhelp.htm ECHO ^<P^>^&nbsp;^</P^>
>>allhelp.htm ECHO.

ECHO Creating command index table . . .
SET FirstCell=1
>>allhelp.htm ECHO ^<TABLE BORDER="0"^>
FOR /F "tokens=* delims=" %%A IN ('HELP ^| MORE /T8') DO CALL :DispLine "%%A"
>>allhelp.htm ECHO ^</TD^>^</TR^>
>>allhelp.htm ECHO ^</TABLE^>
>>allhelp.htm ECHO.
>>allhelp.htm ECHO ^<P^>^&nbsp;^</P^>
>>allhelp.htm ECHO.

ECHO Writing help for each command:
FOR /F "tokens=* delims=" %%A IN ('HELP ^| MORE /T8') DO CALL :DispFull "%%A"

ECHO Closing HTML file
>>allhelp.htm ECHO.
>>allhelp.htm ECHO ^<CENTER^>
>>allhelp.htm ECHO ^<P^>This HTML help file was generated by:^<BR^>
>>allhelp.htm ECHO ^<B^>AllHelp.bat^</B^>, Version %MyVer%
>>allhelp.htm ECHO for Windows NT^&nbsp;4^&nbsp;/^&nbsp;2000^&nbsp;/^&nbsp;XP^<BR^>
>>allhelp.htm ECHO Written by Rob van der Woude^<BR^>
>>allhelp.htm ECHO ^<A HREF="http://www.robvanderwoude.com"^>http://www.robvanderwoude.com^</A^>^</P^>
>>allhelp.htm ECHO ^</CENTER^>
>>allhelp.htm ECHO.
>>allhelp.htm ECHO ^</BODY^>
>>allhelp.htm ECHO ^</HTML^>

ECHO.
ECHO An HTML help file "allhelp.htm" has been created and stored in the current
ECHO directory.
ECHO Now starting display of "allhelp.htm" . . .
START "AllHelp" allhelp.htm

:: End of main batch program
ENDLOCAL
GOTO:EOF


:: Subroutines


:DispLine
SET Line=%1
SET Line=%Line:(=^(%
SET Line=%Line:)=^)%
SET Line=%Line:"=%
SET Command=%Line:~0,8%
SET Command=%Command: =%
IF DEFINED Command CALL :DispCmdLine %Command%
FOR /F "tokens=1* delims= " %%a IN ('ECHO.%*') DO SET Descr=%%b
SET Descr=%Descr:"=%
>>allhelp.htm ECHO.%Descr%
GOTO:EOF


:DispCmdLine
IF "%FirstCell%"=="0" IF DEFINED Command (>>allhelp.htm ECHO ^</TD^>^</TR^>)
SET Command=%1
IF DEFINED Command (>>allhelp.htm ECHO ^<TR^>^<TH ALIGN="left" VALIGN="top"^>^<A HREF="#%Command%"^>%Command%^</A^>^</TH^>^<TD^>^&nbsp;^&nbsp;^&nbsp;^</TD^>^<TD^>)
SET FirstCell=0
SET Command=
GOTO:EOF


:DispFull
SET Line=%1
SET Command=%Line:~1,8%
SET Command=%Command: =%
IF DEFINED Command CALL :WriteFull %Command%
SET Command=
GOTO:EOF


:WriteFull
ECHO.  %1 . . .
>>allhelp.htm ECHO ^<A NAME="%1"^>
>>allhelp.htm ECHO.
>>allhelp.htm ECHO ^<H2^>%1^</H2^>
>>allhelp.htm ECHO.
>>allhelp.htm ECHO ^<PRE^>
>>allhelp.htm HELP %1
>>allhelp.htm ECHO ^</PRE^>
>>allhelp.htm ECHO.
>>allhelp.htm ECHO ^<A HREF="#Top"^>Back to the top of this page^</A^>
>>allhelp.htm ECHO.
>>allhelp.htm ECHO ^<P^>^&nbsp;^</P^>
>>allhelp.htm ECHO.
GOTO:EOF

:End
