'/* SHEL.BAS Call a DOS object in a shell with elapsed time */
'/*          By: Dale Thorn                                 */
'/*          Rev. 14.06.2001                                */

'$include: 'basdef.h'
'$include: 'gettime.h'
'$include: 'midchar.h'

type shelstru                           'define structure for memory allocation
   s as string * 1024                      'elements should be an exponent of 2
end type

'$include: 'basdef.bas'
'$include: 'gettime.bas'
'$include: 'midchar.bas'

cls                                            'pre-clear the user's DOS screen
cmrg = space$(4)                               'initialize the left-side margin
locate 5, 1, 1                               'locate cursor for process message

ccmd = ltrim$(rtrim$(command$))             'get user's command-line parameters
if ccmd = "" then                            'user did NOT input command params
   print cmrg; "Usage:  SHEL  parameters"     'display the 'Usage:SHEL' message
   print
   print cmrg; "If 'parameters' is numeric, allocate that many KB and call DOS shell"
   print
   print cmrg; "If 'parameters' is non-numeric, call the DOS shell using 'parameters'"
   close                                        'close any currently open files
   system                                       'return to the operating system
end if

print "Please standby"                       'user DID input command parameters

ilen = len(ccmd)                             'length of user's input parameters
for ipos = 1 to ilen                         'loop thru user's input parameters
   ichr = midchar(ccmd, ipos)                 'current character in user params
   if ichr < 48 or ichr > 57 then             'current character is NOT numeric
      exit for                               'non-numeric char.found; exit loop
   end if
next

if ipos > ilen then                         'user's param string is all numeric
   imem = pdqvall&(ccmd) mod 512            'limit user's memory spec to 511 kb
   dim smem(imem) as shelstru               'allocate the user-specified memory
   shell                                                 'perform the DOS shell
else
   i = ifn.tbeg(cbeg, cend, cexp, ltic)     'get the beginning/non-elapsed time
   shell ccmd                                'process the user's SHELL commands
   i = ifn.tend(cbeg, cend, cexp, ltic)      'get the ending/total elapsed time
end if

print                                       'blank line between screen messages
print cbeg; "  "; cend; "  "; cexp            'display begin, end, elapsed time

close                              'close open files in case not already closed
system                             'return user control to the operating system
