'/* SDIR.BAS Get disk usage for files by cluster size */
'/*          By: Dale Thorn                           */
'/*          Rev. 03.04.2002                          */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'getdir.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'string.h'
'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'getdir.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'string.bas'

isiz = 6                                       'size of cluster size sums array
dim lsiz(6, 3)                              'initialize cluster size sums array

ccmd = rtrim$(command$)                    'get the DOS command-line parameters
if ccmd = "" then                              'a command line was NOT supplied
   i = ifn.msgs("Usage:  SDIR  filespec/" + char(34) + _
                "listfile" + char(34) + "  [offset]", 5, 24, 79, 0, 1)
end if                              'display the usage message [above] and exit

i = ifn.msgs("Please standby", 5, 24, 79, 0, 0)   'wait while loading filespecs

if left$(ccmd, 1) = char(34) then       'get list from file (no DIR processing)
   ifileproc = not 0                    'set flag to get the list from the file
else                                    'get list from DOS (use DIR processing)
   ifileproc = 0                        'set flag to get the list from DIR cmd.
end if

if ifileproc then                       'get list from file (no DIR processing)
   ipos = instr(2, ccmd, char(34))      'position of closing quote in list name
   if ipos = 0 then                   'closing quote missing from listfile name
      i = ifn.msgs("Close quote missing from listfile name", 5, 24, 79, 1, 1)
   end if
   isrcfl1 = freefile                       'get next available DOS file handle
   csrcfil = mid$(ccmd, 2, ipos - 2)         'get listfile name from user input
   ioffset = pdqvali(mid$(ccmd, ipos + 1))   'position of filesizes in listfile
   i = ifn.open(isrcfl1, csrcfil, "S", llof)  'open the listfile in binary mode
   if llof < 0 then                             'user input a wildcard filespec
      i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)          'beep and exit
   elseif llof = 0 then                       'source file nonexistent or empty
      i = ifn.kill(isrcfl1, csrcfil)                 'kill the zero-length file
      i = ifn.msgs(csrcfil + " not found", 5, 24, 79, 1, 1)      'beep and exit
   end if
else                                    'get list from DOS (use DIR processing)
   csrcdir = "dsrc.dir"                     'initialize source filespec dirname
   i = ifn.gdir(csrcdir, csrcfil, csrcfsp, csrchdr, ccmd, isrcfl1, lsrcsiz, 0)
   if csrcfil = "" then                            'source files were NOT found
      i = ifn.kill(isrcfl1, csrcdir)             'kill source filespec filename
      i = ifn.msgs("Source file(s) not found", 5, 24, 79, 1, 1)
   end if                           'display the error message [above] and exit
   lsiz(0, 2) = 512                     'set cluster size for 1st array element
   for i = 1 to isiz                     'loop thru the cluster size sums array
      lsiz(i, 2) = lsiz(i - 1, 2) * 2      'cluster size for each array element
   next
end if

if ifileproc then                       'get list from file (no DIR processing)
   dsrcsiz = 0                         'initialize current total values in file
   while not eof(isrcfl1)               'loop until no more lines are available
      line input #isrcfl1, csrcfil         'get next filespec from the listfile
      ipos = istr.lnspf(ioffset + 1, csrcfil) '1st character posn.beyond number
      dval = val(mid$(csrcfil, ioffset + 1, ipos - ioffset - 1))'value of number
      dsrcsiz = dsrcsiz + dval         'add number value to sum/total of values
   wend
else                                    'get list from DOS (use DIR processing)
   while csrcfil <> ""                  'loop until no more files are available
      for i = 0 to isiz                      'loop thru cluster size sums array
         imod = lsrcsiz mod lsiz(i, 2)          'no. of bytes over cluster size
         lsiz(i, 0) = lsiz(i, 0) + lsrcsiz - imod - (imod > 0) * lsiz(i, 2)
         lsiz(i, 3) = lsiz(i, 3) + lsrcsiz   'accumulate actual number of bytes
      next                              'accumulate total cluster sizes [above]
      i = ifn.gdir(csrcdir, csrcfil, csrcfsp, csrchdr, ccmd, isrcfl1, lsrcsiz, 0)
   wend
end if

if ifileproc then                       'get list from file (no DIR processing)
'   dsrcsiz = dfn.round(dsrcsiz, 4)    'pre-round the total value before display
   i = ifn.msgs("Total: " + ltrim$(str$(dsrcsiz)), 5, 24, 79, 0, 1)  'sum/total
else                                    'get list from DOS (use DIR processing)
   for i = 0 to isiz                     'loop thru the cluster size sums array
      lsiz(i, 1) = lsiz(i, 0) \ 1024    'set #kilobytes equivalent for each sum
   next
   ilen = len(ltrim$(str$(lsiz(isiz, 0)))) 'length of largest cluster sizes sum
   i = ifn.kill(isrcfl1, "dsrc.dir")          'kill the source filespec dirname
   i = ifn.msgs("", 1, 5, 1, 0, 0)  'clear screen; set position for 1st message
   for i = 0 to isiz                     'loop thru the cluster size sums array
      clsz = right$(space$(2) + ltrim$(str$(lsiz(i, 2))), 5) 'this cluster size
      ctsz = right$(space$(9) + ltrim$(str$(lsiz(i, 0))), ilen)    'total sizes
      cbsz = ltrim$(str$(lsiz(i, 3)))                       'total actual sizes
      lksz = lsiz(i, 0) \ 1024                             'get total kilobytes
      cksz = right$("     (" + ltrim$(str$(lksz)), ilen - 1) 'fmt.tot.kilobytes
      print "    Size in "; clsz; "-byte clusters: "; ctsz; " "; cksz; " kb"; ")"
   next
   print
   print "    "; cbsz; " actual bytes"     'display actual bytes of output data
   locate isiz + 8, 1, 1            'locate cursor for exit to operating system
end if

close                                 'close all files in case not closed above
system                                              'return to operating system
