
/* MENUDEMO

This program demonstrates a basic menuing system.
This system can be used as the front end of any
software package, and can be easily changed to allow
for many more menus and menu items.

*/

/* COMPILER DIRECTIVES */
#include <graphics.h>
#include <bios.h>
#include <stdio.h>
#include <math.h>

#define TITLE 8                          /* Number of characters in the title */
#define NUMBER(array) sizeof(array)/sizeof(array[0])
#define TRUE 1
#define FALSE 0
#define HERC_G 99
#define CGA_G 4
#define EGA_G 13
#define VGA_G 18
#define BULLET 16
#define CURSOR 95
#define SPACE 32
#define BACKSPACE_KEY 8
#define ENTER_KEY 13
#define ESCAPE_KEY 27

/* FUNCTION PROTOTYPES */
void Delay(int);
void Comment_Line(char);
int Get_Choice(int,int,int,int);
void Make_Menu(int,int,int,int,int,int);
void Graphics_Setup();

/* DECLARATION OF GLOBAL VARIABLES */
int choices[2], cursor_x, cursor_y, color;
char menu_buf[2][120][64];
int menu_para[2][4];

struct vconfig screen; /* Holds xpixels, ypixels, textcols, textrows,
                          colors, bitsperpixel, pages, colormask,
                          aspect_v, aspect_h */

char clean[6][6]= {{0,0,0,0,0,0},
                  {0,0,0,0,0,0},
                  {0,0,0,0,0,0},
                  {0,0,0,0,0,0},
                  {0,0,0,0,0,0},
                  {0,0,0,0,0,0}};

char *menu_items[4][5] = {{"MAIN MENU","Menu 1","Menu 2","Menu 3","Exit"},
                          {"MENU 1","Choice 1","Choice 2","Choice 3",""},
                          {"MENU 2","Choice 1","Choice 2","Choice 3",""},
                          {"MENU 3","Choice 1","Choice 2","Choice 3",""}};

/* FUNCTION DEFINITIONS */
main()                                                  /* Controling routine */
{
   int parent_x=16, parent_y=16, items, menu_number=0;
   int level=0, max_chars=11, items_count[4]={5,4,3,4};
   char title="MENUDEMO";
   int i, j, x, y;
   int menu_x, menu_y, right_edge, bottom_edge;

       /* Autodetection of graphics hardware and enter optimum graphics mode */
   Graphics_Setup();
   cursor_x=screen.xpixels/2;
   cursor_y=screen.ypixels/2;
   color=15;

                                      /* Create screen environment for menus */
   pen_color(3);
   move_to(1,1);
   line_to(screen.xpixels-1,1);
   line_to(screen.xpixels-1,screen.ypixels-1);
   line_to(1,screen.ypixels-1);
   line_to(1,1);
   move_to(1,screen.ypixels-14);
   line_to(screen.xpixels-1,screen.ypixels-14);
   move_to(1,11);
   line_to(screen.xpixels-1,11);
   move_to(((screen.xpixels-(TITLE*8))/2),3);
   plots(title);
   pen_color(color);

                                        /* Begin main program control loop */
   while(TRUE)
   {
      menu_number=0;
      level=0;
      items=items_count[menu_number];
      Make_Menu(parent_x,parent_y,items,menu_number,level,max_chars);

      do {
         menu_number=0;
         level=0;
         items=items_count[menu_number];
         menu_number=Get_Choice(parent_x, parent_y, items, level);
         choices[0]=menu_number;

         if (choices[0] == 4) {
            setvmode(DEFAULTMODE);
            exit(0);
         }

         level=1;
         items=items_count[menu_number];
         Make_Menu(parent_x,parent_y,items,menu_number,level,max_chars);

         menu_number=Get_Choice(parent_x, parent_y, items, level);
         choices[1]=menu_number;

          /* Here the Esc key was hit, so restore screen area behind the menu */

         if (menu_number == 0) {
            j=0;
            menu_x=menu_para[level][0];
            menu_y=menu_para[level][1];
            right_edge=menu_para[level][2];
            bottom_edge=menu_para[level][3];

            for(y=menu_y;y<=bottom_edge;y++){
               i=0;
               for(x=menu_x;x<=right_edge;x++){
                  pen_color((int)menu_buf[level][i][j]);
                  setpixel(x,y);
                  i++;
                }
             j++;
             }
         }
      } while (menu_number == 0);

                                                                    /* Menu 1 */
      if (choices[0]==1){
         Comment_Line("NOT IMPLEMENTED YET");
         Delay(500);
         Comment_Line("                                       ");
      }

                                                                    /* Menu 2 */
      if (choices[0]==2){
         Comment_Line("NOT IMPLEMENTED YET");
         Delay(500);
         Comment_Line("                                       ");
      }

                                                                   /* Menu 3 */
      if (choices[0]==3){
         Comment_Line("NOT IMPLEMENTED YET");
         Delay(500);
         Comment_Line("                                       ");

      }

   }

}
Graphics_Setup()                    /* Autodetect and establish graphics mode */
{
   int mode;

   if(setvmode(VGA_G) == VGA_G)
      goto Graphics_mode;
   else if(setvmode(EGA_G) == EGA_G)
      goto Graphics_mode;
   else if(setvmode(CGA_G) == CGA_G)
      goto Graphics_mode;
   else if(setvmode(HERC_G) == HERC_G)
      goto Graphics_mode;
   else {
      printf("You don't have a graphics card installed");
      exit(0);
   }

Graphics_mode:
   getvconfig(&screen);
   mode=getvmode();
   clrscrn2(0);
   return;
}

                                              /* Put the menu on the screen */
Make_Menu(parent_x,parent_y,items,menu_number,level,max_chars)
{
   int i, j, x, y, right_edge, bottom_edge;
   int menu_x=parent_x+level*24, menu_y=parent_y+level*24;
   int width=max_chars*8+16, height=items*8+16;

   j=0;
   right_edge=menu_x+width;
   bottom_edge=menu_y+height;
   menu_para[level][0]=menu_x;
   menu_para[level][1]=menu_y;
   menu_para[level][2]=right_edge;
   menu_para[level][3]=bottom_edge;

                                         /* Store what's underneath the menu */
   for(y=menu_y;y<=bottom_edge;y++){
      i=0;
      for(x=menu_x;x<=right_edge;x++){
         menu_buf[level][i][j]=(char)getpixel(x,y);
         i++;
       }
       j++;
   }

                                                      /* Make the menu boxes */
   fill_style(clean,6,6);
   move_to(menu_x, menu_y);
   box(width, height, 1);
   move_to(menu_x+4, menu_y+4);
   box(width-8, height-8, 0);

                                                     /* Write the menu items */
   for(i=0;i<items;i++) {
      move_to(menu_x+24, menu_y+8+8*i);
      plots(menu_items[menu_number][i]);
   }
}

Get_Choice(parent_x, parent_y, numitems, level)      /* Choose item from menu */
{
   int choice_number=0, keyput=0;
   int bullet_x=parent_x+level*24+8, bullet_y=parent_y+level*24+16;

   pen_color(color);
   move_to(bullet_x, bullet_y);
   plotch(BULLET);

   while(keyput != ENTER_KEY) {
      keyput=getch();
      if (keyput == 72) --choice_number;
      if (keyput == 80) ++choice_number;

      if (choice_number<0) choice_number=numitems-2;
      if (choice_number>numitems-2) choice_number=0;

      move_to(bullet_x, bullet_y);
      plotch(SPACE);
      bullet_y=parent_y+level*24+16+choice_number*8;
      move_to(bullet_x, bullet_y);
      plotch(BULLET);

      if (keyput == ESCAPE_KEY) {
         choice_number=-1;
         keyput = ENTER_KEY;
      }
  }
  move_to(bullet_x, bullet_y);
  plotch(SPACE);
  return choice_number+1;

}

Comment_Line(message)    /* Print message on comment line at bottom of screen */
{
   move_to(8,screen.ypixels-10);
   fill_style(clean,6,6);
   flood(312,8);
   move_to(8,screen.ypixels-10);
   plots(message);
}

Delay(delay)                                            /* Pause in execution */
{
   int i, j, a;
   for (i=0; i<delay; i++) {
      for (j=0; j<1000; j++) ++a;
   }

}
