/* SMJAGUAR.C -- HP95/100LX Commands and Support, System-Manager Compliant

	Written May 1994 by Craig A. Finseth
	Copyright 1994 by Craig A. Finseth

NOTE: This entire file is only compiled and linked on IBM PC (MSDOS)
systems and for the system-manager compliant version.  Therefore, no
#ifdef's are required. */

#include "loki.h"
#undef EVENT
#include "sysmgr.h"

static char clip_buf[BUFFSIZE];

/* ------------------------------------------------------------ */

void
JInit(void)
	{
	m_init();
	}


/* ------------------------------------------------------------ */

void
JFini(void)
	{
	m_fini();
	}


/* ------------------------------------------------------------ */

/* Copy to the clipboard. */

void
JCopy(void)
	{
	char buf[BUFFSIZE];

	if (m_open_cb() != 0) {
		DError(RES_CLIPOPEN);
		return;
		}
	if (m_reset_cb(Res_String(NULL, RES_CONF, RES_CBPROG)) != 0) {
		m_close_cb();
		DError(RES_CLIPINIT);
		return;
		}

	m_new_rep(Res_String(NULL, RES_CONF, RES_CBSMARTTAG));
	m_cb_write((char *)&m.r[X], sizeof(struct number));
	m_fini_rep();

	m_new_rep(Res_String(NULL, RES_CONF, RES_CBTAG));
	if (uarg == 4) {
		UFormat(buf, m.r[X].type, &m.r[X]);
		}
	else if (uarg == 16) {
		DFormat(buf, &m.r[X], "");
		}
	else	{
		UFormat(buf, RES_UN_NONE / UNIT_SIZE, &m.r[X]);
		}
	m_cb_write(buf, strlen(buf));
	m_fini_rep();

	m_close_cb();
	}


/* ------------------------------------------------------------ */

/* End a redisplay. */

void
JDisEnd(void)
	{
	JLightOn();
	m_unlock();
	}


/* ------------------------------------------------------------ */

/* Start a redisplay. */

void
JDisStart(void)
	{
	m_lock();
	JLightOff();
	}


/* ------------------------------------------------------------ */

/* Returns the default configuration file directory. DNAME must point
to an FNAMEMAX-sized buffer. */

void
JGetDir(char *dname)
	{
	m_get_sysdir(dname);
	}


/* ------------------------------------------------------------ */

/* Get a key and handle Jaguar-specific translation. */

int
JGetKey(void)
	{
	int chr;
	FLAG ison = TRUE;
	EVENT e;

	for (;;) {
		if (ison) TCurOn();
		m_event(&e);
		if (ison) TCurOff();
		switch (e.kind) {

		case E_ACTIV:
			TInit();
			DNewDisplay();
			DIncrDisplay();
			return(KEYREGEN);
			/*break;*/

		case E_TERM:
			return(KEYQUIT);
			/*break;*/

		case E_BREAK:
			return(KEYABORT);
			/*break;*/

		case E_KEY:
			chr = e.data;
			if (chr & 0xFF)
				chr &= 0xFF;
			else	chr = ((chr >>= 8) & 0xFF) + 0x100;
			return(chr);
			/*break;*/

		case E_NONE:
			ison = !ison;
			DPostTime();
			break;
			}
		}
	}


/* ------------------------------------------------------------ */

/* Check for a key press.  Return as KIsKey */

char
JIsKey(void)
	{
	EVENT e;

	m_nevent(&e);
	switch (e.kind) {

	case E_ACTIV:
		TInit();
		DNewDisplay();
		DIncrDisplay();
		KPush(KEYREGEN);
		return('Y');
		/*break;*/

	case E_TERM:
		KPush(KEYQUIT);
		return('Y');
		/*break;*/
		
	case E_KEY:
		return('Y');
		/*break;*/
		}
	return('N');
	}


/* ------------------------------------------------------------ */

/* Paste from the clipboard.  Return True if data was stored. */

FLAG
JPaste(void)
	{
	int index;
	int len;
	int amt;

	if (m_open_cb() != 0) {
		DError(RES_CLIPOPEN);
		return(FALSE);
		}

		/* look for smart version */
	if (m_rep_index(Res_String(NULL, RES_CONF, RES_CBSMARTTAG), &index,
		 &len) == 0 && len == sizeof(struct number)) {
		m_cb_read(index, 0, (char *)&m.r[X], sizeof(struct number));
		m_close_cb();
		return(TRUE);
		}

		/* else it must be text */
	if (m_rep_index(Res_String(NULL, RES_CONF, RES_CBTAG), &index,
		 &len) == 0) {
		amt = min(sizeof(clip_buf), len);
		m_cb_read(index, 0, clip_buf, amt);
		KFromStr(clip_buf, amt);
		m_close_cb();
		return(FALSE);
		}

	m_close_cb();
	DError(RES_PASTE);
	return(FALSE);
	}


/* end of  SMJAGUAR.C -- HP95/100LX Commands and Support, System-Manager
Compliant */
