/* LFILE.C -- File-Oriented Commands

	Written April 1994 by Craig A. Finseth
	Copyright 1994 by Craig A. Finseth
*/

#include "loki.h"
char *getenv();

#if defined(MSDOS)
static int numl_state;
#endif

static char envfile[FNAMEMAX] = { NUL };

void F_FPathOpen_DirSep(char *name);

/* ------------------------------------------------------------ */

/* Set up the default environment. */

void
FEnvDefault(void)
	{
	int cnt;

	xstrcpy(m.ident, Res_String(NULL, RES_CONF, RES_IDENT));

	for (cnt = 0; cnt < NUMREGS; cnt++) {
		AZero(&m.r[cnt]);
		}
	m.word_size = Res_Number(RES_CONF, RES_DEFWSIZE);
	MBinFix();
	m.compl_mode = Res_Number(RES_CONF, RES_DEFCOMPL);

	for (cnt = 0; cnt < num_units; cnt++) {
		m.show_types[cnt] = Res_Number(RES_UNITS,
			cnt * UNIT_SIZE + RES_UN__VIS) != 0;
		}

	m.cur_type = RES_UN_NONE / UNIT_SIZE;
	m.frac_mode = Res_Number(RES_CONF, RES_DEFFMODE);
	m.frac_denom = Res_Number(RES_CONF, RES_DEFDENOM);
	m.tab_spacing = Res_Number(RES_CONF, RES_TABW);
	m.stack_lift = FALSE;
	m.fkey_pane = 0;
	m.begnumlock = Res_Number(RES_CONF, RES_BEGNUMLOCK);
	m.endnumlock = Res_Number(RES_CONF, RES_ENDNUMLOCK);
	m.radix = Res_Number(RES_CONF, RES_RADIX);
	*m.line = NUL;
	DNewDisplay();
	}


/* ------------------------------------------------------------ */

/* Load the environment.  If found, save the name. If not found, set
up a default environment. */

void
FEnvLoad(void)
	{
#if defined(FCALLS)
	FILE *fptr;
#else
	int fd;
#endif

#if defined(FCALLS)
	if ((fptr = FPathOpen(Res_String(NULL, RES_CONF, RES_ENVFILE),
		 envfile)) == NULL) {
#else
	if ((fd = FPathOpen(Res_String(NULL, RES_CONF, RES_ENVFILE),
		 envfile)) < 0) {
#endif
		*envfile = NUL;
		FEnvDefault();
		return;
		}

#if defined(FCALLS)
	if (fread((void *)&m, sizeof(char), sizeof(m), fptr) != sizeof(m) ||
		 !strequ(m.ident, Res_String(NULL, RES_CONF, RES_IDENT))) {
		fclose(fptr);
		FEnvDefault();
		return;
		}
	fclose(fptr);
#else
	if (read(fd, (void *)&m, sizeof(m)) != sizeof(m) ||
		 !strequ(m.ident, Res_String(NULL, RES_CONF, RES_IDENT))) {
		close(fd);
		FEnvDefault();
		return;
		}
	close(fd);
#endif
	MBinFix();

#if defined(MSDOS)
	numl_state = KNumLGet();
#endif
	FNumL(m.begnumlock);
	}


/* ------------------------------------------------------------ */

/* Save the environment.  If the environment was loaded from a file,
save it there. */

FLAG
FEnvSave(void)
	{
#if defined(FCALLS)
	FILE *fptr;
#else
	int fd;
#endif

	if (*envfile == NUL) {
		xstrcpy(envfile, Res_String(NULL, RES_CONF, RES_ENVSAVEFILE));
		}

#if defined(FCALLS)
	if ((fptr = fopen(envfile, "wb")) == NULL) return(FALSE);
	if (fwrite((void *)&m, sizeof(char), sizeof(m), fptr) != sizeof(m)) {
		fclose(fptr);
		return(FALSE);
		}
	fclose(fptr);
#else
	if ((fd = open(envfile, O_WRONLY, 0)) < 0) return(FALSE);
	if (write(fd, (void *)&m, sizeof(m)) != sizeof(m)) {
		close(fd);
		return(FALSE);
		}
	close(fd);
#endif
	return(TRUE);
	}


/* ------------------------------------------------------------ */

/* Set the NumLock state */

void
FNumL(int to)
	{
#if defined(MSDOS)
	if (to == 1) {
		KNumLSet(~1);
		}
	else if (to == 2) {
		KNumLSet(0);
		}
	else if (to == 3) {
		KNumLSet(numl_state);
		}
#endif
	}


/* ------------------------------------------------------------ */

/* Open a file for input, searching the path.  NAME should not have a
directory part.  If ACTUALNAME is not NULL, the actual name as opened
will be filled in.  PExpand should be called if you want to remove all
ambuguity.  It searches the following order:

	current dir, $LOKIDIR, $HOME, $PATH, original name
*/

#if defined(MSDOS)
#define SEPCHAR		';'
#define SEPSTR		";"
#endif
#if defined(UNIX)
#define SEPCHAR		':'
#define SEPSTR		":"
#endif

#if defined(FCALLS)
FILE *
#else
int
#endif
FPathOpen(char *name, char *actualname)
	{
#if defined(FCALLS)
	FILE *fptr;
#else
	int fd;
#endif
	char tname[FNAMEMAX];
	char tpath[4 * FNAMEMAX];
	char *cptr;

	*tpath = NUL;
#if !defined(MAC)
	strcat(tpath, ".");
	strcat(tpath, SEPSTR);
#endif

#if defined(SYSMGR)
	cptr = tpath + strlen(tpath);
	JGetDir(cptr);
	strcat(tpath, SEPSTR);
#endif

	if ((cptr = getenv("LOKIDIR")) != NULL) {
		strcat(tpath, cptr);
		strcat(tpath, SEPSTR);
		}

	if ((cptr = getenv("HOME")) != NULL) {
		strcat(tpath, cptr);
		strcat(tpath, SEPSTR);
		}

	if ((cptr = getenv("PATH")) != NULL) {
		if (*cptr == SEPCHAR)  strcat(tpath, ".");
		strcat(tpath, cptr);
		}

	for (cptr = tpath; *cptr != NUL; cptr++) {
		if (*cptr == SEPCHAR) *cptr = NUL;
		}
	*(cptr + 1) = NUL;

	for (cptr = tpath; *cptr != NUL; ) {
		xstrcpy(tname, cptr);
		F_FPathOpen_DirSep(tname);
		strcat(tname, name);
#if defined(FCALLS)
		if ((fptr = fopen(tname, "rb")) != NULL) {
			if (actualname != NULL) xstrcpy(actualname, tname);
			return(fptr);
#else
		if ((fd = open(tname, O_RDONLY, 0)) >= 0) {
			if (actualname != NULL) xstrcpy(actualname, tname);
			return(fd);
#endif
			}
		while (*cptr++ != NUL) ;
		}

#if defined(FCALLS)
	if ((fptr = fopen(name, "rb")) != NULL) {
		if (actualname != NULL) xstrcpy(actualname, name);
		return(fptr);
		}
	return(NULL);
#else
	if ((fd = open(name, O_RDONLY, 0)) >= 0) {
		if (actualname != NULL) xstrcpy(actualname, name);
		return(fd);
		}
	return(-1);
#endif
	}


/* ------------------------------------------------------------ */

/* Load the resource file. */

FLAG
FResLoad(char *file)
	{
	unsigned char *fkeys;
	unsigned char *cptr;
	char fname[FNAMEMAX];
#if defined(FCALLS)
	FILE *fptr;
#else
	int fd;
#endif
	int cnt;

	*fname = NULL;
#if defined(FCALLS)
	if ((fptr = FPathOpen(file, fname)) == NULL) {
#else
	if ((fd = FPathOpen(file, fname)) < 0) {
#endif
#if !defined(SYSMGR)
		xeprintf("Unable to open resource file '%s'.\n", RES_FILENAME);
#endif
		return(FALSE);
		}
#if defined(FCALLS)		
	fclose(fptr);
#else
	close(fd);
#endif
	if (Res_Load(fname) < 0) {
#if !defined(SYSMGR)
		xeprintf("Unable to load resource file '%s'.\n", fname);
#endif
		return(FALSE);
		}

	if (key_method == NUL) key_method = Res_Char(RES_CONF, RES_KEYINP);
	if (screen_type == 102)
		screen_type = Res_Number(RES_CONF, RES_SCRNTYPE);

	madefor = Res_Char(RES_CONF, RES_MADEFOR);
	ESC_swap = Res_Number(RES_CONF, RES_ESCSWAP);
	CTX_swap = Res_Number(RES_CONF, RES_CTXSWAP);
	meta_handle = Res_Char(RES_CONF, RES_METAKEY);
	ctype = (char *)Res_String(NULL, RES_CSET, RES_CTYPE);
	lower = (char *)Res_String(NULL, RES_CSET, RES_TOLOW);
	upper = (char *)Res_String(NULL, RES_CSET, RES_TOUPP);

	num_units = Res_Number(RES_UNITS, -1) / UNIT_SIZE;
	num_panes = Res_Number(RES_PANES, -1) / PANE_SIZE;

	for (cnt = 0; cnt < num_units; cnt++) {
		units[cnt].name = Res_String(NULL, RES_UNITS,
			cnt * UNIT_SIZE);
		units[cnt].format = Res_String(NULL, RES_UNITS,
			cnt * UNIT_SIZE + RES_UN__FORMAT);
		units[cnt].cat = Res_Number(RES_UNITS,
			cnt * UNIT_SIZE + RES_UN__CAT);
		units[cnt].cat = Res_Number(RES_UNITS,
			cnt * UNIT_SIZE + RES_UN__CAT);
		units[cnt].factors = Res_String(&units[cnt].len, RES_UNITS,
			cnt * UNIT_SIZE + RES_UN__FACTORS);
		}

	return(TRUE);
	}


/* ------------------------------------------------------------ */

/* Write the calculator state to the dump file. */

void
FSave(void)
	{
#if defined(FCALLS)
	FILE *fptr;
#else
	int fd;
#endif
	char *fname = Res_String(NULL, RES_CONF, RES_SAVEFILE);
	int cnt;
	char buf[BUFFSIZE];
	char buf2[BUFFSIZE];

#if defined(FCALLS)
	if ((fptr = fopen(fname, "ab")) == NULL) return;
#define FPARM fptr
#else
	if ((fd = open(fname, O_WRONLY, 0)) < 0) {
		if ((fd = creat(fname, 0666)) < 0) {
			return;
			}
		}
	else	{
		lseek(fd, 0L, 2);
		}
#define FPARM fd
#endif
	xdprintf(FPARM, Res_String(NULL, RES_MSGS, RES_FSAVE1));
	DFormat(buf, &m.r[X], "X");
	xdprintf(FPARM, "%s\n", buf);
	DFormat(buf, &m.r[Y], "Y");
	xdprintf(FPARM, "%s\n", buf);
	DFormat(buf, &m.r[Z], "Z");
	xdprintf(FPARM, "%s\n", buf);
	DFormat(buf, &m.r[T], "T");
	xdprintf(FPARM, "%s\n", buf);
	DFormat(buf, &m.r[L], "L");
	xdprintf(FPARM, "%s\n", buf);
	DFormat(buf, &m.r[CLIP], "C");
	xdprintf(FPARM, "%s\n", buf);

	xdprintf(FPARM, Res_String(NULL, RES_MSGS, RES_FSAVE2));
	for (cnt = 0; cnt < REGCOUNT; cnt++) {
		xsprintf(buf2, Res_String(NULL, RES_MSGS, RES_REGSTR), cnt);
		DFormat(buf, &m.r[cnt], buf2);
		xdprintf(FPARM, "%s\n", buf);
		}

	xdprintf(FPARM, "\n");

	xdprintf(FPARM, Res_String(NULL, RES_MSGS, RES_FSAVE3),
		units[m.cur_type].name);

	xdprintf(FPARM, Res_String(NULL, RES_MSGS, RES_FSAVE4),
		m.word_size, m.compl_mode);

	xdprintf(FPARM, Res_String(NULL, RES_MSGS, RES_FSAVE5),
		m.frac_mode, m.frac_denom);

	xdprintf(FPARM, Res_String(NULL, RES_MSGS, RES_FSAVE6),
		m.stack_lift);

	xdprintf(FPARM, Res_String(NULL, RES_MSGS, RES_FSAVE7),
		m.begnumlock);

	xdprintf(FPARM, Res_String(NULL, RES_MSGS, RES_FSAVE8),
		m.endnumlock);

	xdprintf(FPARM, Res_String(NULL, RES_MSGS, RES_FSAVE9),
		m.radix);

	xdprintf(FPARM, Res_String(NULL, RES_MSGS, RES_FSAVE10),
		m.fkey_pane);

	xdprintf(FPARM, Res_String(NULL, RES_MSGS, RES_FSAVE11),
		m.tab_spacing);

	xdprintf(FPARM, Res_String(NULL, RES_MSGS, RES_FSAVE12),
		m.hex_letters);

	xdprintf(FPARM, Res_String(NULL, RES_MSGS, RES_FSAVE13),
		m.line);

	xdprintf(FPARM, Res_String(NULL, RES_MSGS, RES_FSAVE14));

	for (cnt = num_units - 1; cnt >= 0; cnt--) {
		if (m.show_types[cnt]) {
			xdprintf(FPARM, Res_String(NULL, RES_MSGS, RES_FSAVE15),
				units[cnt].name);
			}
		}
	xdprintf(FPARM, "\f\n");
#if defined(FCALLS)
	fclose(fptr);
#else
	close(fd);
#endif
	}


/* ------------------------------------------------------------ */

void
F_FPathOpen_DirSep(char *name)
	{
#if defined(UNIX)
	if (*(name + strlen(name) - 1) != '/') strcat(name, "/");
#endif
#if defined(MSDOS)
	if (*(name + strlen(name) - 1) != '/' &&
		*(name + strlen(name) - 1) != '\\') strcat(name, "/");
#endif
	}


/* end of LFILE.C -- File-Oriented Commands */
