#			 Resource Source File
#			English Language Text
#

# ------------------------------------------------------------
# Messages Table
#
# This table holds all language-dependant messages.

table	MSGS

# loki.c
SCRATCH		"Loki 2.4, a calculator\n\
\n\
Type ^X ^C to exit\n\
     ^^ for menus\n\
-------------------------------------\n\
Copyright 1994 by Craig A. Finseth\n\
1343 Lafond, St Paul MN 55104, USA\n\
+1 612 644 4027\n\
fin@unet.umn.edu\n\
Craig.Finseth@mr.net\n"

# larith.c
CALCDIVZERO	"Divide by Zero"
CALCNEG		"Negative"
CLEARPROMPT	"Clear register: "
RECALLPROMPT	"Recall from register: "
STOREPROMPT	"Store in register: "

# ldisplay.c
HEADER		"Loki 2.4"
DISPBOT1	" %[uns%;1's%;2's%]/%d "
DISPBOT2	" %[none%;fix%;factors%;most%]/%d "

# lfile.c
FSAVE1		"Loki State:\n\n"
FSAVE2		"\nRegisters (R0 is M):\n\n"
FSAVE3		"current type %s\n"
FSAVE4		"word size %d, complement mode %[unsigned%;1's%;2's%]\n"
FSAVE5		"fraction mode %[none%;fixed denominator%;factors of denominator%;most precise%], denominator is %d\n"
FSAVE6		"stack lift %[disabled%:enabled%]\n"
FSAVE7		"NumLock is %[untouched%;set%;cleared%] on startup\n"
FSAVE8		"NumLock is %[untouched%;set%;cleared%;restored%] on exit\n"
FSAVE9		"Radix mark is %[.%;,%]\n"
FSAVE10		"function key pane is %d\n"
FSAVE11		"tab spacing is %d columns\n"
FSAVE12		"hex letters %[off%:on%]\n"
FSAVE13		"entry line '%s'\n"
FSAVE14		"displayed types are:\n\n"
FSAVE15		"\t%s\n"

# lkey.c
ERRNONNUM	"Not a decimal number"
MACROCREATE	"Creating macro"
MACROFULL	"Keyboard macro full"
MACROUSE	"Using macro"
NOSTRING	"\x8\x7fN"
PROMPTARG	"Arg: %d"
YESSTRING	" Y"

# lmisc.c
ABOUTSTR	"Loki calculator, Version 2.4\n\
\n\
running: for %c, key %c, screen %d %c (%d rows, %d cols)\n\
\n\
Copyright 1994 by Craig A. Finseth\n\
1343 Lafond, St Paul MN 55104, USA\n\
+1 612 644 4027\n\
fin@unet.umn.edu\n\
Craig.Finseth@mr.net\n\n"
ASKSURE		"Are you sure? "
EXPLARG		"An explicit argument must be supplied."
PROMPTCTX	"Control-X:"
PROMPTESC	"Meta:"
PROMPTKEY	"Enter value for key:"
PROMPTQUOTE	"Quote:"
REGSTR		"R%d"
STATUSSTR1	"%d registers, R0 is M, radix is %[.%;,%] "
STATUSSTR2	"stack lift %[disabled%:enabled%], hex letters %[off%:on%] "
STATUSSTR3	"NumLock is %[untouched%;set%;cleared%] on startup and %[untouched%;set%;cleared%;restored%] on exit "
STATUSSTR4	"tab spacing is %d columns"
STATUSSTR5	"displayed types are:"
STATUSSTR6	"clipboard is"
UNKCMD		"Unknown command"

# lunits.c
BADNUM		"not a number"
BADUNIT		"unknown unit"
HEXSTR		"0123456789-+.abcdef"
NUMBERSTR	"0123456789-+."
ESTR		"E"

# smjaguar.c
CLIPINIT	_sc "can't init clipboard"
		_* ""
CLIPOPEN	_sc "can't open clipboard"
		_* ""
GETTER		_sc "can't init file getter"
		_* ""
PASTE		_sc "nothing to paste"
		_* ""


# ------------------------------------------------------------
# Key Labels Table
#
# This table holds the labels to display for all function keys.
# Note that there must be 255 entries in this table.

table	KEYLABEL

	# 0
- "^0"		- "^1"		- "^2"		- "Ctrl-2"	- "^4"
- "^5"		- "^6"		- "^7"		- "^8"		- "^9"
	# 10
- "^10"		- "^11"		- "^12"		- "^13"		- "^14"
- "Shift-Tab"	- "Alt-Q"	- "Alt-W"	- "Alt-E"	- "Alt-R"
	# 20
- "Alt-T"	- "Alt-Y"	- "Alt-U"	- "Alt-I"	- "Alt-O"
- "Alt-P"	- ""		- "	"	- ""		- ""
	# 30
- "Alt-A"	- "Alt-S"	- "Alt-D"	- "Alt-F"	- "Alt-G"
- "Alt-H"	- "Alt-J"	- "Alt-K"	- "Alt-L"	- ""
	# 40
- ""		- ""		- ""		- ""		- "Alt-Z"
- "Alt-X"	- "Alt-C"	- "Alt-V"	- "Alt-B"	- "Alt-N"
	# 50
- "Alt-M"	- ""		- ""		- ""		- ""
- ""		- ""		- ""		- ""		- "F1"
	# 60
- "F2"		- "F3"		- "F4"		- "F5"		- "F6"
- "F7"		- "F8"		- "F9"		- "F10"		- ""
	# 70
- ""		- "Home"	- "Up Arrow"	- "PgUp"	- ""
- "Left Arrow"	- ""		- "Right Arrow"	- ""		- "End"
	# 80
- "Down Arrow"	- "PgDn"	- "Ins"		- "Del"		- "Shift-F1"
- "Shift-F2"	- "Shift-F3"	- "Shift-F4"	- "Shift-F5"	- "Shift-F6"
	# 90
- "Shift-F7"	- "Shift-F8"	- "Shift-F9"	- "Shift-F10"	- "Ctrl-F1"
- "Ctrl-F2"	- "Ctrl-F3"	- "Ctrl-F4"	- "Ctrl-F5"	- "Ctrl-F6"
	# 100
- "Ctrl-F7"	- "Ctrl-F8"	- "Ctrl-F9"	- "Ctrl-F10"	- "Alt-F1"
- "Alt-F2"	- "Alt-F2"	- "Alt-F4"	- "Alt-F5"	- "Alt-F6"
	# 110
- "Alt-F7"	- "Alt-F8"	- "Alt-F9"	- "Alt-F10"	- "Ctrl-PrtSc"
- "Ctrl-Left Arrow"	- "Ctrl-Right Arrow"	- "Ctrl-End"	- "Ctrl-PgDn"
- "Ctrl-Home"
	# 120
- "Alt-1"	- "Alt-2"	- "Alt-3"	- "Alt-4"	- "Alt-5"
- "Alt-6"	- "Alt-7"	- "Alt-8"	- "Alt-9"	- "Alt-0"
	# 130
- "Alt--"	- "Alt-="	- "Ctrl-PgUp"	- ""		- ""
- ""		- ""		- ""		- ""		- ""
	# 140
- ""		- "Ctrl-PgUp"	- "Ctrl--"	- ""		- "Alt-+"
- "Ctrl-PgDn"	- "Ctrl-Ins"	- ""		- ""		- ""
	# 150
- "Ctrl-*"	- ""		- ""		- ""		- ""
- ""		- ""		- ""		- ""		- ""
	# 160
- ""		- ""		- "Ctrl-On"	- ""		- _cd "&..."
								  _*  "SETUP"
- "Alt-Tab"	- ""		- "Alt-&..."	- "FILER"	- ""
	# 170
- "Ctrl-&..."	- "Alt-FILER"	- _cd "cc:MAIL"
				  _*  "COMM"	- ""		- "Ctrl-FILER"
- _cd "Alt-cc:MAIL"
  _*  "Alt-COMM" - "APPT"	- ""		- _cd "Ctrl-cc:MAIL"
						  _*  "Ctrl-COMM" - "Alt-APPT"
	# 180
- "PHONE"	- ""		- "Ctrl-APPT"	- "Alt-PHONE"	- "MEMO"
- ""		- "Ctrl-PHONE"	- "Alt-MEMO"	- "123"	- ""
	# 190
- "Ctrl-MEMO"	- "Alt-123"	- _cd "HP CALC"
				  _*  "CALC"	- ""		- "Ctrl-123"
- _cd "Alt-HP CALC"
  _*  "Alt-CALC" - ""		- ""		- _cd "Ctrl-HP CALC"
						  _*  "Ctrl-CALC" - ""
	# 200
- "MENU"	- "Shift-MENU"	- "Ctrl-MENU"	- "Alt-MENU"	- ""
- ""		- ""		- ""		- "ZOOM"	- "DATE"
	# 210
- "TIME"	- ""		- "CUT"		- "COPY"	- "PASTE"
- ""		- ""		- ""		- ""		- ""
	# 220
- ""		- ""		- ""		- ""		- ""
- ""		- ""		- ""		- ""		- ""
	# 230
- ""		- ""		- ""		- ""		- ""
- ""		- ""		- ""		- ""		- ""
	# 240
- ""		- ""		- ""		- ""		- ""
- ""		- ""		- ""		- ""		- ""
	# 250
- ""		- ""		- ""		- ""		- ""
- ""


# ------------------------------------------------------------
# Function Key Panes
#
#
# This table holds all function key pane definitions.  Each definition
# has this format:
#
#	string to use for the display
#	function to invoke
#
# it is repeated 10 times.
#
# Don't forget to add new panes to the PANE menu

table	PANES

PANE_STACK "LastX"	-	key "^Ml "
-	"Roll"		-	key "^Mr "
-	"Swap"		-	key "^Ms "
-	"Enter"		-	key "^Mt "
-	"Recall"	-	key "^M<"
-	"Store"		-	key "^M>"
-	""		-	key ""
-	"+/-"		-	key "`"
-	"More"		-	key "^XP"
-	"Menu"		-	key "^^"

PANE_MEM "M+"		-	key ">+0"
-	"M-"		-	key ">-0"
-	"RM"		-	key "<0"
-	"CM"		-	key "^X@0"
-	""		-	key ""
-	""		-	key ""
-	""		-	key ""
-	"+/-"		-	key "`"
-	"More"		-	key "^XP"
-	"Menu"		-	key "^^"

PANE_MATH1 "Sqrt"	-	key "^R"
-	"x^2"		-	key "^S"
-	"Cbrt"		-	key "^B"
-	"x^3"		-	key "^C"
-	"Distance"	-	key "^^ND"
-	"Area"		-	key "^^NA"
-	"Volume"	-	key "^^NV"
-	"+/-"		-	key "`"
-	"More"		-	key "^XP"
-	"Menu"		-	key "^^"

PANE_MATH2 "Sqrt"	-	key "^R"
-	"x^2"		-	key "^S"
-	"Cbrt"		-	key "^B"
-	"x^3"		-	key "^C"
-	"FracMode"	-	key "^X."
-	"SetDenom"	-	key "^:Enter denominator`^X%"
-	"1/x"		-	key "\\"
-	"+/-"		-	key "`"
-	"More"		-	key "^XP"
-	"Menu"		-	key "^^"

PANE_TYPE "Unit"	-	key "^^U"
-	"Convert"	-	key "^^N"
-	"Show"		-	key "^^S"
-	""		-	key ""
-	""		-	key ""
-	""		-	key ""
-	""		-	key ""
-	"+/-"		-	key "`"
-	"More"		-	key "^XP"
-	"Menu"		-	key "^^"

PANE_BIN "Bin"		-	key "^U^!UN_BIN`^XT"
-	"Oct"		-	key "^U^!UN_OCT`^XT"
-	"Dec"		-	key "^U^!UN_DEC`^XT"
-	"Hex"		-	key "^U^!UN_HEX`^XT"
-	"Compl"		-	key "^XM"
-	"WSize"		-	key "^:Enter word size`^XZ"
-	"ASCIIin"	-	key "^2"
-	"+/-"		-	key "`"
-	"More"		-	key "^XP"
-	"Menu"		-	key "^^"

# ------------------------------------------------------------
# Menus Tables

menu	COMPL
- " Complement "	- _cdiu 0x12
			  _*  0x10
- "1's"			- key "^U1^XM"
- "2's"			- key "^U2^XM"
- "Unsigned"		- key "^U0^XM"
- "SetWordSize..."	- key "^:Enter word size`^XZ"

menu	CONV_ANGLE
- " Angle "		- _cdiu 0x12
			  _*  0x10
- "d)g '"		- key "^U^!UN_DEG`^V"
- "rad"			- key "^U^!UN_RAD`^V"
- "grad"		- key "^U^!UN_GRAD`^V"
- "r&a '"		- key "^U^!UN_RA`^V"

menu	CONV_AREA
- " Area "		- _cdiu 0x12
			  _*  0x10
- "m^2"			- key "^U^!UN_SQM`^V"
- "ft^2"		- key "^U^!UN_SQFT`^V"
- "in^2"		- key "^U^!UN_SQIN`^V"

menu	CONV_BIN
- " Binary "		- _cdiu 0x12
			  _*  0x10
- "Binary"		- key "^U^!UN_BIN`^V"
- "Octal"		- key "^U^!UN_OCT`^V"
- "Decimal"		- key "^U^!UN_DEC`^V"
- "Hexadecimal"		- key "^U^!UN_HEX`^V"
- "ASCII"		- key "^U^!UN_ASCII`^V"
- "B&inaryLeadZeros"	- key "^U^!UN_BINZ`^V"
- "O&ctalLeadZeros"	- key "^U^!UN_OCTZ`^V"
- "H&exadecimalLeadZeros" - key "^U^!UN_HEXZ`^V"

menu	CONV_DIST
- " Distance "		- _cdiu 0x12
			  _*  0x10
- "m"			- key "^U^!UN_M`^V"
- "' \""		- key "^U^!UN_FTIN`^V"
- "ft"			- key "^U^!UN_FT`^V"
- "in"			- key "^U^!UN_IN`^V"
- "smoot"		- key "^U^!UN_SMOOT`^V"

menu	CONV_MASS
- " Mass "		- _cdiu 0x12
			  _*  0x10
- "kg"			- key "^U^!UN_KG`^V"
- "lb"			- key "^U^!UN_LB`^V"
- "oz"			- key "^U^!UN_OZ`^V"

menu	CONV_TEMP
- " Temperature "	- _cdiu 0x12
			  _*  0x10
- "o&C"			- key "^U^!UN_DEGC`^V"
- "o&F"			- key "^U^!UN_DEGF`^V"

menu	CONV_VOL
- " Volume "		- _cdiu 0x12
			  _*  0x10
- "l"			- key "^U^!UN_L`^V"
- "gal"			- key "^U^!UN_GAL`^V"
- "m^3"			- key "^U^!UN_CUM`^V"
- "ft^3"		- key "^U^!UN_CUFT`^V"
- "in^3"		- key "^U^!UN_CUIN`^V"

menu	CONV
- " Convert "		- _cdiu 0x12
			  _*  0x10
- "None"		- key "^U^!UN_NONE`^V"
- "Binary..."		- list16 256 CONV_BIN .
- "Distance..."		- list16 256 CONV_DIST .
- "Area..."		- list16 256 CONV_AREA .
- "Volume..."		- list16 256 CONV_VOL .
- "Mass..."		- list16 256 CONV_MASS .
- "An&gle..."		- list16 256 CONV_ANGLE .
- "Time"		- key "^U^!UN_TIME`^V"
- "Dat&e"		- key "^U^!UN_DATE`^V"
- "Tem&perature..."	- list16 256 CONV_TEMP .

menu	EDIT
- " Edit "		- _cdiu 0x12
			  _*  0x10
- "Copy"		- key "^[W"
- _cs "Copy&W/Type"
  _* "unused"		- _cs key "^U^[W"
  			  _* key ""
- _cs "CopyS&hown"
  _* "unused"		- _cs key "^U^U^[W"
  			  _* key ""
- "Cu&t"		- key "^W"
- "Paste"		- key "^Y"
- "Clear&X"		- key "^XX"
- "Clear&All"		- key "^U^XL"
- "Clear&Stack"		- key "^U1^XL"
- "Clear&Registers"	- key "^U2^XL"

menu	FILE
- " File "		- _cdiu 0x12
			  _*  0x10
- "A&bout"		- key "^8"
- "DefaultSettings"	- key "^X^R"
- "Save"		- key "^X^S"
- "E&xit"		- key "^X^C"

menu	FONT
- " Font "		- _cdiu 0x12
			  _*  0x10
- "Normal"		- key "^U103^X+"
- "Cycle|^X+"		- key "^X+"
- _js "16x&40"
  _cd "25z&80"
  _i "25x&40"
  _* "unused"		- _js key "^U24^X+Y"
			  _cd key "^U2^X+Y"
			  _i key "^U0^X+Y"
  			  _* key ""
- _js "21x&60"
  _cd "18x&64"
  _* "unused"		- _js key "^U25^X+Y"
			  _cd key "^U80^X+Y"
  			  _* key ""
- _js "25x&80"
  _cd "16x&40"
  _* "unused"		- _js key "^U26^X+Y"
			  _cd key "^U84^X+Y"
  			  _* key ""

menu	FRAC
- " Fractions "		- _cdiu 0x12
			  _*  0x10
- "NoFractions"		- key "^U0^X."
- "Fi&xedDenom"		- key "^U1^X."
- "FactorsofDenom"	- key "^U2^X."
- "MostPrecise"		- key "^U3^X."
- "SetDenominator..."	- key "^:Enter denominator`^X%"

menu	KEYMACRO
- " KeyMacro "		- _cdiu 0x12
			  _*  0x10
- "Record|^X("		- key "^X("
- "FinishRecording|^X)"	- key "^U^X)"
- "Execute|^]"		- key "^]"
- "Fe&tch..."		- key "^:Enter macro number`^[^]"

menu	MATH1
- " Math1 "		- _cdiu 0x12
			  _*  0x10
- "+)Addition"		- key "+"
- "-)Subtraction"	- key "-"
- "*)Multiplication"	- key "*"
- "/)Division"		- key "/"
- "%)Percentage"	- key "%"
- "\\\\)1/x"		- key "\\"
- "S)Square"		- key "^S"
- "R)Square Root"	- key "^R"
- "C)Cube"		- key "^C"
- "B)Cube Root"		- key "^B"

menu	MATH2
- " Math2 "		- _cdiu 0x12
			  _*  0x10
- "\\&)Binary And"	- key "&"
- "|)Binary Or"		- key "|"
- "!)Binary Not"	- key "!"
- "^)Binary Xor"	- key "^="
- "[)Shift Left"	- key "["
- "])Shift Right"	- key "]"
- "<)Recall..."		- key "<"
- ">)Store..."		- key ">"

menu	NUMLOCK
- " NumLock "		- _cdiu 0x12
			  _*  0x10
- "&A)Untouched on startup" - key "^U0^XB"
- "&B)Set on startup"	- key "^U1^XB"
- "&C)Cleared on startup" - key "^U2^XB"
- "&1)Untouched on exit" - key "^U0^XD"
- "&2)Set on exit"	- key "^U1^XD"
- "&3)Cleared on exit"	- key "^U2^XD"
- "&4)Restored on exit"	- key "^U3^XD"

menu	OTHER
- " Other "		- _cdiu 0x12
			  _*  0x10
- "Date"		- key "^209"
- "Time"		- key "^210"
- "NewDisplay"		- key "^[^L"
- "EnterASCIIKey..."	- key "^2"
- "KeyInsert..."	- key "^Q"
- "Do&FuncKey..."	- key "^:Enter scan code in decimal`^X#"
- "Ta&bSpacing..."	- key "^:Enter tab spacing`^X,"
- "Num&Lock..."		- list16 256 NUMLOCK .
- "&1)HexLettersOff"	- key "^U0^XH"
- "&2)HexLettersOn"	- key "^U1^XH"
- "Radix&."		- key "^U0^XI"
- "Radix&,"		- key "^U1^XI"

menu	PANE
- " Pane "		- _cdiu 0x12
			  _*  0x10
- "Stack Pane"		- key "^U^!PANE_STACK`^XP"
- "Memor&y Pane"	- key "^U^!PANE_MEM`^XP"
- "Measure Pane"	- key "^U^!PANE_MATH1`^XP"
- "Fractions Pane"	- key "^U^!PANE_MATH2`^XP"
- "Type Pane"		- key "^U^!PANE_TYPE`^XP"
- "Binary Pane"		- key "^U^!PANE_BIN`^XP"

menu	SHOW_ANGLE
- " Angle "		- _cdiu 0x12
			  _*  0x10
- "d)g '"		- key "^U^!UN_DEG`^XS"
- "rad"			- key "^U^!UN_RAD`^XS"
- "grad"		- key "^U^!UN_GRAD`^XS"
- "r&a '"		- key "^U^!UN_RA`^XS"

menu	SHOW_AREA
- " Area "		- _cdiu 0x12
			  _*  0x10
- "m^2"			- key "^U^!UN_SQM`^XS"
- "ft^2"		- key "^U^!UN_SQFT`^XS"
- "in^2"		- key "^U^!UN_SQIN`^XS"

menu	SHOW_BIN
- " Binary "		- _cdiu 0x12
			  _*  0x10
- "Binary"		- key "^U^!UN_BIN`^XS"
- "Octal"		- key "^U^!UN_OCT`^XS"
- "Decimal"		- key "^U^!UN_DEC`^XS"
- "Hexadecimal"		- key "^U^!UN_HEX`^XS"
- "ASCII"		- key "^U^!UN_ASCII`^XS"
- "B&inaryLeadZeros"	- key "^U^!UN_BINZ`^XS"
- "O&ctalLeadZeros"	- key "^U^!UN_OCTZ`^XS"
- "H&exadecimalLeadZeros" - key "^U^!UN_HEXZ`^XS"

menu	SHOW_DIST
- " Distance "		- _cdiu 0x12
			  _*  0x10
- "m"			- key "^U^!UN_M`^XS"
- "' \""		- key "^U^!UN_FTIN`^XS"
- "ft"			- key "^U^!UN_FT`^XS"
- "in"			- key "^U^!UN_IN`^XS"
- "smoot"		- key "^U^!UN_SMOOT`^XS"

menu	SHOW_MASS
- " Mass "		- _cdiu 0x12
			  _*  0x10
- "kg"			- key "^U^!UN_KG`^XS"
- "lb"			- key "^U^!UN_LB`^XS"
- "oz"			- key "^U^!UN_OZ`^XS"

menu	SHOW_TEMP
- " Temperature "	- _cdiu 0x12
			  _*  0x10
- "o&C"			- key "^U^!UN_DEGC`^XS"
- "o&F"			- key "^U^!UN_DEGF`^XS"

menu	SHOW_VOL
- " Volume "		- _cdiu 0x12
			  _*  0x10
- "l"			- key "^U^!UN_L`^XS"
- "gal"			- key "^U^!UN_GAL`^XS"
- "m^3"			- key "^U^!UN_CUM`^XS"
- "ft^3"		- key "^U^!UN_CUFT`^XS"
- "in^3"		- key "^U^!UN_CUIN`^XS"

menu	SHOW
- " Show "		- _cdiu 0x12
			  _*  0x10
- "None"		- key "^U^!UN_NONE`^XS"
- "Binary..."		- list16 256 SHOW_BIN .
- "Distance..."		- list16 256 SHOW_DIST .
- "Area..."		- list16 256 SHOW_AREA .
- "Volume..."		- list16 256 SHOW_VOL .
- "Mass..."		- list16 256 SHOW_MASS .
- "An&gle..."		- list16 256 SHOW_ANGLE .
- "Time"		- key "^U^!UN_TIME`^XS"
- "Dat&e"		- key "^U^!UN_DATE`^XS"
- "Tem&perature..."	- list16 256 SHOW_TEMP .

menu	UNIT_ANGLE
- " Angle "		- _cdiu 0x12
			  _*  0x10
- "d)g '"		- key "^U^!UN_DEG`^XT"
- "rad"			- key "^U^!UN_RAD`^XT"
- "grad"		- key "^U^!UN_GRAD`^XT"
- "r&a '"		- key "^U^!UN_RA`^XT"

menu	UNIT_AREA
- " Area "		- _cdiu 0x12
			  _*  0x10
- "m^2"			- key "^U^!UN_SQM`^XT"
- "ft^2"		- key "^U^!UN_SQFT`^XT"
- "in^2"		- key "^U^!UN_SQIN`^XT"

menu	UNIT_BIN
- " Binary "		- _cdiu 0x12
			  _*  0x10
- "Binary"		- key "^U^!UN_BIN`^XT"
- "Octal"		- key "^U^!UN_OCT`^XT"
- "Decimal"		- key "^U^!UN_DEC`^XT"
- "Hexadecimal"		- key "^U^!UN_HEX`^XT"
- "ASCII"		- key "^U^!UN_ASCII`^XT"
- "B&inaryLeadZeros"	- key "^U^!UN_BINZ`^XT"
- "O&ctalLeadZeros"	- key "^U^!UN_OCTZ`^XT"
- "H&exadecimalLeadZeros" - key "^U^!UN_HEXZ`^XT"

menu	UNIT_DIST
- " Distance "		- _cdiu 0x12
			  _*  0x10
- "m"			- key "^U^!UN_M`^XT"
- "' \""		- key "^U^!UN_FTIN`^XT"
- "ft"			- key "^U^!UN_FT`^XT"
- "in"			- key "^U^!UN_IN`^XT"
- "smoot"		- key "^U^!UN_SMOOT`^XT"

menu	UNIT_MASS
- " Mass "		- _cdiu 0x12
			  _*  0x10
- "kg"			- key "^U^!UN_KG`^XT"
- "lb"			- key "^U^!UN_LB`^XT"
- "oz"			- key "^U^!UN_OZ`^XT"

menu	UNIT_TEMP
- " Temperature "	- _cdiu 0x12
			  _*  0x10
- "o&C"			- key "^U^!UN_DEGC`^XT"
- "o&F"			- key "^U^!UN_DEGF`^XT"

menu	UNIT_VOL
- " Volume "		- _cdiu 0x12
			  _*  0x10
- "l"			- key "^U^!UN_L`^XT"
- "gal"			- key "^U^!UN_GAL`^XT"
- "m^3"			- key "^U^!UN_CUM`^XT"
- "ft^3"		- key "^U^!UN_CUFT`^XT"
- "in^3"		- key "^U^!UN_CUIN`^XT"

menu	UNIT
- " Unit "		- _cdiu 0x12
			  _*  0x10
- "None"		- key "^U^!UN_NONE`^XT"
- "Binary..."		- list16 256 UNIT_BIN .
- "Distance..."		- list16 256 UNIT_DIST .
- "Area..."		- list16 256 UNIT_AREA .
- "Volume..."		- list16 256 UNIT_VOL .
- "Mass..."		- list16 256 UNIT_MASS .
- "An&gle..."		- list16 256 UNIT_ANGLE .
- "Time"		- key "^U^!UN_TIME`^XT"
- "Dat&e"		- key "^U^!UN_DATE`^XT"
- "Tem&perature..."	- list16 256 UNIT_TEMP .

menu	VIEW
- " View "		- _cdiu 0x12
			  _*  0x10
- "Registers"		- key "^XR"
- "Status"		- key "^XU"
- "AllForms"		- key "^XA"

menu	MAIN
- " Main "		- _cdiu 0x01
			  _*  0x00
- "File"		- list16 256 FILE .
- "Edit"		- list16 256 EDIT .
- "Math&1"		- list16 256 MATH1 .
- "Math&2"		- list16 256 MATH2 .
- "Complement"		- list16 256 COMPL .
- "F&ractions"		- list16 256 FRAC .
- "View"		- list16 256 VIEW .
- "Co&nvert"		- list16 256 CONV .
- "Unit"		- list16 256 UNIT .
- "Show"		- list16 256 SHOW .
- "Other"		- list16 256 OTHER .
- "Pane"		- list16 256 PANE .
- "Fon&t"		- list16 256 FONT .
- "KeyMacro"		- list16 256 KEYMACRO .
- "Quit"		- key "^X^C"

