/* "DBTest"  V1.0      
                       

Please observe that this program was written with focus on the Database
functions. It's not program for any serious usage other as information 
how to do an EXM database program. I do not in any way claim that this 
is the only or correct way to do things- but it seams to work. But I
have not tested it for bugs and do not guarantee anything. I do not
claim to be a programmer, so if the program is written in a funny way,
that's the way it is. :) */


/* ======================================
   Definitions
   ====================================== */
#include <string.h>
#include "lxapi.h"    /* The Japanese Header File which makes this possible. */
#include "dbapi.h"    /* Japanese Header File with the DB commands. */
#include "hourglas.h" /* My Header File which gives us an Hourglass. */
#include "pwdedit.h"  /* My Header File which gives us 'X' in Password dlg box.*/

#define XY_CENTER(w,h) ((640-w)/2),((200-h)/2),(w),(h)
#define SET_DISP_MSG(x) ErrorArray[0].Data=(PLHDATA)(x) /* To Center Err Msg */
#define CFGFILE        "c:\\_dat\\dbtest.env" 
#define CFGFILELEN     (18)
#define ENTERKEY       0x0d
#define ESCKEY         0x1b
#define FATAL_ERROR    -50
#define PWD_ERROR      -51

/* DATABASE DEFINITIONS: */
DBBLOCK     dblk;
#define     MAX_CARD_WNDS 16
#define     FIELDCOUNT (sizeof(FieldName)>>1)
char far    *SysMgrPtrs[MAX_CARD_WNDS + 27];
char        filetype    = 'D'; /* D == GDB */
char        CountResult [10]; /* gives the 'x/y' records result. */
char        buf[2048];
char        Pwd[16]     = "";
char        TempPwd[16]  = "";
char        OldPwd[16]  = "";
int         RecNo;
int         DBError     = 0;
int         NewRecNo;
int         FieldKind[] = {NUMBER_FIELD, TIME_FIELD, DATE_FIELD, DATE_FIELD,
                           STRING_FIELD, STRING_FIELD, STRING_FIELD,
                           STRING_FIELD, STRING_FIELD, STRING_FIELD};
char        *FieldName[]= {"Index", "TimeStamp", "DateStamp", "AlarmDate",
                           "Cabinet", "Drawer","File", "Todo", "Priority",
                           "Link"};
/* In order to make things easier, I define CheckBox & RadioButton as
   char and use STRING_FIELD. */

/* Declare the variables for the data in the DATABASE:
   =================================================== */
char  DateStamp[10]     = "";
char  TimeStamp[12]     = "";
char  AlarmDate[10]     = "";
char  Index[7]          = "";
char  Cabinet[21]       = "";
char  Drawer[21]        = "";
char  File[21]          = "";
char  Todo[2]           = ""; /* CheckBox- should be WORD, but this easier.*/
char  Priority[2]       = ""; /* RadioButton- same as above. */
char  Link[128]         = "";

/* For the temp values in Add New Record: */ 
char  NewDateStamp[10]  = "";
char  NewTimeStamp[12]  = "";
char  NewAlarmDate[10]  = "";
char  NewIndex[7]       = "";
char  NewCabinet[21]    = "";
char  NewDrawer[21]     = "";
char  NewFile[21]       = "";
char  NewTodo[2]        = ""; /* CheckBox */
char  NewPriority[2]    = "A"; /* RadioButton */
char  NewLink[128]      = "";

/* For New/Open File Dialog Window: */
char     WildCard[]         = "*.IDB";
char     FileSpec[64]       = "";      /* Buffer for the path */
char     Directory[64]      = "";      /* Buffer for the directory */
char     TempDirectory[64]  = "";      /* Keep the Dir name if cancel. */ 
#define  FILECOUNT   128
#define  FILELENGTH   13
char     *FileList[FILECOUNT];
char     FileSpace[FILECOUNT][FILELENGTH];
#define  DIRCOUNT     64
#define  DIRLENGTH    13
char     *DirList[DIRCOUNT];
char     DirSpace[DIRCOUNT][DIRLENGTH];
char     db_filename[128];


/* The messages for the program: */
char far *msgnull         = "";
char far *msgAppName      = "DBTest";
char far *msgTitle        = " DBTest";
char far *msgHelpKey      = "Help";
char far *msgF2Key        = "Add";
char far *msgF3Key        = "Del";
char far *msgF4Key        = "Copy";
char far *msgF6Key        = "Prev";
char far *msgF7Key        = "Next";
char far *msgF10Key       = "Quit";
char far *msgFile         = "&File";
char far *msgExit         = "E&xit";
char far *msgQuit         = "&Quit";
char far *msgHelp         = "&Help";
char far *msgAbout        = "&About DBTest";
char far *msgOK           = "OK";
char far *msgCancel       = "Cancel";
char far *msgHelpHeader   = "";
char far *msgHelpNote     = "";
char far *msgError1       = "Error";
char far *msgEdit         = "&Edit";
char far *msgAdd          = "&Add New Record   F2";
char far *msgDel          = "&Delete Record    F3";
char far *msgIndex        = "&Index";
char far *msgDateStamp    = "D&ate";
char far *msgTimeStamp    = "&Time";
char far *msgCabinet      = "&Cabinet";
char far *msgDrawer       = "&Drawer";
char far *msgAlarmDate    = "&Remind";
char far *msgToDo         = "T&odo";
char far *msgPriority1    = "&Priority";
char far *msgPriority2    = "&High";
char far *msgPriority3    = "&Medium";
char far *msgPriority4    = "&Low";
char far *msgLink         = "Li&nk";
char far *msgNew          = "&New";
char far *msgOpen         = "&Open";
char far *msgDelDlg1      = "Delete";
char far *msgDelDlg2      = "Delete Current Record?";
char far *msgOWrite1      = "File Already Exsist";
char far *msgOWrite2      = "Replace Exsisting File?";
char far *msgFileOpenDlg0 = "";
char far *msgFileOpenDlg1 = "";
char far *msgFileOpenDlg2 = "";
char far *msgFileOpenDlg3 = "";
char far *msgFileOpenDlg4 = "";
char far *msgPwd1         = "Pass&word";
/*char far *msgPassword1    = "File Is Password Protected";
char far *msgPassword2    = "File Password       ";*/
char far *msgPassword1    = "";
char far *msgPassword2    = "";

UINT PwdFlag = 0; /* So we can use one DialogBox for all Password operations.*/

BOOL Done;
BOOL AddWriteRecord;
BOOL NewOrOpen;
BOOL OWFlag;


/* FUNCTIONS In This Program
  =========================== */
void far SendOK(void);               /* Is sending a CMD_DONE to FileOpenDlgHandler*/
void far DoQuit(void);               /* Quit the program. */
void far DoAbout(void);              /* Run the About screen. */
void far DoHelp1(void);              /* Run main help screen. */
void far DisplayError(int dberror);  /* If any Error- Display Meesage. */
void far DefaultCfg(void);           /* Default valuse for DBTEST.ENV */
void far ReadCfg(void);              /* Read the configuration file */
void far WriteCfg(void);             /* Write the configuration file */
void far DTMToAscii(UCHAR *String, DTM *DTMStructure, int Format);
void far GetTimeDate(void);          /* Get System Time & Date. */
void far DoCLoseDB(void);            /* CLose a Database File. */
void far DoNext(void);               /* Go to next data record. */
void far DoPrev(void);               /* Go to previous data record */
void far DoDel(void);                /* Confirm delete dialog box. */
void far DoCopy(void);               /* Copy Current Record. */
void far DoUpdate(void);             /* Update the records on screen. */
void far DoEmptyFields(void);        /* Empty the displayed fields. */
void far DoNewFile(void);            /* Create a New DB File. */
void far DoOpenFIle(void);           /* Open an exsisting DB File. */
BOOL far DoCheckEdit(void);          /* Check if a record was edited. */
BOOL far DoFileExist(void);          /* Check if a DB File already exist. */
void far DoAdd(void);                /* Add a New Record. */
void far DoWrite(void);              /* Write a Record (save changes). */
int  far Create_DB(void);            /* Create a Database file. */
int  far DB_open_and_setvpt(void);   /* Open DATABASE */
int  far DB_read_record(int RecNo);  /* Read a DATABASE Record */
int  far DB_AddWrite(void);          /* Add data Record */
int  far DB_DelRecord(void);         /* Delete current Record. */
void far DoCount(void);              /* Count & display how many records */
int  far DoNewPassword(void);        /* Handle a Password. */
void far DoPwdOpen(void);            /* Open a Database File with password. */

/* HANDLERS In This Program
  =========================== */
int far MainHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...);
int far HelpHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...);
int far ErrorHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...);
int far DelConfirmHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...);
int far DialogHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...);
int far NewRecordHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...);
int far OverWriteHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...);
int far FileOpenDlgHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...);
int far PasswordHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...);

char far **StringTable[]=
{
&msgnull, &msgAppName, &msgTitle, &msgHelpKey, &msgF2Key, &msgF3Key, &msgF4Key,
&msgF6Key, &msgF7Key, &msgF10Key, &msgFile,  &msgExit, &msgQuit, &msgHelp, 
&msgAbout, &msgOK, &msgCancel, &msgHelpHeader,  &msgHelpNote, &msgError1,
&msgEdit, &msgAdd, &msgDel, &msgIndex, &msgDateStamp, &msgTimeStamp, 
&msgCabinet, &msgDrawer, &msgAlarmDate, &msgToDo, &msgPriority1, &msgPriority2,
&msgPriority3, &msgPriority4, &msgLink, &msgNew, &msgOpen, &msgDelDlg1,
&msgDelDlg2, &msgOWrite1, &msgOWrite2, &msgFileOpenDlg0, &msgFileOpenDlg1,
&msgFileOpenDlg2, &msgFileOpenDlg3, &msgFileOpenDlg4, &msgPwd1, &msgPassword1,
&msgPassword2
}; /* Don't forget to add the msgs in above string! */


/* Events
  =========================== */
LHAPIBLOCK  LHAPIData;
EVENT       app_event;



/* =========================================================================

   ======================================
   Define Main Title Bar
   ====================================== */
LHWINDOW TDateTime = {
    DateTime,0,0,0,0,
    0,0,0,STYLE_DATETIME|STYLE_NOFOCUS,
    NULL,NO_FKEYS,PARENT_MENU,NO_HELP
};

LHWINDOW MainTitle = {
    TitleBar,0,0,0,0,
    (PLHRES)&msgTitle,0,0,STYLE_NOFOCUS,
    NULL,NO_FKEYS,(PLHMENU)&TDateTime,NO_HELP
};


/* ======================================
   Define Main Window, Menu & F-Keys
   ====================================== */
/* This is how the Main Dialog looks like: */
LHWINDOW MainArray[] = {
{StaticText,20, 21, 10, 1,
 (PLHRES)&msgnull, CountResult, 8, STYLE_WHCHAR|STYLE_NOBORDER,
 NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP},
{Edit    , 120, 18,  7, 1,
 (PLHRES)&msgIndex, (PLHDATA)&Index, 7, STYLE_WHCHAR,
  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP},
{TimeEdit, 270, 18, 12, 1,
 (PLHRES)&msgTimeStamp, (PLHDATA)&TimeStamp, 12, STYLE_WHCHAR,
  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP},
{DateEdit, 460, 18, 10, 1,
 (PLHRES)&msgDateStamp, (PLHDATA)&DateStamp, 10, STYLE_WHCHAR,
  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP},
{Edit    ,  20, 37, 21, 1,
 (PLHRES)&msgCabinet, (PLHDATA)&Cabinet, 21, STYLE_WHCHAR,
  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP},
{Edit    ,  30, 55, 21, 1,
 (PLHRES)&msgDrawer, (PLHDATA)&Drawer, 21, STYLE_WHCHAR,
  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP},
{Edit    ,  50, 73, 21, 1,
 (PLHRES)&msgFile, (PLHDATA)&File, 21, STYLE_WHCHAR,
  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP},
{CheckBox, 360, 38, 10, 1,
 (PLHRES)&msgToDo, (PLHDATA)&Todo, 65, STYLE_WHCHAR,
  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP},
{DateEdit, 440, 37, 10, 1,
 (PLHRES)&msgAlarmDate, (PLHDATA)&AlarmDate, 10, STYLE_WHCHAR,
  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP},
{GroupBox, 360, 55, 254, 33,
 (PLHRES)&msgPriority1, NULL, NULL, STYLE_NOFOCUS,
 NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP},
{RadioButton, 370,  69, 1, 1,
 (PLHRES)&msgPriority2, (PLHDATA)&Priority, 65, STYLE_WHCHAR,
 MainArray+9, PARENT_FKEYS, PARENT_MENU, NO_HELP},
{RadioButton, 450,  69, 1, 1,
 (PLHRES)&msgPriority3, (PLHDATA)&Priority, 66, STYLE_WHCHAR,
 MainArray+9, PARENT_FKEYS, PARENT_MENU, NO_HELP},
{RadioButton, 550,  69, 1, 1,
 (PLHRES)&msgPriority4, (PLHDATA)&Priority, 67, STYLE_WHCHAR,
 MainArray+9, PARENT_FKEYS, PARENT_MENU, NO_HELP},
{Edit, 50, 91,  51, 1,
 (PLHRES)&msgLink, (PLHDATA)&Link, 128, STYLE_WHCHAR,
  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP}
};


LHFKEY MainFKeys[]= {
  {(PLHRES)&msgHelpKey  ,(PLHFUNC)DoHelp1,1,0},
  {(PLHRES)&msgF2Key    ,(PLHFUNC)DoAdd  ,2,0},
  {(PLHRES)&msgF3Key    ,(PLHFUNC)DoDel  ,3,0},
  {(PLHRES)&msgF4Key    ,(PLHFUNC)DoCopy ,4,0},
  {(PLHRES)&msgF6Key    ,(PLHFUNC)DoPrev ,6,0},
  {(PLHRES)&msgF7Key    ,(PLHFUNC)DoNext ,7,0},
  {(PLHRES)&msgF10Key   ,(PLHFUNC)DoQuit ,10+FKEY_LAST,0}
};

LHMENU FileMenu[] = {
  { (PLHRES)&msgNew , (PLHFUNC)DoNewFile    , 0, MENU_ELLIPSIS },
  { (PLHRES)&msgOpen, (PLHFUNC)DoOpenFIle   , 0, MENU_ELLIPSIS },
  { (PLHRES)&msgPwd1, (PLHFUNC)DoNewPassword, 0, MENU_ELLIPSIS|MENU_BARBEFORE },
  { (PLHRES)&msgExit, (PLHFUNC)DoQuit       , 0, MENU_BARBEFORE},
  { 0, 0, 0, 0}
};

LHMENU EditMenu[] = {
  { (PLHRES)&msgAdd,(PLHFUNC)DoAdd, 0, 0 },
  { (PLHRES)&msgDel,(PLHFUNC)DoDel, 0, 0 },
  { 0, 0, 0, 0}
};

LHMENU HelpMenu[] = {
  { (PLHRES)&msgHelp , (PLHFUNC)DoHelp1, 0, MENU_ELLIPSIS},
  { (PLHRES)&msgAbout, (PLHFUNC)DoAbout, 0, MENU_BARBEFORE|MENU_ELLIPSIS},
  { 0, 0, 0, 0}
};

LHMENU TopMenu[] = {
  { (PLHRES)&msgFile      , (PLHFUNC)FileMenu   , 0, MENU_PULLDOWN },
  { (PLHRES)&msgEdit      , (PLHFUNC)EditMenu   , 0, MENU_PULLDOWN },
  { (PLHRES)&msgQuit      , (PLHFUNC)DoQuit     , 0, 0 },
  { (PLHRES)&msgHelp      , (PLHFUNC)HelpMenu   , 0, MENU_PULLDOWN },
  { 0, 0, 0, 0}
};

LHWINDOW MainView={
              (PLHCLASS)MainHandler,0,0,640,190,
              (PLHRES)&msgnull,NULL,0, 0,
               NULL,MainFKeys,TopMenu,NO_HELP
};

/* The Main Dialog which we will call in the beginning of the program: */
LHWINDOW MainDlg = {
    (PLHCLASS)DialogHandler, 7, 12, 630, 175,
    (PLHRES)&msgnull, (PLHDATA)MainArray, countof(MainArray),
    NULL, NULL, MainFKeys,TopMenu, NO_HELP
};

int far MainHandler(PLHWINDOW Wnd, WORD Message, WORD Data, WORD Extra,...) 
{
 switch (Message) 
        {
         case KEYSTROKE:
              break; 
         case DRAW:
              if (Data&DRAW_FRAME)
                  ClearRect(Wnd->x,Wnd->y,Wnd->w,Wnd->h);
              break;
        }

/* Emergency Solution, but works fine! */
/* if(!(HelpDialog.Status&STATUS_VISIBLE) && !(LHAPIData.TopMenuWnd.Status&STATUS_VISIBLE)) */

 return SubclassMsg(Object, Wnd, Message, Data, Extra);
}


int far DialogHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...)
{
switch (Message) {
   case KEYSTROKE:
        break;
   case COMMAND:
      switch(Data) 
       {
        case CMD_ESC:
             SendMsg(MainArray, SETFOCUS, SETFOCUS_NORMAL, 0);
             return TRUE;
       }
   case NOTIFY:
        break;        
      }
 /* Update the screen here */

return SubclassMsg(DialogBox, Window, Message, Data, Extra);
}


/* ======================================
   Define Help Window, Menu & F-Keys
   ====================================== */
char far **HelpMsgArray[] = 
{
 &msgHelpNote
};

LHWINDOW HelpArray[] = 
{
 {MessageBox, 10, 17, 580, 145,
  NULL, (PLHDATA)&HelpMsgArray, countof(HelpMsgArray),
  STYLE_NOBORDER|STYLE_NOFOCUS|STYLE_XYRELATIVE,
  NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};  

LHFKEY OKFKeys[]= 
{
 {(PLHRES)&msgOK,(PLHFUNC)CMD_DONE,10+FKEY_LAST,FKEY_SENDMSG}
};

LHWINDOW HelpDialog = 
{
 (PLHCLASS)HelpHandler, XY_CENTER(600,170), 
 (PLHRES)&msgHelpHeader, (PLHDATA)&HelpArray, countof(HelpArray),
  STYLE_SAVEUNDER, NULL, OKFKeys, NO_MENU, NO_HELP
};

int far HelpHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
if(Msg == COMMAND && ( Data == CMD_DONE || Data == CMD_ESC )) 
  {
   Msg =COMMAND;
   Data=CMD_ESC;
  }
 return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}


/* ======================================
   Define Error Window & F-Keys
   ====================================== */
LHFKEY ErrorFKeys[]= 
{
 {(PLHRES)&msgOK, (PLHFUNC)CMD_DONE,10+FKEY_LAST, FKEY_SENDMSG}
};

LHWINDOW ErrorArray[]=
{ 
 {StaticText, 15, 30, 47, 1,NULL,NULL,47,
  STYLE_NOBORDER|STYLE_WHCHAR|STYLE_XYRELATIVE|TEXT_CENTER,
  NULL,PARENT_FKEYS,NO_MENU,NO_HELP},
 {PushButton, 299, 110, 50, 20,
  (PLHRES)&msgOK,(PLHDATA)CMD_DONE, ENTERKEY, PUSHB_SENDMSG|STYLE_PUSHBUTTON,
   0,0,0,NO_HELP},
};

LHWINDOW ErrorDlg=
{
 (PLHCLASS)ErrorHandler, XY_CENTER(520,100),
 (PLHRES)&msgError1,(PLHDATA)ErrorArray, countof(ErrorArray), 
  STYLE_PUSHB_WIDTH, NULL, ErrorFKeys, NO_MENU, NO_HELP
};

int far ErrorHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...)
{
 if(Message == COMMAND && (Data == CMD_DONE || Data == CMD_ESC )) 
   {
    if(Data == CMD_DONE)
      {
       SendMsg(&ErrorDlg, DESTROY, DESTROY_NORMAL, 0 );       
       return TRUE;
      }
   }
 return SubclassMsg(DialogBox, Window, Message, Data, Extra );
}

/* ======================================
   Define Delete Confirm Window & F-Keys
   ====================================== */
LHFKEY DelConfirmFKeys[]= 
{
 {(PLHRES)&msgCancel, (PLHFUNC)CMD_ESC , 9          , FKEY_SENDMSG},
 {(PLHRES)&msgOK    , (PLHFUNC)CMD_DONE,10+FKEY_LAST, FKEY_SENDMSG}
};

LHWINDOW DelDlgArray[]=
{
 {StaticText, 208, 75, 1, 1,(PLHRES)&msgDelDlg2,NULL,10,
 STYLE_NOBORDER|STYLE_WHCHAR,NULL,PARENT_FKEYS,NO_MENU,NO_HELP},
 {PushButton,232,105,50,20,
  (PLHRES)&msgOK,(PLHDATA)CMD_DONE, ENTERKEY, PUSHB_SENDMSG|STYLE_PUSHBUTTON,
   0,0,0,NO_HELP},
 {PushButton,337,105,80,20,
  (PLHRES)&msgCancel,(PLHDATA)CMD_ESC, ESCKEY, PUSHB_SENDMSG|STYLE_PUSHBUTTON,
   0,0,0,NO_HELP}
};

LHWINDOW DelConfirmDlg=
{
 (PLHCLASS)DelConfirmHandler, XY_CENTER(353,97),
 (PLHRES)&msgDelDlg1,(PLHDATA)DelDlgArray, countof(DelDlgArray), 
  STYLE_PUSHB_WIDTH, NULL, DelConfirmFKeys, NO_MENU, NO_HELP
};

int far DelConfirmHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...)
{
 if(Message == COMMAND && (Data == CMD_DONE || Data == CMD_ESC )) 
   {
    if(Data == CMD_DONE)
      {
       SendMsg(&DelConfirmDlg, DESTROY, DESTROY_NORMAL, 0 );       
       DB_DelRecord();
       return TRUE;
      }
   }
 return SubclassMsg(DialogBox, Window, Message, Data, Extra );
}


/* ======================================
   Define add New Record  Window
   ====================================== */
/* This was maybe not the most good looking method, but it's not bad
   for being  5:13 in the morning! :)

   The F Keys are the same as for Delete Confirm Window, but for
   easier understanding, we put in it here: */

LHFKEY NewRecordFKeys[]= 
{
 {(PLHRES)&msgCancel, (PLHFUNC)CMD_ESC , 9          , FKEY_SENDMSG},
 {(PLHRES)&msgOK    , (PLHFUNC)CMD_DONE,10+FKEY_LAST, FKEY_SENDMSG}
};

/* Use the same setup as for the MainDlg, but remove the display of
   x/y record: */
LHWINDOW NewRecordArray[] = {
{Edit    , 120, 18,  7, 1,
 (PLHRES)&msgIndex, (PLHDATA)&NewIndex, 7, STYLE_WHCHAR,
  NULL, PARENT_FKEYS, NO_MENU, NO_HELP},
{TimeEdit, 270, 18, 12, 1,
 (PLHRES)&msgTimeStamp, (PLHDATA)&NewTimeStamp, 12, STYLE_WHCHAR,
  NULL, PARENT_FKEYS, NO_MENU, NO_HELP},
{DateEdit, 460, 18, 10, 1,
 (PLHRES)&msgDateStamp, (PLHDATA)&NewDateStamp, 10, STYLE_WHCHAR,
  NULL, PARENT_FKEYS, NO_MENU, NO_HELP},
{Edit    ,  20, 37, 21, 1,
 (PLHRES)&msgCabinet, (PLHDATA)&NewCabinet, 21, STYLE_WHCHAR,
  NULL, PARENT_FKEYS, NO_MENU, NO_HELP},
{Edit    ,  30, 55, 21, 1,
 (PLHRES)&msgDrawer, (PLHDATA)&NewDrawer, 21, STYLE_WHCHAR,
  NULL, PARENT_FKEYS, NO_MENU, NO_HELP},
{Edit    ,  50, 73, 21, 1,
 (PLHRES)&msgFile, (PLHDATA)&NewFile, 21, STYLE_WHCHAR,
  NULL, PARENT_FKEYS, NO_MENU, NO_HELP},
{CheckBox, 360, 38, 10, 1,
 (PLHRES)&msgToDo, (PLHDATA)&NewTodo, 65, STYLE_WHCHAR,
  NULL, PARENT_FKEYS, NO_MENU, NO_HELP},
{DateEdit, 440, 37, 10, 1,
 (PLHRES)&msgAlarmDate, (PLHDATA)&NewAlarmDate, 10, STYLE_WHCHAR,
  NULL, PARENT_FKEYS, NO_MENU, NO_HELP},
{GroupBox, 360, 55, 254, 33,
 (PLHRES)&msgPriority1, NULL, NULL, STYLE_NOFOCUS,
 NULL, PARENT_FKEYS, NO_MENU, NO_HELP    },
{RadioButton, 370,  69, 1, 1,
 (PLHRES)&msgPriority2, (PLHDATA)&NewPriority, 65, STYLE_WHCHAR,
 NewRecordArray+8, PARENT_FKEYS, NO_MENU, NO_HELP},
{RadioButton, 450,  69, 1, 1,
 (PLHRES)&msgPriority3, (PLHDATA)&NewPriority, 66, STYLE_WHCHAR,
 NewRecordArray+8, PARENT_FKEYS, NO_MENU, NO_HELP},
{RadioButton, 550,  69, 1, 1,
 (PLHRES)&msgPriority4, (PLHDATA)&NewPriority, 67, STYLE_WHCHAR,
 NewRecordArray+8, PARENT_FKEYS, NO_MENU, NO_HELP},
{Edit, 50, 91,  51, 1,
 (PLHRES)&msgLink, (PLHDATA)&NewLink, 128, STYLE_WHCHAR,
  NULL, PARENT_FKEYS, NO_MENU, NO_HELP}
};

LHWINDOW NewRecordDlg = {
    (PLHCLASS)NewRecordHandler, 7, 12, 630, 175,
    (PLHRES)&msgnull, (PLHDATA)NewRecordArray, countof(NewRecordArray),
     NULL, NULL, NewRecordFKeys,NO_MENU, NO_HELP
};

int far NewRecordHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...)
{
 if(Message == COMMAND && (Data == CMD_DONE || Data == CMD_ESC )) 
   {
    if(Data == CMD_DONE)
      {
       /* Copy over the fields which are new to the actual field names. */
       strcpy(DateStamp, NewDateStamp);
       strcpy(TimeStamp, NewTimeStamp);
       strcpy(AlarmDate, NewAlarmDate);
       strcpy(Index    , NewIndex);
       strcpy(Cabinet  , NewCabinet);
       strcpy(Drawer   , NewDrawer);
       strcpy(File     , NewFile);
       strcpy(Todo     , NewTodo);
       strcpy(Priority , NewPriority);
       strcpy(Link     , NewLink);

       AddWriteRecord = TRUE; /* Set to TRUE since we want to ADD a record. */
       DB_AddWrite();     /* Add the record */
       RecNo = NewRecNo;  /* and back, we will get the added record number. */
       if(RecNo > dblk.viewptcount - 1) /* However, if we have many "holes" */
          RecNo = dblk.viewptcount - 1; /* in the data file, things can go */
       DB_read_record(RecNo);           /* wrong. Now, read the new record. */
       SendMsg(&NewRecordDlg, DESTROY, DESTROY_NORMAL, 0 ); /* Close Window */
       DoUpdate(); /* Update the screen. */
 
       /* Set the New Record fields to be empty. */
       *NewDateStamp = '';
       *NewTimeStamp = '';
       *NewAlarmDate = '';
       *NewIndex     = '';
       *NewCabinet   = '';
       *NewDrawer    = '';
       *NewFile      = '';
       *NewTodo      = '';
       *NewPriority  = 'A';
       *NewLink      = '';

       return TRUE;
      }
   }
return SubclassMsg(DialogBox, Window, Message, Data, Extra);
}


/* ======================================
   Define Overwrite Confirm Window & F-Keys
   ====================================== */
LHFKEY OverWriteFKeys[]= 
{
 {(PLHRES)&msgCancel, (PLHFUNC)CMD_ESC , 9          , FKEY_SENDMSG},
 {(PLHRES)&msgOK    , (PLHFUNC)CMD_DONE,10+FKEY_LAST, FKEY_SENDMSG}
};

LHWINDOW OverWriteArray[]=
{
 {StaticText, 184, 75, 1, 1,(PLHRES)&msgOWrite2,NULL,10,
 STYLE_NOBORDER|STYLE_WHCHAR,NULL,PARENT_FKEYS,NO_MENU,NO_HELP},
 {PushButton,210,105,50,20,
  (PLHRES)&msgOK,(PLHDATA)CMD_DONE, ENTERKEY, PUSHB_SENDMSG|STYLE_PUSHBUTTON,
   0,0,0,NO_HELP},
 {PushButton,316,105,80,20,
  (PLHRES)&msgCancel,(PLHDATA)CMD_ESC, ESCKEY, PUSHB_SENDMSG|STYLE_PUSHBUTTON,
   0,0,0,NO_HELP}
};

LHWINDOW OverWriteDlg=
{
 (PLHCLASS)OverWriteHandler, 136,51,353,97,
 (PLHRES)&msgOWrite1,(PLHDATA)OverWriteArray, countof(OverWriteArray), 
  STYLE_PUSHB_WIDTH, NULL, OverWriteFKeys, NO_MENU, NO_HELP
};

int far OverWriteHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...)
{
 if(Message == COMMAND && (Data == CMD_DONE || Data == CMD_ESC )) 
   {
    if(Data == CMD_DONE)
      {
       OWFlag = FALSE; /* So this dialog only appears when it should */
       SendMsg(&OverWriteDlg, DESTROY, DESTROY_NORMAL, 0 );
       SendOK(); /* Send a OK message to the New File Dialog */
       return TRUE;
      }
   }
 return SubclassMsg(DialogBox, Window, Message, Data, Extra );
}


/* ======================================
   Define New/Open File Dialog  Window
   ====================================== */
   /* Use this Dialog for both New and Open file.

   The F Keys are the same as for Delete Confirm and New Record 
   Window, but for easier understanding, we put in it here also: */

LHFKEY NewFileFKeys[]= 
{
 {(PLHRES)&msgCancel, (PLHFUNC)CMD_ESC , 9          , FKEY_SENDMSG},
 {(PLHRES)&msgOK    , (PLHFUNC)CMD_DONE,10+FKEY_LAST, FKEY_SENDMSG}
};

LHWINDOW FileOpenDlgArray[]=
{
 {Edit,49,33,27,1,
  (PLHRES)&msgFileOpenDlg1, (PLHDATA)&FileSpec, countof(FileSpec), 
  0|STYLE_WHCHAR|EDIT_INSERT,NULL,PARENT_FKEYS, (PLHMENU)&WildCard, NO_HELP},
 {PathText,49,55,31,1,
  (PLHRES)&msgFileOpenDlg2, (PLHDATA)&Directory, countof(Directory),
  STYLE_NOBORDER|STYLE_WHCHAR,NULL,PARENT_FKEYS,NO_MENU,NO_HELP},
 {FileListBox,49,74,17,7,
  (PLHRES)&msgFileOpenDlg3, (PLHDATA)&FileList, countof(FileList),
  0|STYLE_WHCHAR,NULL,PARENT_FKEYS,(PLHMENU)countof(FileList),NO_HELP},
 {DirListBox,272,74,17,7,
  (PLHRES)&msgFileOpenDlg4, (PLHDATA)&DirList, countof(DirList),
  0|STYLE_WHCHAR,NULL,PARENT_FKEYS,(PLHMENU)countof(DirList),NO_HELP},
 {PushButton,497,37,80,20,
  (PLHRES)&msgOK, (PLHDATA)CMD_DONE,ENTERKEY,
  1|PUSHB_SENDMSG|STYLE_PUSHBUTTON,0,0,0,NO_HELP},
 {PushButton,497,77,80,20,
  (PLHRES)&msgCancel, (PLHDATA)CMD_ESC,0,
  0|PUSHB_SENDMSG|STYLE_PUSHBUTTON,0,0,0,NO_HELP}
};

LHWINDOW FileOpenDlgBox=
{
 (PLHCLASS)FileOpenDlgHandler, 35, 16, 569, 165,
 (PLHRES)&msgFileOpenDlg0, (PLHDATA)FileOpenDlgArray, countof(FileOpenDlgArray),
 FILEOPEN_NODEFAULT, NULL, NewFileFKeys, NO_MENU, NO_HELP
};

int far FileOpenDlgHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...)
{
 if(Message == COMMAND && (Data == CMD_DONE || Data == CMD_ESC ))
   {
    if(Data == CMD_DONE)
      {
       /* Create the full path & file name- easier to open File: */
       strcpy(db_filename, Directory);
       if(strlen(db_filename) > 3)
          strcat(db_filename, "\\");
       strcat(db_filename, FileSpec);

       strcpy(Pwd, ""); /* Password should be empty. */
       PwdFlag = 0;

       if(NewOrOpen == TRUE) /* Then Create a New DB File. */
         { 
          if((DoFileExist() == TRUE) && (OWFlag== TRUE))
            {
             SendMsg(&OverWriteDlg, CREATE, CREATE_FOCUS, 0 );
             return TRUE;
            }

          /* If any field in current record is changed, save it first: */
          if(DoCheckEdit() == TRUE)
             DoWrite();
          DoEmptyFields(); /* Empty the fields. */
          DoCLoseDB();     /* Close an open DB file- if we have it and*/
                           /* don't care if error or not. */
          Create_DB();     /* Create the new DB File. */
          RecNo = 0;  /* When no records, display '1/0'. */
          DoCount();  /* Update the 'x/y' record display- now '1/0'. */
         }
      else /* Or just Open a new DB FIle. */
        {
         /* If any field in current record is changed, save it first: */
         if(DoCheckEdit() == TRUE)
            DoWrite();
         DoCLoseDB();/* Close an open DB file- if we have it. Don't
                        care if error or not. */
         DoEmptyFields(); /* Empty the fields. */
         DB_open_and_setvpt(); /* Ok, open the new file now. */
         RecNo = 0;
         if(dblk.viewptcount != 0)
           {
            DB_read_record(RecNo); /* Go to first record when open a new file. */
            DoUpdate(); /* Update the screen. */
           }
         else return FALSE;
        }

       SendMsg(&FileOpenDlgBox, DESTROY, DESTROY_NORMAL, 0 );
       return TRUE;
      }
  else
      strcpy(Directory, TempDirectory); /* If you Cancel the Open/New dialog */
    }                                   /* go back to last Directory. */
 return SubclassMsg(FileOpenDialogBox, Window, Message, Data, Extra);
}


void far SendOK(void)
{
/* Since I can't send a message from within the OverWriteHandler to the
   FileOpenDlgHandler, I send it from here. Reason is simply because
   I can't refer to FileOpenDlgBox, before it's declared. */

 SendMsg(&FileOpenDlgBox, COMMAND, CMD_DONE, 0 );

 /* Through sending this message, an OK in the OverWrite Dialog Box
    will press the OK button in the File Open Dialog Box. SO with other
    words, I do't need to press Enter 2 times if I want to overwrite
    an exsisting DB FIle. */
}


/* ======================================
   Define Password Dialog  Window
   ====================================== */
LHFKEY PasswordFKeys[]= 
{
 {(PLHRES)&msgCancel, (PLHFUNC)CMD_ESC , 9          , FKEY_SENDMSG},
 {(PLHRES)&msgOK    , (PLHFUNC)CMD_DONE,10+FKEY_LAST, FKEY_SENDMSG}
};

LHWINDOW PasswordDlgArray[]=
{
{(PLHCLASS)PwdEdit,123, 75, 17, 1,
 (PLHRES)&msgPassword2, (PLHDATA)&Pwd, 17, STYLE_WHCHAR,
  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP}, 
 {PushButton,232,105,50,20,
  (PLHRES)&msgOK,(PLHDATA)CMD_DONE, ENTERKEY, PUSHB_SENDMSG|STYLE_PUSHBUTTON,
   0,0,0,NO_HELP},
 {PushButton,337,105,80,20,
  (PLHRES)&msgCancel,(PLHDATA)CMD_ESC, ESCKEY, PUSHB_SENDMSG|STYLE_PUSHBUTTON,
   0,0,0,NO_HELP}
};

LHWINDOW PasswordDlg=
{
 (PLHCLASS)PasswordHandler, XY_CENTER(450,100),
 (PLHRES)&msgPassword1,(PLHDATA)PasswordDlgArray, countof(PasswordDlgArray), 
  STYLE_PUSHB_WIDTH, NULL, PasswordFKeys, NO_MENU, NO_HELP
};

int far PasswordHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...)
{
int i;
 if(Message == COMMAND && (Data == CMD_DONE || Data == CMD_ESC )) 
   {
    if(Data == CMD_DONE)
      {
       switch(PwdFlag) 
             {
              case 1: /* Enter New Password */
              SendMsg(&PasswordDlg, DESTROY, DESTROY_NORMAL, 0 );
              strcpy(TempPwd, Pwd);
              strcpy(Pwd, "");
              msgPassword2 = "Reenter New Password";
              PwdFlag = 3;
              SendMsg(&PasswordDlg, CREATE, CREATE_FOCUS, 0 );
              return TRUE;

              case 2: /* Enter Old Password */
              SendMsg(&PasswordDlg, DESTROY, DESTROY_NORMAL, 0 );
              if(DB_VerifyPassword(&dblk, Pwd) == DB_OK)
                {
                 strcpy(OldPwd, Pwd);
                 strcpy(Pwd, "");
                 msgPassword2 = "Enter New Password  ";
                 PwdFlag = 1;
                 SendMsg(&PasswordDlg, CREATE, CREATE_FOCUS, 0 );
                }
              else
                 DisplayError(PWD_ERROR);
              return TRUE;

              case 3: /* Reenter New Password */
              SendMsg(&PasswordDlg, DESTROY, DESTROY_NORMAL, 0 );
              if(strcmp(TempPwd, Pwd) == 0)
                {
                 HourGlassOn();
                 DBError = DB_ChangePassword(&dblk, OldPwd, Pwd);
                 HourGlassOff();
                 if(DBError < DB_OK) return DBError;
                 PwdFlag = 0;
                }
              else
                 DisplayError(PWD_ERROR);
              return TRUE;

              default: /* File Password */
              SendMsg(&PasswordDlg, DESTROY, DESTROY_NORMAL, 0 );
              DoPwdOpen();
              return TRUE;
             }
      }
    else PwdFlag = 0;
   }
 return SubclassMsg(DialogBox, Window, Message, Data, Extra );
}


/* ======================================
   Standard Stuff...
   ====================================== */

#define GetDataSeg()  _DS

void FixupFarPtrs(void)
{
 int i,dataseg;
 dataseg=GetDataSeg();
 for(i=0; i<countof(StringTable); i++)
    *(((int *)(StringTable[i]))+1) = dataseg;
}


/* ======================================
   Quit the program
   ====================================== */
void far DoQuit(void)
{
    HourGlassOn();
 /* Before we give a go ahead to close down the program, check if any
    records has been edited. If so, save changes. */
 if(DoCheckEdit() == TRUE)
    DoWrite();

 Done = TRUE; /* Ok, let's exit this program! */
}

/* ======================================
   Run the About screen.
   ====================================== */
void far DoAbout(void)
{
 msgHelpHeader = "About DBTest";

/*
|-----------------------------------------------------------|
Text can be from position 1 to 61 and a total of 13 rows. */

msgHelpNote = 
"DBTest V1.0 is a program from THE PALMTOP NETWORK-\n"
"http://www.palmtop.net\n"
"\n"
"DBTest has been written and compiled on the HP 200LX\n"
"Palmtop PC, using Borland Turbo C 2.0 and NKIT EXM devel-\n"
"opment kit. It was done in order to learn DB programming.\n"
"\n"
"This is a small freeware program with source code for you\n"
"that want to start EXM DB programming. Use the source\n"
"code as a start and from there you can create your own\n"
"database applications.\n"
"\n"
"THE PALMTOP NETWORK, April 1999.";

 SendMsg( &HelpDialog, CREATE, CREATE_FOCUS, 0 );
}

/* ======================================
   Run the Main Help screen.
   ====================================== */
void far DoHelp1(void)
{
/* Check if the Menu is active, if so close it. 
   Emergency Solution- should actually stay open */
if(LHAPIData.TopMenuWnd.Status&STATUS_VISIBLE)
   SendMsg(&LHAPIData.TopMenuWnd, DESTROY, 0, 0);

msgHelpHeader = "DBTest Overview";

msgHelpNote = 
"F1 - This help dialog.\n"
"F10- Exit the program.\n"
"\n";

 SendMsg( &HelpDialog, CREATE, CREATE_FOCUS, 0 );
}


/* ======================================
   If any Error- display Error Message.
   ====================================== */
 void far DisplayError(int dberror)
{
 switch(dberror) 
       {
        case DB_OK:
             return;
        case DB_NOTFOUND:
             SET_DISP_MSG("Requested Record Not Found.");
             break;
        case DB_DELETED:
             SET_DISP_MSG("Record is Already Deleted.");
             break;
        case DB_OPEN:
             SET_DISP_MSG("Cannot Open File.");
             break;
        case DB_CLOSE:
             SET_DISP_MSG("Cannot Close File.");
             break;
        case DB_READ:
             SET_DISP_MSG("Cannot Read From File.");
             break;
        case DB_WRITE:
             SET_DISP_MSG("Cannot Write Record (Disk Full?)");
             break;
        case DB_SIGNATURE:
             SET_DISP_MSG("File Is Not A Database File.");
             break;
        case DB_CREATE:
             SET_DISP_MSG("File Cannot Be Created.");
             break;
        case DB_SEEK:
             SET_DISP_MSG("Cannot Seek Within File, File May Be Corrupted.");
             break;
        case DB_SYNTAX:
             SET_DISP_MSG("Syntax Error In Expression.");
             break;
        case DB_OVERFLOW:
             SET_DISP_MSG("Expression Larger Than Allocated Buffer.");
             break;
        case DB_COMPLEX:
             SET_DISP_MSG("Expression Too Complex/Large To Be Parsed.");
             break;
        case DB_TYPEMISMATCH:
             SET_DISP_MSG("FiSL Type Mismatch.");
             break;
        case DB_NOFIELD:
             SET_DISP_MSG("Field Not Found.");
             break;
        case DB_NOCALLBACK:
             SET_DISP_MSG("Field Callback Not Supplied.");
             break;
        case DB_LARGEVIEWPT:
             SET_DISP_MSG("View Point Information Too Large.");
             break;
        case DB_VPABSENT:
             SET_DISP_MSG("Record Vanished From Viewpoint.");
             break;
        case DB_CANTUNDO:
             SET_DISP_MSG("Further Undo Not Possible.");
             break;
        case DB_MEMORY:
             SET_DISP_MSG("Not Enough Memory To Complete Operation.");
             break;
        case DB_PASSWORDFAILED:
             SET_DISP_MSG("The Password Is Invalid.");
             break;
        case DB_MAYBEINUSE:
             SET_DISP_MSG("Database File May Be Already In Use.");
             break;
        case DB_RELEASE:
             SET_DISP_MSG("Database File Of Later Release.");
             break;
        case DB_FILETYPE:
             SET_DISP_MSG("Type Of File Is Different Than Expected.");
             break;
        case DB_ILLEGAL: /* I am guessing here. */
             SET_DISP_MSG("Illegal Operation.");
             break;
        case DB_USERABORT: /* I am guessing here. */
             SET_DISP_MSG("Operation Interrupted By User.");
             break;
        case DB_CORRUPT:
             SET_DISP_MSG("Media Error.");
             break;
        case DB_SORTCHANGE:
             SET_DISP_MSG("Sort Order Changed- Invalid Viewpoints.");
             break;
        case DB_PROTECTED:
             SET_DISP_MSG("File Is On Protected Media.");
             break;
        /* Why not use this for other Error Messages also: */
        case FATAL_ERROR:
             SET_DISP_MSG("Fatal Error! Please Restart Application");
             break;
        case PWD_ERROR:
             SET_DISP_MSG("Password Entered Incorrectly");
             PwdFlag = 0;
             break;
        default:
             SET_DISP_MSG("* ERROR UNKNOWN *");
             break;
  }
 m_beep();
 SendMsg(&ErrorDlg, CREATE, CREATE_FOCUS, 0 );
 DBError = DB_OK; /* Reset the Error. */
}


/* ======================================
   Default values values for DBTEST.ENV
   file when it's created first time.
   ====================================== */
void far DefaultCfg(void)
{
 *Directory   = ''; /* The last Directory when Open/Create DB File. */
 *db_filename = ''; /* The last used File Name. */
 RecNo        =  0; /* The Record Number which was viewed last time. */
 WriteCfg();
}


/* ======================================
   Read the configuration file
   ====================================== */
void far ReadCfg(void)
{
 int len;
 NBFILE infile;

 /* Read the DBTEST.ENV file */
 m_lock(); /* Prevent interruptions while reading the file. */
 if (!m_openro(&infile,  CFGFILE, CFGFILELEN,0,1)) 
    {
     m_read(&infile, &Directory  , sizeof(Directory)  , &len);
     m_read(&infile, &db_filename, sizeof(db_filename), &len);
     m_read(&infile, &RecNo      , sizeof(RecNo)      , &len);

     m_close(&infile); 
    }
  else 
     DefaultCfg();
 m_unlock(); /* Ok, done- unlock the file. */
}


/* ======================================
   Write the configuration file
   ====================================== */
void far WriteCfg(void)
{
 NBFILE outfile;

/* Write the DBTEST.ENV file */
 m_lock(); /* Prevent interruptions while reading the file. */
 if (!m_fcreat(&outfile, CFGFILE, CFGFILELEN, 0, 1)) 
    {
      m_write(&outfile, &Directory  , sizeof(Directory));
      m_write(&outfile, &db_filename, sizeof(db_filename));
      m_write(&outfile, &RecNo      , sizeof(RecNo));
      
      m_close(&outfile); 
    }
 m_unlock(); /* Ok, done- unlock the file. */
}


/* ======================================
   Convert Time & Date To ASCII.
   ====================================== */
void far DTMToAscii(UCHAR *String, DTM *DTMStructure, int Format)
{
 UCHAR far *FormattedString;

 if(DTMStructure->dt_year == -1)
    {
     String[0] = 0;
    }
 else
    {
     FormattedString = m_tell_anytime(Format, 0, 0, NULL, DTMStructure);
     lstrcpy(String, FormattedString);
    }
}


/* ======================================
   Get System Time & Date for the time
   and date stamp.
   ====================================== */
void far GetTimeDate(void)
{
 DTM HPdtm;

 m_getdtm((DTM far*)&HPdtm); /* Get System Time/Date. */

 /* Convert the System Time and Date to ASCII format so we can
    display the results in our fields: */
 DTMToAscii(NewTimeStamp, &HPdtm, TIME_ONLY);
 DTMToAscii(NewDateStamp, &HPdtm, DATE_ONLY);
 /* DTMToAscii(NewAlarmDate, &HPdtm, DATE_ONLY); */
 strcpy(NewAlarmDate, NewDateStamp); /* Easier & Faster... */
}


/* ======================================
   Close a Database File.
   ====================================== */
void far DoCLoseDB(void)
{
/* When closing a big Database File, it can take some time.
   Better to do like this then and also since it seams like
   a call for "HourGlassOn();" within a Handler, will hang
   the palmtop. */
 HourGlassOn();
 DB_Close(&dblk);
 HourGlassOff();
}


/* ======================================
   Go to the Next record in the DATABASE
   ====================================== */
void far DoNext(void)
{
 if(DoCheckEdit() == TRUE) /* If any record is changed, save it before */
    DoWrite();             /* we proceed to next record. */

 RecNo = RecNo + 1;

 /* Last record reached, beep and stay there! */
 if(RecNo >  dblk.viewptcount - 1) 
   {
    RecNo = dblk.viewptcount -1;   
    if(dblk.viewptcount -1 < 1) /* In case we just have created a New DB File */
       RecNo = 0;              /* make sure RecNo is set to 0. */
    m_beep();
   }

 if(dblk.viewptcount != 0) /* If no records in File, no point to try to read.*/
    DB_read_record(RecNo);
 DoUpdate(); /* Update the screen. */
}

/* ======================================
   Go to the Previous record in the DATABASE
   ====================================== */
void far DoPrev(void)
{
 if(DoCheckEdit() == TRUE) /* If any record is changed, save it before */
    DoWrite();             /* we proceed to previous record. */

 RecNo = RecNo -1;

 /* If previous record is the first record, beep and stay there.*/
 if(RecNo < 0) 
   {
    RecNo = 0;
    m_beep();
   }

 if(dblk.viewptcount != 0) /* If no records in File, no point to try to read.*/
    DB_read_record(RecNo);
 DoUpdate(); /* Update the screen. */
}


/* ======================================
   Update screen display of the records
   ====================================== */
void far DoUpdate(void)
{
 if(dblk.viewptcount < 1) /* The total number of records: */
    DoEmptyFields(); 

 /* Udate All fields on the screen after a new record is read: */
 SendMsg(MainArray  , DRAW, DRAW_CLIENT, 0);
 SendMsg(MainArray+1, DRAW, DRAW_CLIENT, 0);
 SendMsg(MainArray+2, DRAW, DRAW_CLIENT, 0);
 SendMsg(MainArray+3, DRAW, DRAW_CLIENT, 0);
 SendMsg(MainArray+4, DRAW, DRAW_CLIENT, 0);
 SendMsg(MainArray+5, DRAW, DRAW_CLIENT, 0);
 SendMsg(MainArray+6, DRAW, DRAW_CLIENT, 0);
 SendMsg(MainArray+7, DRAW, DRAW_CLIENT, 0);
 SendMsg(MainArray+8, DRAW, DRAW_CLIENT, 0);
/* SendMsg(MainArray+9, DRAW, DRAW_CLIENT, 0); GroupBox */
 SendMsg(MainArray+10, DRAW, DRAW_CLIENT, 0);
 SendMsg(MainArray+11, DRAW, DRAW_CLIENT, 0);
 SendMsg(MainArray+12, DRAW, DRAW_CLIENT, 0);
 SendMsg(MainArray+13, DRAW, DRAW_CLIENT, 0);

 DoCount();  /* Display the amount of records in file. */
}


/* ======================================
   Empty the fields dispayed.
   ====================================== */
void far DoEmptyFields(void)
{
 int i;
 char *CurrentField[] = {Index, TimeStamp, DateStamp, AlarmDate, Cabinet,
                         Drawer, File, Todo, Link}; /* Not Priority! */

 for(i=0; i<FIELDCOUNT; i++) 
     *CurrentField[i] = '';
}


/* ======================================
   Create a New DB File.
   ====================================== */
void far DoNewFile(void)
{
 int i;

 msgFileOpenDlg0 = "Create New File";
 msgFileOpenDlg1 = "&New File Name";
 msgFileOpenDlg2 = "Directory";
 msgFileOpenDlg3 = "&Files";
 msgFileOpenDlg4 = "&Directories";

 /* Initiate the File & Dir Lists: */
 *FileSpec = ''; /* Want the File Name empty when the dialog is opened. */
 for (i=0; i<FILECOUNT; ++i) FileList[i] = &FileSpace[i][0];
 for (i=0; i<DIRCOUNT; ++i)  DirList[i]  = &DirSpace[i][0];

 NewOrOpen = TRUE; /* If TRUE, then create a New File */
 strcpy(TempDirectory, Directory); /* Save current Directory */
 OWFlag = TRUE;

 SendMsg( &FileOpenDlgBox, CREATE, CREATE_FOCUS, 0 );
}


/* ======================================
   Open an excisting DB File.
   ====================================== */
void far DoOpenFIle(void)
{
 int i;

 msgFileOpenDlg0 = "Open File";
 msgFileOpenDlg1 = "File To &Open";
 msgFileOpenDlg2 = "Directory";
 msgFileOpenDlg3 = "&Files";
 msgFileOpenDlg4 = "&Directories";

 /* Initiate the File & Dir Lists: */
 *FileSpec = ''; /* Want the File Name empty when the dialog is opened. */
 for (i=0; i<FILECOUNT; ++i) FileList[i] = &FileSpace[i][0];
 for (i=0; i<DIRCOUNT; ++i)  DirList[i]  = &DirSpace[i][0];

 NewOrOpen = FALSE; /* If FALSE, open an exsisting File. */
 strcpy(TempDirectory, Directory); /* Save current Directory */

 SendMsg( &FileOpenDlgBox, CREATE, CREATE_FOCUS, 0 );
}


/* ======================================
   Check if a records has been edited.
   ====================================== */
BOOL far DoCheckEdit(void)
{
int i;

for( i= 1; i < 14; i++)
   {
    if(!(MainArray[i].Status&STATUS_NOT_EDITED)) /* If the Edit field has */
      {                                          /* changed- reset the flag */
       MainArray[i].Status |= STATUS_NOT_EDITED; /* and return TRUE. */
       return TRUE;
      }
   }

 return FALSE; /* If no Edit field has changed, return FALSE. */
}


/* ======================================
   Check if a DB file exist (used so we
   do not overwrite an existing file.
   ====================================== */
BOOL far DoFileExist(void)
{
 /* I guess there are better ways, but it works! */
 NBFILE infile;

 m_lock();
 if(!m_openro(&infile,  db_filename, strlen(db_filename), 0, 1)) 
   {
   m_close(&infile); 
   m_unlock();
   return TRUE;
   } 
 else 
   {
    m_unlock();
    return FALSE;
   }
}


/* ======================================
   Create a DATABASE file.
   ====================================== */
int far Create_DB(void)
{
 int i;
 FIELDDEF f;

 /* Create the file if no Error: */
 DBError = DB_Create(&dblk, db_filename, 0, NULL, NULL,NULL);
 if(DBError < DB_OK) return DBError;

 /*Create the field definitions:*/
 for(i=0; i<FIELDCOUNT; i++) 
    {
     f.fieldtype = FieldKind[i];
     f.fieldID = 0;
     f.dataoffset = i*2;
     f.flags = (FieldKind[i]==NOTE_FIELD)?0:FIELDDEF_RELATIVE;
   /*f.reserved = (FieldKind[i]==RADIO_FIELD)?4:1; Using STRING_FIELD instead*/
     lstrcpy(f.name, FieldName[i]);
     DBError = DB_WriteRecord(&dblk, TYPE_FIELDDEF, i, &f, FIELDDEFSIZEOF(f), 0);
     if(DBError < DB_OK) return DBError;
    }
 DBError = DB_Close(&dblk); /*Close the created file to get things right.*/
 if(DBError < DB_OK) return DBError;
 DB_open_and_setvpt(); /* Ok, open it again. */

 return TRUE;
}


/* ======================================
   Open the DATABASE
   ====================================== */
int far DB_open_and_setvpt(void)
{
 HourGlassOn();
 DBError = DB_Open(&dblk, db_filename, filetype, NULL, Pwd, 0, 0);
 if(DBError < DB_OK)
   {
    if(DBError == DB_PASSWORDFAILED)
      {
       if(FileOpenDlgBox.Status&STATUS_VISIBLE)
          SendMsg(&FileOpenDlgBox, DESTROY, DESTROY_NORMAL, 0 );
       strcpy(Pwd, ""); /* First time Password should be empty. */
       msgPassword1 = "File Is Password Protected";
       msgPassword2 = "File Password       ";
       SendMsg(&PasswordDlg, CREATE, CREATE_FOCUS, 0 );
       DBError = DB_OK;
        return FALSE;
      }
   else
      {
       /* The Database File May be corrupted, Try to fix it: */
       DBError = DB_Reset(&dblk);
       if(DBError < DB_OK) return DBError;
       DBError = DB_Open(&dblk, db_filename, filetype, NULL, Pwd, 0, 0);
       if(DBError < DB_OK) return DBError;
      }
   }
 DBError = DB_SetCurrentViewpt(&dblk, 0); /* VIEWPTTABLE set 0 */
 if(DBError < DB_OK) return DBError;

 HourGlassOff();
 return TRUE;
}


/* ======================================
   Read a data record from the DATABASE
   ====================================== */
int far DB_read_record(int  RecNumber)
{
 int len;

 DBError = DB_ReadRecord(&dblk, TYPE_DATA, (*dblk.viewpt)[RecNumber], buf, sizeof(buf), &len);
 if(DBError < DB_OK) return DBError;

 DBError = DB_GetNamedField(&dblk, buf, "Index"     , Index    ,  7);
 DBError = DB_GetNamedField(&dblk, buf, "TimeStamp" , TimeStamp, 12);
 DBError = DB_GetNamedField(&dblk, buf, "DateStamp" , DateStamp, 10);
 DBError = DB_GetNamedField(&dblk, buf, "AlarmDate" , AlarmDate, 10);
 DBError = DB_GetNamedField(&dblk, buf, "Cabinet"   , Cabinet  , 21);
 DBError = DB_GetNamedField(&dblk, buf, "Drawer"    , Drawer   , 21);
 DBError = DB_GetNamedField(&dblk, buf, "File"      , File     , 21);
 DBError = DB_GetNamedField(&dblk, buf, "Todo"      , Todo     ,  2);
 DBError = DB_GetNamedField(&dblk, buf, "Priority"  , Priority , 21);
 DBError = DB_GetNamedField(&dblk, buf, "Link"      , Link     ,128);

 if(DBError < DB_OK) return DBError;
 
 return TRUE;
}


/* ======================================
   Add a new record to the DATABASE
   ====================================== */
void far DoAdd(void)
{
 SendMsg(&NewRecordDlg, CREATE, CREATE_FOCUS, 0 );

 GetTimeDate(); /* Get the System Time & Date. */
 /* Update the Time & Date Fields- so we can see it directly. */
 SendMsg(NewRecordArray+1, DRAW, DRAW_CLIENT, 0);
 SendMsg(NewRecordArray+2, DRAW, DRAW_CLIENT, 0);
 SendMsg(NewRecordArray+7, DRAW, DRAW_CLIENT, 0);
}

/* ======================================
   Write (Save after edit) a record to 
   the DATABASE
   ====================================== */
void far DoWrite(void)
{
 AddWriteRecord = FALSE;
 DB_AddWrite();
}


/* ======================================
   Add a new record to the DATABASE
   ====================================== */
int far DB_AddWrite(void)
{
 int i, n;
 unsigned char Buffer[1024];
 unsigned char Record[512];
 char *CurrentField[] = {Index, TimeStamp, DateStamp, AlarmDate, Cabinet,
                         Drawer, File, Todo, Priority, Link};

 HourGlassOn();
 strcpy(Buffer, CurrentField[0]); 
 n = FIELDCOUNT * 2;     /* Reserve room for pointer table */
 *((int *)Record) = n;   /* Store the pointer */
 n+=lstrcpyto(Record+n, Buffer, sizeof(Record)-n)+1;


 for(i=1; i<FIELDCOUNT; i++) 
    {
     strcpy(Buffer, CurrentField[i]);
     *(((int *)Record)+i) = n;  /* Save offset pointer */

     /* Convert the Buffer to the proper type: */
     switch(FieldKind[i]) 
           {
            case TIME_FIELD:
                 StringToTime(Buffer, (DB_TIME far *)(Record+n));
                 n+=2;
                 break;
            case DATE_FIELD:
                 StringToDate(Buffer, (DB_DATE far *)(Record+n));
                 n+=3;
                 break;
            case NUMBER_FIELD: 
            case STRING_FIELD:
                 n+=lstrcpyto(Record+n, Buffer, sizeof(Record)-n)+1;
                 break;
           }
     }


 if((AddWriteRecord == TRUE) && (DBError > -1))
   {
    NewRecNo = DB_AddRecord(&dblk, TYPE_DATA, &Record, n, 0);
    DBError = NewRecNo; /* Must capture any Error! */
    if(DBError < DB_OK) return DBError;
   }
 else

    DBError = DB_WriteRecord(&dblk, TYPE_DATA, (*dblk.viewpt)[RecNo], &Record, n, 0);
    if(DBError < DB_OK) return DBError;

 DoCount(); /* Check how many records we have and display the result. */

 HourGlassOff();
 return TRUE;
}


/* ======================================
   Delete current record in the DATABASE
   ====================================== */
void far DoDel(void)
{
 SendMsg(&DelConfirmDlg, CREATE, CREATE_FOCUS, 0 );
}


/* ======================================
   Copy current record in the DATABASE
   ====================================== */
void far DoCopy(void)
{
 AddWriteRecord = TRUE;
 DB_AddWrite();

/* DoUpdate();*/ /* Update the screen. */
}


/* ======================================
   Delete current record in the DATABASE
   ====================================== */
int far DB_DelRecord(void)
{
 HourGlassOn();
 DBError = DB_DeleteRecord(&dblk,TYPE_DATA, (*dblk.viewpt)[RecNo], 0);
 if(DBError < DB_OK) return DBError;
 DBError = DB_FlushFile(&dblk); /* Flush the file- make sure it's updated!*/
 if(DBError < DB_OK) return DBError;

 /* If the last record is current record when it's deleted,
    move back one record for viewing: */
 if(RecNo > dblk.viewptcount - 1)
    RecNo = dblk.viewptcount - 1;

 if(RecNo > -1)
    DB_read_record(RecNo); /* Read the new current record. */
 DoCount(); /* Display the amount of records in file. */
 DoUpdate(); /* Update the screen. */

 HourGlassOff();
 return TRUE;
}


/* ======================================
   Check how many records we have in the 
   DATABASE
   ====================================== */
void far DoCount(void)
{
 int n;
 char temp [8];

 *CountResult = '';
 n = RecNo + 1; /* The current record # */

 itoa( n, temp, 10);
 strcat(CountResult, temp);

 strcat(CountResult, "/");

 n = dblk.viewptcount; /* The total number of records: */

 itoa( n, temp, 10);
 strcat(CountResult, temp);

 SendMsg(MainArray  , DRAW, DRAW_CLIENT, 0);

 /* When I read the Developer's Guide, I first thouht that I should use one
    of these two ways to get the total number of records:
    DB_CountRecords(&dblk,TYPE_DATA);
    DB_NextRecord(&dblk, TYPE_DATA);
    But DB_CountRecords counts all available slots, even deleted records,
    and DB_NextRecord seams to give the next free slot for a new record-
    which doesn't necessarily mean in the end of the file! */
}


/* ======================================
   Handle a Password for the DATABASE
   ====================================== */
int far DoNewPassword(void)
{
 msgPassword1 = "File Password";

 if(DB_VerifyPassword(&dblk, "") == DB_OK)
   { /* If do not already have a password: */
    msgPassword2 = "Enter New Password  ";
    strcpy(OldPwd, "");
    strcpy(Pwd, "");
    PwdFlag = 1;
   }
 else
   { /* if file already password protected:*/
    msgPassword2 = "Enter Old Password  ";
    strcpy(Pwd, "");
    PwdFlag = 2;
   }

 SendMsg(&PasswordDlg, CREATE, CREATE_FOCUS, 0 );
}


/* ======================================
   Open a Database File with a Password.
   ====================================== */
void far DoPwdOpen(void)
{
 DB_open_and_setvpt();
 /* If no records in File Or have an Error- no point to try to read:*/
 if((dblk.viewptcount != 0) && (DBError > -1))
   {
    DB_read_record(RecNo); /* Go to the record which was viewed last time. */
    DoUpdate(); /* Update the Edit fields. */
    DoCount();  /* Display the amount of records in file. */
   }
}


/* ======================================
   MAIN
   ====================================== */
void main(void)
{
    m_init_app(SYSTEM_MANAGER_VERSION);
    InitializeLHAPI(&LHAPIData);
    /* Must register a far pointer table for the DATABASE: */
    m_reg_far(&SysMgrPtrs,countof(SysMgrPtrs),4);
    /* Initialize the DATABASE ENGINE: */
    DB_Init();
    m_reg_app_name(msgAppName);
    SetMenuFont(FONT_NORMAL);
    SetDefaultFont(FONT_NORMAL);
    FixupFarPtrs();

    ReadCfg(); /* Read the configuration file. */

    SendMsg(&MainView , CREATE, CREATE_FOCUS , 0 );
    SendMsg(&MainTitle, CREATE, CREATE_NORMAL, 0 ); /* Show Main Title */

    /* Create the Main Dialog: */
    SendMsg(&MainDlg, CREATE, CREATE_FOCUS, 0 );

    /* Open the Database File: */
    DB_open_and_setvpt();

    /* If no records in File Or have an Error- no point to try to read:*/
    if((dblk.viewptcount != 0) && (DBError > -1))
      {
       DB_read_record(RecNo); /* Go to the record which was viewed last time. */
       DoUpdate(); /* Update the Edit fields. */
       DoCount();  /* Display the amount of records in file. */
      }
    Done = FALSE;

    while(!Done) {
         /* Save data from buffered disk i/o to avoid data loss: */
         if(dblk.flags & DB_SHOULDFLUSH)
            DBError = DB_FlushFile(&dblk);

         if(DBError < DB_OK) /* If any Error. */
            DisplayError(DBError); /* go and display the Error Message. */

         maction:
         app_event.norm.do_event = DO_EVENT;
         m_action(&app_event); /* Grab System Manager Events. */
         if(DB_CardChanged(&dblk) < DB_OK) /* If PC Card has changed */
            goto CloseIt;
         switch(app_event.norm.kind) {
             case E_KEY:
                  if(GetFocus())
                     SendFocusMsg(KEYSTROKE,app_event.norm.data,app_event.norm.scan);
                  else
                     goto CloseIt;
                  break;
             case E_REFRESH:
                  FixupFarPtrs();
                  ReactivateLHAPI(&LHAPIData);
                  break;
             case E_ACTIV:
                  FixupFarPtrs();
/*Fix it*/        if(dblk.viewptcount != 0)
                    {
                     if(DB_Reactivate(&dblk) != DB_OK) /* Reactivate DATABASE */
                       {
                        CloseIt:
                        DisplayError(FATAL_ERROR); /* Display a msg before closing. */
                        delay(3000); /* Give the user 3 seconds to read msg. */
                        m_fini();  
                        return; /* Bail out! */
                       }
                    }
                  ReactivateLHAPI(&LHAPIData);
                  SyncLHAPIKeyState();
                  break;
             case E_DEACT:              /* Switch to another App. */
                  DB_Deactivate(&dblk); /* Deactivate DATABASE */
                  DeactivateLHAPI();
                  goto maction;
             case E_TERM:
                  FixupFarPtrs();
                  Done = TRUE;
                  break;
             case E_NONE:
                  SendMsg(&TDateTime,DRAW,DRAW_ALL,0);
                  break; 
             }

        }

    DBError = DB_Close(&dblk); /* Close the DATABASE. */
    if(DBError < DB_OK)
      { 
       m_beep();
       DisplayError(DBError);
       delay(2000); /* A short delay for displaying Err Msg before we quit. */
      }
    WriteCfg(); /* Write the DBTEST.ENV file before we quit. */
    app_event.norm.do_event = DO_FINI;
    m_action(&app_event);
}

 /*    char tempErr [8];
     itoa( DBError, tempErr, 10); 
     DrawText(20, 170, tempErr, DRAW_NORMAL, FONT_NORMAL); */