# PQ2T.AWK   Pocket Quicken to Text/CSV
#   Author: David Gwillim
#     Date: 19 March 1998
# Language: Thompson Automation AWK v5.0 (should work with NAWK as well)
#  Purpose: To export HP 200LX Pocket Quicken "Export" files into a common
#           format for use with other spreadsheet and database programs.
#           Data is expected to be in format produced by File/Export command
#           with Lists options "Category and Class" and "Account" set OFF
#           (no checkmark in box).
#    Usage: PQ2T ExpFile >OutFile
#           For CSV (Comma Separated Value) output set DOS environment
#           variable with SET PQ2TFSEP=,
#           Or run command line: PQ2T -vsep=, ExpFile >OutFile
#
# Program Copyright (C) 1998 by Noesis Corporation, license granted
# for personal use.
#

global program = "Pocket Quicken(tm) Export file to Text/CSV Converter"
global copyright = "Program Copyright (C) 1998 by Noesis Corporation."
global email = "Send email about this program to: NoesisDG@aol.com"
global license   = "Free license granted for personal use.\n"
global usage = \
"Usage:\n\
 PQ2T ExpFile >OutFile\n\
 For CSV (Comma Separated Value) output set DOS environment\n\
 variable with SET PQ2TFSEP=,\n\
 Or, run command line: PQ2T -vsep=, ExpFile >OutFile\n"
global rec = ""
global sep = "\\"
global dq = "\""
global dqc = ""
global date = ""
global amount = ""
global chknum = ""
global status = ""
global payee = ""
global memo = ""
global category = ""
global class = ""

function init_vars() {
  date = ""
  amount = ""
  chknum = ""
  status = ""
  payee = ""
  memo = ""
  category = ""
  class = ""
}

# use BEGIN clause to setup program vars
BEGIN {
  local fsep = ENVIRON["PQ2TFSEP"]

  # output banner
  print program >stderr
  print copyright >stderr
  print email >stderr
  print license >stderr
  # pick up alternate field separator from DO environment
  if (fsep != "") sep = fsep

  # check for file name on command line, print usage and abort if none.
  if (ARGC != 2)
  {
    print usage >stderr
    abort(1)
  }

  # prepare for CSV output format
  if (sep == ",")
  {
    dqc = dq sep dq
    print "Output is in CSV format" >stderr
  }
  else
  {
    print "Output record separator is \"" sep "\"" >stderr
  }
  init_vars()
}

# line processing pattern/action statements which
# follow run in the AWK automatic loop

# get Date field
substr($0,1,1) == "D" {
  date = substr($0,2)
  next
}

# get amounT field
substr($0,1,1) == "T" {
  amount = substr($0,2)
  next
}

# get check Number field
substr($0,1,1) == "N" {
  chknum = substr($0,2)
  next
}

# get Cleared status field
substr($0,1,1) == "C" {
  status = substr($0,2)
  next
}

# get Payee field
substr($0,1,1) == "P" {
  payee = substr($0,2)
  next
}

# get Memo field
substr($0,1,1) == "M" {
  memo = substr($0,2)
  next
}

# get category/cLass field - parse into 2 separate fields
substr($0,1,1) == "L" {
  local oldFS = FS
  $0 = substr($0,2)
  FS = "/"
  category = $1
  class = $2
  FS = oldFS
  next
}

# process record terminator
substr($0,1,1) == "^" {
  # see if separator is a COMMA, if so output record in CSV format
  if (sep == ",")
  {
    rec = dq date dqc amount dqc chknum dqc status dqc payee dqc memo dqc class dqc category dq
  }
  else
  {
    rec = date sep amount sep chknum sep status sep payee sep memo sep class sep category
  }

  # output record
  print rec
  # reset globals to null strings
  init_vars()
}
