#!/usr/local/perl -w
#
# Name:
#
#   csv2html.pl
# 
# Description:
#
#   This is a little hack to convert my hp 200 lx database file to
#   a html file so I can view it on my desktop. Please note that it
#   doesn't do any sorting yet, just a straight dump.
#
# Flow:
#
#   phone.pdb > gdpdump > phone.csv > perl csv2html.pl > phone.html
#
# Usage:
#
#   gdbdump phone.pdb > phone.csv
#   perl csv2html.pl  phone.csv > phone.html
#
# Contact:
#
#   Chad Bearden
#   ebeard@compuserve.com
#   1999/08/24
#
# Version:
#
#   $Id: csv2html.pl,v 1.2 1999/08/26 09:29:44 chadb Exp $
#

require Text::CSV_XS;

my $csv = Text::CSV_XS->new({
             'quote_char'  => '"',
             'escape_char' => '"',
             'sep_char'    => ',',
             'binary'      => 0
         });

my $column = '';

#
# this stuff could all be done by other fancy modules
# but I figure with no more than I have to do why not
# just hard code it...(famous last words)
#

print "<HTML>\n";
print "<HEAD><TITLE>HP LX database</TITLE>\n";
print "</HEAD>\n";
print "<body bgcolor=\"#99cc99\" link=\"#009966\" vlink=\"#663399\" text=\"#000000\" >\n";
print "<TABLE BORDER=2>\n";

#
# go through all args on the command line 1 by 1
#

while(<>){
	#
	# remove all \" and replace with ""
	#   text::csv_xs seems to like it this way...
	#

    s/\\"/""/g;

	#
	# 1. parse a line and divy it into @field 
	# 2. put each line into its' own table record
	#    and each field into its' own table column
	# 3. if we have trouble parsing stop the table issue a
	#    warning and begin the table again.
	#

	if ($csv->parse($_)) {
	  my @field = $csv->fields;
	  print "<TR>\n ";
	  for $column (@field) {

	  	#
		# remove all & symbols (this could be nicer)
		#

		$column =~ s/\&//;

		#
		# replace \r\n with html <P>
		# Again, probably a nicer way to do this but 
		# I'm no html wizard.
		#

		$column =~ s/\\r\\n/<P>/g;
		
		print "    <TD VALIGN=\"TOP\">\n";
		print "        <P>$column</TD>\n";
	  }
	  print "</TR>\n";
	} else {
	  my $err = $csv->error_input;
      print "</TABLE>\n";
	  print "<P><STRONG>parse() failed on argument: ", $err, "\n</STRONG>";
      print "<TABLE BORDER=2>\n";
	}
}
print "</TABLE>\n";
print "</BODY>\n";
print "</HTML>\n";
