/* WHITE.C -- Whitespace-Oriented Commands

	Written July 1991 by Craig A. Finseth
	Copyright 1991 by Craig A. Finseth
*/

#include "freyja.h"


/* ------------------------------------------------------------ */

/* Delete the surounding whitespace. */

void
WDelFWhite()
	{
	BMarkToPoint(cwin->point);
	MovePastF(IsWhite);
	BRegDelete(cwin->point);
	}


/* ------------------------------------------------------------ */

/* Delete the spaces and tabs around the point. */

void
WDelWhite()
	{
	MovePastB(IsWhite);
	BMarkToPoint(cwin->point);
	MovePastF(IsWhite);
	BRegDelete(cwin->point);
	}


/* ------------------------------------------------------------ */

/* Perform consistency and reasonableness checking on the conf_buffer
data. */

void
WFixup(cptr)
	struct conf_buffer *cptr;
	{
	if (cptr->left_margin < 0) cptr->left_margin = 0;
	if (cptr->left_margin > 100) cptr->left_margin = 100;

	if (cptr->right_margin <= 0) cptr->right_margin = 9999;
	if (cptr->right_margin <= cptr->left_margin + 2)
		cptr->right_margin = cptr->left_margin + 3;
	if (cptr->right_margin > 9999) cptr->right_margin = 9999;

	if (cptr->tab_spacing < 1) cptr->tab_spacing = 1;
	if (cptr->tab_spacing > 50) cptr->tab_spacing = 50;

	if (cptr->fill != 'N' && cptr->fill != 'F' && cptr->fill != 'W')
		cptr->fill = 'N';
	}


/* ------------------------------------------------------------ */

/* Delete the indentation from the current line. */

void
WIndDel()
	{
	CLineA();
	BMarkToPoint(cwin->point);
	WDelWhite();
	BPointToMark(cwin->point);
	uarg = 0;
	}


/* ------------------------------------------------------------ */

/* Indent the next line the same as the current line. */

void
WIndNext()
	{
	int cnt;

	BInsChar(NL);
	BMoveBy(-1);
	CLineA();
	MovePastF(IsWhite);
	cnt = BGetCol();
	SearchNLF();
	BInsTabSpaces(cnt);
	uarg = 0;
	}


/* ------------------------------------------------------------ */

/* Open a new line indented the same as the current line. */

void
WIndThis()
	{
	int cnt;

	CLineA();
	MovePastF(IsWhite);
	cnt = BGetCol();
	CLineA();
	BInsTabSpaces(cnt);
	BInsChar(NL);
	BMoveBy(-1);
	uarg = 0;
	}


/* ------------------------------------------------------------ */

/* Insert a newline. */

void
WInsNL()
	{
	BInsChar(NL);
	}


/* ------------------------------------------------------------ */

/* Insert a newline after the current position. */

void
WInsNLA()
	{
	BInsChar(NL);
	BMoveBy(-1);
	}


/* ------------------------------------------------------------ */

/* Delete the surrounding grayspace and leave exactly one blank. */

void
WJoinGray()
	{
	GoToNotGrayB();
	BMarkToPoint(cwin->point);
	GoToNotGrayF();
	BRegDelete(cwin->point);
	BInsChar(SP);
	}


/* ------------------------------------------------------------ */

/* Center the current line. */

void
WLineCenter()
	{
	int cnt;
	int tmp;

	cnt = cbuf->c.right_margin;
	if ((cnt -= cbuf->c.left_margin) >= 1) {
		CLineA();
		WDelWhite();
		CLineE();
		tmp = BGetCol();
		if (tmp && tmp <= cnt) {
			CLineA();
			BInsTabSpaces(cbuf->c.left_margin + (cnt - tmp) / 2);
			}
		}
	CLineE();
	if (uarg > 1) BMoveBy(1);
	}


/* ------------------------------------------------------------ */

/* Print the line count of the point and the buffer. */

void
WPrintLine()
	{
	char buf[LINEBUFFSIZE];
	int pointline = 1;
	int bufline = 1;
	int markline = 1;

	uarg = 0;
	BMarkToPoint(cwin->point);
	BMoveToStart();
	while (!BIsEnd()) {
		if (SearchNLF()) ++bufline;
		if (!BIsAfterMark(cwin->point)) pointline = bufline;
		if (!BIsAfterMark(mark)) markline = bufline;
		}
	BPointToMark(cwin->point);

	xsprintf(buf,
		TMaxCol() < 60 ?
			"Line %u  Total %u  Mark %u " :
			"Current line %u   Total lines %u   Mark on line %u ",
		pointline, bufline, markline);
	DView(buf);
	}


/* ------------------------------------------------------------ */

/* Print the margin settings */

void
WPrintMar()
	{
	char buf[LINEBUFFSIZE];

	uarg = 0;
	if (isuarg) {
		xsprintf(buf, "\013R %d,T %d,L %d%s%s\n",
			cbuf->c.right_margin,
			cbuf->c.tab_spacing,
			cbuf->c.left_margin,
			cbuf->c.fill == 'N' ? ",N" : "",
			cbuf->c.fill == 'F' ? ",F" : "");
		BMarkToPoint(cwin->point);
		BMoveToStart();
		BInsStr(buf);
		BPointToMark(cwin->point);
		DView("Ruler inserted");
		}
	else	{
		xsprintf(buf,
			TMaxCol() < 60 ?
	"Left %d  Right %d  Tab %d  Fill %s%s%s" :
	"Left margin %d   Right margin %d   Tab spacing %d   Fill %s%s%s",
			cbuf->c.left_margin,
			cbuf->c.right_margin,
			cbuf->c.tab_spacing,
			cbuf->c.fill == 'N' ? "none" : "",
			cbuf->c.fill == 'F' ? "hard" : "",
			cbuf->c.fill == 'W' ? "word wrap" : "");
		DView(buf);
		}
	}


/* ------------------------------------------------------------ */

/* Print the current position. */

void
WPrintPos()
	{
	char buf[LINEBUFFSIZE];
	long tmp;

	BMarkSwap(mark);
	tmp = BGetLocation();
	BMarkSwap(mark);
	xsprintf(buf,
		TMaxCol() < 60 ?
			"Pt %l  Len %l  Col %d  Mark %l" :
			"Point %l   Length %l   Column %d   Mark %l ",
		BGetLocation(),
		BGetLength(cbuf),
		BGetCol(),
		tmp);
	DView(buf);
	}


/* ------------------------------------------------------------ */

/* Ask for the fill mode and set this buffer's fill mode. */

void
WSetFill()
	{
	int chr;

	uarg = 0;
	for (;;) {
		DEcho("Fill mode: ");
		chr = xtoupper(KGetChar());
		switch (chr) {

		case KEYQUIT:
		case KEYABORT:
		case BEL:
		case ESC:
			DModeLine();
			return;
			/*break;*/
			
		case 'N':
		case 'F':
		case 'W':
			cbuf->c.fill = chr;
			DModeLine();
			return;
			/*break;*/

		default:
			DView("N)No filling   F)hard fill   W)word wrap");
			break;
			}
		}
	}


/* ------------------------------------------------------------ */

/* Set this buffer's left margin to the argument. */

void
WSetLeft()
	{
	if (!isuarg) {
		DError("An explicit argument must be supplied.");
		}
	else	{
		cbuf->c.left_margin = uarg;
		WFixup(&cbuf->c);
		}
	uarg = 0;
	}


/* ------------------------------------------------------------ */

/* Set this buffer's right margin to the argument. */

void
WSetRight()
	{
	if (!isuarg) {
		DError("An explicit argument must be supplied.");
		}
	else	{
		cbuf->c.right_margin = uarg;
		WFixup(&cbuf->c);
		}
	uarg = 0;
	}


/* ------------------------------------------------------------ */

/* Set this buffer's tab spacing to the argument. */

void
WSetTabs()
	{
	if (!isuarg) {
		DError("An explicit argument must be supplied.");
		}
	else	{
		cbuf->c.tab_spacing = uarg;
		WFixup(&cbuf->c);
		DNewDisplay();
		}
	uarg = 0;
	}


/* end of WHITE.C -- Whitespace-Oriented Commands */
