                page    66,132
;============================================================================
; CD_CHECK.COM

                code    segment
		assume	cs:code

                org     100h

main:		jmp	initialize
int21h          dd      -1                      ;Int 21 vector (DOS)

;============================================================================
; DOSINT processes calls to interrupt 21h
;============================================================================
dosint		proc	far
		assume	cs:code,ds:nothing,es:nothing
                cmp     ah,4eh                  ;Check for find first
                jne     goto_dos                ;No, nevermind
                push    di                      ;Save DI
                mov     di,dx                   ;copy DX pointer to index reg
                cmp     byte ptr [di],'@'       ;is it our 'fake' drive?
                jne     goto_dos_2              ;No, nevermind
                cmp     byte ptr [di+1],':'     ;is it our 'fake' drive
                jne     goto_dos_2              ;No, nevermind
                push    es                      ;Yes, Save ES
                push    ds                      ;Point ES to DS for scasb
                pop     es
                push    si                      ;Save SI
                push    cx                      ;Save CX
                push    bx                      ;Save BX
                mov     cx,64
                cld
                mov     al,0                    ;find the length
                repne   scasb                   ;di points past the 0
                mov     si,di                   ;Save pointer
                mov     cx,si                   ;calculate path length
                sub     cx,dx                   ;  as SI-DX
                jcxz    exit                    ;Abort if length 0
                std                             ;Scan backwords
                mov     al,'\'                  ;find the last '\'
                repne   scasb                   ;
                je      got_it                  ;  Found one
                mov     di,dx                   ;otherwise,point to drive letter
got_it:         inc     di                      ;back up the pointer
                inc     di                      ;  to the actual filename
                mov     cx,si                   ;calculate the length
                sub     cx,di                   ;  as SI-DI
                jcxz    exit                    ;Abort if length 0
                push    cx                      ;Save Filename length
                push    di                      ;Save Filename Pointer
                mov     ah,2fh                  ;Get DTA address [ES:BX]
                pushf
                call    cs:[int21h]             ;call the old INT 21
                mov     di,bx                   ;Copy DTA to DI
                cld                             ;Copy forward
                mov     cx,1eh                  ;fill the first 30 bytes
                xor     al,al                   ;  with zeros
                rep     stosb                   ;Stuff 0's, point to filename
                pop     si                      ;Restore Filename Pointer
                pop     cx                      ;Restore Filename length
loop1:          rep     movsb                   ;(ES:DI) < (DS:SI)
                xor     ax,ax                   ;Yes, say the file exists
                pop     bx                      ;Restore BX
                pop     cx                      ;Restore CX
                pop     si                      ;Restore SI
                pop     es                      ;Restore ES
                pop     di                      ;Restore DI
                iret                            ;Return

exit:           pop     bx                      ;Restore BX
                pop     cx                      ;Restore CX
                pop     si                      ;Restore SI
                pop     es                      ;Restore ES
goto_dos_2:     pop     di                      ;Restore DI
goto_dos:       jmp     cs:[int21h]             ;else pass the call to DOS

dosint          endp

;----------------------------------------------------------------------------
; Initialization routine.
;----------------------------------------------------------------------------
initialize	proc	near
		assume	cs:code,ds:code,es:code
                mov     ax,3521h                ;Get interrupt 21 (DOS)
		int	21h                     ;  vector.
		mov	word ptr [int21h],bx
		mov	word ptr [int21h+2],es
		mov	ax,2521h                ;Point int 21 to internal
		mov	dx,offset dosint        ;  routine.
		int	21h
                mov     ax,ds:[2ch]             ;Get environment segment.
                mov     es,ax
                mov     ah,49h                  ;Free up environment.
                int     21h
tsr:            mov     dx,OFFSET initialize
		mov	ax,3100h		;Terminate and stay resident
                int     27h
initialize	endp
code		ends
end		main
