#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <time.h>

#define ALWAYS   1
#define NOTYET   1
#define NOTFOUND -1
#define SWITCH   '/'
#define ENTER    7181
#define ESC      283
#define SET      0
#define GET      1
#define NO       0
#define YES      1

/*==[ ERRORLEVEL CODES ]==
*/
#define BOARD  3
#define DOS    2
#define ERROR  1
#define NORMAL 0

/*==[ DECLARE functions ]==
*/
void cursoron(void);
void cursoroff(void);
void clearkey(void);
int  myaccess(int args,char **filelist,int row,int col);


/*==[ START OF PROGRAM ]==
*/
void main(int argc, char *argv[]){
        time_t tme;
        int status,x,y,fx,fy,t1,t2,td,key;

        cursoroff(); /* When cursor is - Snow appears */
        atexit(cursoron);

        clrscr();
        textcolor(YELLOW);

        /*==[ MAKE SURE FILENAMES WERE PROVIDED ]==
        */
        if(argc < 2){
                printf("\nProcess aborted!  No filename supplied");
                printf("\nSyntax: DOWNTIL filename\n");
                printf("\n\nPress any key to return\n");
                getch();
                exit(ERROR);
        }

        /*==[ DISPLAY SCREEN/INFORMATION ]==
        */
        time(&tme);
        cprintf("\r\nPress <ESC> to exit to DOS               <ENTER> Returns to board\r\n");
        cprintf("\r\nWaiting to bring up PCBoard node",argv[1]);
        cprintf("\r\nStarted: %s \r",ctime(&tme));
        x=wherex(); y=wherey();
        cprintf("\r\n\r\r===========================[ FILE STATUS FOLLOWS ]=========================\r\n");
        fx=wherex();fy=wherey();

        textcolor(WHITE);
        if(myaccess(argc,argv,fx,fy)==0){
		if(switches(GET,'O')) exit(BOARD);
		gotoxy(1,4);
                textcolor(WHITE);
                cprintf("All files exist!  Will restart PCBoard in 30 seconds -> ");
                x=wherex();  y=wherey();
                t1=time(&tme);
                textcolor(LIGHTCYAN);
                while(ALWAYS){
                        gotoxy(x,y);
                        td=time(&tme)-t1;  /* Use time for counter */
                        cprintf("%d",td);
                        if (td > 29) exit(BOARD);
                        if(bioskey(1)>0) clearkey();
                }
        }
        while (ALWAYS){
            time(&tme);
            gotoxy(x,y);
            textcolor(WHITE);
            cprintf("   Time: %s ",ctime(&tme));
            if(bioskey(1)>0) clearkey();
            status=myaccess(argc,argv,fx,fy);
            if(status==0) exit(BOARD);
        }
}


/*==[ If keypress detected, clear key and process it ]==
*/
void clearkey(){
        int key;
        cursoron();
        key=bioskey(0);
        switch(key){
                case ESC  :   exit(DOS);
                case ENTER:   exit(BOARD);
        }
}

/*==[ Process Switches ]==
// After programming in C++ OOP, globals feel uncomfortable.
// This method of defining data (using C) feels a little more at home.
*/
#define NUM_SWITCHES 1
#define OVERRIDE     0
int switches(int mode, char string){
	char valid_switches[1]={'O'};
	static override=NO;
	int i;
	int swtch=NOTFOUND;     /* Initialize switch setting */

	for(i=0;i<NUM_SWITCHES;i++)
		if(toupper(string)==valid_switches[i])
			swtch=i;

	if(mode==SET)  /* Setting data */
	   switch(swtch){
		case OVERRIDE: override=YES; break;
	   }
	else           /* Get data     */
	   switch(swtch){
		case OVERRIDE: return override;
	   }
}


/*==[ Check to see if files exist, flag accordingly ]==
*/
int myaccess(int args,char **filelist, int col, int row){
        int status,i,rstatus,holdrow;
        holdrow=row;
        rstatus=0;
	for (i=1;i<args;i++){
		if(*filelist[i]==SWITCH) {
			switches(SET,filelist[i][1]);
			i++;
		} else {
			status=access(filelist[i],0);
			gotoxy(col,row);
			textcolor(WHITE);
			cprintf("%20s ",filelist[i]);
			if(status==0){
				textcolor(YELLOW);
				cprintf("");
			}
			else{   rstatus=NOTYET;
				textcolor(LIGHTRED);
				cprintf("X");
			}
			if(row++ > holdrow+15){
				row=holdrow;
				col+=25;
			}
		}
        }
        return rstatus;
}

void cursoroff(){
        union REGS r;
        r.h.ah=1;
        r.h.ch=255;
        r.h.cl=255;
        int86(0x10,&r,&r);
}

void cursoron(){
        union REGS r;
        r.h.ah=1;
        r.h.ch=5;
        r.h.cl=7;
        int86(0x10,&r,&r);
	gotoxy(1,23);
}
