unit FilProps;

{
1997 Apr 07  V1.1.2   Use ShellAPI function to move file to recycle bin
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FileProp, StdCtrls, ExtCtrls, ComCtrls;

type
  TfrmFileProperties1 = class(TfrmFileProperties)
    btnDelete: TButton;
    procedure btnDeleteClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmFileProperties1: TfrmFileProperties1;

implementation

uses ShellAPI;

{$R *.DFM}

procedure TfrmFileProperties1.btnDeleteClick(Sender: TObject);
var
  shell_filename: string;
  SHFileOp: TSHFileOpStruct;
begin
  Inherited;
  // we return a result of either mrCancel if we didn't delete the file
  ModalResult := mrCancel;
  shell_filename := filename + #0#0;
  FillChar (SHFileOp, SizeOf (SHFileOp), 0);
  with SHFileOp do
    begin
    wFunc := FO_DELETE;
    pFrom := PChar (shell_filename);
    fFlags := FOF_ALLOWUNDO;
    end;
  SHFileOperation (SHFileOp);
  // we could check the eror code, simpler, see if the file has gone!
  // and if it's gone, return an mrYes
  if not FileExists (filename) then ModalResult := mrYes;
end;

end.
