/********    EXTREMELY IMPORTANT   ************/
/*
 * If you modify tde, it is your responsibility to find the offset of
 * the key definition array in your new executable, tde.exe.
 *
 */

#define  COLOR_OFFSET   81048l
#define  HELP_OFFSET    78946l
#define  KEYS_OFFSET    78088l
#define  MACRO_OFFSET   73232l
#define  MODE_OFFSET    72942l

/********    EXTREMELY IMPORTANT   ************/


#define TRUE            1
#define FALSE           0

#define OK              0
#define ERROR           (-1)


#define MAX_KEYS        256
#define AVAIL_KEYS      233


#define STROKE_LIMIT    1024


#define NUM_FUNC        122

#define NUM_COLORS      12

#define NUM_MODES       17

/*
 * mode indexes
 */
#define Ins     0 
#define Ind     1 
#define TAB     2
#define Smart   3 
#define Write_Z 4 
#define Crlf    5 
#define Trim    6 
#define Eol     7 
#define WW      8 
#define Left    9 
#define Para    10
#define Right   11
#define Size    12
#define Backup  13
#define Ruler   14
#define Date    15
#define Time    16



#define EXIST           0

#define VIDEO_INT       0x10

#define VGA             3
#define EGA             2
#define CGA             1
#define MDA             0

#define NORMAL          7
#define COLOR_ATTR      31
#define MONO_ATTR       112


#define ESC             27
#define LEFT            (75 | 0x100)
#define RIGHT           (77 | 0x100)
#define UP              (72 | 0x100)
#define DOWN            (80 | 0x100)
#define RTURN           13
#define PGUP            (73 | 0x100)
#define PGDN            (81 | 0x100)
#define F1              (59 | 0x100)
#define F2              (60 | 0x100)
#define F3              (61 | 0x100)
#define F5              (63 | 0x100)
#define F6              (64 | 0x100)
#define F7              (65 | 0x100)
#define F8              (66 | 0x100)
#define F10             (68 | 0x100)


#define U_LEFT          218
#define U_RIGHT         191
#define VER_LINE        179
#define HOR_LINE        196
#define L_LEFT          192
#define L_RIGHT         217

#define SAVE            0
#define RESTORE         1


/*
 * Save the underlying text of the screen in a structure.  We need to know
 * the column and row to begin saving the text.  Since we are doing an
 * optimal save and restore, we don't know how much memory to allocate to
 * the save buffer.  If we use a pointer, then we can dynamically allocate as
 * much or as little memory as we need.  Finally, we need a window pointer
 * to point to the next item on the stack.
 */
typedef struct win {
   int x;
   int y;
   int *buf;
   struct win *n;
} WINDOW;


/*
 * Structure to store the row and column of a string.
 */
struct screen {
   unsigned int   row;
   unsigned int   col;
   unsigned char *text;
};


/*
 * video adapter stuff.
 */
struct vcfg {
   int color;
   int rescan;
   int mode;
   int adapter;
   int attr;
   int far *videomem;
};


/*
 * When we display a pop-up or pull-down window, we need to know a few things
 * about the window and the text to display in the window.
 */
typedef struct {
   int dply_col;        /* offset into window to begin displaying help list */
   int dply_row;        /* dito */
   int line_length;     /* the length of the help line in the window */
   int avail_lines;     /* number of lines in the window available for list */
   int v_row;           /* virtual row of cursor in window */
   int select;          /* item currently selected in help list */
   int num_entries;     /* total number of items in help list */
   int ulft_col;        /* absolute upper left column of window */
   int ulft_row;        /* absolute upper left row of window */
   int total_col;       /* total number of columns in window */
   int total_row;       /* total number of rows in window */
} HELP_WINDOW;


/*
 * structure for list of available keys.   See default.h for more info.
 */
typedef struct {
   char *key;           /* key name */
   int  key_index;      /* offset into key structure in tde.exe file */
   unsigned char func_index;     /* function of key */
} KEY_DEFS;


/*
 * structure for list of available keys.   See default.h for more info.
 */
typedef struct {
   char *key;           /* key name */
   int  key_index;      /* offset into key structure in tde.exe file */
} CONFIG_DEFS;


/*
 * From the source code of tde.
 */
typedef struct {
  int key;      /* key assinged to this node, which may be text or function */
  int next;     /* pointer to next node in macro def */
} STROKES;

/*
 * structure for the macro buffer.
 */
typedef struct {
   int  first_stroke[MAX_KEYS];         /* pointer to first key in macro */
   STROKES strokes[STROKE_LIMIT];       /* buffer to hold key strokes */
} MACRO;



/*
 * "mode_infos" contain the editor mode variables.  The configuration
 *  utility modifies this structure to custimize the start-up tde
 *  configuration
 */
typedef struct {
   int  color_scheme;           /* color to start out with */
   int  sync;                   /* sync the cursor movement command? */
   int  sync_sem;               /* sync the cursor movement command? */
   int  record;                 /* are we recording keystrokes? */
   int  insert;                 /* in insert mode? */
   int  indent;                 /* in auto-indent mode? */
   int  tab_size;               /* characters between tab stops */
   int  smart_tab;              /* smart tab mode on or off? */
   int  enh_kbd;                /* type of keyboard */
   int  cursor_size;            /* insert cursor big or small? */
   char *eof;                   /* message to display at end of file */
   int  control_z;              /* write ^Z - t or f */
   int  crlf;                   /* <cr><lf> toggle CRLF or LF */
   int  trailing;               /* remove trailing space? T or F */
   int  show_eol;               /* show lf at eol? T or F */
   int  word_wrap;              /* in word wrap mode? */
   int  left_margin;            /* left margin */
   int  parg_margin;            /* column for 1st word in paragraph */
   int  right_margin;           /* right margin */
   int  do_backups;             /* create backup or ".bak" files? T or F */
   int  ruler;                  /* show ruler at top of window? T or F */
   int  date_style;             /* date style for date and time stamp */
   int  time_style;             /* time style for date and time stamp */
} MODE_INFO;


/*************  prototypes for functions in  tdecfg.c  *******************/
void  main( int, char *[] );
void xygoto( int, int );
void video_config( void );
int getkey( void );
void s_output( char far *, int, int, int );
void cls( void );
void hlight_line( int, int, int, int );
void c_off( void );
void c_on( void );
void scroll_window( int, int, int, int, int, int );
void cls( void );
void show_box( int, int, struct screen *, int );
void make_window( int, int, int, int, int );
void buf_box( int, int, int, int, int );
void clear_window( int, int, int, int );
void window_control( WINDOW **, int, int, int, int, int );
void save_window( int *, int, int, int, int );
void restore_window( int *, int, int, int, int );
/*************************************************************************/


/*************  prototypes for functions in  cfgcolor.c  *****************/
void tdecolor( void );
void initialize_color( void );
void show_init_sample( void );
void color_number( char *, int );
void current_color_number( char *, int );
void show_help_color( void );
void show_fileheader_color( void );
void show_text_color( void );
void show_curl_color( void );
void show_warning_color( void );
void show_mode_color( void );
void show_wrapped_color( void );
void show_eof_color( void );
void show_ruler_color( void );
void show_rulerptr_color( void );
void show_block_color( void );
void show_hilitedfile_color( void );
void change_colors( void );
/*************************************************************************/


/*************  prototypes for functions in  cfgkeys.c  *****************/
void tdekeys( void );
void initialize_keys( void );
void show_key_def_list( HELP_WINDOW *, KEY_DEFS * );
void show_func_list( HELP_WINDOW *, char *[] );
void position_cursor( HELP_WINDOW *, int, int *, int *, int * );
void master_help( HELP_WINDOW *, KEY_DEFS *, struct screen *, char *, int * );
void new_assignment_help( HELP_WINDOW *, char *[], struct screen *, int * );
void save_and_draw( HELP_WINDOW *, struct screen *, WINDOW ** );
/*************************************************************************/


/*************  prototypes for function in  cfghelp.c  *******************/
void tdehelp( void );
/*************************************************************************/


/*************  prototypes for function in  cfgmacro.c  *******************/
void tdemacro( void );
/*************************************************************************/


/*************  prototypes for functions in cfgmodes.c  *****************/
void tdemodes( void );
void initialize_modes( void );
void show_init_mode( void );
void show_insert_mode( void );
void show_indent_mode( void );
void show_smart_mode( void );
void show_tabsize( void );
void show_controlz( void );
void show_eol_out( void );
void show_trail( void );
void show_eol_display( void );
void show_ww( void );
void show_left( void );
void show_para( void );
void show_right( void );
void show_cursor_size( void );
void show_backup_mode( void );
void show_ruler_mode( void );
void show_date_style( void );
void show_time_style( void );
void change_modes( void );
/*************************************************************************/


/*************  prototypes for functions in cfgmodes.c  *****************/
void tdecfgfile( void );
void parse_line( char * );
char *parse_token( char *, char * );
int  search( char *, CONFIG_DEFS [], int );
void parse_macro( int, char * );
int  parse_literal( int, char *, char *, char ** );
void initialize_macro( int );
void clear_previous_macro( int );
void check_macro( int );
int  record_keys( int, int );
int  get_stroke_count( void );
int  getfunc( int );
/*************************************************************************/


#define   Help                     1
#define   Rturn                    2
#define   NextLine                 3
#define   BegNextLine              4
#define   LineDown                 5
#define   LineUp                   6
#define   CharRight                7
#define   CharLeft                 8
#define   ScrollRight              9
#define   ScrollLeft              10
#define   WordRight               11
#define   WordLeft                12
#define   ScreenDown              13
#define   ScreenUp                14
#define   EndOfFile               15
#define   TopOfFile               16
#define   BotOfScreen             17
#define   TopOfScreen             18
#define   EndOfLine               19
#define   BegOfLine               20
#define   JumpToLine              21
#define   CenterWindow            22
#define   CenterLine              23
#define   HorizontalScreenRight   24
#define   HorizontalScreenLeft    25
#define   ScrollDnLine            26
#define   ScrollUpLine            27
#define   FixedScrollUp           28
#define   FixedScrollDn           29
#define   ToggleOverWrite         30
#define   ToggleSmartTabs         31
#define   ToggleIndent            32
#define   ToggleWordWrap          33
#define   ToggleCRLF              34
#define   ToggleTrailing          35
#define   ToggleZ                 36
#define   ToggleEol               37
#define   ToggleSync              38
#define   ToggleRuler             39
#define   SetTabs                 40
#define   SetLeftMargin           41
#define   SetRightMargin          42
#define   SetParagraphMargin      43
#define   FormatParagraph         44
#define   FormatText              45
#define   LeftJustify             46
#define   RightJustify            47
#define   CenterJustify           48
#define   Tab                     49
#define   BackTab                 50
#define   ParenBalance            51
#define   BackSpace               52
#define   DeleteChar              53
#define   StreamDeleteChar        54
#define   DeleteLine              55
#define   DelEndOfLine            56
#define   WordDelete              57
#define   AddLine                 58
#define   SplitLine               59
#define   JoinLine                60
#define   DuplicateLine           61
#define   AbortCommand            62
#define   UndoLine                63
#define   UndoDelete              64
#define   ToggleSearchCase        65
#define   FindForward             66
#define   FindBackward            67
#define   RepeatFindForward1      68
#define   RepeatFindForward2      69
#define   RepeatFindBackward1     70
#define   RepeatFindBackward2     71
#define   ReplaceForward          72
#define   ReplaceBackward         73
#define   MarkBox                 74
#define   MarkLine                75
#define   MarkStream              76
#define   UnMarkBlock             77
#define   FillBlock               78
#define   NumberBlock             79
#define   CopyBlock               80
#define   KopyBlock               81
#define   MoveBlock               82
#define   OverlayBlock            83
#define   DeleteBlock             84
#define   BlockToFile             85
#define   PrintBlock              86
#define   BlockExpandTabs         87
#define   BlockTrimTrailing       88
#define   BlockUpperCase          89
#define   BlockLowerCase          90
#define   BlockStripHiBit         91
#define   SortBoxBlock            92
#define   DateTimeStamp           93
#define   EditFile                94
#define   DirList                 95
#define   File                    96
#define   Save                    97
#define   SaveAs                  98
#define   SetFileAttributes       99
#define   EditNextFile           100
#define   RedrawScreen           101
#define   SizeWindow             102
#define   SplitHorizontal        103
#define   SplitVertical          104
#define   NextWindow             105
#define   PreviousWindow         106
#define   ZoomWindow             107
#define   NextHiddenWindow       108
#define   SetMark1               109
#define   SetMark2               110
#define   SetMark3               111
#define   GotoMark1              112
#define   GotoMark2              113
#define   GotoMark3              114
#define   RecordMacro            115
#define   PlayBack               116
#define   SaveMacro              117
#define   LoadMacro              118
#define   ClearAllMacros         119
#define   Pause                  120
#define   Quit                   121

