/* This is a simple demo that just loads a file and exits. */

#include "config.h"

#include <stdio.h>
#include <slang.h>

/* Here are two intrinsics that the S-lang code can call. */

/* An intrinsic function to set error */
/* Function to quit */
static void c_quit (void)
{
   exit (0);
}

static void c_exit (int *code)
{
   exit (*code);
}

/* Create the Table that S-Lang requires */
static SLang_Intrin_Fun_Type Demo_Intrinsics [] =
{
   MAKE_INTRINSIC_I("exit", c_exit, VOID_TYPE),
   MAKE_INTRINSIC_0("quit", c_quit, VOID_TYPE),
   SLANG_END_TABLE
};


int main (int argc, char **argv)
{
   
   char *file;

   if ((-1 == SLang_init_slang ())    /* basic interpreter functions */
       || (-1 == SLang_init_slmath ()) 	       /* sin, cos, etc... */
#ifdef unix
       || (-1 == SLang_init_slunix ())	       /* unix system calls */
#endif
       || (-1 == SLang_init_slfile ())	       /* file i/o */
	  
	  /* Now add intrinsics for this application */
       || (-1 == SLadd_intrin_fun_table (Demo_Intrinsics, NULL)))
     {
	fprintf(stderr, "Unable to initialize S-Lang.\n");
	return 1;
     }

   /* parse command line arguments */
   if (argc != 2) 
     {
	fprintf (stderr, "Usage: %s FILENAME\n", argv[0]);
	return 1;
     }
   
   file = argv[1];
   
   /* Initialize the library.  This is always needed. */
   

   /* Turn on debugging */
   SLang_Traceback = 1;
   
   /* Now load an initialization file and exit */
   SLang_load_file (file);
   
   return (SLang_Error);
}

   

   
