/*_______________________________________________________________

tc-014.c

Function:  This program demonstrates high speed animation of
a walking human figure using bitblt animation techniques.

Compatibility:  Supports all graphics adapters and monitors.
If a VGA, EGA, CGA, or MCGA is present, the 320x200 4-color
mode is used.

Remarks:  Refer to the book.

Copyright 1988 Lee Adams and TAB BOOKS Inc.

_________________________________________________________________


I N C L U D E    F I L E S                                       */

#include <stdio.h>               /* supports the printf function */
#include <graphics.h>         /* supports the graphics functions */
#include <process.h>             /* supports the exit() function */
#include <bios.h>            /* supports read of keyboard buffer */
#include <alloc.h>                 /* supports memory allocation */

/*_______________________________________________________________


D E C L A R A T I O N S                                          */

void keyboard(void);void quit_pgm(void);
void notice(float x,float y);void graphics_setup(void);
void save_arrays(void);void draw_bg(void);

int t1=1,t2=2;                                  /* loop counters */
int C0=0,C1=1,C2=2,C3=3,C4=4,C5=5,C6=6,C7=7,C8=8,C9=9,C10=10,
C11=11,C12=12,C13=13,C14=14,C15=15;
float sx=0,sy=0,sx1=0,sy1=0,sx2=0,sy2=0;
int x=252,x1=-2;

/*                     graphic arrays will be stored in far heap */
char far *A1;char far *A2;char far *A3;char far *A4;
char far *A5;char far *A6;char far *A7;

int p1=0;                        /* pointer into database arrays */

int draw_A1[][2]={                 /* xy coordinates for frame 1 */
155,53,  171,65,  165,66,  167,72,  170,100, 144,143,
159,146, 162,122, 170,100, 173,125, 183,147, 173,150,
170,150, 157,108, 163,92,  164,72,  168,71,  173,90,
175,106};

int draw_A2[][2]={                 /* xy coordinates for frame 2 */
155,53,  171,65,  165,66,  167,72,  170,100, 141,144,
154,146, 161,122, 170,100, 176,125, 186,146, 177,150,
172,150, 153,107, 162,93,  164,72,  168,71,  175,90,
178,107};

int draw_A3[][2]={                 /* xy coordinates for frame 3 */
155,53,  171,65,  165,66,  167,72,  170,100, 145,146,
159,148, 164,125, 170,100, 175,124, 183,146, 176,150,
172,150, 158,107, 163,93,  164,72,  168,71,  173,89,
174,105};

int draw_A4[][2]={                 /* xy coordinates for frame 4 */
155,53,  171,65,  165,66,  167,72,  170,100, 153,149,
168,150, 168,123, 170,100, 173,123, 183,144, 170,147,
162,109, 165,91,  164,72,  168,71,  172,89,  175,106};

int draw_A5[][2]={                 /* xy coordinates for frame 5 */
155,53,  171,65,  165,66,  167,72,  170,100, 155,150,
170,150, 168,122, 170,100, 169,122, 176,143, 160,146,
166,108, 167,90,  164,72,  168,71,  170,90,  171,108};

int draw_A6[][2]={                 /* xy coordinates for frame 6 */
155,53,  171,65,  165,66,  167,72,  170,100, 158,144,
172,142, 165,122, 170,100, 170,122, 175,150, 162,150,
162,108, 167,91,  164,72,  168,71,  171,89,  174,106};

int draw_A7[][2]={                 /* xy coordinates for frame 7 */
155,53,  171,65,  165,66,  167,72,  170,100, 148,143,
161,145, 163,122, 170,100, 172,124, 178,148, 163,150,
158,110, 164,92,  164,72,  168,71,  172,89,  175,107};

/*_______________________________________________________________


M A I N    R O U T I N E                                         */

main(){
graphics_setup();                     /* establish graphics mode */

save_arrays();                 /* create and save graphic arrays */
draw_bg();                                /* draw the background */
moveto(56,80);outtext("Ready to begin animation...");
for (t1=1;t1<=30000;t1++);                              /* pause */
for (t1=1;t1<=30000;t1++);                              /* pause */
draw_bg();

animation_loop:
for (t1=1;t1<=18;t1++){
putimage(x,50,A1,COPY_PUT);x=x+x1;
for (t2=1;t2<=1000;t2++);keyboard();
putimage(x,50,A2,COPY_PUT);x=x+x1;
for (t2=1;t2<=1000;t2++);keyboard();
putimage(x,50,A3,COPY_PUT);x=x+x1;
for (t2=1;t2<=1000;t2++);keyboard();
putimage(x,50,A4,COPY_PUT);x=x+x1;
for (t2=1;t2<=1000;t2++);keyboard();
putimage(x,50,A5,COPY_PUT);x=x+x1;
for (t2=1;t2<=1000;t2++);keyboard();
putimage(x,50,A6,COPY_PUT);x=x+x1;
for (t2=1;t2<=1000;t2++);keyboard();
putimage(x,50,A7,COPY_PUT);x=x+x1;
for (t2=1;t2<=1000;t2++);};

x=252;
for (t2=1;t2<=30000;t2++);keyboard();
for (t2=1;t2<=30000;t2++);keyboard();
draw_bg();
goto animation_loop;                            /* infinite loop */

quit_pgm();}                       /* end the program gracefully */

/*_______________________________________________________________


SUBROUTINE: create & save graphic arrays                         */

void save_arrays(void){

setfillstyle(SOLID_FILL,C1);bar(140,50,190,90);
setfillstyle(SOLID_FILL,C2);bar(140,91,190,150);
setcolor(C7);p1=0;
sx1=draw_A1[p1][0];sy1=draw_A1[p1][1];p1++;
sx2=draw_A1[p1][0];sy2=draw_A1[p1][1];p1++;
circle(163,59,8);
sx=draw_A1[p1][0];sy=draw_A1[p1][1];p1++;moveto(sx,sy);
for (t1=1;t1<=2;t1++){
sx=draw_A1[p1][0];sy=draw_A1[p1][1];p1++;lineto(sx,sy);};
sx=draw_A1[p1][0];sy=draw_A1[p1][1];p1++;moveto(sx,sy);
for (t1=1;t1<=7;t1++){
sx=draw_A1[p1][0];sy=draw_A1[p1][1];p1++;lineto(sx,sy);};
sx=draw_A1[p1][0];sy=draw_A1[p1][1];p1++;moveto(sx,sy);
for (t1=1;t1<=5;t1++){
sx=draw_A1[p1][0];sy=draw_A1[p1][1];p1++;lineto(sx,sy);};
A1=(char far *)farmalloc((unsigned long)
imagesize(140,50,190,150));     /* calculate memory requirements */
getimage(140,50,190,150,A1);             /* save array in memory */

setfillstyle(SOLID_FILL,C1);bar(140,50,190,90);
setfillstyle(SOLID_FILL,C2);bar(140,91,190,150);
p1=0;
sx1=draw_A2[p1][0];sy1=draw_A2[p1][1];p1++;
sx2=draw_A2[p1][0];sy2=draw_A2[p1][1];p1++;
circle(163,59,8);
sx=draw_A2[p1][0];sy=draw_A2[p1][1];p1++;moveto(sx,sy);
for (t1=1;t1<=2;t1++){
sx=draw_A2[p1][0];sy=draw_A2[p1][1];p1++;lineto(sx,sy);};
sx=draw_A2[p1][0];sy=draw_A2[p1][1];p1++;moveto(sx,sy);
for (t1=1;t1<=7;t1++){
sx=draw_A2[p1][0];sy=draw_A2[p1][1];p1++;lineto(sx,sy);};
sx=draw_A2[p1][0];sy=draw_A2[p1][1];p1++;moveto(sx,sy);
for (t1=1;t1<=5;t1++){
sx=draw_A2[p1][0];sy=draw_A2[p1][1];p1++;lineto(sx,sy);};
A2=(char far *)farmalloc((unsigned long)
imagesize(140,50,190,150));     /* calculate memory requirements */
getimage(140,50,190,150,A2);             /* save array in memory */

setfillstyle(SOLID_FILL,C1);bar(140,50,190,90);
setfillstyle(SOLID_FILL,C2);bar(140,91,190,150);
p1=0;
sx1=draw_A3[p1][0];sy1=draw_A3[p1][1];p1++;
sx2=draw_A3[p1][0];sy2=draw_A3[p1][1];p1++;
circle(163,59,8);
sx=draw_A3[p1][0];sy=draw_A3[p1][1];p1++;moveto(sx,sy);
for (t1=1;t1<=2;t1++){
sx=draw_A3[p1][0];sy=draw_A3[p1][1];p1++;lineto(sx,sy);};
sx=draw_A3[p1][0];sy=draw_A3[p1][1];p1++;moveto(sx,sy);
for (t1=1;t1<=7;t1++){
sx=draw_A3[p1][0];sy=draw_A3[p1][1];p1++;lineto(sx,sy);};
sx=draw_A3[p1][0];sy=draw_A3[p1][1];p1++;moveto(sx,sy);
for (t1=1;t1<=5;t1++){
sx=draw_A3[p1][0];sy=draw_A3[p1][1];p1++;lineto(sx,sy);};
A3=(char far *)farmalloc((unsigned long)
imagesize(140,50,190,150));     /* calculate memory requirements */
getimage(140,50,190,150,A3);             /* save array in memory */

setfillstyle(SOLID_FILL,C1);bar(140,50,190,90);
setfillstyle(SOLID_FILL,C2);bar(140,91,190,150);
p1=0;
sx1=draw_A4[p1][0];sy1=draw_A4[p1][1];p1++;
sx2=draw_A4[p1][0];sy2=draw_A4[p1][1];p1++;
circle(163,59,8);
sx=draw_A4[p1][0];sy=draw_A4[p1][1];p1++;moveto(sx,sy);
for (t1=1;t1<=2;t1++){
sx=draw_A4[p1][0];sy=draw_A4[p1][1];p1++;lineto(sx,sy);};
sx=draw_A4[p1][0];sy=draw_A4[p1][1];p1++;moveto(sx,sy);
for (t1=1;t1<=6;t1++){
sx=draw_A4[p1][0];sy=draw_A4[p1][1];p1++;lineto(sx,sy);};
sx=draw_A4[p1][0];sy=draw_A4[p1][1];p1++;moveto(sx,sy);
for (t1=1;t1<=5;t1++){
sx=draw_A4[p1][0];sy=draw_A4[p1][1];p1++;lineto(sx,sy);};
A4=(char far *)farmalloc((unsigned long)
imagesize(140,50,190,150));     /* calculate memory requirements */
getimage(140,50,190,150,A4);             /* save array in memory */

setfillstyle(SOLID_FILL,C1);bar(140,50,190,90);
setfillstyle(SOLID_FILL,C2);bar(140,91,190,150);
p1=0;
sx1=draw_A5[p1][0];sy1=draw_A5[p1][1];p1++;
sx2=draw_A5[p1][0];sy2=draw_A5[p1][1];p1++;
circle(163,59,8);
sx=draw_A5[p1][0];sy=draw_A5[p1][1];p1++;moveto(sx,sy);
for (t1=1;t1<=2;t1++){
sx=draw_A5[p1][0];sy=draw_A5[p1][1];p1++;lineto(sx,sy);};
sx=draw_A5[p1][0];sy=draw_A5[p1][1];p1++;moveto(sx,sy);
for (t1=1;t1<=6;t1++){
sx=draw_A5[p1][0];sy=draw_A5[p1][1];p1++;lineto(sx,sy);};
sx=draw_A5[p1][0];sy=draw_A5[p1][1];p1++;moveto(sx,sy);
for (t1=1;t1<=5;t1++){
sx=draw_A5[p1][0];sy=draw_A5[p1][1];p1++;lineto(sx,sy);};
A5=(char far *)farmalloc((unsigned long)
imagesize(140,50,190,150));     /* calculate memory requirements */
getimage(140,50,190,150,A5);             /* save array in memory */

setfillstyle(SOLID_FILL,C1);bar(140,50,190,90);
setfillstyle(SOLID_FILL,C2);bar(140,91,190,150);
p1=0;
sx1=draw_A6[p1][0];sy1=draw_A6[p1][1];p1++;
sx2=draw_A6[p1][0];sy2=draw_A6[p1][1];p1++;
circle(163,59,8);
sx=draw_A6[p1][0];sy=draw_A6[p1][1];p1++;moveto(sx,sy);
for (t1=1;t1<=2;t1++){
sx=draw_A6[p1][0];sy=draw_A6[p1][1];p1++;lineto(sx,sy);};
sx=draw_A6[p1][0];sy=draw_A6[p1][1];p1++;moveto(sx,sy);
for (t1=1;t1<=6;t1++){
sx=draw_A6[p1][0];sy=draw_A6[p1][1];p1++;lineto(sx,sy);};
sx=draw_A6[p1][0];sy=draw_A6[p1][1];p1++;moveto(sx,sy);
for (t1=1;t1<=5;t1++){
sx=draw_A6[p1][0];sy=draw_A6[p1][1];p1++;lineto(sx,sy);};
A6=(char far *)farmalloc((unsigned long)
imagesize(140,50,190,150));     /* calculate memory requirements */
getimage(140,50,190,150,A6);             /* save array in memory */

setfillstyle(SOLID_FILL,C1);bar(140,50,190,90);
setfillstyle(SOLID_FILL,C2);bar(140,91,190,150);
p1=0;
sx1=draw_A7[p1][0];sy1=draw_A7[p1][1];p1++;
sx2=draw_A7[p1][0];sy2=draw_A7[p1][1];p1++;
circle(163,59,8);
sx=draw_A7[p1][0];sy=draw_A7[p1][1];p1++;moveto(sx,sy);
for (t1=1;t1<=2;t1++){
sx=draw_A7[p1][0];sy=draw_A7[p1][1];p1++;lineto(sx,sy);};
sx=draw_A7[p1][0];sy=draw_A7[p1][1];p1++;moveto(sx,sy);
for (t1=1;t1<=6;t1++){
sx=draw_A7[p1][0];sy=draw_A7[p1][1];p1++;lineto(sx,sy);};
sx=draw_A7[p1][0];sy=draw_A7[p1][1];p1++;moveto(sx,sy);
for (t1=1;t1<=5;t1++){
sx=draw_A7[p1][0];sy=draw_A7[p1][1];p1++;lineto(sx,sy);};
A7=(char far *)farmalloc((unsigned long)
imagesize(140,50,190,150));     /* calculate memory requirements */
getimage(140,50,190,150,A7);             /* save array in memory */

return;}

/*_______________________________________________________________


SUBROUTINE: draw the background                                  */

void draw_bg(void){

setfillstyle(SOLID_FILL,C1);bar(0,22,319,90);
setfillstyle(SOLID_FILL,C2);bar(0,91,319,170);
setcolor(C7);rectangle(0,22,319,170);notice(5,160);return;}

/*_______________________________________________________________


SUBROUTINE: press any key to quit                                */

void keyboard(void){if (bioskey(1)==0) return; else quit_pgm();}

/*_______________________________________________________________


SUBROUTINE: GRACEFUL EXIT FROM THE PROGRAM                       */

void quit_pgm(void){cleardevice();restorecrtmode();exit(0);}

/*______________________________________________________________


SUBROUTINE: VGA/EGA/CGA/MCGA compatibility module                */

void graphics_setup(void){
int graphics_adapter,graphics_mode;
detectgraph(&graphics_adapter,&graphics_mode);
if (graphics_adapter==VGA) goto CGA_mode;              /* if VGA */
if (graphics_mode==EGAHI) goto CGA_mode;       /* if EGA and ECD */
if (graphics_mode==EGALO) goto CGA_mode;       /* if EGA and SCD */
if (graphics_adapter==CGA) goto CGA_mode;              /* if CGA */
if (graphics_adapter==MCGA) goto CGA_mode;            /* if MCGA */
goto abort_message;              /* if no VGA, EGA, CGA, or MCGA */


CGA_mode:                      /* establish 320x200 4-color mode */
graphics_adapter=CGA;graphics_mode=CGAC3;
initgraph(&graphics_adapter,&graphics_mode,"");
C0=0;C1=1;C2=2;C7=3;setcolor(C7);
outtextxy(40,0,"USING C FOR HIGH SPEED ANIMATION");
outtextxy(72,184,"320x200 4-color CGA mode");
outtextxy(80,192,"Press any key to stop...");
return;

abort_message:
printf("\n\nUnable to proceed.\n");
printf("Requires VGA, EGA, MCGA, or CGA adapter\n");
printf("   with appropriate monitor.\n");
printf("Please refer to the book.\n\n");
exit(0);
}
/*_______________________________________________________________



SUBROUTINE: Copyright Notice

This subroutine displays the standard copyright notice.
If you are typing in this program from the book you can
safely omit this subroutine, provided that you also remove
the instruction "notice()" from the main routine.                */

int copyright[][3]={0x7c00,0x0000,0x0000,0x8231,
0x819c,0x645e,0xba4a,0x4252,0x96d0,0xa231,0x8252,0x955e,0xba4a,
0x43d2,0xf442,0x8231,0x825c,0x945e,0x7c00,0x0000,0x0000};

void notice(float x, float y){
int a,b,c; int t1=0;
for (t1=0;t1<=6;t1++){a=copyright[t1][0];b=copyright[t1][1];
c=copyright[t1][2];
setlinestyle(USERBIT_LINE,a,NORM_WIDTH);
moveto(x,y);lineto(x+15,y);
setlinestyle(USERBIT_LINE,b,NORM_WIDTH);
moveto(x+16,y);lineto(x+31,y);
setlinestyle(USERBIT_LINE,c,NORM_WIDTH);
moveto(x+32,y);lineto(x+47,y);y=y+1;};
setlinestyle(USERBIT_LINE,0xFFFF,NORM_WIDTH);
return;}

/*_______________________________________________________________

End of source code                                               */


